#include <alloc.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "dx.h"
#include "tools.h"
#include "protocol.h"
#include "spy.h"

#ifdef DOS

int	SPY_nPort = -1;
int	SPY_nHops = 99;

/*-------------------------------------------------------------------------
  ------ Decortiquer la trame pour savoir s'il y a un spot a recuperer ----
  -------------------------------------------------------------------------*/
void SPY_frame(char * szBuffer)
{
  char *pszStart;
  char *pszEnd;
  char *pszNext;

  if( ! *szBuffer )	/*Ne fait rien si vide*/
    return;

  /*Port a espionner ?*/
  if( atoi (szBuffer + 1) != SPY_nPort )
    return;	/*Non*/

  pszNext = szBuffer;

  for(;;)
  {
    /*Chercher la presence d'un PC11*/
    pszStart = strstr(pszNext, "PC11^");
    if( ! pszStart )
      return;	/*Il n'y en a pas ...*/

    /*A t-on la fin ?*/
    pszEnd   = strchr(pszStart, '\n');

    if( ! pszEnd )
    {
      return;	/*Pas de fin, protocole tronque*/
    }
    else
    {
      char szProtocol[256];

      /*Decortiquer le protocole*/
      strcpy(szProtocol, pszStart);
      szProtocol[strlen (szProtocol)] = SNULL;
      SPY_extractPC11(szProtocol);
    }
    pszNext = pszEnd + 1;
  }
}

/*-------------------------------------------------------------------------
  ------ Decortiquer le protocole -----------------------------------------
  -------------------------------------------------------------------------*/
void SPY_extractPC11(char * szBuffer)
{
  int 			index;
  char  	       *pParams[10];
  char		       *pPtr1;
  unsigned long 	lFrequency;

  /*Par securite*/
  if( strlen (szBuffer) < 6 )
    return;

  pPtr1 = szBuffer + 5;

  for(index = 0; index < 10; index++)
  {
    pParams[index] = pPtr1;

    //Rechercher le champs suivant
    while( *pPtr1 != SNULL && *pPtr1 != '^'/* && *pPtr1 != '~'*/ )
      pPtr1++;

    //Fin de la ligne de commande atteinte ?
    if( *pPtr1 == SNULL || *pPtr1 == '~' )
      break;

    *pPtr1++ = SNULL;
  }

  /*Verifier*/
  if( index != 8 )
    return;
  if( ! TOOLS_isCall(pParams[5]) || ! TOOLS_isCall(pParams[6]) )
    return;

  /*Lire la frquence*/
  /*(on ajoute 0.000001 pour corriger un bug sous linux)*/
  lFrequency = (unsigned long) (atof(pParams[0]) * 10.0 + 0.000001);
  if( ! DX_checkFrequency(lFrequency) )
    return;		/*Frequence incorrecte*/

  /*Enlever le "Z"  l'heure*/
  pParams[3][4] = SNULL;

  /*Transmettre le spot aux clusters adjacents et aux utilisateurs*/
  PROTOCOL_sendDx(0, pParams[6], pParams[5], lFrequency, pParams[2],
		  pParams[3], pParams[1], pParams[4], SPY_nHops + 1);

}


/*-------------------------------------------------------------------------
  ------ Parametrer le spy ------------------------------------------------
  -------------------------------------------------------------------------*/
void SPY_set(int nPort, int nHops)
{
  SPY_nPort = nPort;
  SPY_nHops = nHops;
}

#endif