#ifndef USERS_H
#define USERS_H

#include <time.h>
#include "define.h"


typedef struct USER_OLD
{
  char 	sCallSign[7];	//Indicatif de l'utilisateur, sans le SSID
  char 	sHomeNode[10];  //Home node
  char  sName[23];	//Prnom, max 22 caractres
  char	sQth[81];	//Maximum 80 caractres
  char  sLocator[7];    //Locator

  BYTE	byPage;		//Page length
  BYTE  byLanguage;	//Quelle langue

  unsigned int iBandsOff;	//Recevoir les spots sur quelle bande ?
  unsigned int iFlags;		//Divers flags

  unsigned long	lLogins;	//Nombre de connexions
  unsigned long lLastMsg;	//Dernier message list
  unsigned long lLastConnect;	//Date et heure de la dernire connexion
} tUser_old;


typedef struct USER
{
  char 	sCallSign[7];				/* Indicatif de l'utilisateur, sans le SSID */
  char 	sHomeNode[10];				/* Home node */
  char  sName[23];					/* Prenom, max 22 caracteres */
  char	sQth[81];					/* Max 80 caracteres */
  char  sLocator[7];				/* Locator */

  BYTE	byPage;						/* Page length */
  BYTE  byLanguage;					/* Quelle langue */

  unsigned int iDummy;				/* Sera a remplacer par qq chose des que possible : j'ai du le conserver pour des raisons de compatibiliote */
  unsigned int iFlags;				/* Divers flags */

  unsigned long	lLogins;			/* Nombre de connexions */
  unsigned long lLastMsg;			/* Dernier message liste */
  unsigned long lLastConnect;		/* Date et heure de la derniere connexion */

  unsigned long lBandsOff;			/* Bandes & modes a exclure */

  unsigned long lLastNetwkConnect;	/* Derniere connexion au reseau cluster */
  char szLastCluster[10];			/* sur quel cluster ? */

  char reserved[36];
} tUser;

typedef struct
{
  //Mode TALK
  char	sTalkToUser[11];
  char  sTalkToNode[11];

  //Identification SYSOP
  char	 sPassword[6];
  time_t MD_Key;

  //Divers
  char	sFileName[256];			//Chaine de caracteres pour memoriser un nom de fichier (UPDATE DataBase, etc...)
  char *pBuffer;				//Pointeur vers un buffer dynamique
  unsigned int iBufferLength;	//Taille du buffer dynamique en question

  //Date et Heure de la connexion
  unsigned long	lConnectedDateTime;

  //Edition d'un utilisateur
  char  sEditUser[7];
  char  sHomeNode[10];
  char	sName[23];
  char	sQth[81];
  char  sLocator[7];

} tUserCfg;

/* prototypes */

void 	USERS_sendAll(char * String, int ToWho, int nMessageType, int nWAZ);
int 	USERS_init(void);
long 	USERS_newRecord(char * CallSign);
void 	USERS_updateRecord(int StreamNum);
void 	USERS_saveRecord(int StreamNum);
void 	USERS_getRecord(int StreamNum);
void 	USERS_changeConfig(char * CallSign, char * String, int Data);
void 	USERS_updateLocalConfig(int StreamNum);
int		USERS_getHomeQth(char * UserCall, char * HomeQth);
int		USERS_isExist(char * UserCall);
int		USERS_get(char * UserCall, char * String, int Field);
void 	USERS_setFlags(int StreamNum, unsigned int iFlags);
void 	USERS_sendUserLoginAnnouncement(int StreamNum, char * pszUserCall, int nMsg);
void 	USERS_sendNodeLoginAnnouncement(char * pszNodeCall, int nIsIN);
int 	USERS_getConfig(char * szCallSign, tUser * user);
void	USERS_updateLastNetworkLogin(char* szUserCall, char* szClusterCall);

unsigned int USERS_getFlags(int StreamNum);
unsigned long USERS_openRecord(int StreamNum, char * UserCall);


#define USERS_NAME			1
#define USERS_QTH			2
#define USERS_COORDINATES	3
#define USERS_HOME			4
#define USERS_LOCATOR		5

#define USERS_ALL			1
#define USERS_SYSOP			2
#define USERS_EXCEPTCONSOLE	3
#define USERS_LOCALCONF		4
#define USERS_CLUSTERCONF	5

/* BITS de tUsers.iFlags */
#define USERS_NOBEEP			    1	//Est a 1 quand pas de beep
#define USERS_NOLOGIN			    2
#define USERS_FILTER_NA	       	    4
#define USERS_FILTER_SA	       	    8
#define USERS_FILTER_EU            16
#define USERS_FILTER_AS	           32
#define USERS_FILTER_OC	           64
#define USERS_FILTER_AF	       	  128
#define USERS_NODX				  256
#define USERS_NOANNOUNCEMENTS	  512
#define USERS_NODXBEEP			 1024	
#define USERS_NOANNBEEP			 2048
#define USERS_NOWWVBEEP			 4096
#define USERS_NOTALKBEEP		 8192
#define USERS_NOLOGINBEEP		16384
#define USERS_NOMAILBEEP		32768


#define USERS_2KM	1L
#define USERS_160M	2L
#define USERS_80M       4L
#define USERS_40M	8L
#define USERS_30M	16L
#define USERS_20M	32L
#define USERS_17M	64L
#define USERS_15M	128L
#define USERS_12M	256L
#define USERS_10M	512L
#define USERS_6M	1024L
#define USERS_4M	2048L
#define USERS_2M	4096L
#define USERS_135CM	8192L
#define USERS_70CM	16384L
#define USERS_34CM	32768L
#define USERS_23CM	65536L
#define USERS_13CM	131072L
#define USERS_9CM	262144L
#define USERS_5CM	524288L
#define USERS_3CM	1048576L
#define USERS_1CM	2097152L
#define USERS_6MM	4194304L
#define USERS_SSB	8388608L
#define USERS_CW	16777216L
#define USERS_RTTY	33554432L

#define USERS_ALLBANDS  0x003FFFFFL
#define USERS_ALLMODES  0x01C00000L

#endif	/* USERS_H */
