#include <alloc.h>
#include <string.h>
#include <stdio.h>
#include "tools.h"
#include "define.h"
#include "wcy.h"

/* Date       Hour SFI A K Exp.K R   SA  GMF Aurora Logger
   2-Nov-2000 16   204 8 1 1     206 eru qui no     <DK0WCY-3>
   2-Nov-2000 15   204 8 1 0     206 eru qui no     <DK0WCY-3>
   2-Nov-2000 14   204 8 3 0     206 eru qui no     <DK0WCY-3>

   PC73^ 1-Nov-2000^23^193^ 18^ 2^ 3^135^eru^act^no^DK0WCY-3^DB0SUE-7^H99^
   PC73^ 2-Nov-2000^16^204^ 8^ 1^ 1^206^eru^qui^no^DK0WCY-3^DB0SUE-7^H92^

   PC73^date^hour^SFI^A^K^Exp.K^R^SA^GMF^Aurora^Logger^FmPC^Hops^

   See http://www.dk0wcy.de for more info
*/


/*------------------------------------------------------------------------
  ------ Ajouter un WCY dans le fichier WCY ------------------------------
  ------------------------------------------------------------------------
  return TRUE si accepte et FALSE sinon                                   */
int WCY_add(char* pszDate, char* pszTime, int nSFI, int nA, int nK, int nExpK, int nR, char* pszSA, char* pszGMF, char* pszAurora, char* pszLogger, char* pszFromPC)
{
	FILE * fPtr;
	WCYSPOT WcySpot;

	/* Verifier la validite de certains champs */
	if( nSFI < 65 || nSFI > 300 )
		return FALSE;
	if(   nA < 0  ||   nA > 400 )
		return FALSE;
	if(   nR < 0  ||   nR > 300 )
		return FALSE;
	if(   nK < 0  ||   nK > 9 )
		return FALSE;

	/* Limiter la longueur des champs */
	TOOLS_maxLength(pszDate,  11);
	TOOLS_maxLength(pszTime,   4);
	TOOLS_maxLength(pszSA,     3);
	TOOLS_maxLength(pszGMF,    3);
	TOOLS_maxLength(pszAurora, 6);
	TOOLS_maxLength(pszLogger, 9);
	TOOLS_maxLength(pszFromPC, 9);

	/* Preparer tous les champs de l'enregistrement */
	memset(&WcySpot, 0, sizeof(WcySpot));	/* fichier plus clean ! */
	strcpy(WcySpot.szDate,   pszDate);
	strcpy(WcySpot.szTime,   pszTime);
	strcpy(WcySpot.szSA,     pszSA);
	strcpy(WcySpot.szGMF,    pszGMF);
	strcpy(WcySpot.szAurora, pszAurora);
	strcpy(WcySpot.szLogger, pszLogger);
	strcpy(WcySpot.szFromPC, pszFromPC);
	WcySpot.nSFI  = nSFI;
	WcySpot.nA    = nA;
	WcySpot.nK    = nK;
	WcySpot.nExpK = nExpK;
	WcySpot.nR    = nR;

	/* Ouvrir le fichier pour placer le nouveau WCY  la fin */
	fPtr = fopen(WCY_FILE, "a+b");

	if( ! fPtr )	/* Erreur d'ouverture du fichier */
	{
		perror("fopen in WCY_add");
		return FALSE;
	}

	/* Enregistrer le WCY a la fin du fichier */
	fwrite(&WcySpot, sizeof(WCYSPOT), 1, fPtr);
	fclose(fPtr);

	return TRUE;
}

/*------------------------------------------------------------------------
  ------ Lire un fichier dans WCY.BIN ------------------------------------
  ------------------------------------------------------------------------
  Retourne TRUE si un enregistrement a pu etre lu                         */
int WCY_get(int nPos, WCYSPOT * pWcySpot)
{
	FILE *fPtr;
	long  lOffset;

	fPtr = fopen(WCY_FILE, "a+b");

	if( ! fPtr )	/* Erreur d'ouverture du fichier */
	{
		perror("fopen in WCY_get");
		return FALSE;
	}

	/* Se placer a la fin du fichier */
	fseek(fPtr, 0L, SEEK_END);

	/* Remonter de nPos enregistrements */
	lOffset =  (long) nPos * (long) sizeof(WCYSPOT);
	if( lOffset > ftell(fPtr) )
	{
		fclose(fPtr);
		return FALSE;
	}
	fseek(fPtr, -lOffset, SEEK_CUR);

	/* Extraire l'enregistrement */
	fread(pWcySpot, sizeof(WCYSPOT), 1, fPtr);

	/* Fermer le fichier et retourner */
	fclose(fPtr);
	return TRUE;
}

/*------------------------------------------------------------------------
  ------ Rechercher si un WCY a deja ete recu ----------------------------
  ------------------------------------------------------------------------
  Retourne FALSE si un wcy a deja ete recu dans l'heure en cours          */
int WCY_isAllowed(char* pszDate, char* pszTime)
{
	FILE   *fPtr;
	long	lOffset;
	WCYSPOT WcySpot;
	unsigned long lCurrentDateTime;
	unsigned long lSpotDateTime;

	/* Quoi qu'il arrive, rejeter si le spot est plus vieux d'une
	   heure */
	lCurrentDateTime = TOOLS_whatDateTime();
	lSpotDateTime    = TOOLS_dateTime_Str2Long(pszDate, pszTime);
	if( TOOLS_diffDateTime(lCurrentDateTime, lSpotDateTime) >= 7200.0 )
		return FALSE;	/* Spot trop vieux */

	/* Ouvrir le fichier */
	fPtr = fopen(WCY_FILE, "rb");

	if( ! fPtr )	/* Impossible d'ouvrir */
	{
		perror("fopen in WCY_isDupe");
		return FALSE;
	}

	/* Placer le pointeur de fichier NLAST spots en arriere */
	fseek(fPtr, 0L, SEEK_END);	    /* Fin du fichier */
	lOffset =  (long) sizeof(WCYSPOT);  /* Calcul offset */
	if( lOffset > ftell(fPtr) )
		return TRUE;		    /* Fichier vide ! */
	fseek(fPtr, -lOffset, SEEK_CUR);    /* Pointer sur le dernier enregistrement */

	/* Lecture enregistrement */
	if( ! fread(&WcySpot, sizeof(WCYSPOT), 1, fPtr) )
	{
		fclose(fPtr);
		return TRUE;	/* EOF */
	}

	fclose(fPtr);

	/* Tester */
	if( strcmp(pszDate, WcySpot.szDate) )
		return TRUE;	/* Date differente : OK */

	if( strcmp(pszTime, WcySpot.szTime) )
		return TRUE;	/* Heure differente : OK */

	return FALSE;		/* Tout autre cas : rejeter */
}

/*-------------------------------------------------------------------------
  ------ Rechercher si un WCY est un DUPE ---------------------------------
  -------------------------------------------------------------------------
  Retourne TRUE si c'est un DUPE                                           */
int WCY_isDupe(char* pszFromPC, char* pszLogger, char* pszDate, char* pszTime)
{
	#define	NLAST	50L
	FILE   *fPtr;
	long	lOffset;
	int	index;
	char	szLoggerNOS[16];
	WCYSPOT WcySpot;

	/* Recherche de DUPE a effectuer qqs le SSID du logger */
	strcpy(szLoggerNOS, pszLogger);
	TOOLS_removeSsid(szLoggerNOS);

	/* Ouvrir le fichier */
	fPtr = fopen(WCY_FILE, "rb");

	if( ! fPtr )	/* Impossible d'ouvrir */
	{
		perror("fopen in WCY_isDupe");
		return FALSE;
	}

	/* Placer le pointeur de fichier NLAST spots en arriere */
	fseek(fPtr, 0L, SEEK_END);			/* Fin du fichier */
	lOffset =  NLAST * (long) sizeof(WCYSPOT);	/* Calcul offset */
	if( lOffset > ftell(fPtr) )
		fseek(fPtr, 0L, SEEK_SET);		/* Moins de NLAST spots enregistres : se placer en debut de fichier */
	else
		fseek(fPtr, -lOffset, SEEK_CUR);	/* Pointer NLAST */

	/* Tester chacun des spots */
	for(index = 0; index < NLAST; index++)
	{
		/* Lecture enregistrement */
		if( ! fread(&WcySpot, sizeof(WCYSPOT), 1, fPtr) )
			break;	/* EOF */

		/* Comparer ... */
		TOOLS_removeSsid(WcySpot.szLogger);	/* Qqs le SSID du logger */

		if( ! strcmp(pszTime,     WcySpot.szTime)   &&
		    ! strcmp(pszDate,     WcySpot.szDate)   &&
		    ! strcmp(pszFromPC,   WcySpot.szFromPC) &&
		    ! strcmp(szLoggerNOS, WcySpot.szLogger) )
		{
			/* DUPE */
			fclose(fPtr);
			return TRUE;
		}
	}/* End FOR */

	/* Fermer le fichier et retourner */
	fclose( fPtr );
	return FALSE;
}

