#include <windowsx.h>
//#include <winuser.h>
#include "resource.h"
#include "WinMain.h"
#include "LimitSingleInstance.h"

HINSTANCE g_hinst = NULL;
DWORD     g_dwChildThreadID;
HANDLE    g_hChildTheard;

CLimitSingleInstance g_SingleInstanceObj(TEXT("{2D8BAD8D-8C01-4ded-9429-06307AE936C0}"));

int main(int Argc, char * Argv[]);

DWORD WINAPI ChildThreadProc(HWND hWnd)
{
	main(0, NULL);
	return TRUE;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	if (g_SingleInstanceObj.IsAnotherInstanceRunning())
	{
		MessageBox(NULL, "DxNet already active", "DxNet for Windows", MB_OK | MB_ICONSTOP); 
		return FALSE; 
	}

    g_hinst = hInstance;
    DialogBox(hInstance, MAKEINTRESOURCE(IDD_DXNET), NULL, (DLGPROC) SetDispDlgProc);

    return(FALSE);
}

BOOL CALLBACK SetDispDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    switch (uMsg)
    {
	
    case WM_INITDIALOG:
		// Add Tray Notify Icon
		NotifyAdd(hDlg, 0);

		// Update Tip to current settings
	    TrayMessage(hDlg, NIM_MODIFY, 0, LoadImage(g_hinst, MAKEINTRESOURCE(IDI_DXNET),
                        IMAGE_ICON, 16, 16, 0), "DxNet for Windows"); 
		SetForegroundWindow(hDlg);

		// Will " close " the window in 5 seconds ...
		SetTimer(hDlg, TIMER, 5000, NULL);

		g_hChildTheard = CreateThread(NULL, 4096, ChildThreadProc, (LPVOID) hDlg, NULL, 
			&g_dwChildThreadID);
		break;
    
    case WM_DESTROY:	
		NotifyDelete(hDlg, 0);
		break;

	case WM_TIMER:
		ShowWindow(hDlg, SW_HIDE);
		SetTimer(hDlg, TIMER, 0, NULL);
		break;

    case WM_COMMAND:
		switch (GET_WM_COMMAND_ID(wParam, lParam))
		{
		case ID_EXIT: 
		case IDCANCEL:
			EndDialog(hDlg, TRUE);
			break;

		case IDB_HIDE:    
			ShowWindow(hDlg, SW_HIDE);
			break;
        
		default:
			break;
		}
		break;

	case MYWM_NOTIFYICON:
		switch (lParam)
		{
	    case WM_RBUTTONDOWN:
			{
				// Handle popup here
				POINT point;
				GetCursorPos(&point);
				HandlePopupMenu(hDlg, point);            
				break;
			}	    
		
			default:
				break;			
		}
		
	default:
		return(FALSE);
    
    }

    return(TRUE);
}

void NotifyAdd(HWND hDlg, UINT uIndex )
{
	TrayMessage(hDlg, NIM_ADD, 0, NULL, NULL);
}

void NotifyDelete(HWND hDlg, UINT uIndex)
{
	TrayMessage(hDlg, NIM_DELETE, 0, NULL, NULL);
}

BOOL TrayMessage(HWND hDlg, DWORD dwMessage, UINT uID, HICON hIcon, PSTR pszTip)
{
	BOOL res;
	NOTIFYICONDATA tnd;

    // Get the Tray Icon
	hIcon = (HICON)LoadImage(g_hinst, MAKEINTRESOURCE(IDI_DXNET), IMAGE_ICON,
		16, 16, 0);
    
	tnd.cbSize				= sizeof(NOTIFYICONDATA);
	tnd.hWnd				= hDlg;
	tnd.uID					= uID;
	tnd.uFlags				= NIF_MESSAGE | NIF_ICON | NIF_TIP;
	tnd.uCallbackMessage	= MYWM_NOTIFYICON;
	tnd.hIcon				= hIcon;
	
    // If there is a specific tip, set it otherwise use SetDisp as the default
    if (pszTip)
		lstrcpyn(tnd.szTip, pszTip, sizeof(tnd.szTip));
    else
		lstrcpyn(tnd.szTip, "DxNet for Waindows", sizeof("DxNet for Windows"));;

    //	Use the Shell_NotifyIcon API to setup the tray icon
	res = Shell_NotifyIcon(dwMessage, &tnd);

	if(hIcon)
		DestroyIcon(hIcon);

	return res;
}

VOID APIENTRY HandlePopupMenu(HWND hwnd, POINT point)
{
	HMENU hMenu = CreatePopupMenu();
	
	AppendMenu(hMenu, MFT_STRING, ID_EXIT, "&Exit");

    SetForegroundWindow (hwnd);
    TrackPopupMenu(hMenu, TPM_LEFTBUTTON | TPM_RIGHTBUTTON,
                    point.x, point.y, 0, hwnd, NULL);
    PostMessage(hwnd, WM_USER, 0, 0);
}


