// windows portage of dxnet - AGW pe interface - (c) f5mzn
// Part of code is (c) sv2agw

#include <winsock2.h>
#include "switch.h"
#include "agw.h"
#include "buffers.h"
#include "users.h"
#include "tools.h"
#include "commands.h"
#include "log.h"

///////////////////////////////////////////////////////////////////////////////////////////
// Variables globales
SOCKET AGW_socket = NULL;
QSO	   AGW_qso[65];

static char AGW_szHostAddr[256];
static int  AGW_nPort;

//static WSAEVENT SockEvent;
//static WSAEVENT EventArray[WSA_MAXIMUM_WAIT_EVENTS];
//static int NumEvents;

static void AGW_logSocketError(char* pszText)
{
	char* pszError;
	int   nErrorCode;

	nErrorCode = WSAGetLastError();

	switch( nErrorCode )
	{
	case WSAENAMETOOLONG :
		pszError = "Name too long";
		break;
		
	case WSANOTINITIALISED :
		pszError = "Not initialized";
		break;
		
	case WSASYSNOTREADY :
		pszError = "System not ready";
		break;
		
	case WSAVERNOTSUPPORTED :
		pszError = "Version is not supported";
		break;
		
	case WSAESHUTDOWN :
		pszError = "Can't send after socket shutdown";
		break;
		
	case WSAEINTR :
		pszError = "Interrupted system call";
		break;
		
	case WSAHOST_NOT_FOUND :
		pszError = "Host not found";
		break;
		
	case WSATRY_AGAIN :
		pszError = "Try again";
		break;
		
	case WSANO_RECOVERY :
		pszError = "Non-recoverable error";
		break;
		
	case WSANO_DATA :
		pszError = "No data record available";
		break;
		
	case WSAEBADF :
		pszError = "Bad file number";
		break;
		
	case WSAEWOULDBLOCK :
		pszError = "Operation would block";
		break;
		
	case WSAEINPROGRESS :
		pszError = "Operation now in progress";
		break;
		
	case WSAEALREADY :
		pszError = "Operation already in progress";
		break;
		
	case WSAEFAULT :
		pszError = "Bad address";
		break;
		
	case WSAEDESTADDRREQ :
		pszError = "Destination address required";
		break;
		
	case WSAEMSGSIZE :
		pszError = "Message too long";
		break;
		
	case WSAEPFNOSUPPORT :
		pszError = "Protocol family not supported";
		break;
		
	case WSAENOTEMPTY :
		pszError = "Directory not empty";
		break;
		
	case WSAEPROCLIM :
		pszError = "EPROCLIM pszError =ed";
		break;
		
	case WSAEUSERS :
		pszError = "EUSERS pszError =ed";
		break;
		
	case WSAEDQUOT :
		pszError = "Disk quota exceeded";
		break;
		
	case WSAESTALE :
		pszError = "ESTALE pszError =ed";
		break;
		
	case WSAEINVAL :
		pszError = "Invalid argument";
		break;
		
	case WSAEMFILE :
        pszError = "Too many open files";
		break;
		
	case WSAEACCES :
		pszError = "Access denied";
		break;
		
	case WSAELOOP :
		pszError = "Too many levels of symbolic links";
		break;
		
	case WSAEREMOTE :
		pszError = "The object is remote";
		break;
		
	case WSAENOTSOCK :
		pszError = "Socket operation on non-socket";
		break;
		
	case WSAEADDRNOTAVAIL :
		pszError = "Can't assign requested address";
		break;
		
	case WSAEADDRINUSE :
		pszError = "Address already in use";
		break;
		
	case WSAEAFNOSUPPORT :
		pszError = "Address family not supported by protocol family";
		break;
		
	case WSAESOCKTNOSUPPORT :
		pszError = "Socket type not supported";
		break;
		
	case WSAEPROTONOSUPPORT :
		pszError = "Protocol not supported";
		break;
		
	case WSAENOBUFS :
		pszError = "No buffer space is supported";
		break;
		
	case WSAETIMEDOUT :
		pszError = "Connection timed out";
		break;
		
	case WSAEISCONN :
		pszError = "Socket is already connected";
		break;
		
	case WSAENOTCONN :
		pszError = "Socket is not connected";
		break;
		
	case WSAENOPROTOOPT :
		pszError = "Bad protocol option";
		break;
		
	case WSAECONNRESET :
		pszError = "Connection reset by peer";
		break;
		
	case WSAECONNABORTED :
		pszError = "Software caused connection abort";
		break;
		
	case WSAENETDOWN :
		pszError = "Network is down";
		break;
		
	case WSAENETRESET :
		pszError = "Network was reset";
		break;
		
	case WSAECONNREFUSED :
		pszError = "Connection refused";
		break;
		
	case WSAEHOSTDOWN :
		pszError = "Host is down";
		break;
		
	case WSAEHOSTUNREACH :
		pszError = "Host is unreachable";
		break;
		
	case WSAEPROTOTYPE :
		pszError = "Protocol is wrong type for socket";
		break;
		
	case WSAEOPNOTSUPP :
		pszError = "Operation not supported on socket";
		break;
		
	case WSAENETUNREACH :
		pszError = "ICMP network unreachable";
		break;
		
	case WSAETOOMANYREFS :
		pszError = "Too many references";
		break;
		
	default :
		pszError = "Unknown";
		break;
	 }

	 LOG_sysMessage(LOG_SOCKET_ERROR, "%s : %s", pszText, pszError);
}

///////////////////////////////////////////////////////////////////////////////////////////
// Essaye de connecter le PE
//
// Retourne TRUE si OK

int AGW_connectPE(char* pszHostAddr, int nAGWPEPort)
{
	static BOOL bFirstCall = TRUE;
	u_long InetAddr;
	struct hostent *host;
	struct sockaddr_in SockAddrInet;

	if( bFirstCall )
	{
		strcpy(AGW_szHostAddr, pszHostAddr);
		AGW_nPort = nAGWPEPort;
		bFirstCall = FALSE;
		ZeroMemory(AGW_qso, sizeof AGW_qso);
	}

	//create the address suitable for winsock
	InetAddr = inet_addr(pszHostAddr);
	if (InetAddr == INADDR_NONE)// this means that address is a name like www.agw.org
	{
		host = gethostbyname(pszHostAddr);// in case that we need a dns to get the address
		if( host ) 
			InetAddr = *((u_long *)host->h_addr_list[0]);
	}

	//create a sockaddress structure
	SockAddrInet.sin_family = AF_INET;
	SockAddrInet.sin_port = htons(nAGWPEPort);
	SockAddrInet.sin_addr.S_un.S_addr = InetAddr;

	//Create the socket
	AGW_socket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if( AGW_socket == INVALID_SOCKET ) 
	{
		AGW_logSocketError("socket in AGW_connectPE");
		return FALSE;
	}

	//NOW connect the socket
	int Err = connect(AGW_socket, (struct sockaddr*)& SockAddrInet, sizeof(SockAddrInet));
	if( Err == SOCKET_ERROR )
	{
		if (WSAGetLastError() != WSAEWOULDBLOCK) // the socket will notify us later
		{
			//it is  a fatal error
			closesocket(AGW_socket);
			AGW_socket = NULL;
			return FALSE;
		}
	}

	return TRUE;
}

////////////////////////////////////////////////////////////////////////////////////////
// Lire un evenement sur le socket

void AGW_readEvent(void)
{
	char  szBuffer[4096];
	char* pszData;
	AGWHEADER * AgwHeader;

	int nHowManyCharsWait;
	int nHowManyCharsRead;
	int nSize;
	int index;
	int stream;

	extern unsigned long COMMANDS_statut[MAX_STREAMS];

	if( AGW_socket == NULL )
		return;

	//check how many characters are waiting in the socket for reading
	nHowManyCharsWait = recv(AGW_socket, szBuffer, 4096, MSG_PEEK);
	if( nHowManyCharsWait == SOCKET_ERROR )
	{
		AGW_logSocketError("recv returned SOCKET_ERROR in AGW_readEvent #1");
		AGW_goToIdleState();
		return;
	}

	if( nHowManyCharsWait == 0 )
	{
		/* disconnected from AGW pe*/
		AGW_goToIdleState();
		return;
	}

	if( nHowManyCharsWait < sizeof AGWHEADER )
		return;	/* header is not complete yet */

	AgwHeader = (AGWHEADER*) szBuffer;
	pszData   = szBuffer + sizeof AGWHEADER;

	if( nHowManyCharsWait < (int) (AgwHeader->nDataLen + sizeof(AGWHEADER)) )
		return;	/* frame not complete, it will be read later */

	/* Read header + datas */
	nSize = AgwHeader->nDataLen + sizeof AGWHEADER;
	nHowManyCharsRead = recv(AGW_socket, szBuffer, nSize, NULL);
	if( nHowManyCharsRead == SOCKET_ERROR )
	{
		AGW_logSocketError("recv returned SOCKET_ERROR in AGW_readEvent #2");
		AGW_goToIdleState();
		return;
	}

	/* what kind of data ? */
	switch( LOWORD(AgwHeader->lDataKind) )
	{
	case 'C' :	/* connection */
		if( strstr(pszData, "With") )
		{
			/* Outgoing connection */
			if( (stream = AGW_searchStream((char*) AgwHeader->szCallFrom)) == -1 )
				return;	/* station not found */

			AGW_qso[stream].nFlags = 0; //AGW_CONNECTION_DONE;
			BUFFERS_printBuff(stream, IN, "*** Connected to %s\r", AgwHeader->szCallFrom);
		}
		else
		{
			/* Incoming connection */
			/* search for a free stream */
			for(index = 1 ; index <= 64; index++)
			{
				if( AGW_qso[index].szCallSign[0] == '\0' )
					break;
			}

			if( index == 65 )
			{
				/* no free stream available : disconnect immediatly = busy */
				AGW_send(AgwHeader->nPort, 'd', 
					(char*) AgwHeader->szCallTo, (char*)AgwHeader->szCallFrom, 0, 
					NULL, NULL, 0);
				return;
			}

			/* accept connection */
			AGW_qso[index].nFlags = AGW_NEW_INCOMING_CONNECTION;
			AGW_qso[index].nPort  = AgwHeader->nPort;
			strcpy(AGW_qso[index].szCallSign, (char*) AgwHeader->szCallFrom);
		}
		break;

	case 'v' :	/* connect via */
		break;

	case 'd' :	/* deconnection */
		/* look for the stream the station is connected to */
		if( (stream = AGW_searchStream((char*) AgwHeader->szCallFrom)) == -1 )
			return;	/* station not found */

		AGW_qso[stream].nFlags |= AGW_NEW_INCOMING_DISCONNECT;
		break;

	case 'D' :	/* rcv datas */
		if( (stream = AGW_searchStream((char*) AgwHeader->szCallFrom)) == -1 )
			return;	/* station not found */
		BUFFERS_addBuff_sized(stream, pszData, IN, AgwHeader->nDataLen);
		break;

	case 'Y' :	/* outstanding frame on stream */
		if( (stream = AGW_searchStream((char*) AgwHeader->szCallTo)) == -1 )
			return;		/* station not found */
//		/* Has it been requested ? */
//		if( ! (AGW_qso[stream].nFlags & AGW_UNACK_REQUESTED) )
//			return;		/* no : ignore */
		
//		AGW_qso[stream].nFlags &= ~AGW_UNACK_REQUESTED;
//		AGW_qso[stream].nFlags |=  AGW_UNACK_AVAILABLE;
		AGW_qso[stream].nOutStandingFrame = *pszData;

		/* Une demande de deconnexion a t-elle ete demandee ? */
		if( (*pszData == 0) && (COMMANDS_statut[stream] & COMMANDS_statutDisconnect) && 
			(BUFFERS_getSize(stream, OUT) == 0) )
		{
			AGW_disconnect(stream);
			AGW_qso[stream].nFlags |= AGW_NEW_INCOMING_DISCONNECT;
		}
		break;
			

	default :
		/* unknown or not implemented yet */
		break;
	}
}

////////////////////////////////////////////////////////////////////////////////////////////
// Send a frame to AGW PE
//
// nDataSize = size of szData  -  nDataSize = -1 means that the function must check the 
//             length of szData

static void AGW_send(int nPort, int nDataKind, char* pszCallFrom, char* pszCallTo, int nDigiCount, char** pszDigiTable, char* pszData, int nDataSize)
{
	char* pszBuffer;
	char* ptr;
	AGWHEADER * AgwHeader;
	int   nSize;
	int   ret;
	int   nDigiStringLen;

	if( AGW_socket == NULL )
		return;

	/* data size */
	if( nDataSize == -1 )
		nDataSize = strlen(pszData);

	/* digi string size */
	nDigiStringLen = (nDigiCount ? nDigiCount * 10 + 1 : 0);

	/* total size of the frame to be sent */
	nSize = sizeof(AGWHEADER) + nDataSize + nDigiStringLen;
	pszBuffer = (char*) malloc(nSize + 1);
	if( pszBuffer == NULL )
		return;	

	AgwHeader = (AGWHEADER*) pszBuffer;
	ZeroMemory(AgwHeader, sizeof AGWHEADER);

	AgwHeader->nPort     = nPort;
	AgwHeader->lDataKind = MAKELONG(nDataKind, 0);
	strcpy((char*) AgwHeader->szCallFrom, pszCallFrom);
	strcpy((char*) AgwHeader->szCallTo,   pszCallTo);
	AgwHeader->nDataLen  = nDataSize + nDigiStringLen;

	ptr = pszBuffer + sizeof AGWHEADER;

	/* Add digipeaters, if any */
	if( nDigiCount )
	{
		*ptr++ = (char) nDigiCount;
		for(int index = 0; index < nDigiCount; index++)
		{
			strcpy(ptr, pszDigiTable[index]);
			ptr += 10;
		}
	}

	/* Add pszData to the end */
	if( pszData != NULL )
		MoveMemory(ptr, pszData, nDataSize);

	/* Send now to AGW PE via the socket */
	ret = send(AGW_socket, pszBuffer, nSize, 0);
	if( ret == SOCKET_ERROR )
	{
		AGW_logSocketError("send returned SOCKET_ERROR in AGW_sendFrame");
		AGW_goToIdleState();
	}

	free(pszBuffer);
}

////////////////////////////////////////////////////////////////////////////////////////////
// Register callsign

void AGW_registerCallSign(char* pszCallSign)
{
	static char szOldCallSign[10];
	static BOOL bFirst = FALSE;

	if( bFirst == FALSE )
	{
		/* First time this function is called, no callsign registred yet */
		bFirst = TRUE;
	}
	else
	{
		/* Unregister the old callsign */
		AGW_send(0, 'x', szOldCallSign, "", 0, NULL, NULL, 0);
	}

	AGW_send(0, 'X', pszCallSign, "", 0, NULL, NULL, 0);
	strcpy(szOldCallSign, pszCallSign);
}



////////////////////////////////////////////////////////////////////////////////////////////
// Entrer en mode idle - une erreur est certainement survenue

void AGW_goToIdleState(void)
{
	if( AGW_socket == NULL )
		return;

	USERS_sendAll("Disconnected from SV2AGW packet engine : program enters idled mode\n", USERS_SYSOP, 0, -1);
	LOG_sysMessage(LOG_STATUS, "AGWPE : entering idled mode");
	closesocket(AGW_socket);
	AGW_socket = NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////
// Sortir du mode idle - si possible !

void AGW_goOutOfIdleState(void)
{
	extern char SWITCH_szMyCall[20];
	if( AGW_socket != NULL )
		return;	/* not in idle state */

	if( ! AGW_connectPE(AGW_szHostAddr, AGW_nPort) )
		return;

	/* Register again the callsign because it has been lost during the idle mode */
	AGW_send(0, 'X', SWITCH_szMyCall, "", 0, NULL, NULL, 0);

	USERS_sendAll("SV2AGW packet engine found : program leaves idled mode\n", USERS_SYSOP, 0, -1);	
	LOG_sysMessage(LOG_STATUS, "AGWPE : leaving idled mode");
}

////////////////////////////////////////////////////////////////////////////////////////////
// Retourne TRUE si le mode IDLE est actif

int AGW_isIdled(void)
{
	return AGW_socket == NULL ? TRUE : FALSE;
}

////////////////////////////////////////////////////////////////////////////////////////////
// Rechercher sur quel stream un utilisateur est connecte
//
// La fonction retourne -1 si pas trouve 

static int AGW_searchStream(char* pszCallSign)
{
	for(int stream = 1; stream <= 64; stream++)
	{
		if( ! strcmp(pszCallSign, AGW_qso[stream].szCallSign) )
			return stream;
	}

	return -1;
}

////////////////////////////////////////////////////////////////////////////////////////////
// Envoyer une trame packet

void AGW_sendFrame(int StreamNum, char* pszString, int nSize)
{
	extern char SWITCH_szMyCall[10];

	if( StreamNum < 1 || StreamNum > 64 )
		return;

	AGW_send(AGW_qso[StreamNum].nPort, 'D', SWITCH_szMyCall, AGW_qso[StreamNum].szCallSign, 
		0, NULL, pszString, nSize);
}

////////////////////////////////////////////////////////////////////////////////////////////
// Deconnecter un stream

void AGW_disconnect(int StreamNum)
{
	extern char SWITCH_szMyCall[10];

	if( StreamNum < 1 || StreamNum > 64 )
		return;

	if( AGW_qso[StreamNum].szCallSign[0] == SNULL )
		return;

	/* deconnecter ! */
	AGW_send(AGW_qso[StreamNum].nPort, 'd', SWITCH_szMyCall, AGW_qso[StreamNum].szCallSign, 
		0, NULL, NULL, 0);
	AGW_qso[StreamNum].nFlags = AGW_DISCONNECTED;
	
}

////////////////////////////////////////////////////////////////////////////////////////////
// Demander a PE le nombre de trames qui doivent etre transmises

void AGW_askForOutstandingFrameOnStream(int StreamNum)
{
	extern char SWITCH_szMyCall[10];

	if( StreamNum < 1 || StreamNum > 64 )
		return;

//	if( AGW_qso[StreamNum].nFlags & AGW_UNACK_REQUESTED )
//		return;

	AGW_send(AGW_qso[StreamNum].nPort, 'Y', SWITCH_szMyCall, AGW_qso[StreamNum].szCallSign, 
		0, NULL, NULL, 0);

//	AGW_qso[StreamNum].nFlags |= AGW_UNACK_REQUESTED;
}

////////////////////////////////////////////////////////////////////////////////////////////
// Y a t-il un UNACK disponible ?
//
// Retourne -1 si non, ou la valeur si dispo

int AGW_getOutStandingFrameOnStream(int StreamNum)
{
	extern char SWITCH_szMyCall[10];

	if( StreamNum < 1 || StreamNum > 64 )
		return -1;

//	if( AGW_qso[StreamNum].nFlags & AGW_UNACK_AVAILABLE )
//	{
//		AGW_qso[StreamNum].nFlags &= ~AGW_UNACK_AVAILABLE;
		return AGW_qso[StreamNum].nOutStandingFrame;
//	}
	
//	return -1;
}

////////////////////////////////////////////////////////////////////////////////////////////
// Connecter a une station via AGW pe

void AGW_connect(int StreamNum, char* pszToString)
{
	extern char SWITCH_szMyCall[10];

	char* token;
	int	  index = 0;
	int	  nPort;
	int   nViaCount = 0;
	char* pszToCall;
	char* pszViaList[7];

	if( StreamNum < 1 || StreamNum > 64 )
		return;

	strupr(pszToString);
	TOOLS_removeNR(pszToString);

	token = strtok(pszToString, " ,");
	while( token )
	{
		TOOLS_maxLength(token, 9);

		switch(index)
		{
		case 0 :
			nPort = atoi(token) - 1;
			if( nPort < 0 || nPort > 100)
				nPort = 0;
			break;

		case 1 :
			pszToCall = token;
			break;

		default :
			pszViaList[nViaCount++] = token;
			break;
		}
		
		if( index++ == 9 )
			break;
		token = strtok(NULL, " ,");
	}

	if( index < 2 )
		return;

	strcpy(AGW_qso[StreamNum].szCallSign, pszToCall);
	AGW_qso[StreamNum].nPort  = nPort;
	AGW_qso[StreamNum].nFlags = AGW_TRY_TO_CONNECT;

	if( nViaCount )
		AGW_send(nPort, 'v', SWITCH_szMyCall, pszToCall, nViaCount, pszViaList, NULL, 0);
	else
		AGW_send(nPort, 'C', SWITCH_szMyCall, pszToCall, 0, NULL, NULL, 0);
}