
// ==========================================
//
// F6FBB 09/97 Portage DxNet F5MZN sous LINUX
//
// ==========================================

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
// #include <syslog.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <io.h>
// #include <sys/wait.h>

#include "dos.h"
#include "define.h"
#include "node.h"
#include "tools.h"
#include "buffers.h"
#include "execute.h"
#include "database.h"
#include "protocol.h"

#define P_WAIT 0

int EXECUTE_windows(char *Cmd, char *Out);

/*Cette fonction est utilisee afin de permettre de repondre a un acces remote
  a la base de donnees BuckMaster*/
int EXECUTE_buckMaster(int nUserStream, char * Cmd, char * Args, char * Path, int Remote)
{
	struct stat bufstat;
	char  sBuffer[MAXPATH+256];
	char* pTmpFile;
	char  sCmd[256];
	int	  ExitCode;
	FILE* fPtr;

	/* Enlever CRLF de la commande */
	strcpy(sCmd, Cmd);
	TOOLS_removeNR(sCmd);

	/* Remplacer les '/' par des '\' */
	TOOLS_slash2back(sCmd);

	/* Quitter si Cmd commence par un '*' ou un '*' (car stat considere un tel fichier comme
	   existant) */
	if( *sCmd == '?' || *sCmd == '*' )
		return -1;

	/* Creer le nom du fichier (.EXE) */
	sprintf(sBuffer, "%s%s.exe", Path, sCmd);

	/* Ce programme existe t-il (.EXE) ? */
	if( (stat(sBuffer, &bufstat) == -1) )
	{
		/* Peut-etre un .BAT ? */
		sprintf(sBuffer, "%s%s.bat", Path, sCmd);

		/* Ce programme existe t-il (.BAT) ? */
		if( (stat(sBuffer, &bufstat) == -1) )
			return -1;
	}

	/* Le fichier existe - Ajouter les arguments */
	strcat(sBuffer, " ");
	strcat(sBuffer, Args);

	/* Preparer le fichier temporaire */
	pTmpFile = tempnam("/tmp", "dx");

	/* Executer la commande */
	ExitCode = EXECUTE_windows(sBuffer, pTmpFile);

	if( ExitCode == 127 )
		ExitCode = -1;

	/* Renvoyer le retour a l'utilisateur */
	if( (ExitCode >= 0) && (fPtr = fopen(pTmpFile, "rt")) != 0 )
	{
		char szServer[16];
		extern char * DATABASE_pszRemoteDB_FromPC;

		NODE_getNodeCall(0, 0, szServer);	/* Indicatif du serveur - Remote DB */

		for(;;)
		{
			if( ! fgets(sBuffer, 128, fPtr) )
				break;

			TOOLS_removeNR (sBuffer);

			/* Router vers utilisateur local ou remote ? */
			if( Remote == DB_LOCAL )
				BUFFERS_printBuff(nUserStream, OUT, "%s\n", sBuffer);
			else
				PROTOCOL_dbResponse(0, szServer, DATABASE_pszRemoteDB_FromPC,
					nUserStream, sBuffer);
		}

		/* Fermer le fichier */
		fclose (fPtr);

	}

	/* Effacer le fichier temporaire et liberer la memoire */
	unlink(pTmpFile);
	free(pTmpFile);

	return ExitCode;
}

int EXECUTE_command(int StreamNum, char *Cmd, char *Args, char *Path)
{
	struct stat bufstat;
	char  sBuffer[MAXPATH+256];
	char* pTmpFile;
	char  sCmd[256];
	int	  ExitCode;
	int	  fd;
	int   nb;

	/* Enlever CRLF de la commande */
	strcpy(sCmd, Cmd);
	TOOLS_removeNR(sCmd);

	/* Remplacer les '/' par des '\' */
	TOOLS_slash2back(sCmd);

	/* Quitter si Cmd commence par un '*' ou un '*' (car stat considere un tel fichier comme 
	   existant) */
	if( *sCmd == '?' || *sCmd == '*' )
		return -1;

	/* Creer le nom du fichier (.EXE) */
	sprintf(sBuffer, "%s%s.exe", Path, sCmd);

	/* Ce programme existe t-il (.EXE) ? */
	if( (stat(sBuffer, &bufstat) == -1) )
	{
		/* Peut-etre un .BAT ? */
		sprintf(sBuffer, "%s%s.bat", Path, sCmd);

		/* Ce programme existe t-il (.BAT) ? */
		if( (stat(sBuffer, &bufstat) == -1) )
			return -1;
	}

	/* Le fichier existe - Ajouter les arguments */
	strcat(sBuffer, " ");
	strcat(sBuffer, Args);

	/* Preparer le fichier temporaire */
	pTmpFile = tempnam("/tmp", "dx");

	/* Executer la commande */
	ExitCode = EXECUTE_windows(sBuffer, pTmpFile);

	if( ExitCode == 127 )
		ExitCode = -1;

	/* Renvoyer le retour a l'utilisateur */
	if( (ExitCode) >= 0 && (fd = _open(pTmpFile, O_RDONLY)) != 0 )
	{
		for(;;)
		{
			nb = _read(fd, sBuffer, 250);
			if( nb <= 0 )
				break;
			BUFFERS_addBuff_sized(StreamNum, sBuffer, OUT, nb);
		}
	}

	_close( fd );

	/* Effacer le fichier temporaire et liberer la memoire */
	unlink(pTmpFile);
	free(pTmpFile);

	return ExitCode;
}

/* This function is straight from *NOS */

/*static*/ char *parse_string(char *str)
{
	char *cp = str;
	unsigned long num;

	while (*str != '\0' && *str != '\"') {
		if (*str == '\\') {
			str++;
			switch (*str++) {
			case 'n':
				*cp++ = '\n';
				break;
			case 't':
				*cp++ = '\t';
				break;
			case 'v':
				*cp++ = '\v';
				break;
			case 'b':
				*cp++ = '\b';
				break;
			case 'r':
				*cp++ = '\r';
				break;
			case 'f':
				*cp++ = '\f';
				break;
			case 'a':
				*cp++ = '\007';
				break;
			case '\\':
				*cp++ = '\\';
				break;
			case '\"':
				*cp++ = '\"';
				break;
			case 'x':
				num = strtoul(--str, &str, 16);
				*cp++ = (char) num;
				break;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
				num = strtoul(--str, &str, 8);
				*cp++ = (char) num;
				break;
			case '\0':
				return NULL;
			default:
				*cp++ = *(str - 1);
				break;
			};
		} else {
			*cp++ = *str++;
		}
	}
	if (*str == '\"')
		str++;		/* skip final quote */
	*cp = '\0';		/* terminate string */
	return str;
}

static int parse_args(char **argv, char *cmd)
{
	int ct = 0;
	int quoted;

	while (ct < 31)
	{
		quoted = 0;
		while (*cmd && isspace(*cmd))
			cmd++;
		if (*cmd == 0)
			break;
		if (*cmd == '"') {
			quoted++;
			cmd++;
		}
		argv[ct++] = cmd;
		if (quoted) {
			if ((cmd = parse_string(cmd)) == NULL)
				return 0;
		} else {
			while (*cmd && !isspace(*cmd))
				cmd++;
		}
		if (*cmd)
			*cmd++ = 0;
	}
	argv[ct] = NULL;
	return ct;
}
extern "C" { 
	int _spawnv( int mode, const char *cmdname, const char *const *argv ); 
}


/*---------------------------------------------------------------------------
  ------ Executer la commande DOS -------------------------------------------
  ---------------------------------------------------------------------------*/
int EXECUTE_windows(char * Cmd, char * Out)
{
	char* argv[34];
	int fd;
	int oldstdout;
	int exitcode;

	/* Isoler les arguments */
	argv[0] = getenv("COMSPEC");
	argv[1] = "/C";
	parse_args(argv+2, Cmd);

	/* ?? */
	if( strstr(argv[0], "..") )
		return -1;

	/* Verifier que le fichier temporaire peut-etre ouvert */
	fd = _open(Out, O_CREAT | O_RDWR, S_IREAD|S_IWRITE);
	if( fd < 0 )
		return 1;

	/* Dupliquer un handle pour la sortie standard */
	oldstdout = _dup(_fileno(stdout));

	/* Rediriger la sortie standard */
	_dup2(fd, _fileno(stdout));

	/* Fermer le handle */
	_close(fd);

	/* Executer la commande */
	if( strstr(argv[2], ".bat") )
		exitcode = _spawnv(P_WAIT, argv[0], argv);		/* Fichier BATCH */
	else
		exitcode = _spawnv(P_WAIT, argv[2], argv + 2);	/* Fichier EXE */

	/* Restaurer le handle d'origine et fermer le fichier */
	_dup2(oldstdout, _fileno(stdout));
	_close(oldstdout); 	/* Ne pas oublier de fermer ce fichier la !!! */

	return exitcode;
}
