(* The canvas widget *)
open Tk
open Widget
open Textvariable
val create : widget -> options list -> widget 
             (* [create p options] creates a new widget with parent p.
                Options are restricted to the widget class subset,
                and checked dynamically. *)
val create_named : widget -> string -> options list -> widget 
             (* [create p name options] creates a new widget with
                parent p and new patch component name.
                Options are restricted to the widget class subset,
                and checked dynamically. *)
val addtag : widget -> tagOrId -> searchSpec list -> unit 
(* tk invocation: <widget> addtag <tagOrId> <searchSpec list> *)

val bbox : widget -> tagOrId list -> int * int * int * int 
(* tk invocation: <widget> bbox <tagOrId list> *)

val canvasx : widget -> units -> float 
(* tk invocation: <widget> canvasx <units> *)

val canvasx_grid : widget -> units -> units -> float 
(* tk invocation: <widget> canvasx <units> <units> *)

val canvasy : widget -> units -> float 
(* tk invocation: <widget> canvasy <units> *)

val canvasy_grid : widget -> units -> units -> float 
(* tk invocation: <widget> canvasy <units> <units> *)

val configure : widget -> options list -> unit 
(* tk invocation: <widget> configure <options list> *)

val configure_arc : widget -> tagOrId -> options list -> unit 
(* tk invocation: <widget> itemconfigure <tagOrId> <options list> *)

val configure_bitmap : widget -> tagOrId -> options list -> unit 
(* tk invocation: <widget> itemconfigure <tagOrId> <options list> *)

val configure_get : widget -> string 
(* tk invocation: <widget> configure *)

val configure_image : widget -> tagOrId -> options list -> unit 
(* tk invocation: <widget> itemconfigure <tagOrId> <options list> *)

val configure_line : widget -> tagOrId -> options list -> unit 
(* tk invocation: <widget> itemconfigure <tagOrId> <options list> *)

val configure_oval : widget -> tagOrId -> options list -> unit 
(* tk invocation: <widget> itemconfigure <tagOrId> <options list> *)

val configure_polygon : widget -> tagOrId -> options list -> unit 
(* tk invocation: <widget> itemconfigure <tagOrId> <options list> *)

val configure_rectangle : widget -> tagOrId -> options list -> unit 
(* tk invocation: <widget> itemconfigure <tagOrId> <options list> *)

val configure_text : widget -> tagOrId -> options list -> unit 
(* tk invocation: <widget> itemconfigure <tagOrId> <options list> *)

val configure_window : widget -> tagOrId -> options list -> unit 
(* tk invocation: <widget> itemconfigure <tagOrId> <options list> *)

val coords_get : widget -> tagOrId -> float list 
(* tk invocation: <widget> coords <tagOrId> *)

val coords_set : widget -> tagOrId -> units list -> unit 
(* tk invocation: <widget> coords <tagOrId> <units list> *)

val create_arc : widget -> units -> units -> units -> units -> options list -> tagOrId 
(* tk invocation: <widget> create arc <units> <units> <units> <units> <options list> *)

val create_bitmap : widget -> units -> units -> options list -> tagOrId 
(* tk invocation: <widget> create bitmap <units> <units> <options list> *)

val create_image : widget -> units -> units -> options list -> tagOrId 
(* tk invocation: <widget> create image <units> <units> <options list> *)

val create_line : widget -> units list -> options list -> tagOrId 
(* tk invocation: <widget> create line <units list> <options list> *)

val create_oval : widget -> units -> units -> units -> units -> options list -> tagOrId 
(* tk invocation: <widget> create oval <units> <units> <units> <units> <options list> *)

val create_polygon : widget -> units list -> options list -> tagOrId 
(* tk invocation: <widget> create polygon <units list> <options list> *)

val create_rectangle : widget -> units -> units -> units -> units -> options list -> tagOrId 
(* tk invocation: <widget> create rectangle <units> <units> <units> <units> <options list> *)

val create_text : widget -> units -> units -> options list -> tagOrId 
(* tk invocation: <widget> create text <units> <units> <options list> *)

val create_window : widget -> units -> units -> options list -> tagOrId 
(* tk invocation: <widget> create window <units> <units> <options list> *)

val dchars : widget -> tagOrId -> index -> index -> unit 
(* tk invocation: <widget> dchars <tagOrId> <index> <index> *)

val delete : widget -> tagOrId list -> unit 
(* tk invocation: <widget> delete <tagOrId list> *)

val dtag : widget -> tagOrId -> tagOrId -> unit 
(* tk invocation: <widget> dtag <tagOrId> <tagOrId> *)

val find : widget -> searchSpec list -> tagOrId list 
(* tk invocation: <widget> find <searchSpec list> *)

val focus : widget -> tagOrId -> unit 
(* tk invocation: <widget> focus <tagOrId> *)

val focus_get : widget -> tagOrId 
(* tk invocation: <widget> focus *)

val focus_reset : widget -> unit 
(* tk invocation: <widget> focus  *)

val gettags : widget -> tagOrId -> tagOrId list 
(* tk invocation: <widget> gettags <tagOrId> *)

val icursor : widget -> tagOrId -> index -> unit 
(* tk invocation: <widget> icursor <tagOrId> <index> *)

val index : widget -> tagOrId -> index -> int 
(* tk invocation: <widget> index <tagOrId> <index> *)

val insert : widget -> tagOrId -> index -> string -> unit 
(* tk invocation: <widget> insert <tagOrId> <index> <string> *)

val itemconfigure_get : widget -> tagOrId -> string 
(* tk invocation: <widget> itemconfigure <tagOrId> *)

val lower_below : widget -> tagOrId -> tagOrId -> unit 
(* tk invocation: <widget> lower <tagOrId> <tagOrId> *)

val lower_bot : widget -> tagOrId -> unit 
(* tk invocation: <widget> lower <tagOrId> *)

val move : widget -> tagOrId -> units -> units -> unit 
(* tk invocation: <widget> move <tagOrId> <units> <units> *)

(* unsafe *)
val postscript : widget -> options list -> string 
(* tk invocation: <widget> postscript <options list> *)
(* /unsafe *)

val raise_above : widget -> tagOrId -> tagOrId -> unit 
(* tk invocation: <widget> raise <tagOrId> <tagOrId> *)

val raise_top : widget -> tagOrId -> unit 
(* tk invocation: <widget> raise <tagOrId> *)

val scale : widget -> tagOrId -> units -> units -> float -> float -> unit 
(* tk invocation: <widget> scale <tagOrId> <units> <units> <float> <float> *)

val scan_dragto : widget -> int -> int -> unit 
(* tk invocation: <widget> scan dragto <int> <int> *)

val scan_mark : widget -> int -> int -> unit 
(* tk invocation: <widget> scan mark <int> <int> *)

val select_adjust : widget -> tagOrId -> index -> unit 
(* tk invocation: <widget> select adjust <tagOrId> <index> *)

val select_clear : widget -> unit 
(* tk invocation: <widget> select clear *)

val select_from : widget -> tagOrId -> index -> unit 
(* tk invocation: <widget> select from <tagOrId> <index> *)

val select_item : widget -> tagOrId 
(* tk invocation: <widget> select item *)

val select_to : widget -> tagOrId -> index -> unit 
(* tk invocation: <widget> select to <tagOrId> <index> *)

val typeof : widget -> tagOrId -> canvasItem 
(* tk invocation: <widget> type <tagOrId> *)

val xview : widget -> scrollValue -> unit 
(* tk invocation: <widget> xview <scrollValue> *)

val xview_get : widget -> float * float 
(* tk invocation: <widget> xview *)

val yview : widget -> scrollValue -> unit 
(* tk invocation: <widget> yview <scrollValue> *)

val yview_get : widget -> float * float 
(* tk invocation: <widget> yview *)

val bind : widget -> tagOrId -> 
                    (modifier list * xEvent) list -> bindAction -> unit 


