(* The entry widget *)
open Tk
open Widget
open Textvariable
val create : widget -> options list -> widget 
             (* [create p options] creates a new widget with parent p.
                Options are restricted to the widget class subset,
                and checked dynamically. *)
val create_named : widget -> string -> options list -> widget 
             (* [create p name options] creates a new widget with
                parent p and new patch component name.
                Options are restricted to the widget class subset,
                and checked dynamically. *)
val configure : widget -> options list -> unit 
(* tk invocation: <widget> configure <options list> *)

val configure_get : widget -> string 
(* tk invocation: <widget> configure *)

val delete_range : widget -> index -> index -> unit 
(* tk invocation: <widget> delete <index> <index> *)

val delete_single : widget -> index -> unit 
(* tk invocation: <widget> delete <index> *)

val get : widget -> string 
(* tk invocation: <widget> get *)

val icursor : widget -> index -> unit 
(* tk invocation: <widget> icursor <index> *)

val index : widget -> index -> int 
(* tk invocation: <widget> index <index> *)

val insert : widget -> index -> string -> unit 
(* tk invocation: <widget> insert <index> <string> *)

val scan_dragto : widget -> int -> unit 
(* tk invocation: <widget> scan dragto <int> *)

val scan_mark : widget -> int -> unit 
(* tk invocation: <widget> scan mark <int> *)

val selection_adjust : widget -> index -> unit 
(* tk invocation: <widget> selection adjust <index> *)

val selection_clear : widget -> unit 
(* tk invocation: <widget> selection clear *)

val selection_from : widget -> index -> unit 
(* tk invocation: <widget> selection from <index> *)

val selection_present : widget -> bool 
(* tk invocation: <widget> selection present *)

val selection_range : widget -> index -> index -> unit 
(* tk invocation: <widget> selection range <index> <index> *)

val selection_to : widget -> index -> unit 
(* tk invocation: <widget> selection to <index> *)

val xview : widget -> scrollValue -> unit 
(* tk invocation: <widget> xview <scrollValue> *)

val xview_get : widget -> float * float 
(* tk invocation: <widget> xview *)

val xview_index : widget -> index -> unit 
(* tk invocation: <widget> xview <index> *)

