(* The grid commands  *)
open Tk
open Widget
open Textvariable
val all_slaves : widget -> widget list 
(* tk invocation: grid slaves <widget> *)

val bbox : widget -> int -> int -> int * int * int * int 
(* tk invocation: grid bbox <widget> <int> <int> *)

val column_configure : widget -> int -> gridopt list -> unit 
(* tk invocation: grid columnconfigure <widget> <int> <gridopt list> *)

val column_slaves : widget -> int -> widget list 
(* tk invocation: grid slaves <widget> -column <int> *)

val configure : widget list -> options list -> unit 
(* tk invocation: grid configure <widget list> <options list> *)

val forget : widget list -> unit 
(* tk invocation: grid forget <widget list> *)

val info : widget -> string 
(* tk invocation: grid info <widget> *)

val location : widget -> units -> units -> int * int 
(* tk invocation: grid location <widget> <units> <units> *)

val propagate_get : widget -> bool 
(* tk invocation: grid propagate <widget> *)

val propagate_set : widget -> bool -> unit 
(* tk invocation: grid propagate <widget> <bool> *)

val row_configure : widget -> int -> gridopt list -> unit 
(* tk invocation: grid rowconfigure <widget> <int> <gridopt list> *)

val row_slaves : widget -> int -> widget list 
(* tk invocation: grid slaves <widget> -row <int> *)

val size : widget -> int * int 
(* tk invocation: grid size <widget> *)

