(* The winfo commands  *)
open Tk
open Widget
open Textvariable
(* unsafe *)
val atom : string -> atomId 
(* tk invocation: winfo atom <string> *)
(* /unsafe *)

(* unsafe *)
val atom_displayof : widget -> string -> atomId 
(* tk invocation: winfo atom -displayof <widget> <string> *)
(* /unsafe *)

(* unsafe *)
val atomname : atomId -> string 
(* tk invocation: winfo atomname <atomId> *)
(* /unsafe *)

(* unsafe *)
val atomname_displayof : widget -> atomId -> string 
(* tk invocation: winfo atomname -displayof <widget> <atomId> *)
(* /unsafe *)

val cells : widget -> int 
(* tk invocation: winfo cells <widget> *)

val children : widget -> widget list 
(* tk invocation: winfo children <widget> *)

val class_name : widget -> string 
(* tk invocation: winfo class <widget> *)

val colormapfull : widget -> bool 
(* tk invocation: winfo colormapfull <widget> *)

(* unsafe *)
val containing : int -> int -> widget 
(* tk invocation: winfo containing <int> <int> *)
(* /unsafe *)

(* unsafe *)
val containing_displayof : widget -> int -> int -> widget 
(* tk invocation: winfo containing -displayof <widget> <int> <int> *)
(* /unsafe *)

val depth : widget -> int 
(* tk invocation: winfo depth <widget> *)

val exists : widget -> bool 
(* tk invocation: winfo exists <widget> *)

val fpixels : widget -> units -> float 
(* tk invocation: winfo fpixels <widget> <units> *)

val geometry : widget -> string 
(* tk invocation: winfo geometry <widget> *)

val height : widget -> int 
(* tk invocation: winfo height <widget> *)

(* unsafe *)
val id : widget -> string 
(* tk invocation: winfo id <widget> *)
(* /unsafe *)

(* unsafe *)
val interps : unit ->string list 
(* tk invocation: winfo interps *)
(* /unsafe *)

(* unsafe *)
val interps_displayof : widget -> string list 
(* tk invocation: winfo interps -displayof <widget> *)
(* /unsafe *)

val ismapped : widget -> bool 
(* tk invocation: winfo ismapped <widget> *)

val manager : widget -> string 
(* tk invocation: winfo manager <widget> *)

val name : widget -> string 
(* tk invocation: winfo name <widget> *)

(* unsafe *)
val parent : widget -> widget 
(* tk invocation: winfo parent <widget> *)
(* /unsafe *)

(* unsafe *)
val pathname : string -> widget 
(* tk invocation: winfo pathname <string> *)
(* /unsafe *)

(* unsafe *)
val pathname_displayof : widget -> string -> widget 
(* tk invocation: winfo pathname -displayof <widget> <string> *)
(* /unsafe *)

val pixels : widget -> units -> int 
(* tk invocation: winfo pixels <widget> <units> *)

val pointerx : widget -> int 
(* tk invocation: winfo pointerx <widget> *)

val pointerxy : widget -> int * int 
(* tk invocation: winfo pointerxy <widget> *)

val pointery : widget -> int 
(* tk invocation: winfo pointery <widget> *)

val reqheight : widget -> int 
(* tk invocation: winfo reqheight <widget> *)

val reqwidth : widget -> int 
(* tk invocation: winfo reqwidth <widget> *)

val rgb : widget -> color -> int * int * int 
(* tk invocation: winfo rgb <widget> <color> *)

val rootx : widget -> int 
(* tk invocation: winfo rootx <widget> *)

val rooty : widget -> int 
(* tk invocation: winfo rooty <widget> *)

val screen : widget -> string 
(* tk invocation: winfo screen <widget> *)

val screencells : widget -> int 
(* tk invocation: winfo screencells <widget> *)

val screendepth : widget -> int 
(* tk invocation: winfo screendepth <widget> *)

val screenheight : widget -> int 
(* tk invocation: winfo screenheight <widget> *)

val screenmmdepth : widget -> int 
(* tk invocation: winfo screenmmdepth <widget> *)

val screenmmheight : widget -> int 
(* tk invocation: winfo screenmmheight <widget> *)

val screenvisual : widget -> string 
(* tk invocation: winfo screenvisual <widget> *)

val screenwidth : widget -> int 
(* tk invocation: winfo screenwidth <widget> *)

(* unsafe *)
val server : widget -> string 
(* tk invocation: winfo server <widget> *)
(* /unsafe *)

(* unsafe *)
val toplevel : widget -> widget 
(* tk invocation: winfo toplevel <widget> *)
(* /unsafe *)

val viewable : widget -> bool 
(* tk invocation: winfo viewable <widget> *)

val visual : widget -> string 
(* tk invocation: winfo visual <widget> *)

val visualsavailable : widget -> string 
(* tk invocation: winfo visualsavailable <widget> *)

val vrootheight : widget -> int 
(* tk invocation: winfo vrootheight <widget> *)

val vrootwidth : widget -> int 
(* tk invocation: winfo vrootwidth <widget> *)

val vrootx : widget -> int 
(* tk invocation: winfo vrootx <widget> *)

val vrooty : widget -> int 
(* tk invocation: winfo vrooty <widget> *)

val width : widget -> int 
(* tk invocation: winfo width <widget> *)

val x : widget -> int 
(* tk invocation: winfo x <widget> *)

val y : widget -> int 
(* tk invocation: winfo y <widget> *)

val contained : int -> int -> widget -> bool
(* [contained x y w] returns true if (x,y) is in w *)


