head	1.43;
access;
symbols
	V0-99-8:1.43
	V0-99-7:1.41
	V0-99-6:1.39
	V0-99-5:1.39
	V0-99-4:1.39
	V0-99-2:1.35
	V0-99-1:1.35
	V0-93-14:1.35
	V0-93-13:1.35
	V0-93-12:1.34
	V0-93-11:1.34
	V0-93-10:1.34
	V0-93-9:1.33
	V0-93-8:1.32
	V0-93-7:1.31
	V0-93-5:1.30
	V80:1.9
	V76d:1.1;
locks; strict;
comment	@ * @;


1.43
date	96.08.31.06.59.18;	author dumoulin;	state Exp;
branches;
next	1.42;

1.42
date	96.08.13.05.00.16;	author dumoulin;	state Exp;
branches;
next	1.41;

1.41
date	95.11.07.23.03.53;	author dumoulin;	state Exp;
branches;
next	1.40;

1.40
date	95.08.23.23.36.46;	author dumoulin;	state Exp;
branches;
next	1.39;

1.39
date	95.05.19.23.07.42;	author dumoulin;	state Exp;
branches;
next	1.38;

1.38
date	95.04.21.21.47.11;	author dumoulin;	state Exp;
branches;
next	1.37;

1.37
date	95.04.17.23.28.29;	author dumoulin;	state Exp;
branches;
next	1.36;

1.36
date	95.04.03.15.12.33;	author ishidou;	state Exp;
branches;
next	1.35;

1.35
date	95.02.07.23.01.52;	author jcooper;	state Exp;
branches;
next	1.34;

1.34
date	94.12.12.19.39.13;	author jcooper;	state Exp;
branches;
next	1.33;

1.33
date	94.11.30.22.22.08;	author jcooper;	state Exp;
branches;
next	1.32;

1.32
date	94.11.28.22.01.06;	author jcooper;	state Exp;
branches;
next	1.31;

1.31
date	94.11.21.21.20.46;	author jcooper;	state Exp;
branches;
next	1.30;

1.30
date	94.11.10.01.53.43;	author rushing;	state Exp;
branches;
next	;


desc
@winvn version 0.76 placed into RCS
@


1.43
log
@clean up some compile time errors
@
text
@/* --- WVHEADER.C ---------------------------------------------
 *  This file contains the code necessary to create the initial skeleton
 *  version of an article, which will be edited by the user.
 *
 *  Mark Riordan   24-JAN-1990
 * 
 *  Major overhaul by John S. Cooper  October 1994 
 */

/*
 * $Id: wvheader.c 1.42 1996/08/13 05:00:16 dumoulin Exp $
 */

#include <windows.h>
#include <windowsx.h>
#include "wvglob.h"
#include "winvn.h"
#pragma hdrstop
#include <ctype.h>
#include <time.h>
#include <stdlib.h>

static char *days[] =
{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
static char *months[] =
{"Jan", "Feb", "Mar", "Apr", "May", "Jun",
 "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};


BOOL AuthenticatePosting (BOOL AuthReq);
/*--- function CreateComposeWnd -----------------------------------------
 *
 *    Create the window for composing the text of a posting,
 *    if it's OK to post.
 *
 *    Entry    Hwnd     Handle to parnet window
 *             Doc      points to the document to which we are posting
 *                      a followup--NULL if it's a new posting.
 *
 *    Exit     Returns the handle of the newly-created window
 *              (zero if failure).
 */
HWND
CreateComposeWnd (HWND hWnd, TypDoc * Doc, int DocType)
{
  register int i;
  BOOL found;
  BOOL AuthReq;
  int x, y, height, width;
  char *TitlePtr, *WndClassName, *posnString;
  int maxNum,mstatus;
  WndEdit *wndEdits;
  char temp[MAXINTERNALLINE];

  if ((DocType == DOCTYPE_POSTING) || (DocType == DOCTYPE_CANCEL)) {
	wndEdits = WndPosts;
	maxNum = MAXPOSTWNDS;

	AuthReq = AuthReqPost;
	posnString = "PostWindowPos";
	WndClassName = "WinVnPost";
	if (DocType == DOCTYPE_CANCEL)
	  TitlePtr = "Cancel Article";
	else if (Doc) {
	  TitlePtr = "Followup Article";
	}
	else {
	  TitlePtr = "New Article";
	}
  }
  else {
	wndEdits = WndMails;
	maxNum = MAXMAILWNDS;

	AuthReq = AuthReqMail;
	posnString = "MailWindowPos";
	WndClassName = "WinVnMail";
	if (Doc) {
	  if (DocType == DOCTYPE_FORWARD)
		TitlePtr = "Forward Article";
	  else
		TitlePtr = "Followup Mail";
	}
	else {
	  TitlePtr = "New Mail Message";
	}
  }

  for (i = 0, found = FALSE; !found && i < maxNum; i++) {
	if (!wndEdits[i].hWnd) {
	  found = TRUE;
	  break;
	}
  }
  if (!found) {
	MessageBox (hWnd, "Too many composition windows are open.\nPlease send or close one before continuing.",
				"Cannot Continue", MB_OK | MB_ICONSTOP);
  }
  else if (AuthenticatePosting (AuthReq)) {

	x = i * CompositionCharWidth;
	y = (int) (yScreen * 3 / 8) + (1 + i) * CompositionLineHeight;
	height = (int) (yScreen * 5 / 8) - (2 * CompositionLineHeight);
	if ((xScreen - SideSpace - 32) > (78 * CompositionCharWidth)) {    /* 32 for scroll bar */
	  width = (78 * CompositionCharWidth) + 32 + SideSpace;
	}
	else {
	  width = (xScreen - 32 - SideSpace);
	}

	wndEdits[i].Doc = Doc;
	wndEdits[i].composeType = DocType;

	/* If the screen position has been saved, use that instead. */
	GetPrivateProfileString (COMPOSE, posnString, "!",
							 temp, MAXINTERNALLINE, szAppProFile);
	if (*temp != '!') {
	  sscanf (temp, "%d,%d,%d,%d", &x, &y, &width, &height);
	}
	
	/* So we can get the "seal of approval" in the Broken Newsreader FAQ (JD 4/20/95)*/
	if (((width - 32 - SideSpace) / CompositionCharWidth) > 78) {
	   mstatus = MessageBox (hWnd, "Your Screen Width is wider than the Internet \n"
	                               "standard of 78 fixed point characters. This \n"
	                               "will make your post look bad on some viewers.  \n"
	                               "Select OK if you wish WinVN to make your \n"
	                               "edit window conform to the Internet standard.\n"
	                               "To make this a permanent change, Click on \n"
	                               "Save Window Positions from the Window menu \n",
				             "Screen Size exceeds Recommend Size",
				              MB_OKCANCEL | MB_ICONEXCLAMATION);
	   switch(mstatus) {
	     case IDOK:
		   width = (78 * CompositionCharWidth) + 32 + SideSpace;
		   SaveWindowPositions();
		   break;

		 case IDCANCEL:
		   break;
	   }
	 }

	wndEdits[i].hWnd = CreateWindow (WndClassName, TitlePtr,
									 WS_OVERLAPPEDWINDOW /* | WS_VSCROLL */ ,
									 x + (i * CompositionCharWidth),
									 y + (i * CompositionLineHeight),
									 width, height,
									 NULL, NULL, hInst,
									 (void *)&wndEdits[i]);

  }
  return (wndEdits[i].hWnd);
}

/*--- function GetHeaderLine -------------------------------------------
 *
 *  Given a document, get a line from the header portion of that document
 *  whose prefix matches a given prefix.  Prefix = firsComposition word in line.
 *  For instance, you might call this routine to say "Get the 'Subject:'"
 *  line from this document.
 *
 *    Entry    Doc      points to the document whose header we are scanning.
 *                      The header is all the lines up to the first blank line.
 *             Prefix   is the character string which will identify the
 *                      line we are seeking.  It is the first word
 *                      (blank-delimited) in a line in the header.
 *             BufLen   is the number of bytes left in the buffer Buf.
 *
 *    Exit     Returns TRUE iff we returned a line.
 *             Buf      if line was returned, contains that line, zero-
 *                      terminated.
 */

#define myisspace(c) (((char)(c) == ' ' ) || (((char)(c) >= (char)0x09) && ((char)(c) <= (char)0x0d)))

BOOL
GetHeaderLine (TypDoc * Doc, char *Prefix, char *Buf, int BufLen)
{
  char *bufptr = Buf;
  TypBlock far *BlockPtr;
  TypLine far *LinePtr;
  unsigned int Offset;
  HANDLE hBlock;
  TypLineID MyLineID;
  int found = FALSE;
  int len;

  if (TopOfDoc (Doc, &BlockPtr, &LinePtr)) {
        while (ExtractTextLine (Doc, LinePtr, Buf, BufLen-3)) {
		/* Is this a blank line signifying the end of the header?      */
		if (IsBlankStr (Buf))
		  break;

		if ( _strnicmp (Buf, Prefix, strlen (Prefix)) == 0) {
		  found = TRUE;

// for continuous lines by shimomai
                  while (BufLen-3 > 0 && NextLine (&BlockPtr, &LinePtr)) {
			BufLen -= (len = strlen(Buf) + 2);
			Buf += len;
                    if (!ExtractTextLine (Doc, LinePtr, Buf, BufLen-3) ||
				!myisspace(*Buf) || IsBlankStr (Buf)) {
//                        *(Buf-2) = '\0';
			  break;
			}
                        else {
                          *(Buf-2) = '\r';
                          *(Buf-1) = '\n';
                        }
		  }
		  break;
		}
		if (!NextLine (&BlockPtr, &LinePtr))
	 	 break;
  	}
  	UnlockLine (BlockPtr, LinePtr, &hBlock, &Offset, &MyLineID);
  }
  return (found);
}

/*--- function NextToken -----------------------------------------------
 *
 *  Position a pointer to the next token in a string.
 *  Delimiters are space and tab.
 *
 *    Entry    cptr     points to a position in a zero-terminated string.
 *
 *    Exit     Returns TRUE iff a next token was found.
 *             cptr     points to the next token, if found--else
 *                      it is unchanged.
 */
BOOL
NextToken (char **cptr)
{
  /* Skip to end of current token, if any. */
  while (**cptr != ' ' && **cptr != '\t' && **cptr)
	(*cptr)++;

  /* Skip past white space. */
  while (**cptr && (**cptr == ' ' || **cptr == '\t'))
	(*cptr)++;

  return (**cptr != '\0');
}

/*--- function AppendTextToEditBuf ----------------------------------------
 *
 *    Appends a zero-terminated text line to a buffer to be given
 *    to an Edit window.  Used in building messages to be displayed
 *    and edited by an Edit window.
 *
 *    Entry    instr    points to a text line to add.  It is terminated
 *                      by a zero byte and does not end in CR or LF.
 *             left     is the number of characters left in buf.
 *
 *    Exit     buf      contains the line, terminated by CR and LF.
 *                      buf now points to the next available byte.
 *             left     has been decremented as appropriate.
 */
void
AppendTextToEditBuf (char *instr, char far ** buf, long *left)
{
  while (--(*left) > 0 && *instr) {
	*((*buf)++) = *(instr++);
  }
  if (--(*left) > 0)
	*((*buf)++) = '\r';

  if (--(*left) > 0)
	*((*buf)++) = '\n';

  if ((*left) > 0)
	**buf = '\0';
}

/*--- function ParseAddress --------------------------
 *   Scan the
 *       address field (null terminated ascii string)
 *  representing any email address and optional
 *       name
 *
 *   and extract
 *   addressout which is the email address
 *   nameout    which is the name (enclosed in parenthises)
 *
 */
void
ParseAddress(const char *headerline, char *addressout, long addressoutlen, char *nameout, long nameoutlen)
{
  const char *ptra = headerline;
  char *ptrb, *ptrc;
  char *iptr, *optr;
  int lastspace;
  long int adlen = addressoutlen - 1, nmlen = nameoutlen - 1;
  long int l;

  *nameout = *addressout = '\0';

// Note parsing not strictly correct as anything in quotes '"'
  // overrides the meaning of lexical constructs '<' and '('

// Seems this works and is robust but is now in the main
  // group list read and should be extremely efficient
  // suggest a single pass 'stream' parse more appropriate
  // but is more work

  if (ptrb = strchr (headerline, '<')) {	// address enclosed in brackets  

	l = min (ptrb - ptra - 1, nmlen);
	if (l < 0)
	  l = 0;					/* this was killing print??? */
	if (l > 0) {				// otherwise strncpy crashes

      if (*(ptrb + l) != ' ') l++;  //shimomai

	  nmlen -= l;
	  strncpy (nameout, ptra, (int) l);
	  nameout[l] = 0;
	}
	if (ptrc = strchr (headerline, '>')) {
	  if (nmlen > 0) {
		strncpy (nameout + l, ptrc + 1, (int) nmlen);
		nameout[nameoutlen - 1] = 0;
	  }
	  l = min (ptrc - ptrb - 1, adlen);
	}
	else {
	  l = adlen;
	}
	if (l > 0) {
	  strncpy (addressout, ptrb + 1, (int) l);
	  addressout[l] = 0;
	}

  }
  else if (ptrb = strchr (headerline, '(')) {	// name enclosed in braces

	l = min (ptrb - ptra - 1, adlen);
	if (l < 0) l = 0;					// JD 8/3/96
	if (l > 0) {
		if (*(ptrb + l) != ' ') l++;    // JD 8/3/96
	  adlen -= l;
	  strncpy (addressout, ptra, (int) l);
	  addressout[l] = 0;
	}
	if (ptrc = strchr (headerline, ')')) {
	  if ((adlen > 0) && *(ptrc+1)){
		strncpy (addressout + l, ptrc + 1, (int) adlen);
		addressout[addressoutlen - 1] = 0;
	  }
	  l = min (ptrc - ptrb - 1, nmlen);
	}
	else {
	  l = nmlen;
	}
	if (l > 0) {
	  strncpy (nameout, ptrb + 1, (int) l);
	  nameout[l] = 0;
	}

  }
  else {						// just an address

	strncpy (addressout, ptra, (int) adlen);
	addressout[addressoutlen - 1] = 0;
  }

// Clean Name   - remove multiple space and quotes and parens
  lastspace = TRUE;
   for (iptr = optr = nameout; *iptr; iptr++) {
	switch (*iptr) {
	case ' ':
	  if (!lastspace)
		*optr++ = *iptr;
	  lastspace = TRUE;
	  break;
	case '"':
	case '(':
	case ')':
	  break;
	default:
	  *optr++ = *iptr;
	  lastspace = FALSE;
	}
  }
  *optr = 0;

// Clean Address
  for (iptr = optr = addressout; *iptr; iptr++) {
	switch (*iptr) {
	case ' ':
	case '(':
	case ')':
	  break;
	default:
	  *optr++ = *iptr;
	  lastspace = FALSE;
	}
  }
  *optr = 0;

  if (*nameout == 0) {			// if no name default to address

	strncpy (nameout, addressout, (int) nmlen);
	addressout[nameoutlen - 1] = 0;
  }

}

/*------------------------------------------------------------------------
 * Getxxx functions
 * Fill a buffer with appropriate string for use in header
 * possibly based on a refDoc (doc to which we are replying/following-up)
 * jsc 10/3/94
 */
BOOL
GetToAddress (char *buf, int len, TypDoc * refDoc, HWND hWnd)
{
  char headerLine[MAXHEADERLINE];
  char *ptr = headerLine;
  BOOL gotwho;
  char replyAddress[MAXHEADERLINE], replyName[MAXHEADERLINE];

  *buf = '\0';
  if (refDoc) {
	if (GetHeaderLine (refDoc, "From:", headerLine, MAXHEADERLINE)) {
	  NextToken (&ptr);
	  ParseAddress (ptr, AddressString, MAXDIALOGSTRING, NameString, MAXDIALOGSTRING);
	}
	if (gotwho = GetHeaderLine (refDoc, "Reply-To:", headerLine, MAXHEADERLINE)) {
	  NextToken (&ptr);
	  ParseAddress (ptr, replyAddress, MAXHEADERLINE, replyName, MAXHEADERLINE);
	}
	if (gotwho && strcmp (AddressString, replyAddress)) {
	  if (*AddressString && ConfirmReplyTo) {
		sprintf (str, "Use Reply-To: (%s) instead of\nFrom: (%s) in reply?",
				 replyAddress, AddressString);

		if (MessageBox (hWnd, str, "Confirm Reply-To",
						MB_YESNO | MB_ICONQUESTION) == IDNO) {
		  gotwho = FALSE;
		}
	  }
	  if (gotwho) {
		strcpy (AddressString, replyAddress);
	  }
	}
	if (*AddressString) {
	  strntcpy (buf, AddressString, len);
	  return TRUE;
	}
  }
  return FALSE;
}

BOOL
GetNewsgroups (char *buf, int len, TypDoc * refDoc)
{
  char headerLine[MAXHEADERLINE];
  char *ptr = headerLine;
  BOOL gotnews = FALSE;

  if (refDoc) {
    if (refDoc->DocType == DOCTYPE_CANCEL)
	   gotnews = GetHeaderLine (refDoc, "Newsgroups:", headerLine, MAXHEADERLINE);
	else
       gotnews = GetHeaderLine (refDoc, "Followup-to:", headerLine, MAXHEADERLINE) ||
                 GetHeaderLine (refDoc, "Newsgroups:", headerLine, MAXHEADERLINE);

	if (gotnews) {
	  NextToken (&ptr);
	  strntcpy (buf, ptr, len);
	  return TRUE;
	}
  }
  if (NewsgroupsPtr && *NewsgroupsPtr) {
	strntcpy (buf, NewsgroupsPtr, len);
	return TRUE;
  }
  return FALSE;
}

BOOL
GetFromAddress (char *buf, int len, TypDoc * refDoc)
{
  char temp[MAXHEADERLINE];

  *buf = '\0';
  if (*MailAddress) {
	strntcpy (buf, MailAddress, len);
	if (*UserName) {
	  len -= strlen (MailAddress);
	  _snprintf (temp, len, " (%s)", UserName);
	  strcat (buf, temp);
	}
	return TRUE;
  }
  return FALSE;
}

BOOL
GetSubject (char *buf, int len, TypDoc * refDoc, int docType)
{
  char headerLine[MAXHEADERLINE];
  char *ptr = headerLine;

  *buf = '\0';
  if (refDoc) {
	if (GetHeaderLine (refDoc, "Subject:", headerLine, MAXHEADERLINE)) {
	  NextToken (&ptr);
	  if (docType == DOCTYPE_FORWARD) {
		_snprintf (buf, len, "%s (fwd)", ptr);
	  }
	  else {
		if (_strnicmp (ptr, "re:", 3)) {
		  _snprintf (buf, len, "Re: %s", ptr);
		}
		else {
		  strntcpy (buf, ptr, len);
		}
	  }
	  return TRUE;
	}
  }
  return FALSE;
}

BOOL
GetCcAddress (char *buf, int len, TypDoc * refDoc)
{
  char from[MAXHEADERLINE], cc[MAXHEADERLINE];
  char *ptr = from;

  *buf = '\0';
  if (refDoc) {
	if (GetHeaderLine (refDoc, "Cc:", from, MAXHEADERLINE - 1)) {
	  NextToken (&ptr);
	  ParseAddress (ptr, cc, MAXHEADERLINE, str, MAXINTERNALLINE);
	  if (_stricmp(cc, MailAddress)) {	// ignore if Cc: is me
	  	strntcpy (buf, cc, len);
	  }
	  return TRUE;
	}
  }
  return FALSE;
}


BOOL
GetReplyToAddress (char *buf, int len, TypDoc * refDoc)
{
  *buf = '\0';
  if (*ReplyTo && strcmp (ReplyTo, MailAddress)) {
	strntcpy (buf, ReplyTo, len);
	return TRUE;
  }
  return FALSE;
}

BOOL
GetOrganization (char *buf, int len, TypDoc * refDoc)
{
  *buf = '\0';
  if (*Organization) {
	strntcpy (buf, Organization, len);
	return TRUE;
  }
  return FALSE;
}

BOOL
GetFollowupTo (char *buf, int len, TypDoc * refDoc)
{
  char headerLine[MAXHEADERLINE];
  char *ptr = headerLine;

  *buf = '\0';
  if (refDoc) {
	if (GetHeaderLine (refDoc, "Followup-to:", headerLine, MAXHEADERLINE)) {
	  NextToken (&ptr);	  
	  strntcpy (buf, ptr, len);
	  return TRUE;
	}
  }
  return FALSE;
}

// Checks a special case of RFC 1036
BOOL
FollowupToPoster (TypDoc * refDoc)
{
  char headerLine[MAXHEADERLINE];
  char *ptr = headerLine;

  if ((refDoc) &&
	  (GetHeaderLine (refDoc, "Followup-to:", headerLine, MAXHEADERLINE))) {
	 if (string_compare_insensitive("poster",headerLine+14) != NULL) 
       return TRUE; 
     else
       return FALSE;
	}
  return FALSE;
}

BOOL
GetHeaderContents (char *buf, int len, TypDoc * refDoc, char *hdr)
{
  char headerLine[MAXHEADERLINE];
  char *ptr = headerLine;

  *buf = '\0';
  if (refDoc) {
	if (GetHeaderLine (refDoc, hdr, headerLine, MAXHEADERLINE)) {
	  NextToken (&ptr);
	  strntcpy (buf, ptr, len);
	  return TRUE;
	}
  }
  return FALSE;
}

/* If refDoc has a references then use that followed by one space. 
 * Then add the refDoc message-id.
 */
BOOL
GetReferences (char *buf, int len, TypDoc * refDoc)
{
  char headerLine[MAXHEADERLINE];
  char *ptr;
  int tokenLen, lenToGo = len;

  *buf = '\0';
  if (refDoc) {
	if (GetHeaderLine (refDoc, "References:", headerLine, MAXHEADERLINE)) {
	  ptr = headerLine;
	  NextToken (&ptr);
	  tokenLen = strlen (ptr);
// shimomai
          while(tokenLen > 0 && ptr[tokenLen-1] != '>') tokenLen--;
//
          strncpy (buf, ptr, tokenLen);
	  buf[tokenLen++] = ' ';
	  buf[tokenLen] = '\0';
	  lenToGo -= tokenLen;
	}
	if (GetHeaderLine (refDoc, "Message-ID:", headerLine, MAXHEADERLINE)) {
	  ptr = headerLine;
	  NextToken (&ptr);
// shimomai
          if((tokenLen=strlen(ptr)) >= lenToGo) {
                char *p, *q;
                p = &(buf[tokenLen-lenToGo]);
                if(p = strchr(p+1,'<')) {
                        for(q = buf ; *p != '\0' ; p++,q++) *q = *p;
                        *q= '\0';
                }
                else {
                        buf[0] = '\0';
                }
                lenToGo = len - strlen(buf);
          }
          strncat (buf, ptr, tokenLen);
	}
  }
  return (*buf != '\0');
}     

/*  If the article has an Xref header, we should check to see if the news server 
    that calculated the message ID matches the news server to which we are 
    connected.  This is hard since WinVN doesn't have direct access to the
    WinSock routines.  Since WinVN currently doesn't support multiple simultaneous
    servers, we'll not validate the server and just skip over this entry.  This
    routine then returns a list of crossposted references in "buf" and
    return TRUE, else return FALSE (no Xref or not our server)   
                                                          JD 5/3/95          */
BOOL
GetXref (char *buf, int len, TypDoc * refDoc)
{
  char headerLine[MAXHEADERLINE];
  char *ptr,*ptr1;

  *buf = '\0';
  if (refDoc) {
	if (GetHeaderLine (refDoc, "Xref:", headerLine, MAXHEADERLINE)) {
	  ptr = headerLine;
	  NextToken (&ptr);          /* Skip over Xref: */
	  ptr1 = ptr;
	  while (*ptr1 != ' ' && *ptr1 != '\t' && *ptr1) (ptr1)++;
	  strntcpy (buf, ptr, ptr1-ptr);
//	  if ((NNTPHost == 0) || (compare_hostname (NNTPHost,buf) != 0)) return FALSE;
	  NextToken (&ptr);
	  strntcpy (buf, ptr, len);
	}
  }
  return (*buf != '\0');
}

/* For mail, an In-Reply-To field contains the msg-id of the msg 
 * being replied to.
 */
BOOL
GetInReplyTo (char *buf, int len, TypDoc * refDoc)
{
  char headerLine[MAXHEADERLINE];
  char *ptr;

  *buf = '\0';
  if (refDoc) {
	if (GetHeaderLine (refDoc, "Message-ID:", headerLine, MAXHEADERLINE)) {
	  ptr = headerLine;
	  NextToken (&ptr);
	  strntcpy (buf, ptr, len);
	}
  }
  return (*buf != '\0');
}

/* Returned date str is computed from operating system time.
 * Be sure to set the TZ environment variable correctly for
 * "gmtime" to work properly.  Typical setting:  SET TZ=EST5
 */
BOOL
GetDate (char *buf, int len)
{
#ifdef WIN32
  TIME_ZONE_INFORMATION tzinfo;
  SYSTEMTIME local_time;
  DWORD dstflag;
  DWORD errorcode;
  long timezonebias;

  dstflag = GetTimeZoneInformation(&tzinfo);
  switch (dstflag) {
	case 0xfffffff:
	  errorcode = GetLastError();
	  wsprintf(str, "Failed to retrieve system timezone information\nError code:%d", errorcode);
	  MessageBox (NULL, str, "Timezone info retrieve failure", MB_OK | MB_ICONHAND);
	  return FALSE;
	  break;

	case TIME_ZONE_ID_UNKNOWN:
	case TIME_ZONE_ID_STANDARD:
	  timezonebias = (tzinfo.Bias/60) * 100 + (tzinfo.Bias%60);
	  break;

	case TIME_ZONE_ID_DAYLIGHT:
	  timezonebias = ((tzinfo.Bias + tzinfo.DaylightBias)/60) * 100 + ((tzinfo.Bias + tzinfo.DaylightBias)%60);
	  break;
  }

  GetLocalTime(&local_time);

  /* rfc1036&rfc822 acceptable format */
  /* Mon, 29 Jun 93 02:15:23 -0800 */
  _snprintf (buf, len, "%s, %.2d %s %.2d %.2d:%.2d:%.2d %+05d",
			 days[local_time.wDayOfWeek],
			 local_time.wDay,
			 months[local_time.wMonth-1],
			 local_time.wYear,
			 local_time.wHour,
			 local_time.wMinute,
			 local_time.wSecond,
			 -timezonebias);

#else
  struct tm *timeptr;
  time_t curtime;
  long TimezoneBias;
  char TimeZoneBuf[MAXTZONESIZE+5];

  if (TimeZone == NULL) {
	if (!getenv ("TZ")) {
	  MessageBox (NetDoc.hDocWnd,
				"Timezone environment variable 'TZ' not set.\n"
				"You must set this variable for your messages\n"
				"to be timestamped correctly.  Set it from the \n"
				"config menu or add it as an environment varialbe \n"
				"For example, you could add the following to your\n"
				"'autoexec.bat' file:\n"
				"set TZ=EST5EDT\n",
				"Warning:",
				MB_OK | MB_ICONHAND);
    }
  }

  strcpy(TimeZoneBuf,"TZ=");
  strcat(TimeZoneBuf,TimeZone);
  _putenv(TimeZoneBuf);
  _tzset();
  curtime = time ((time_t *) NULL);
  timeptr = localtime (&curtime);
  TimezoneBias = (_timezone/3600) * 100 + ((_timezone/60)%60);

  /* rfc1036&rfc822 acceptable format */
  /* Mon, 29 Jun 93 02:15:23 -0800 */
  _snprintf (buf, len, "%s, %.2d %s %.2d %.2d:%.2d:%.2d %+05d",
			 days[timeptr->tm_wday],
			 timeptr->tm_mday,
			 months[timeptr->tm_mon],
			 timeptr->tm_year,
			 timeptr->tm_hour,
			 timeptr->tm_min,
			 timeptr->tm_sec,
			 -TimezoneBias);
#endif
  return TRUE;
}


/* Returned date str is computed from operating system time.
 */
BOOL
GetMailboxDate (char *buf, int len)
{
  struct tm *timeptr;
  time_t curtime;

  curtime = time ((time_t *) NULL);
  timeptr = localtime (&curtime);

  // mailbox acceptable format */
  // i.e.       Tue 15 Mar 1994 11:11:22 */
  // changed to Tue Mar 15 11:11:22 1994 for compatibility with elm (JD 5/3/95)
  _snprintf (buf, len, "%s %s %.2d %.2d:%.2d:%.2d %.2d",
			 days[timeptr->tm_wday],
			 months[timeptr->tm_mon],
			 timeptr->tm_mday, 
			 timeptr->tm_hour,
			 timeptr->tm_min,
			 timeptr->tm_sec,
			 1900+timeptr->tm_year);

  return TRUE;
}

/* ------------------------------------------------------------------------
 * Generate 'says' line, given orig doc, template, and a dest buffer
 *  Replace %i with article ID
 *  Replace %d article date
 *  Replace %a with author email address
 *  Replace %n with author full name
 *
 * called by MakeBodyContents
 */
void
GenerateSaysLine (char *line, TypDoc * Doc, char *template)
{
  register char *src, *dest, *ptr;
  char mesId[MAXHEADERLINE];
  char from[MAXHEADERLINE];
  char date[MAXHEADERLINE];
  char address[MAXDIALOGSTRING];
  char name[MAXDIALOGSTRING];
  char *mesPtr = mesId;
  char *fromPtr = from;
  char *datePtr = date;
  char *addrPtr = address;
  char *namePtr = name;
  BOOL gotMesId, gotFrom, gotDate;

  gotMesId = GetHeaderLine (Doc, "Message-ID:", mesId, MAXHEADERLINE);
  if (gotMesId)
	NextToken (&mesPtr);
  else
	mesPtr = "<Unknown>";

  gotDate = GetHeaderLine (Doc, "Date:", date, MAXHEADERLINE);
  if (gotDate)
	NextToken (&datePtr);
  else
	datePtr = "<Unknown>";

  *address = *name = '\0';
  gotFrom = GetHeaderLine (Doc, "From:", from, MAXHEADERLINE);
  if (gotFrom) {
	NextToken (&fromPtr);
	ParseAddress (fromPtr, address, MAXDIALOGSTRING, name, MAXDIALOGSTRING);
	if (!(*addrPtr))
	  addrPtr = "<Unknown>";
	if (!(*namePtr))
	  namePtr = "<Unknown>";

  }
  else {
	fromPtr = "<Unknown>";
  }

  for (src = template, dest = line; *src != '\0';) {
	if (*src == '%') {
	  src++;
	  switch (*src) {
	  case '%':				// literal percent is %%

		*dest++ = '%';
		break;
	  case 'i':
		for (ptr = mesPtr; *ptr; *dest++ = *ptr++);
		break;
	  case 'd':
		for (ptr = datePtr; *ptr; *dest++ = *ptr++);
		break;
	  case 'n':
		for (ptr = namePtr; *ptr; *dest++ = *ptr++);
		break;
	  case 'a':
		for (ptr = addrPtr; *ptr; *dest++ = *ptr++);
		break;

	  default:
		*dest++ = '%';
		*dest++ = *src;
		break;

	  }
	  src++;					// skip control char after %

	  continue;
	}
	*dest++ = *src++;
  }
  *dest = '\0';
}

/*--- function MakeBodyContents ----------------------------------------------
 *
 *    Make the body of the article.  This is null if there's no article
 *    to reply to, else it's text of the form:
 *    In article <Message-ID>, <user> says:
 *    >line 1
 *    >line 2
 *    > .....
 *
 *    Entry    Doc      points to the article being replied to, else
 *                      NULL if none.
 *             left     is the number of bytes left in MesBuf.
 *
 *    Exit     MesBuf   contains the added lines, and has been updated
 *                      to point to just after the last added byte.
 *             left     has been decremented appropriately.
 *             Return value is not used, for now.
 *
 * called by MakeBody
 */
BOOL
MakeBodyContents (TypDoc * Doc, char far ** MesBuf, long *left, int DocType)
{
  HANDLE hBlock;
  unsigned int Offset, quoteIndSize;
  TypLineID MyLineID;
  TypBlock far *BlockPtr;
  TypLine far *LinePtr;
  char line[MAXHEADERLINE];
  register unsigned long i;

  if (Doc &&
	  TopOfDoc (Doc, &BlockPtr, &LinePtr)) {
	if (DocType == DOCTYPE_FORWARD) {
	  AppendTextToEditBuf ("----Forwarded----", MesBuf, left);
	  /* include original headers in forwarded doc */
	} 
	else if (DocType == DOCTYPE_CANCEL) { 
	  AppendTextToEditBuf ("", MesBuf, left);
	  GenerateSaysLine (line, Doc, "   Article %i canceled by WinVN");
	  AppendTextToEditBuf (line, MesBuf, left);
	  AppendTextToEditBuf ("", MesBuf, left);
	  AppendTextToEditBuf ("Cancel Reason:", MesBuf, left);
	  AppendTextToEditBuf ("", MesBuf, left);
	  AppendTextToEditBuf ("   NONE GIVEN", MesBuf, left);
	  }
	else {
	  GenerateSaysLine (line, Doc,
						(DocType == DOCTYPE_POSTING) ? FollowupSaysTemplate : ReplySaysTemplate);
	  AppendTextToEditBuf (line, MesBuf, left);

	  /* Skip past headers */
	  while (ExtractTextLine (Doc, LinePtr, line, MAXHEADERLINE) &&
			 !IsBlankStr (line)) {
		if (!NextLine (&BlockPtr, &LinePtr))
		  break;
	  }
	}

	/* Copy body of reply document into the body of this article,  */
	/* prepending a ">" to each line */

	/* following line commented after a merge of MRB code (SMR) */
	/* line[0] = '>'; */
    
    if (DocType != DOCTYPE_CANCEL) {
    
	  if (DocType == DOCTYPE_FORWARD) {
	    quoteIndSize = 0;
	  }
	  else {
	    quoteIndSize = 1;
	    line[0] = QuoteLineInd;
	  }
	  while (ExtractTextLine (Doc, LinePtr, line + quoteIndSize, MAXHEADERLINE - 1)) {
	    AppendTextToEditBuf (line, MesBuf, left);
	    if (!NextLine (&BlockPtr, &LinePtr))
		  break;
	  }
	}
	UnlockLine (BlockPtr, LinePtr, &hBlock, &Offset, &MyLineID);
  }

  if (EnableSig && Signature->numLines > 0) {
	AppendTextToEditBuf ("", MesBuf, left);		/* blank line before sig */
	if (strcmp (TextBlockLine (Signature, 0), SIG_DELIMITER)) {
	  AppendTextToEditBuf (SIG_DELIMITER, MesBuf, left);
	}
	for (i = 0; i < Signature->numLines; i++) {
	  AppendTextToEditBuf (TextBlockLine (Signature, i), MesBuf, left);
	}
  }
  return TRUE;
}

/* MakeBody sets endBuf to an allocated buf containing body, or NULL if no body.
 * It is the caller's responsibility to free the buf.
 * This can fail.
 */
BOOL
MakeBody (char **endBuf, TypDoc * refDoc, int docType, HWND hWnd)
{
  char *ptr, *buf;
  long bytesLeft;

  /* Compute the number of bytes we need to hold a straight ASCII representation
   * of the initial text of the reply, and allocate a buffer of that size.
   */
  bytesLeft = 0L;
  if (EnableSig && Signature->numLines) {
	// the 2 * Signature->numLines is to count \r\n for each line
	bytesLeft += Signature->numBytes + 2 * Signature->numLines + strlen (SIG_DELIMITER) + 10;
  }
  if (refDoc) {
	bytesLeft += (2 + NumBlocksInDoc (refDoc)) * refDoc->BlockSize;
  }
  if (bytesLeft) {
	if ((ptr = buf = (char *) GlobalAllocPtr (GMEM_MOVEABLE, bytesLeft * sizeof (char))) == NULL) {
	  MessageBox (hWnd, "Failed to Generate Article", "Memory Allocation Failure", MB_OK | MB_ICONSTOP);
	  return FAIL;
	}
	*ptr = '\0';
	MakeBodyContents (refDoc, &ptr, &bytesLeft, docType);
	*endBuf = buf;
  }
  else {
	*endBuf = (char *) NULL;
  }
  return SUCCESS;
}




/*--- function AuthenticatePosting --------------------------------
 *
 *   Determine whether the user has sent valid authentication
 *   information to the host.
 *
 *    Entry    Authenticated  is TRUE if we're already authorized.
 *             AuthReq        is TRUE if we need authorization.
 *
 *    Exit     Returns TRUE if we are authorized, else FALSE.
 *                                                             
 *    This routine is largely unimplemented.
 *    Intended
 *    Method   If we're already authorized, just return TRUE.
 *             Otherwise, make sure the comm channel to the server
 *             isn't busy.  If it is, put up a message to that
 *             effect and quit.
 *             If not busy, get authorization information from the
 *             user and present it to the server (in encoded form).
 *             Wait until the server responds or until the Abort
 *             Protocol flag is set (by the user via a menu).
 *             If authorized, return TRUE, else put up a
 *             message to the user and return FALSE.
 */
BOOL
AuthenticatePosting (BOOL AuthReq)
{
  BOOL whetherOK = FALSE;

  if (AuthReq && !Authenticated) {
	MessageBox (NetDoc.hDocWnd,
				"Sorry, you must identify yourself to the news server \
before sending.  Choose the Config/Configure Comm... menu option \
and enter your username and password.  \
Then Choose Network/Disconnect and Network/Connect.",
				"No permission", MB_OK);
  }
  else {
	whetherOK = TRUE;
  }

  return (whetherOK);
}
@


1.42
log
@support changes to support timezone
@
text
@d11 1
a11 1
 * $Id: wvheader.c 1.41 1995/11/07 23:03:53 dumoulin Exp $
d125 1
a125 1
	                               "will make your post look bad some viewers.  \n"
@


1.41
log
@Added code where TopOfDoc and BottomOfDoc were being called
but not handing case where function failed.  These are now
BOOL and set FALSE if the function failed to lock memory to
that location.
@
text
@d11 1
a11 1
 * $Id: wvheader.c 1.40 1995/08/23 23:36:46 dumoulin Exp $
d173 3
d186 1
d189 1
a189 1
  	while (ExtractTextLine (Doc, LinePtr, Buf, BufLen)) {
d196 15
d288 1
a288 1
ParseAddress (char *headerline, char *addressout, long addressoutlen, char *nameout, long nameoutlen)
d290 2
a291 1
  char *ptra = headerline, *ptrb, *ptrc;
d314 2
d339 1
d341 1
d638 4
a641 1
	  strncpy (buf, ptr, len);
d649 14
a662 1
	  strncat (buf, ptr, lenToGo);
d725 41
d768 2
d772 2
a773 5
#ifdef WIN32
  _tzset ();					/* get values from NT control panel */
#else
  if (!getenv ("TZ")) {
	MessageBox (NetDoc.hDocWnd,
d783 1
d785 5
a789 3
#endif
   }
   
d792 1
d795 2
a796 2
  /* Mon, 29 Jun 93 02:15:23 GMT */
  _snprintf (buf, len, "%s, %.2d %s %.2d %.2d:%.2d:%.2d %s",
d804 2
a805 2
			 tzname[0]);

@


1.40
log
@added an extra check incase a user posts without a valid
header entry for username and personal name.
@
text
@d11 1
a11 1
 * $Id: wvheader.c 1.39 1995/05/19 23:07:42 dumoulin Exp $
d184 5
a188 5
  TopOfDoc (Doc, &BlockPtr, &LinePtr);
  while (ExtractTextLine (Doc, LinePtr, Buf, BufLen)) {
	/* Is this a blank line signifying the end of the header?      */
	if (IsBlankStr (Buf))
	  break;
d190 8
a197 6
	if (_strnicmp (Buf, Prefix, strlen (Prefix)) == 0) {
	  found = TRUE;
	  break;
	}
	if (!NextLine (&BlockPtr, &LinePtr))
	  break;
a198 1
  UnlockLine (BlockPtr, LinePtr, &hBlock, &Offset, &MyLineID);
d320 1
a320 1
	  addressout[l + 1] = 0;
d346 1
a346 1
  for (iptr = optr = nameout; *iptr; iptr++) {
d871 2
a872 2
  if (Doc) {
	TopOfDoc (Doc, &BlockPtr, &LinePtr);
@


1.39
log
@changed syntax of file save to match unix mailbox format.  Changed
size of year from 2 character years (ie: 95) to 4 character years
(ie: 1995).  Added ability to post followup-to header to go to
the keyword poster.  Cleaned up raw pointer math.
@
text
@d11 1
a11 1
 * $Id: wvheader.c 1.38 1995/04/21 21:47:11 dumoulin Exp $
d322 1
a322 1
	  if (adlen > 0) {
@


1.38
log
@Add cancel capability and warning message when posting window is larger
than 78 characters in width.
@
text
@d11 1
a11 1
 * $Id: wvheader.c 1.36 1995/04/03 15:12:33 ishidou Exp $
d101 5
a105 5
	x = i * ArtCharWidth;
	y = (int) (yScreen * 3 / 8) + (1 + i) * ArtLineHeight;
	height = (int) (yScreen * 5 / 8) - (2 * ArtLineHeight);
	if (xScreen > 78 * ArtCharWidth) {
	  width = 78 * ArtCharWidth;
d108 1
a108 1
	  width = xScreen - 2 * ArtCharWidth;
d122 1
a122 1
	if (width/ArtCharWidth > 78) {
d134 2
a135 2
		   width = 78 * ArtCharWidth;
		   WriteWinvnProfile ();
d145 2
a146 2
									 x + (i * ArtCharWidth),
									 y + (i * ArtLineHeight),
d158 1
a158 1
 *  whose prefix matches a given prefix.  Prefix = first word in line.
d439 5
a443 3
//	gotnews = GetHeaderLine (refDoc, "Newsgroups:", headerLine, MAXHEADERLINE);
    gotnews = GetHeaderLine (refDoc, "Followup-to:", headerLine, MAXHEADERLINE) ||
              GetHeaderLine (refDoc, "Newsgroups:", headerLine, MAXHEADERLINE);
d563 1
d565 16
d625 30
d687 1
d695 2
a696 1
				"to be timestamped correctly.\n"
d704 2
d736 4
a739 3
  /* mailbox acceptable format */
  /* i.e. Tue 15 Mar 1994 11:11:22 */
  _snprintf (buf, len, "%s %.2d %s %.2d %.2d:%.2d:%.2d",
a740 1
			 timeptr->tm_mday,
d742 1
a742 1
			 timeptr->tm_year,
d745 2
a746 1
			 timeptr->tm_sec);
@


1.37
log
@Allow followup-to header to be displayed during posting window
@
text
@d51 1
a51 1
  int maxNum;
d55 1
a55 1
  if (DocType == DOCTYPE_POSTING) {
d62 3
a64 1
	if (Doc) {
d120 22
d821 10
a830 1
	}
d849 15
a863 12

	if (DocType == DOCTYPE_FORWARD) {
	  quoteIndSize = 0;
	}
	else {
	  quoteIndSize = 1;
	  line[0] = QuoteLineInd;
	}
	while (ExtractTextLine (Doc, LinePtr, line + quoteIndSize, MAXHEADERLINE - 1)) {
	  AppendTextToEditBuf (line, MesBuf, left);
	  if (!NextLine (&BlockPtr, &LinePtr))
		break;
d880 1
a880 1
/* MakeBody sets endBuf to an alloced buf containing body, or NULL if no body.
@


1.36
log
@Use Followup-to header instead of newsgroups header if available
@
text
@d11 1
a11 1
 * $Id: wvheader.c 1.35 1995/02/07 23:01:52 jcooper Exp $
d520 16
@


1.35
log
@pays attention to CC's during mail reply.
@
text
@d11 1
a11 1
 * $Id: wvheader.c 1.34 1994/12/12 19:39:13 jcooper Exp $
d415 4
a418 1
	gotnews = GetHeaderLine (refDoc, "Newsgroups:", headerLine, MAXHEADERLINE);
@


1.34
log
@0.9.99 update
@
text
@d11 1
a11 1
 * $Id: wvheader.c 1.33 1994/11/30 22:22:08 jcooper Exp $
d482 1
a482 1
	if (GetHeaderLine (refDoc, "From:", from, MAXHEADERLINE - 1)) {
d485 3
a487 1
	  strntcpy (buf, cc, len);
@


1.33
log
@93.9 changes
@
text
@d11 1
a11 1
 * $Id: wvheader.c 1.32 1994/11/28 22:01:06 jcooper Exp $
d432 1
a432 1
  char temp[MAXINTERNALLINE];
a520 1
  long int BufLen = MAXDIALOGSTRING;
@


1.32
log
@93.8 update from jcooper
@
text
@d11 1
a11 1
 * $Id: wvheader.c 1.31 1994/11/21 21:20:46 jcooper Exp $
d319 1
a319 1
// Clean Name   - remove multiple space and quotes
d329 2
d343 2
@


1.31
log
@93.7 update
@
text
@d11 1
a11 1
 * $Id: wvheader.c 1.30 1994/11/10 01:53:43 rushing Exp $
d78 1
a78 1
		TitlePtr = "Forward Message";
d80 1
a80 1
		TitlePtr = "Reply Message";
a83 1
	  strcpy (AddressString, "");
d375 1
a375 1
	  ParseAddress (ptr, AddressString, MAXHEADERLINE, NameString, MAXHEADERLINE);
d480 1
a480 1
	  ParseAddress (ptr, cc, MAXDIALOGSTRING, str, MAXINTERNALLINE);
@


1.30
log
@restart
@
text
@d49 2
a50 2
  unsigned int width;
  char *TitlePtr, *WndClassName;
d53 1
d60 1
d74 1
a93 1

d99 4
d112 8
d122 3
a124 4
									 i * CharWidth,
							 (int) (yScreen * 3 / 8) + (1 + i) * LineHeight,
									 (int) width,
								 (int) (yScreen * 5 / 8) - (2 * LineHeight),
d126 1
a126 1
									 &wndEdits[i]);
@
