/*
 * DEFAULTS.H
 * Defaults for profile
 * JSC 1/18/94
 * 
 * $Id: defaults.h 1.35 1996/08/31 06:50:41 dumoulin Exp $
 * 
 */

// personal
#define DEF_UserName "Your Name Here"
#define DEF_MailAddr "you@somehost.somedomain"
#define DEF_Organization "Your Organization"
#define DEF_ReplyTo ""

// comm
#define DEF_UsingSocket TRUE
#define DEF_NNTPHost "News"
#define DEF_SMTPHost "Mail"
#define DEF_NNTPService "nntp"
#define DEF_ConnectAtStartup TRUE
#define DEF_GenSockDLL "gwinsock.dll"
#define DEF_ForceXhdr HDR_AUTO
#define DEF_MailDemandLogon TRUE
#define DEF_MailForceType 2
#define DEF_DebugComm TRUE
#define DEF_TimeZone "EST5EDT" 
#define DEF_MAPIPrefix "SMTP:"

// auth
#define DEF_NNTPUserName ""
#define DEF_NNTPPassword ""
#define DEF_AuthReqPost FALSE
#define DEF_AuthReqMail FALSE
#define DEF_NNTPSavePassword FALSE	// PCT, 10/05/94

// logging
#define DEF_MailLog FALSE
#define DEF_MailLogFile  "MAIL.LOG"
#define DEF_PostLog FALSE
#define DEF_PostLogFile  "POST.LOG"

// confirmations
#define DEF_ConfirmBatchOps TRUE
#define DEF_ConfirmDisconnect TRUE
#define DEF_ConfirmSaveOnExit FALSE
#define DEF_ConfirmReplyTo TRUE

// article list
#define DEF_NewWndGroup TRUE
#define DEF_ArticleThreshold 300L
#define DEF_MinToRetrieve 50L
#define DEF_FullNameFrom TRUE
#define DEF_EnableThreading TRUE
#define DEF_ThreadFullSubject FALSE
#define DEF_DoList ID_DOLIST_ASK-ID_DOLIST_BASE
#define DEF_ArticleThreshold 300L
#define DEF_MinToRetrieve 50L
#define DEF_ShowUnreadOnly FALSE
#define DEF_ShowReadArticles TRUE
#define DEF_SaveArtAppend TRUE
#define DEF_SaveNewsrcOnClose FALSE
#define DEF_ArtListMultiSelect FALSE
#define DEF_ThreadDepthIndicator ">"
#define DEF_SpareRanges 8
#define DEF_TrackSubscribedCrossposts TRUE
#define DEF_TrackUnsubscribedCrossposts FALSE
#define DEF_EnableArticleAction TRUE

// article
#define DEF_NewWndArticle FALSE
#define DEF_TrimHeaders FALSE
#define DEF_WrapIncomingArticleText FALSE
#define DEF_WrapIncomingArticleTextLength 80
#define DEF_ScrollPastHeaders TRUE
#define DEF_ItalicizeQuotes TRUE

// group list
#define DEF_DoList ID_DOLIST_ASK-ID_DOLIST_BASE
#define DEF_ShowUnsubscribed TRUE
#define DEF_GroupListMultiSelect FALSE
#define DEF_GroupFilter "*"
#define DEF_EnableGroupFilter FALSE
#define DEF_MaxNewGroups 3000

// windows
#define DEF_ShowUnsubscribed TRUE
#define DEF_ShowReadArticles TRUE

#define DEF_GroupMultiSelect TRUE

// compose
#define DEF_WordWrap TRUE
#define DEF_PrefillCcAddress TRUE
#define DEF_ShowFromHdr FALSE
#define DEF_ShowOrgHdr FALSE
#define DEF_ShowReplyToHdr FALSE
#define DEF_ShowKeywordsHdr FALSE
#define DEF_ShowSummaryHdr FALSE
#define DEF_ShowDistributionHdr FALSE
#define DEF_EnableSignature FALSE
#define DEF_ShowFollowupToHdr TRUE
#define DEF_SignatureFile ""

// misc
#define DEF_FollowupSaysTemplate "In article %i, %a says..."
#define DEF_ReplySaysTemplate "In article %i, you say..."

// coding
#define DEF_DecodePath ""
#define DEF_CodingStatusVerbose FALSE
#define DEF_DumbDecode FALSE
#define DEF_ExecuteDecodedFiles FALSE
#define DEF_KeepArticleHeaderVisible FALSE
#define DEF_BlockCodingStatusAlwaysOnTop FALSE
#define DEF_MinimizeStatusWindows FALSE
#define DEF_AlsoDecodeOpenArticles FALSE

// attachments
#define DEF_DefaultAttachInNewArt FALSE
#define DEF_ArticleSplitLength 60000L
#define DEF_SubjectTemplate "%s - %f [%0p/%t]"
#define DEF_GenerateMIME TRUE
#define DEF_MIMEUsageSuggestions TRUE
#define DEF_MIMEBoundary  "*-*-*- Next Section -*-*-*"
#define DEF_MIMEUUType "x-uue"
#define DEF_MIMEXXType "x-xxe"
#define DEF_MIMECustomType "x-custom3to4"
#define DEF_MIMECharset "ISO-8859-1"
#define DEF_DefaultEncodingType "Base-64"
#define DEF_DefaultContentType "Other"
#define DEF_EncodingTable ""


// interface
#define DEF_WinVnFontFace "MS Sans Serif"
#define DEF_WinVnFontSize 8
#define DEF_WinVnFontStyle "Bold"
#define DEF_CompositionFontFace "Courier"
#define DEF_CompositionFontSize 10
#define DEF_CompositionFontStyle "Regular"
#define DEF_ListFontFace "Courier"
#define DEF_ListFontSize 10
#define DEF_ListFontStyle "Regular"
#define DEF_ArticleFontFace "Courier"
#define DEF_ArticleFontSize 10
#define DEF_ArticleFontStyle "Regular"
#define DEF_StatusFontFace "Times New Roman"
#define DEF_StatusFontSize 11
#define DEF_StatusFontStyle "Regular"
#define DEF_PrintFontFace "Arial"
#define DEF_PrintFontSize 12
#define DEF_NetUnSubscribedColor "0,0,255"
#define DEF_NetSubscribedColor "0,0,0"
#define DEF_ArticleUnSeenColor "0,0,0"
#define DEF_ArticleSeenColor "0,0,255"
#define DEF_ArticleKilledColor "128,128,255"
#define DEF_ArticleTextColor "0,0,0"
#define DEF_StatusTextColor "0,0,0"
#define DEF_ArticleBackgroundColor "192,192,192"	// grey
#define DEF_ListBackgroundColor "192,192,192"
#define DEF_StatusBackgroundColor "192,192,192"
#define DEF_ThumbTrack TRUE
#define DEF_UseInverseSelections FALSE
#ifdef USE_SPLASH
#define DEF_ShowSplashScreen TRUE
#endif

// smart filer 
#define DEF_OnDupeName 0
#define DEF_OnNameTooLong 0
#define DEF_EnableExtensionConversion 1 
#ifdef WIN32
#define DEF_MaxFileNameLen 155
#define DEF_MaxFileExtLen 50
#else
#define DEF_MaxFileNameLen 8
#define DEF_MaxFileExtLen 3
#endif


// execute
#define DEF_HttpClient "%INTERNET%\\mosaic\\mosaic %u"
#define DEF_FtpClient "%INTERNET%\\ws_ftp\\ws_ftp %h:%f"
#define DEF_GopherClient ""
#define DEF_WaisClient ""

/* this is for emacs
 * Local variables:
 * tab-width: 2
 * end:
 */
