#! /usr/local/bin/python
# checks to see what files have changed from their RCS counterparts.

import sys
import os
import regex

# a hack, sort of
sys.path.append ('maint')

from getver import *

def usage ():
	print 'checkver.py file ...'

if len(sys.argv) < 2:
	usage()
	sys.exit()
	
files = sys.argv[1:]

# this grabs the version number out of the first line of an RCS file.
head_reg = regex.compile ('head\t\(\([0-9]+\.\)*[0-9]+\);$')

# this grabs the version number out of an Id string.
id_reg = regex.compile('[^ \t]+[ \t]\(\([0-9]+\.\)*[0-9]+\).*$')
#id_reg = regex.compile('[^ \t]+ \([^ \t]+\) .*$')

changed = []

print 'checking for changes...'
sys.stdout.flush()

for x in files:
	result = os.system ('rcsdiff -q '+x)
	if result != 0:
		changed.append (x)
	print x
	sys.stdout.flush()

if len(changed) > 0:
	print '-'*75
	print 'the following files have changed (* means an rcsmerge is necessary):'
	for x in changed:
		fname = os.path.join('RCS', x)
		fd = open (fname, 'r')
		head_line = fd.readline()
		fd.close()
		if head_reg.match (head_line) == -1:
			print "couldn't get RCS version info from "+fname
		else:
			rcs_ver = head_reg.group(1)
			id_string = find_version (x)
			if id_string != '':
				# this is guaranteed to work.
				id_reg.match (id_string)
				file_ver = id_reg.group(1)
				if file_ver == rcs_ver:
					print x
				else:
					print x + ' * ',
					print 'source: '+file_ver+'   RCS: '+rcs_ver
			else:
				print 'no version string found in '+x
else:
	print 'all files are checked in correctly.'
