/*
 * $Id: winvn.h 1.72 1996/08/13 03:38:57 brydon Exp $
 */

#ifndef __WINVN__
#define __WINVN__

#ifdef WIN32
#define __far far
#define huge far
#define __near near
#endif

#define ID_ABOUT 100

#ifdef __cplusplus
extern "C" {
#endif

int PASCAL WinMain (HINSTANCE, HINSTANCE, LPSTR, int);
BOOL WinVnInit (HINSTANCE hInstance, LPSTR lpCmdLine);

/* Functions define in Ini-News.c */
int fnLocateFiles (HINSTANCE hInstance, LPSTR lpCmdLine);
int ReadSortOption(const char* sDefSort, const char* sGrp);
void WriteSortOption(int iOpt, const char* sGrp);

/* (SMR) Changed parameter lists to conform with 3.1 windows.h. */
long WINAPI WinVnConfWndProc (HWND, UINT, WPARAM, LPARAM);
long FAR PASCAL WinVnViewWndProc (HWND, UINT, WPARAM, LPARAM);
long WINAPI WinVnArtWndProc (HWND, UINT, WPARAM, LPARAM);

long WINAPI WinVnConfFrameWndProc (HWND, UINT, WPARAM, LPARAM);
long FAR PASCAL WinVnViewFrameWndProc (HWND, UINT, WPARAM, LPARAM);
long WINAPI WinVnArtFrameWndProc (HWND, UINT, WPARAM, LPARAM);

BOOL GetMemo (HWND, HWND, int);
BOOL WINAPI About (HWND, unsigned, WORD, LONG);
LRESULT FAR PASCAL WinVnArticleActionDlg (HWND, unsigned, WPARAM, LPARAM);
BOOL FAR PASCAL WinVnCommDlg (HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL WinVnSaveArtDlg (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL WinVnSaveArtsDlg (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL WinVnFindDlg (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL WinVnPersonalInfoDlg (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL WinVnExecuteInfoDlg (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL WinVnConfigConfirmationDlg (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL WinVnThresholdDlg (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL WinVnLogOptDlg (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL WinVnDecodeArtsDlg (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL WinVnAttachDlg (HWND hDlg, unsigned iMessage, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL WinVnAttachPrefsDlg (HWND hDlg, unsigned iMessage, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL WinVnComposePrefsDlg (HWND hDlg, unsigned iMessage, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL WinVnConfigArticleDlg (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL WinVnConfigArticleListDlg (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL WinVnConfigGroupListDlg (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL WinVnConfigCodingPrefsDlg (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL WinVnEncodeDlg (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL WinVnExitDlg (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL WinVnMailDlg (HWND hDlg, unsigned iMessage, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK VerListDlgProc (HWND hDlg, UINT iMessage, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL WinVnSmartFilerDlg (HWND hDlg, unsigned iMessage, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL WinVnSelectPathDlg (HWND hDlg, unsigned iMessage, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL WinVnHeadersDlg (HWND hDlg, unsigned iMessage, WPARAM wParam, LPARAM lParam);	//shimomai

/* several debug routines */
#ifndef TRACE0
#ifdef _DEBUG
#define TRACE0(parm1) {\
    wsprintf(szDebugBuffer,parm1);\
    OutputDebugString(szDebugBuffer);}
#define TRACE1(parm1,parm2) {\
    wsprintf(szDebugBuffer,parm1,parm2);\
    OutputDebugString(szDebugBuffer);}
#define TRACE2(parm1,parm2,parm3) {\
    wsprintf(szDebugBuffer,parm1,parm2,parm3);\
    OutputDebugString(szDebugBuffer);}
#define TRACE3(parm1,parm2,parm3,parm4) {\
    wsprintf(szDebugBuffer,parm1,parm2,parm3,parm4);\
    OutputDebugString(szDebugBuffer);}
#define TRACE4(parm1,parm2,parm3,parm4,parm5) {\
    wsprintf(szDebugBuffer,parm1,parm2,parm3,parm4,parm5);\
    OutputDebugString(szDebugBuffer);}
#else
#define TRACE0(parm1)
#define TRACE1(parm1,parm2)
#define TRACE2(parm1,parm2,parm3)
#define TRACE3(parm1,parm2,parm3,parm4)
#define TRACE4(parm1,parm2,parm3,parm4,parm5)
#endif
#endif

#ifdef _DEBUG
//#define DEBUG_BREAK _asm { int 3 }
#define DEBUG_BREAK DebugBreak()
#else
#define DEBUG_BREAK
#endif

#ifdef USE_SPLASH
/* in wvsplash.c */
void DisplaySplashScreen (HINSTANCE hInstance, HWND hwnd, int delay);
#endif

/* in file WVUSENET.C */
BOOL FAR PASCAL About (HWND, unsigned, WORD, LONG);
BOOL CrackGroupLine (char *buf, TypLine * lineptr, void*pEndLine);
BOOL CursorToTextLine (int X, int Y, TypDoc * DocPtr, TypBlock far ** BlockPtr,
                       TypLine far ** LinePtr);
int ReadNewsrc (void);
void WriteNewsrc (void);
void SetNetDocTitle (void);
void SetLineFlag (TypDoc * Doc, TypBlock far ** BlockPtr, TypLine far ** LinePtr, int wFlag, int wValue);
void SetExLineFlag (TypDoc * Doc, TypBlock far ** BlockPtr, TypLine far ** LinePtr, int wFlag, int wValue);
void GroupAction (TypDoc * Doc, TypBlock far ** BlockPtr, TypLine far ** LinePtr, int wFlag, int wValue);
void MakeHelpPathName (char *szFileName, int maxchars);
long cursor_to_char_number (long X, long Y, TypDoc * DocPtr, TypBlock far ** BlockPtr, TypLine far ** LinePtr);
void SetGroupActiveLines (void);
void SetSelections (TypDoc * MyDoc, TypLine far * LinePtr);

void SetUserMenus (TypDoc FAR * DocPtr, int enable);
void SetConnectMenuItems (TypDoc FAR * DocPtr, int enable);
void SetGroupMenus (TypDoc far * DocPtr, int enable);
void SetArticleMenus (TypDoc far * DocPtr, int enable);

BOOL MoreInit (void);
void InitAllFonts ();
void InitWinVnFonts ();
void InitCompositionFonts ();
void InitListFonts ();
void InitArticleFonts ();
void InitPrintFonts ();
void InitStatusFonts ();
void DestroyFonts ();
void InitBitmaps ();
void DestroyBitmaps ();
BOOL MainLoopPass (void);
void Connect ();
void Disconnect ();
void Reconnect ();
void AbortAllComm ();

void MakeHelpPathName (char *szFileName, int maxchars);
void WriteWinvnProfile ();
void SaveWindowPositions ();

void MoveCursor ();
BOOL CursorToTextLine (int X, int Y, TypDoc * DocPtr, TypBlock far ** BlockPtr,
                       TypLine far ** LinePtr);
void ViewArticle (TypDoc * Doc, long artindex, BOOL Reuse, BOOL showArt, char far * articleID);
void UnlinkArtsInGroup (TypDoc * GroupDoc);
void UpdateSeenArts (TypDoc * Doc);

/* in file WVBLOCK.C */
int NewBlock (TypBlock far * CurBlockPtr, TypBlock far ** NewBlockPtr);
void SetupEmptyBlock (TypBlock far * BlockPtr, HANDLE hCur, HANDLE hPrev,
                      HANDLE hNext, TypDoc * DocPtr);
BOOL DeleteBlock (TypBlock far ** CurBlockPtr, TypLine far ** CurLinePtr);
int AddLine (TypLine * LineToAdd, TypBlock far ** CurBlockPtr, TypLine far ** CurAddPtr);
BOOL ReplaceLine (TypLine * LineToAdd, TypBlock far ** CurBlockPtr, TypLine far ** CurLinePtr);
BOOL DeleteLine (TypBlock far ** CurBlockPtr, TypLine far ** CurLinePtr);
int NextLine (TypBlock far ** BlockPtr, TypLine far ** LinePtr);
int NextActiveLine (TypBlock far ** BlockPtr, TypLine far ** LinePtr);
int PrevLine (TypBlock far ** BlockPtr, TypLine far ** LinePtr);
int PrevActiveLine (TypBlock far ** BlockPtr, TypLine far ** LinePtr);
int NumBlocksInDoc (TypDoc * Doc);
void ForAllLines (TypDoc * Doc,
                  void lpfnFunc (TypDoc * Doc, TypBlock far ** BlockPtr, TypLine far ** LinePtr, int wFlag, int wValue),
                  int wFlag, int wValue);
void ForAllLinesOnScreen (TypDoc * Doc,
                          void lpfnFunc (TypDoc * Doc, TypBlock far ** BlockPtr, TypLine far ** LinePtr, int wFlag, int wValue),
                          int wFlag, int wValue);
void ForAllBlocks (TypDoc * Doc,
                   void lpfnFunc (TypDoc * Doc, TypBlock far ** BlockPtr, int wFlag, int wValue),
                   int wFlag, int wValue);
void SetForBlock (TypDoc * Doc, TypBlock far ** BlockPtr, int wFlag, int wValue);
BOOL FindLineOrd (TypDoc * Doc, unsigned int LineOrd, TypBlock far ** BlockPtr, TypLine far ** LinePtr);
int SearchLine (char *Line, int LineLen, char *Target, int TargLen);
BOOL DoFind (BOOL StartAtTop, BOOL multiSelect);
BOOL TopOfDoc (TypDoc * Doc, TypBlock far ** BlockPtr, TypLine far ** LinePtr);
BOOL BottomOfDoc (TypDoc * MyDoc, TypBlock far ** BlockPtr, TypLine far ** LinePtr);
BOOL ExtractTextLine (TypDoc * Doc, TypLine far * LinePtr, char *Buf, int BufSize);
BOOL LockLine (HANDLE hBlock, unsigned int LineOff, TypLineID FindLineID,
               TypBlock far ** BlockPtr, TypLine far ** LinePtr);
void UnlockLine (TypBlock far * BlockPtr, TypLine far * LinePtr,
             HANDLE * hBlock, unsigned int *LineOff, TypLineID * TheLineID);
void PtrToOffset (TypBlock far * BlockPtr, TypLine far * LinePtr,
             HANDLE * hBlock, unsigned int *LineOff, TypLineID * TheLineID);
TypLineID LineIDtoLinePtr (TypLineID MyLineID, TypDoc far * MyDoc, TypBlock far ** MyBlock, TypLine far ** LinePtr);
unsigned int WhatLine (TypBlock far * BlockPtr, TypLine far * LinePtr);
void MoveBytes (void far * Source, void far * Target, int NumBytes);
int InitDoc (TypDoc * Doc, HWND hWnd, TypDoc * Parent, int DType);
void FreeDoc (TypDoc * Doc);
int mylstrncmp (char far * ptr1, char far * ptr2, int len);
char far *mylstrncpy (char far * ptr1, const char far * ptr2, int len);

/* in file WVSCREEN.C */
void ScreenDown (int nLines, int LinesOnScreen, TypBlock far ** BlockPtr,
                 TypLine far ** LinePtr, int *LinesAdvanced);
void ScreenUp (int nLines, TypBlock far ** BlockPtr, TypLine far ** LinePtr,
               int *LinesBackedUp);
void ScrollIt (TypDoc * Document, WPARAM wParam, LPARAM lParam);
void NewScrollIt (TypDoc * Document, WPARAM wParam, LPARAM lParam);
void HScrollIt (TypDoc * Document, WPARAM wParam, LPARAM lParam);
int LineOnScreen (TypDoc * Doc, HANDLE hTargBlock, unsigned int TargOffset, TypLineID TargLineID);
void NextWindow (HWND hWnd, int docType);
void AdjustMidSc (TypBlock far * BlockPtr, TypLine far * LinePtr);
void AdjustTopSc (TypBlock far * BlockPtr, TypLine far * LinePtr);
void AdjustTopScByDoc (TypDoc * aDoc, TypLineID index);
void ScreenToTop (TypDoc * Doc);
BOOL AdvanceToActive (TypBlock far ** BlockPtr, TypLine far ** LinePtr);

/* in file WVFILE.c */
HFILE MRROpenFile (char *FileName, int Mode, TypMRRFile ** MRRFile);
void MRRCloseFile (TypMRRFile * MRRFile);
int MRRReadLine (TypMRRFile * MRRFile, char *Linebuf, int Len);
BOOL MRRWriteLine (TypMRRFile * MRRFile, char far * Linebuf, unsigned int Len);
BOOL MRRWriteDocument (TypDoc * Document, int Offset, char *szFileName, BOOL Append);

#ifndef _WIN32
BOOL CopyFile(char *source, char *destin, BOOL bFailIfExists);
#endif

BOOL GetNum (char **ptr, long int *num);
COLORREF StrToRGB (char *cstring);
char *RGBToStr (char *buf, COLORREF rgbVal);
char *StringDate (char *s, time_t time);
void DoCommState (void);
char WasArtSeen (unsigned long ArtNum, TypGroup far * GroupPtr);
char chROT13 (char achar);
void strROT13 (char *cstring);
void strnROT13 (char *cstring, int len);
BOOL isLineQuotation (char *textptr);
void SetHandleBkBrush (HWND hwnd, HBRUSH handle);

/* in file WVUTIL.CPP */
WndEdit *getWndEdit (WndEdit * WndEdits, HWND hWnd, int numEntries);
WndEdit *GetComposeWnd (HWND hWnd);
void DoCommInput (void);
void ClearLatestInfo();

/* in wvpost.c */
void AddAuthHeader (HWND hWndEdit);

/* in wvsend.c */
BOOL SendOneLine(char *str);

/* in wvgroup.cpp    */
void SetGroupSelections (TypDoc * MyDoc, header_p headers, long newActive);
void SeverArticleParent(TypDoc *doc);
void setArticleFocus (HWND hWndArt);
long NewCursorToTextLine (int X, int Y, TypDoc far * DocPtr);
long search_headers (TypDoc far * HeaderDoc, header_p headers, long artindex, long num_headers);
void SaveSelectedArts (HWND hwnd, TypDoc far * Doc, header_p headers, long num_headers);
long AffectSelected (TypDoc far * Doc, BOOL value, BOOL compare);
long AffectSelectedOnScreen (TypDoc far * Doc, BOOL value, BOOL compare);
void InitiateReceiveArticle (TypDoc far * Doc, char far * articleId);
char_p string_compare_insensitive (char_p a, char far * b);
BOOL article_operation (TypDoc far * Doc, long artindex,BOOL (*art_fun) (TypDoc far * Doc, header_p headers, TypGroup * group, long artindex));
BOOL toggle_read_unread (TypDoc far * Doc, header_p headers, TypGroup * group, long artindex);
BOOL toggle_selected (TypDoc far * Doc, header_p headers, TypGroup * group, long artindex);
BOOL selected_true (TypDoc far * Doc, header_p headers, TypGroup * group, long artindex);
BOOL selected_false (TypDoc far * Doc, header_p headers, TypGroup * group, long artindex);
BOOL seen_true (TypDoc far * Doc, header_p headers, TypGroup * group, long artindex);
BOOL seen_false (TypDoc far * Doc, header_p headers, TypGroup * group, long artindex);
BOOL mark_read_to_here (TypDoc far * Doc, header_p headers, TypGroup * group, long artindex);
BOOL mark_read_all (TypDoc far * Doc, header_p headers, TypGroup * group, long artindex);
BOOL mark_read_selected (TypDoc far * Doc, header_p headers, TypGroup * group, long artindex);
BOOL mark_selected_read_articles (TypDoc far * Doc, header_p headers, TypGroup * group, long artindex);
BOOL mark_selected_unread_articles (TypDoc far * Doc, header_p headers, TypGroup * group, long artindex);
BOOL mark_deselected_read_articles (TypDoc far * Doc, header_p headers, TypGroup * group, long artindex);
BOOL mark_deselected_unread_articles (TypDoc far * Doc, header_p headers, TypGroup * group, long artindex);
BOOL mark_unread_selected (TypDoc far * Doc, header_p headers, TypGroup * group, long artindex);
void CloseGroupWnd (HWND hWnd, TypDoc far * ThisDoc);
void SetMenusForMultiArticleOperation (TypDoc far * DocPtr, int enable);
BOOL SelectHeader (TypDoc far * Doc, header_p header, BOOL value);

/* in headarray.cpp    */
long find_index_from_artnum (long artindex, HANDLE header_handle, HANDLE thread_handle, long length);

/* in file wvart.c */
long find_article_by_subject (TypHeader huge * headers, long artindex, long num_headers);
void view_article_by_message_id (TypDoc * Doc, char far * msg_id, long artindex);
void SetArticleRot13Mode (HWND hWnd, BOOL RotMode);
BOOL GetArticleRot13Mode (HWND hWnd);
void mark_article_seen(TypDoc FAR * Doc, char * groupname, long artindex);
void CloseArtWnd (HWND hWnd, TypDoc * ThisDoc);
void UpdateHighlightedText (TypDoc far * DocPtr, TextSelect far * PreviousPos);
void HighlightText (TypDoc far * DocPtrs);
void CopyTextToClipBoard (TypDoc FAR * DocPtr);

/* in file wvheader.c */
BOOL GetHeaderLine (TypDoc * Doc, char *Prefix, char *Buf, int BufLen);
BOOL NextToken (char **cptr);
void AppendTextToEditBuf (char *instr, char far ** buf, long int *left);
void ParseAddress(const char *headerline, char *addressout, long int addressoutlen, char *nameout, long int nameoutlen);

HWND CreateComposeWnd (HWND hWnd, TypDoc * Doc, int DocType);
BOOL GetToAddress (char *buf, int len, TypDoc * refDoc, HWND hWnd);
BOOL GetNewsgroups (char *buf, int len, TypDoc * refDoc);
BOOL GetFromAddress (char *buf, int len, TypDoc * refDoc);
BOOL GetSubject (char *buf, int len, TypDoc * refDoc, int docType);
BOOL GetCcAddress (char *buf, int len, TypDoc * refDoc);
BOOL GetReplyToAddress (char *buf, int len, TypDoc * refDoc);
BOOL GetOrganization (char *buf, int len, TypDoc * refDoc);
BOOL GetFollowupTo (char *buf, int len, TypDoc * refDoc);
BOOL FollowupToPoster (TypDoc * refDoc);
BOOL GetHeaderContents (char *buf, int len, TypDoc * refDoc, char *str);
BOOL GetReferences (char *buf, int len, TypDoc * refDoc);
BOOL GetXref (char *buf, int len, TypDoc * refDoc);
BOOL GetInReplyTo (char *buf, int len, TypDoc * refDoc);
BOOL GetDate (char *buf, int len);
BOOL MakeBody (char **endBuf, TypDoc * refDoc, int docType, HWND hWnd);
BOOL GetMailboxDate (char *buf, int len);

/* in file wvcompos.c */
long FAR PASCAL WinVnComposeWndProc (HWND, unsigned int, WPARAM, LPARAM);
BOOL CreateEditWnd (WndEdit * compWnd);
BOOL CreateComposeControls (WndEdit * compWnd);
void ResizeComposeControls (WndEdit * compWnd, int cx, int cy);
BOOL FAR PASCAL WinVnControlIntercept (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL GenerateHeadersForSend (WndEdit * compWnd, TypTextBlock * headers, char *saveSubject);
void EnableSendComposition (WndEdit * compWnd, BOOL enable);

                             /* In file WVPRINT.C *//* JD 930208 */
BOOL WINAPI PrinterInit (void);
BOOL WINAPI FreePrinterMemory (void);
BOOL WINAPI DeletePrinterDC (HDC);
HDC WINAPI GetPrinterDC (HWND);
BOOL CALLBACK AbortProc (HDC, int);
DWORD WINAPI PrinterSetup (HWND, DWORD);
//BOOL WINAPI PrintDlgProc(HWND, WORD, WORD, LPARAM); 
LRESULT CALLBACK PrintDlgProc (HWND, UINT, WPARAM, LPARAM);
BOOL WINAPI PrintHeaderP (char *str, int limit);
void WINAPI PrintFile (HWND);
void WINAPI PrintArticle (HWND, TypDoc * Doc);
void WINAPI ReportPrintError (int, HWND);

/* in file wvsckgen.c */
int SetupSock (void);
void PutCommLine (char *line);
void PutCommData (char *data, unsigned int length);
int MRRReadComm (void);
void MRRCloseComm (void);
int MRRInitComm (void);

int send_smtp_line (char *str, unsigned long len);
int post_line (char *str, unsigned long len);
int end_post ();
int end_send_smtp ();
int prepare_smtp_message (TypTextBlock * headers);
int prepare_cc_smtp_message (char *destination, TypTextBlock * headers);
int close_smtp_socket (void);

/* In file WVLIST.C */
void StartList (void);
void ProcListLine (unsigned char *ListLine);
void AddGroupToTable (char far * GroupLine);
void InitHashTable (unsigned int);
void InitGroupTable (void);
unsigned int HashGroup (unsigned char huge * gname);
void HashNetGroups (TypDoc * Doc, TypLine huge * huge * HashTable);
void BuildPtrList (void);
void BuildHashTable (void);
void ProcEndList (void);
int GroupCompare (TypLine const huge * huge * g1, TypLine const huge * huge * g2);
BOOL FAR PASCAL WinVnGroupListDlg (HWND hDlg, unsigned iMessage, WPARAM wParam, LPARAM lParam);
void PositionEndSubscribed (TypBlock far ** BlockPtr, TypLine far ** LinePtr);
void MergeGroups (int WhereSubscribed);
void CleanUpGroupTable (void);
unsigned long FindNextPrime (unsigned long);

/* In file WVMAIL.C  */
/* mlPOPSend (HWND hWnd, char *mBuf); */
int MailClose (HWND hWnd);
void SetMailType (int mailType);
void MailEnableLogout (BOOL enable);
void MailCrashExit (HWND hWnd);
int MailInit (HWND hWnd);

/* In file WVMAPI.C */
int mlMAPIInit (HWND hWnd);
int mlMAPILogout (HWND hWnd);
int mlMAPILogon (HWND hWnd);
int mlMAPISend (HWND hWnd, TypDoc * Doc, int DocType);
/* mlMAPILogon (HWND hWnd); */ 
int mlMAPIClose (HWND hWnd);

/* JSC additions to WVUTIL.CPP */
void RemoveTrailingWhiteSpace (char *str);
BOOL IsBlankStr (char *temp);
BOOL isnumber (char *str);
char *strntcpy (char *dest, char *src, int len);
BOOL AskForFont (HWND hParentWnd, char *face, int *size, char *style);
BOOL AskForColor (HWND hParentWnd, COLORREF * color);
BOOL AskForExistingFileName (HWND hParentWnd, char *fileName, char *title);
char *GetEditText (HWND hWndEdit);
LRESULT SetEditText (HWND hWndEdit, char *editMem);
BOOL WritePrivateProfileInt (char far * lpAppName, char far * lpKeyName, int val, char far * lpProFile);
BOOL WritePrivateProfileUInt (char far * lpAppName, char far * lpKeyName, unsigned int val, char far * lpProFile);
unsigned int GetPrivateProfileUInt (char far * lpAppName, char far * lpKeyName, unsigned int val, char far * lpProFile);
BOOL WritePrivateProfileLong (char far * lpAppName, char far * lpKeyName, long val, char far * lpProFile);
long GetPrivateProfileLong (char far * lpAppName, char far * lpKeyName, long val, char far * lpProFile);

void RefreshGroupWnds ();
void RefreshArticleWnds ();
void RefreshStatusWnds ();
void RefreshComposeWnds ();
void BatchSend (int DocType);

void CloseWindows ();
void CloseGroupWnds ();
void CloseArticleWnds ();
void CloseComposeWnds ();
void CloseStatusWnds ();

void WinVNCascadeWindows ();

void MinimizeWindows ();
void MinimizeGroupWnds ();
void MinimizeArticleWnds ();
void MinimizeComposeWnds ();
void MinimizeStatusWnds ();

void RestoreWindows ();

BOOL TestCommBusy (HWND hParentWnd, char *msg);
BOOL TestCodingBusy (HWND hParentWnd, char *msg);

void SetMainMailMenu (TypDoc FAR * DocPtr);
void SetArticleMailMenu (TypDoc FAR * DocPtr);
void SetGroupMailMenu (TypDoc FAR * DocPtr);
void UpdateAllMailMenus ();

unsigned long GetFreeDiskSpace (char *drive);
unsigned long GetFileLength (char *fileName);
unsigned long CalcNumUnread(TypGroup far *GroupPtr);

/* in file wvfiler.c (jsc) */
char *GetFileExtension (char *tempName, char *fileName);
char *NameWithoutPath (char *tempName, char *fileName);
char *PathWithoutName (char *tempName, char *fileName);
BOOL AskForNewFileName (HWND hParentWnd, char *fileName, char *startDir, BOOL appendOk);
BOOL AskForFilePath (HWND hParentWnd, char *pathName, char *title);
BOOL VerifyFileName (char *fileName);
BOOL SmartFile (HWND hParentWnd, char *fileName);

/* in wvfilter.c */
int MatchFilter (char *group, char *filterBuf);

/* In file WVCODING.C */
void DecodeInit ();
void DecodeDone ();
TypCoded *InitCoded (HWND h);
BOOL DecodeLine (TypCoded * thisDecode, char *line);
void DecodeFile (HWND hParentWnd);
void DecodeOpenArticles (HWND hParentWnd);
void DecodeDoc (HWND hParentWnd, TypDoc * Document);
unsigned long EncodeIntoFile (HFILE hFile, TypAttachment * thisAttach, unsigned long startByte, unsigned long maxBytes);
unsigned long EncodeToTextBlock (TypTextBlock * textBlock, TypAttachment * thisAttach, unsigned long startByte, unsigned long maxBytes);
unsigned long EncodeAndSend (TypAttachment * thisAttach, unsigned long startByte, unsigned long maxBytes);

void EncodeToFile (HWND hParentWnd, TypAttachment * attachment);
BOOL CompleteThisDecode ();
int CreateCodingMap (char *map, char *table);
void CreateStatusArea (HWND hParentWnd, char *title, int show);
void DestroyStatusArea ();
void UpdateBlockStatus ();

/* In file WVCODEWN.C */
long FAR PASCAL WinVnCodedBlockWndProc (HWND, UINT, WPARAM, LPARAM);
long FAR PASCAL WinVnCodingWndProc (HWND, UINT, WPARAM, LPARAM);
void RefreshCodedBlockWnd ();

/* In file WVTXTBLK.C */
TypTextBlock *InitTextBlock (HWND hParentWnd);
TypTextBlock *InitTextBlockWithSize (HWND hParentWnd, unsigned long bytes, unsigned long lines);
void FreeTextBlock (TypTextBlock * textBlock);
BOOL AddLineToTextBlock (TypTextBlock * textBlock, char *line);
BOOL ReplaceLineInTextBlock (TypTextBlock * textBlock, unsigned long num, char *line);
BOOL AddEndedLineToTextBlock (TypTextBlock * textBlock, char *line);
void ResetTextBlock (TypTextBlock * textBlock);
BOOL ReadFileToTextBlock (HWND hParentWnd, TypTextBlock * block, char *fileName);

/* in file WVATTACH.C */
BOOL SendComposition (WndEdit * compWnd);
void DoSend (int cancel);
void AbortSendPost (HWND hNotifyWnd);

void FinishAttachment (int abort);
int EncodingTypeToNum (char *str);
void ReadTextFileIntoEditWnd (HWND hEditWnd, char *fileName);

/* in file headarry.c */
header_p header_elt (header_p headers, long index);
header_p lock_headers (HANDLE header_handle, HANDLE thread_handle);
void unlock_headers (HANDLE header_handle, HANDLE thread_handle);
void free_headers (HANDLE header_handle, HANDLE thread_handle);
void sort_by_option(header_p h, thread_array t, BOOL tOk, unsigned int nL, HANDLE hHandle, HANDLE tHandle);
//void sort_by_threads (HANDLE header_handle, HANDLE thread_handle, long length);
void initialize_header_array (HANDLE header_handle, HANDLE thread_handle, long length);
void set_index_to_identity (HANDLE header_handle, HANDLE thread_handle, long length);
void shell_sort_index_array (header_p headers, thread_array index, long nElements,
                 int (*compare) (header_p headers, long elem1, long elem2));
//int compare_subject (header_p headers, long elem1, long elem2);
//int compare_date (header_p headers, long elem1, long elem2);
//int compare_lines (header_p headers, long elem1, long elem2);
//int compare_from (header_p headers, long elem1, long elem2);
//int compare_artnum (header_p headers, long elem1, long elem2);

/* In file WVCRYPT.C */
void MRREncrypt (unsigned char *plainText, int len, char *cipherText);
int MRRDecrypt (char *cipherText, unsigned char *plainText, int plainMax);

/* In file WVDEBUGC.C */
long FAR PASCAL
  WinVnDebugCommWndProc (HWND hWnd, unsigned message, WPARAM wParam, LPARAM lParam);

/* in file WVSTBAR.C  */
void InitStatBar (STATUSPAINT * StatbarPntData);
void SetNumLockText (HWND hwnd);
void SetCapsLockText (HWND hwnd);
void SetStatbarText (HWND hwnd, LPSTR lpszStatBarText, TypDoc * MyDoc, BOOL redrawflg, BOOL permflg);
void SetStatbarPercent(HWND hwnd, int StatBarPercent, TypDoc * MyDoc, BOOL redrawflg);
void PaintStatbarText(HDC hdc, RECT rcTemp, LPSTR lpszStatBarText, TypDoc *MyDoc);
void PaintStatbar (HWND hwnd, HDC hdc, TypDoc * MyDoc);
BOOL StatusBarProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, TypDoc * MyDoc);
void StatBarMainPopups ();
void StatBarGroupPopups (TypDoc * MyDoc);
void StatBarArtPopups (TypDoc * MyDoc);


#if 0
/* In file FASTQSRT.C */
void __far __cdecl fastQSort (void far * base, size_t n, size_t size,
          int (__far __cdecl * cmpFn) (const void far *, const void far *));
#endif

void
  ShellSort (void huge * huge * base,
             size_t nElements,
             size_t width,
         int (*compare) (void const huge * elem1, void const huge * elem2));

/* void IncPtr(void **ptr,int incval); */

#define     IDM_UNDO             8
#define     IDM_CUT              9
#define     IDM_COPY             10
#define     IDM_PASTE            11
#define     IDM_DEL            12

#define     IDM_SHOW_SUBSCR        101
#define     IDM_SHOW_ALL_GROUP     102
#define     IDM_VIEW_SEL_GROUP     103
#define     IDM_SEL_SUBSCR         104
#define     IDM_UNSEL_ALL          105
#define     IDM_EXIT               106
#define     IDM_QUIT               107
#define     IDM_GROUP_TOP          108
#define     IDM_CONFIG_LOG         109
#define     IDM_COMMOPTIONS        110
#define     IDM_CONFIG_PERSONAL    111
#define     IDM_CONFIG_APPEARANCE  112
#define     IDM_SAVE_NEWSRC        113
#define     IDM_CONFIG_SMART_FILER 114
#define     IDM_CONFIG_CONFIRMATIONS 115
#define     IDM_CONFIG_GROUPLIST   116
#define     IDM_CONFIG_ARTLIST     117
#define     IDM_CONFIG_ARTICLE     118
#define     IDM_CONFIG_COMPOSE     119
#define     IDM_CONFIG_CODING      120
#define     IDM_CONFIG_EXECUTE     121
#define     IDM_SORT_SELECTED      122

#define     IDM_EDIT               124
#define     IDM_EXCLUDE            125
#define     IDM_DELETE             126
#define     IDM_NEW                127
#define     IDM_DECODE_FILE        128
#define     IDM_ENCODE_FILE        129
#define     IDM_SUBSCRIBE          130
#define     IDM_UNSUBSCRIBE        131

#define     IDM_RESET              140
#define     IDM_CONNECT            141
#define     IDM_DISCONNECT         142
#define     IDM_RECONNECT          143
#define     IDM_SAVE_WINDOW        144 
#define     IDM_SAVE_CONFIG        145 

/* jlg - toolbar buttons with no menu equivalent */
#define     IDB_TOGGLE_CONNECT     146
#define     IDB_TOGGLE_VIEW_UNSUB  147
#define     IDB_FASTEXIT           148

#define     IDM_HELP               150

#define     IDC_SIZECURSOR         160 //shimomai

#define     IDV_APPEND             201
#define     IDV_EDIT               202
#define     IDV_FORGET             203

#define     IDV_NEXT               205

#define     IDV_EXIT               206

#define     IDM_NEXT_ARTICLE       401
#define     IDM_NEXT_SAME_SUBJECT  402
#define     IDM_PREV_ARTICLE       403
#define     IDM_DECODE_ARTICLE     404
#define     IDM_ALWAYSONTOP        405
#define     IDM_CANCELART          406

#define     IDM_SAVE             410
#define     IDM_SAVEAS           411
#define     IDM_PRINT            412
#define     IDM_PRINT_SETUP      413

#define     IDM_POST             420
#define     IDM_ATTACH           421
#define     IDM_COMPOSE_PREFS    422
#define     IDM_ATTACH_PREFS     423
#define     IDM_READ_FILE        424

#define IDM_FIND                430
#define IDM_FIND_NEXT_SAME      431
#define IDM_SEARCH              432
#define IDM_SEARCH_NEXT         433
#define IDM_FIND_NEXT_UNSEEN    434
#define IDM_NEXT_SAME_SUBJ      435
#define IDM_FIND_NEXT_SELECTED          436

#define IDM_SEND                        440
#define IDM_CANCEL                      441
#define IDM_MAIL                        442
#define IDM_LOGOUT                      443
#define IDM_REPLY                       444
#define IDM_ROT13                       445
#define IDM_UNROT                       446
#define IDM_WORDWRAP                    447
#define IDM_UPDATE                      448
#define IDM_FORWARD                     449
#define IDM_HEADER_EDIT                 492	//shimomai

#define     IDM_CONTROL_INSERT   491	//shimomai

#define IDM_DISPLAY_SEEN_ARTS           450
#define IDM_DISPLAY_KILLED_ARTS         451

// The next 7 values should not be reassigned (used in .ini files)
#define IDM_SORT_THREADSUB              459
#define IDM_SORT_DATE                   460
#define IDM_SORT_SUBJECT                461
#define IDM_SORT_LINES                  462
#define IDM_SORT_THREADS                463
#define IDM_SORT_ARTNUM                 464
#define IDM_SORT_FROM                   465


#define IDM_SELECT_ALL                  470
#define IDM_MARK_READ_ARTICLES          471
#define IDM_MARK_UNREAD_ARTICLES        472
#define IDM_SELECT_MATCH                473
#define IDM_DESELECT_ALL                474
#define IDM_UNMARK_READ_ARTICLES        475
#define IDM_UNMARK_UNREAD_ARTICLES      476
#define IDM_DESELECT_MATCH              477
#define IDM_SAVE_SELECTED               478
#define IDM_DECODE_SELECTED             479
#define IDM_READ_SELECTED               480
#define IDM_MARK_SELECTED               481
#define IDM_UNMARK_SELECTED             482

#define ID_RETRIEVE_COMPLETE            483
#define ID_ARTICLE_RETRIEVE_COMPLETE    484

#define IDM_FONT_WINVNSYSTEM    500
#define IDM_FONT_COMPOSITION    501
#define IDM_FONT_GROUPLIST      502
#define IDM_FONT_ARTICLE_LIST   503
#define IDM_FONT_ARTICLE_TEXT   504
#define IDM_FONT_PRINT_TEXT     505
#define IDM_FONT_STATUS_TEXT    506

#define IDM_COLOR_UNSUBSCRIBED       510
#define IDM_COLOR_SUBSCRIBED         511
#define IDM_COLOR_UNSEEN             512
#define IDM_COLOR_SEEN               513
#define IDM_COLOR_KILLED             514
#define IDM_COLOR_LIST_BACKGROUND    515
#define IDM_COLOR_ARTICLE_BACKGROUND 516
#define IDM_COLOR_STATUS_BACKGROUND  517
#define IDM_COLOR_ARTICLE_TEXT       518
#define IDM_COLOR_STATUS_TEXT        519
#define IDM_TRUE_INVERSE_SELECTIONS  520
#define IDM_USE_SPLASH               525

#define IDM_WINDOW_CASCADE      530
#define IDM_CLOSE_ALL_GROUP     531
#define IDM_CLOSE_ALL_ARTICLE   532
#define IDM_CLOSE_ALL_COMPOSE   533
#define IDM_CLOSE_ALL_STATUS    534
#define IDM_CLOSE_ALL           535
#define IDM_MINIMIZE_ALL_GROUP   536
#define IDM_MINIMIZE_ALL_ARTICLE 537
#define IDM_MINIMIZE_ALL_COMPOSE 538
#define IDM_MINIMIZE_ALL_STATUS  539

#define IDM_MINIMIZE_ALL         540    // Never change these: 540, 541 (jsc)
#define IDM_RESTORE_ALL          541    // (so i send these msgs to winvn from a toolbar app)

#define IDM_SEND_ALL_POST       550
#define IDM_SEND_ALL_MAIL       551

#define IDM_MARK_ALL            600 
#define     IDM_PREFERENCES     650

#define     ID_TIMER            1000

/* IDs for popup menus */
#define POPUP_BASE            700
#define IDM_NETWORK_MENU      POPUP_BASE + 1
#define IDM_GROUP_MENU        POPUP_BASE + 2
#define IDM_UTILITIES_MENU    POPUP_BASE + 3
#define IDM_BATCH_MENU        POPUP_BASE + 4
#define IDM_CONFIG_MENU       POPUP_BASE + 5
#define IDM_FONT_MENU         POPUP_BASE + 6
#define IDM_COLOR_MENU        POPUP_BASE + 7
#define IDM_WINDOW_MENU       POPUP_BASE + 8
#define IDM_CLOSE_MENU        POPUP_BASE + 9
#define IDM_MINIMIZE_MENU     POPUP_BASE + 10
#define IDM_HELP_MENU         POPUP_BASE + 11
#define IDM_ARTICLE_MENU      POPUP_BASE + 12
#define IDM_SORT_MENU         POPUP_BASE + 13
#define IDM_SEARCH_MENU       POPUP_BASE + 14
#define IDM_FILE_MENU         POPUP_BASE + 15
#define IDM_EDIT_MENU         POPUP_BASE + 16
#define IDM_ARTSEARCH_MENU    POPUP_BASE + 17
#define IDM_VIEW_MENU         POPUP_BASE + 18
#define IDM_RESPOND_MENU      POPUP_BASE + 19

#define MAXPOPUPS 20

/* Article status values (Article Action items) */
#define ART_UNSEEN     0
#define ART_UNSELECTED 0
#define ART_SEEN       1
#define ART_KILLED     2
#define ART_SEENORKILLED (ART_SEEN | ART_KILLED)
#define ART_SELECTED   4

/* Window word values for child windows */
#define GWW_HWNDEDIT    0
#define GWW_CHANGED     2
#define GWW_WORDWRAP    4
#define GWW_UNTITLED    6
#define CBWNDEXTRA      8

/* String Table constants */
#define IDS_FILTERSTRING   0

/* path selection bitmap ids, etc */
#ifndef WIN32
// Private drive types not covered in Win3.x GetDriveType but in Win32
#define DRIVE_CDROM                 5
#define DRIVE_RAMDISK               6
#endif

#define IDB_DRIVEMIN                DRIVE_REMOVABLE
#define IDB_DRIVEFLOPPY             DRIVE_REMOVABLE
#define IDB_DRIVEHARD               DRIVE_FIXED
#define IDB_DRIVENETWORK            DRIVE_REMOTE
#define IDB_DRIVECDROM              DRIVE_CDROM
#define IDB_DRIVERAM                DRIVE_RAMDISK
#define IDB_DRIVEMAX                DRIVE_RAMDISK

#define IDB_FOLDERMIN               10
#define IDB_FOLDERCLOSED            10
#define IDB_FOLDEROPEN              11
#define IDB_FOLDEROPENSELECT        12
#define IDB_FOLDERMAX               12

/* toolbar constants  */
#define CMD_TB_BASE 400
#define MAINTB CMD_TB_BASE+1
#define VIEWTB CMD_TB_BASE+2
#define ARTTB  CMD_TB_BASE+3

#define IDB_ARTTOOLBAR     100  /* bitmaps */
#define IDB_TOOLBAR        101
#define IDB_VIEWTOOLBAR    102


#define WM_MYINITMENU      (WM_USER+1024)

/*-- Dialog box constants -- */
#include "wvdlg.h"

#ifdef __cplusplus
}
#endif

#endif

/*
 * Local Variables:
 * tab-width: 2
 * end:
 */
