/*
 * $Id: wvclass.h 1.3 1996/08/13 03:46:40 brydon Exp $
 */

/*
 *
 *  WinVN C++ class definitions
 *
 */

#ifndef WVCLASS_H
#define WVCLASS_H

// Action/Killfile constants
#define AA_NOACTION_MASK               1
#define AA_LT_MASK                     2
#define AA_EQ_MASK                     3
#define AA_GT_MASK                     4
#define AA_IS_MASK                     5
#define AA_CONTAINS_MASK               6
#define AA_SELECT_MASK            0x1000
#define AA_MODULO                 0x0010

#define NO_ACTION                      1
#define MARK_SEEN_ART_LINES_BASE       1 * AA_MODULO  // 0x10/16
#define MARK_SEEN_ART_LINES_LT          MARK_SEEN_ART_LINES_BASE + AA_LT_MASK
#define MARK_SEEN_ART_LINES_EQ          MARK_SEEN_ART_LINES_BASE + AA_EQ_MASK
#define MARK_SEEN_ART_LINES_GT          MARK_SEEN_ART_LINES_BASE + AA_GT_MASK
#define MARK_SEEN_ART_FROM_BASE        2 * AA_MODULO  // 0x20/32
#define MARK_SEEN_ART_FROM_IS           MARK_SEEN_ART_FROM_BASE + AA_IS_MASK
#define MARK_SEEN_ART_FROM_CONTAINS     MARK_SEEN_ART_FROM_BASE + AA_CONTAINS_MASK
#define MARK_SEEN_ART_EMAIL_BASE       3 * AA_MODULO  // 0x30/48
#define MARK_SEEN_ART_EMAIL_IS          MARK_SEEN_ART_EMAIL_BASE + AA_IS_MASK
#define MARK_SEEN_ART_EMAIL_CONTAINS    MARK_SEEN_ART_EMAIL_BASE + AA_CONTAINS_MASK
#define MARK_SEEN_ART_SUBJ_BASE        4 * AA_MODULO  // 0x40/64
#define MARK_SEEN_ART_SUBJ_IS           MARK_SEEN_ART_SUBJ_BASE + AA_IS_MASK
#define MARK_SEEN_ART_SUBJ_CONTAINS     MARK_SEEN_ART_SUBJ_BASE + AA_CONTAINS_MASK
#define MARK_SEEN_ART_MSGID_BASE       5 * AA_MODULO  // 0x50/80
#define MARK_SEEN_ART_MSGID_IS          MARK_SEEN_ART_MSGID_BASE + AA_IS_MASK
#define MARK_SEEN_ART_MSGID_CONTAINS    MARK_SEEN_ART_MSGID_BASE + AA_CONTAINS_MASK
#define MARK_SEEN_ART_REF_BASE         6 * AA_MODULO  // 0x60/96
//#define MARK_SEEN_ART_REF_IS            MARK_SEEN_ART_REF_BASE + AA_IS_MASK
#define MARK_SEEN_ART_REF_CONTAINS      MARK_SEEN_ART_REF_BASE + AA_CONTAINS_MASK
#define MARK_SEEN_NGROUP_BASE          7 * AA_MODULO  // 0x70/112
//#define MARK_SEEN_NGROUP_IS             MARK_SEEN_NGROUP_BASE + AA_IS_MASK
#define MARK_SEEN_NGROUP_CONTAINS       MARK_SEEN_NGROUP_BASE + AA_CONTAINS_MASK
#define SELECT_ART_LINES_BASE           AA_SELECT_MASK + MARK_SEEN_ART_LINES_BASE
#define SELECT_ART_LINES_LT             AA_SELECT_MASK + MARK_SEEN_ART_LINES_LT
#define SELECT_ART_LINES_EQ             AA_SELECT_MASK + MARK_SEEN_ART_LINES_EQ
#define SELECT_ART_LINES_GT             AA_SELECT_MASK + MARK_SEEN_ART_LINES_GT
#define SELECT_ART_FROM_BASE            AA_SELECT_MASK + MARK_SEEN_ART_FROM_BASE
#define SELECT_ART_FROM_IS              AA_SELECT_MASK + MARK_SEEN_ART_FROM_IS
#define SELECT_ART_FROM_CONTAINS        AA_SELECT_MASK + MARK_SEEN_ART_FROM_CONTAINS
#define SELECT_ART_EMAIL_BASE           AA_SELECT_MASK + MARK_SEEN_ART_EMAIL_BASE
#define SELECT_ART_EMAIL_IS             AA_SELECT_MASK + MARK_SEEN_ART_EMAIL_IS
#define SELECT_ART_EMAIL_CONTAINS       AA_SELECT_MASK + MARK_SEEN_ART_EMAIL_CONTAINS
#define SELECT_ART_SUBJ_BASE            AA_SELECT_MASK + MARK_SEEN_ART_SUBJ_BASE
#define SELECT_ART_SUBJ_IS              AA_SELECT_MASK + MARK_SEEN_ART_SUBJ_IS
#define SELECT_ART_SUBJ_CONTAINS        AA_SELECT_MASK + MARK_SEEN_ART_SUBJ_CONTAINS
#define SELECT_ART_MSGID_BASE           AA_SELECT_MASK + MARK_SEEN_ART_MSGID_BASE
#define SELECT_ART_MSGID_IS             AA_SELECT_MASK + MARK_SEEN_ART_MSGID_IS
#define SELECT_ART_MSGID_CONTAINS       AA_SELECT_MASK + MARK_SEEN_ART_MSGID_CONTAINS
#define SELECT_ART_REF_BASE             AA_SELECT_MASK + MARK_SEEN_ART_REF_BASE
//#define SELECT_ART_REF_IS               AA_SELECT_MASK + MARK_SEEN_ART_REF_IS
#define SELECT_ART_REF_CONTAINS         AA_SELECT_MASK + MARK_SEEN_ART_REF_CONTAINS
#define SELECT_NGROUP_BASE              AA_SELECT_MASK + MARK_SEEN_NGROUP_BASE
//#define SELECT_NGROUP_IS                AA_SELECT_MASK + MARK_SEEN_NGROUP_IS
#define SELECT_NGROUP_CONTAINS          AA_SELECT_MASK + MARK_SEEN_NGROUP_CONTAINS

typedef struct tag_ad
{
  int iAction;
  long int iParam;
  char *sParam;
} ACTIONDATA, FAR *LPACTIONDATA;

struct Node
{
  Node * Flink;
  Node * Blink;
  ACTIONDATA ad;
};

// WVArticleAction - 'killfile' et al
class WVArticleAction
{
public:
protected:
  Node *m_Head;
  Node *m_Tail;
  Node *m_Current;
  char m_ProfSect[128];
private:
public:
  WVArticleAction();
  WVArticleAction(WVArticleAction*wv);
  ~WVArticleAction();
  void SetIParam(int i);
  void SetParamText(char*sP);
  void ResetCurrent(){m_Current = m_Head;};
  void ReadActions(char*sGroup);
  void WriteActions();
  Node*GetCurrent(){return m_Current;};
  void Append(int iA, long int iP, char*sP);
  void DeleteNode(Node* pN);
  void DeleteAll();
  void GoToNext();
  void GoToPrev();
  void Switch(Node*nA, Node*nB);
  void Switchwith(WVArticleAction*nB);
  void ActOnArticles(TypGroup far *Group, header_p headers);
  BOOL NeedNgroupHeader();
protected:
private:
};

extern WVArticleAction g_action;

#endif /* WVCLASS_H  */
