/*--- WVMAIL.C ------------------------------------------------------------
 *
 *    This file contains the window procedure for the windows
 *    used to edit outgoing mail messages.
 *
 *    Mark Riordan   11 June 1991
 *
 *    MAPI interface implemented by MAtthew Bretherton  March 1993
 *
 *    Much of the send/forward/etc code, as well as the main window handler
 *    now replaced by new code in wvcompos.c and wvattach.c (jsc 10/1/94)
 */

/*
 * $Id: wvmail.c 1.30 1996/08/13 04:50:05 dumoulin Exp $
 */

#include <windows.h>
#include <windowsx.h>
#include "wvglob.h"
#include "winvn.h"
#pragma hdrstop

/*---- function MailLogout---------------------------------------------
 *
 *   Finish up the mail session
 *
 */
int
MailClose (HWND hWnd)
{
  return ((MailCtrl.fnMlClose) (hWnd));
}

/*---- function MailInit ----------------------------------------------
 *
 *
 *
 */
int 
MailInit (HWND hWnd)
{
  int Mapi_Type;

  if (MailForceType >= 0) {		/* Accept Private Profile directive to override Mail negotiation */
	MailCtrl.MailType = MailForceType;
  }
  else {						/* MAPI is next on the negotiation list */
#if 0 // WIN32  win32s version isn't around anymore
	if (GetVersion () & 0x80000000)		/* win32s */
	  Mapi_Type = 0;
	else
#endif
	  Mapi_Type = GetProfileInt ("Mail", "MAPI", 0);

	if (Mapi_Type > 0) {
	  MailCtrl.MailType = MT_MAPI;
	}
	else if (strcmp (SMTPHost, "")) {	/* SMTP next on the negotiation list
										   and assume that if SMTP host is specified use it */
	  MailCtrl.MailType = MT_SMTP;
	}
	else {
	  MailCtrl.MailType = MT_NONE;
	};
  }

  SetMailType (MailCtrl.MailType);

  (MailCtrl.fnMlInit) (hWnd);

  return (0);
}

/* -------------- MailCrashClose -----------------

 *  On serious error in mail interface crash mail and
 * disable mail interface - winvn Ok to run without mail
 *
 * -----------------------------------------------*/

void
MailCrashExit (HWND hWnd)
{
  MailCtrl.fnMlClose (hWnd);	// clear down mail resources in use

  SetMailType (MT_NONE);
}

int
mlSMTPClose (HWND hWnd)
{
//  extern int close_smtp_socket ();	/* in wvsckgen.c */

  return close_smtp_socket ();
}

/*---- function MailxxxDefProc -------------------------------------------
 *
 *  Default Proc to support generic nature of dealing with multiple 
 *  mailing interfaces
 *                                                       
 */
MailDefCtlProc (HWND hWnd)
{
  return (0);
}
MailDefChrProc (HWND hWnd, TypTextBlock * textBlock, char *mBuf)
{
  return (0);
}
MailDefDocProc (HWND hWnd, TypDoc * Doc, int DocType)
{
  return (0);
}
MailDefDocProc2 (HWND hWnd, TypDoc * Doc)
{
  return 0;
}

/* --- SetMailType  ----------------------------------------------------

 *  set up logic attributes for selected mail interface
 *
 */

void
SetMailType (int mailType)
{
#if 0
  static BOOL (*NoHeaderFuncs[]) (TypDoc * Doc, char *Buf, long int BufLen) =
  {
	NULL
  };
  static BOOL (*MAPIHeaderFuncs[]) (TypDoc * Doc, char *Buf, long int BufLen) =
  {
	GetArtHeaderTo,
	GetArtHeaderSubject,
	NULL
  };
  static BOOL (*SMTPHeaderFuncs[]) (TypDoc * Doc, char *Buf, long int BufLen) =
  {
	MakeArtHeaderTo,
	MakeArtHeaderFrom,
	MakeArtHeaderSubject,
	MakeArtHeaderOrganization,
	MakeArtHeaderDate,
	MakeArtHeaderReplyTo,
	MakeArtHeaderXmailer,
	NULL
  };
#endif

  switch (mailType) {
  case MT_MAPI:
	MailCtrl.enableMail = MF_ENABLED;
	MailCtrl.enableLogout = MF_GRAYED;
	MailCtrl.enableForward = MF_ENABLED;
	MailCtrl.fnMlInit = mlMAPIInit;
	MailCtrl.fnMlLogout = mlMAPILogout;
	MailCtrl.fnMlClose = mlMAPIClose;
	MailCtrl.fnMlWinCreate = mlMAPISend;
	break;
  case MT_SMTP:
	MailCtrl.enableMail = MF_ENABLED;
	MailCtrl.enableLogout = MF_GRAYED;
	MailCtrl.enableForward = MF_ENABLED;
	MailCtrl.fnMlInit = MailCtrl.fnMlLogout = MailDefCtlProc;
	MailCtrl.fnMlLogout = MailDefCtlProc;
	MailCtrl.fnMlClose = mlSMTPClose;
	MailCtrl.fnMlWinCreate = (int (*)(HWND, TypDoc *, int)) CreateComposeWnd;
	break;
	/* error handling for Fall through case message box plus */
	/* default to none */
  case MT_NONE:
  default:
	MailCtrl.enableMail = MF_GRAYED;
	MailCtrl.enableLogout = MF_GRAYED;
	MailCtrl.enableForward = MF_GRAYED;
	MailCtrl.fnMlClose = MailDefCtlProc;
	MailCtrl.fnMlInit = MailCtrl.fnMlLogout = MailDefCtlProc;
//   MailCtrl.fnMlSend=MailDefChrProc ;
	//   MailCtrl.fnMlForward=MailDefDocProc2;
	MailCtrl.fnMlWinCreate = MailDefDocProc;
//   MailCtrl.MailHeaderFuncs = NoHeaderFuncs ;
	break;
  };
}

/* -------------- MailEnableLogout ------------------------

 *  Allow discard (freeing) of mail resources during
 *  the session - Not necessarily available to all mail
 *  services
 *
 *--------------------------------------------------------*/
void
MailEnableLogout (BOOL enable)
{
  if (enable)
	MailCtrl.enableLogout = MF_ENABLED;
  else
	MailCtrl.enableLogout = MF_GRAYED;
}

//
// Local Variables:
// tab-width: 2
// end:
//
