head	1.13;
access;
symbols
	V0-99-8:1.12
	V0-99-7:1.12
	V0-99-6:1.12
	V0-99-5:1.12
	V0-99-4:1.12
	V0-99-2:1.12
	V0-99-1:1.12
	V0-93-14:1.12
	V0-93-13:1.12
	V0-93-12:1.12
	V0-93-11:1.12
	V0-93-10:1.12
	V0-93-9:1.12
	V0-93-8:1.12
	V0-93-7:1.12
	V0-93-5:1.12
	V80:1.1
	V76d:1.1;
locks; strict;
comment	@ * @;


1.13
date	97.02.06.17.32.11;	author dumoulin;	state Exp;
branches;
next	1.12;

1.12
date	94.11.10.01.57.05;	author rushing;	state Exp;
branches;
next	;


desc
@winvn version 0.76 placed into RCS
@


1.13
log
@convert shell sort to from int's to longs
@
text
@
/*
 * $Id: shellsor.c 1.12 1994/11/10 01:57:05 rushing Exp $
 */

/* Shellsort is a variation on Insertion Sort that is virtually unbeatable
 * on small data sets.  Insertion Sort is slow because it only exchanges
 * adjacent elements.  Shellsort circumvents this by allowing the exchange
 * of elements that are farther apart.  It works by first performing Insertion
 * Sort on subsets of the data.  For example, Shellsort might first sort
 * the set of elements 1, 6, 11, 16... relative to each other--the effect
 * is that the elements in that subset are moved much closer to their final
 * positions.  At first the sets are wide-spread, perhaps every fortieth
 * element.  Then it repeats using a tighter set, perhaps every fourteenth
 * element, then every fourth element.  Each of these passes is much cheaper
 * than a traditional Insertion Sort pass.  The effect of the passes is that
 * the data set is mutated to be in "almost sorted" order.  The final insertion
 * sort pass can then go very quickly because insertion sort does very well on
 * almost sorted data.  In other words, at first the elements take large leaps
 * to the general location they belong and successively smaller steps move the
 * element to its precise place. I call this algorithm "inscrutable sort"
 * because even after having coded the algorithm, I still have trouble
 * following the animation.  No one has been able to analyze this algorithm
 * rigorously; the functional form of the running time is conjectured to be
 * O(N^1.25).  Shellsort may be a bit mysterious, but it is an good general
 * purpose sort since it has excellent performance and the code you must write
 * is only slightly more complex than Insertion Sort.
 *
 * Author: Julie Zelenski, NeXT Developer Support
 * You may freely copy, distribute and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.      qsort
 */

#ifdef WIN32
#include <windows.h>
#include <windef.h>
#endif

#include <stdio.h>
#include <string.h>

#ifdef WIN32
#define __far far
#define huge far
#define       __near near
#endif


#define memSwap(a,b,unused) tmp = *(char huge * huge *)(a); \
  *(char huge * huge *)(a) = *(char huge * huge *)(b); *(char huge * huge *)(b) = tmp;

void
ShellSort (void huge * huge * base,
		   unsigned long nElements,
		   size_t width,
		   int (*compare) (void const huge * elem1, void const huge * elem2))
{
#define STRIDE_FACTOR 3
 // unsigned int c, stride;
  unsigned long c, stride;
 // int d;
  long d;
  char far *tmp;
  int found;

  stride = 1;
  while (stride <= nElements)
	stride = stride * STRIDE_FACTOR + 1;

  while (stride > (STRIDE_FACTOR - 1)) {
	stride = stride / STRIDE_FACTOR;
	for (c = stride; c < nElements; c++) {
	  found = 0;
	  d = c - stride;
	  while ((d >= 0) && !found) {
		if (compare ((char huge *) base + (d + stride) * width, (char huge *) base + d * width) < 0) {
		  memSwap ((char huge *) base + (d + stride) * width, (char huge *) base + d * width, width);
		  d -= stride;
		}
		else {
		  found = 1;
		}
	  }
	}
  }
}
@


1.12
log
@restart
@
text
@d55 1
a55 1
		   size_t nElements,
d60 4
a63 2
  unsigned int c, stride;
  int d;
@
