head	1.35;
access;
symbols
	V0-99-8:1.34
	V0-99-7:1.33
	V0-99-6:1.31
	V0-99-5:1.30
	V0-99-4:1.29
	V0-99-2:1.26
	V0-99-1:1.26
	V0-93-14:1.26
	V0-93-13:1.25
	V0-93-12:1.23
	V0-93-11:1.22
	V0-93-10:1.22
	V0-93-9:1.21
	V0-93-8:1.21
	V0-93-7:1.21
	V0-93-5:1.20
	V80:1.1
	V76d:1.1;
locks; strict;
comment	@ * @;


1.35
date	97.02.06.17.27.19;	author dumoulin;	state Exp;
branches;
next	1.34;

1.34
date	96.08.13.04.34.18;	author dumoulin;	state Exp;
branches;
next	1.33;

1.33
date	95.11.07.23.05.09;	author dumoulin;	state Exp;
branches;
next	1.32;

1.32
date	95.08.23.23.38.29;	author dumoulin;	state Exp;
branches;
next	1.31;

1.31
date	95.08.16.22.38.21;	author dumoulin;	state Exp;
branches;
next	1.30;

1.30
date	95.06.06.04.09.06;	author dumoulin;	state Exp;
branches;
next	1.29;

1.29
date	95.05.19.22.32.17;	author dumoulin;	state Exp;
branches;
next	1.28;

1.28
date	95.04.22.02.06.39;	author dumoulin;	state Exp;
branches;
next	1.27;

1.27
date	95.04.22.02.03.28;	author dumoulin;	state Exp;
branches;
next	1.26;

1.26
date	95.02.13.19.30.03;	author rushing;	state Exp;
branches;
next	1.25;

1.25
date	95.02.07.22.43.03;	author jglasser;	state Exp;
branches;
next	1.24;

1.24
date	95.02.02.21.29.30;	author rushing;	state Exp;
branches;
next	1.23;

1.23
date	95.01.19.02.47.25;	author jglasser;	state Exp;
branches;
next	1.22;

1.22
date	94.12.12.19.39.13;	author jcooper;	state Exp;
branches;
next	1.21;

1.21
date	94.11.21.21.20.46;	author jcooper;	state Exp;
branches;
next	1.20;

1.20
date	94.11.10.01.53.16;	author rushing;	state Exp;
branches;
next	;


desc
@winvn version 0.76 placed into RCS
@


1.35
log
@fixes on 16bit version to support more than 32K groups.  Don't
use Microsofts MulDiv macros
@
text
@/*
 * $Id: wvlist.c 1.34 1996/08/13 04:34:18 dumoulin Exp $
 */

/*-- WVLIST.C -- File containing functions to deal with the NNTP LIST
 *   command, which lists all the newsgroups and their status.
 *
 *   Mark Riordan   25 October 1990
 */

#include <windows.h>
#include <windowsx.h>
#include "wvglob.h"
#include "winvn.h"
#pragma hdrstop
#include "dos.h"
#include "primes.h"
#include "defaults.h"

#include <ctype.h>


/* The size of the chunks of memory that make up the new group list data */
#define CHUNKSIZE       64L*1024L

TypLine huge * huge * NetHashTable;
HANDLE hNetHashTable;

HANDLE htohNewGroupLines;
HANDLE far *lphNewGroupLines;	/* array of handles to new group lines */

DWORD NewGroupDataSize;			/* The size (in bytes) of NewGroupData */
char huge *CurrentSpot;			/* The pointer to the next available spot in NewGroupData */
unsigned long BytesSoFar;

#define MyGlobalUnlock(hWhat)  MRRGlobalUnlock(hWhat,__LINE__)

void MRRGlobalUnlock (HANDLE hWhat, WORD wLine);

void
MRRGlobalUnlock (HANDLE hWhat, WORD wLine)
{
  WORD LockCount;

  if (hWhat) {
    if (!(LockCount = (GMEM_LOCKCOUNT & GlobalFlags (hWhat)))) {
    }
    else {
	  GlobalUnlock (hWhat);
    }
  } 
}


/*--- function StartList -----------------------------------------------
 *
 *  Initiate the process of sending a LIST command and using its
 *  output to update our list of news groups.
 */

void
StartList ()
{
  CommState = ST_LIST_RESP;
  CommBusy = TRUE;
  PutCommLine ("LIST");
  Initializing = INIT_SCANNING_NETDOC;
  InvalidateRect (NetDoc.hDocWnd, NULL, FALSE);
  SendMessage (NetDoc.hWndFrame, WM_PAINT, 0, 0L);

  /* Set up table of pointers to new group lines. */
  InitGroupTable ();

  /* Initialize the hash table */
  InitHashTable (LinesInRC);

  /* And set up the hash table for stuff from the newsrc */
  HashNetGroups (&NetDoc, NetHashTable);
  InvalidateRect (NetDoc.hDocWnd, NULL, FALSE);
  Initializing = INIT_GETTING_LIST;
  SendMessage (NetDoc.hWndFrame, WM_PAINT, 0, 0L);
}

/*--- function InitHashTable -------------------------------------------
 *
 *  Allocate and zero the NetHashTable. The argument is the number of
 *  elements to be hashed (NOT the number of elements in the hash table)
 *
 *  Exit:   hNetHashTable     is the handle
 *          NetHashTable      points to the table
 *                      HashTableSize     The number of elements in the hash table
 */
void
InitHashTable (unsigned long Elements)
{

  /* First, figure out how large the hashtable should be.
   * The basic algorithm used here is to double the size of what you're
   * hashing, rounded up to the next nearest prime number
   */
  HashTableSize = (unsigned long) FindNextPrime (Elements * 2L);

  /* Set up hash table for group names */
  hNetHashTable = GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT,
							   HashTableSize *
							   sizeof (TypLine far *));
  NetHashTable = (TypLine huge * huge *) GlobalLock (hNetHashTable);

}


/*--- function InitGroupTable -------------------------------------------
 *
 *  Allocate the first CHUNKSIZE bytes of memory for the
 * new group lines.
 *
 *  Exit:   hNewGroupData    is the handle
 *          NewGroupData     points to the table
 *          nNewGroups        has been initialized to 0.
 *                      NewGroupDataSize  is the current size of the NewGroupData
 */
void
InitGroupTable (void)
{
  /* Allocate the first chunk */
  NewGroupDataSize = CHUNKSIZE;
  hNewGroupData = GlobalAlloc (GMEM_MOVEABLE, NewGroupDataSize);
  NewGroupData = (void far *) GlobalLock (hNewGroupData);
  CurrentSpot = NewGroupData;
  BytesSoFar = 0;
  nNewGroups = 0L;
}


/*--- function HashNetGroups ------------------------------------------
 *
 *  Enter all the groups in the Net document into the hash table.
 *
 *  Exit    All blocks in the document are locked.
 *          HashTable   is (partially) filled with pointers to
 *                      each of the lines in "Doc".
 */

void
HashNetGroups (TypDoc *Doc, TypLine huge * huge * HashTable)
{
  TypBlock far *BlockPtr;
  TypLine far *LinePtr;
  unsigned long hashval;
  HANDLE hBlock;
  unsigned int Offset;
  unsigned int TextOffset;
  unsigned char far *textptr;
  TypLineID MyLineID;

  /* Lock all blocks in the document */
  hBlock = Doc->hFirstBlock;
  do {
	BlockPtr = (TypBlock far *) GlobalLock (hBlock);
	hBlock = BlockPtr->hNextBlock;
  }
  while (hBlock);

  /* Now start at the beginning of the document, going through
   * each line in the document, hashing its group name into the table.
   */

  hBlock = Doc->hFirstBlock;
  Offset = sizeof (TypBlock);
  MyLineID = 0L;

  LockLine (hBlock, Offset, MyLineID, &BlockPtr, &LinePtr);

  TextOffset = Doc->OffsetToText;

  if (LinePtr->length != END_OF_BLOCK) {
	do {
	  textptr = ((unsigned char far *) LinePtr) + TextOffset;
	  hashval = HashGroup (textptr);
	  while (HashTable[hashval]) {
		hashval = (hashval + 1) % HashTableSize;
	  }
	  HashTable[hashval] = LinePtr;
	}
	while (NextLine (&BlockPtr, &LinePtr));
  }
  UnlockLine (BlockPtr, LinePtr, &hBlock, &Offset, &MyLineID);
}

/*--- function ProcListLine ---------------------------------------------
 *
 *  Process a line received from the NNTP LIST command output.
 *  Each line from the LIST command has the form:
 *   <groupname> <highest_art_#> <lowest_art_#> {y|n|m}
 */

void
ProcListLine (unsigned char *ListLine)
{
  unsigned long hashval;
  char far *textptr;
  unsigned char *cptr, *restline;
  char mygroupline[BLOCK_SIZE];
  TypGroup *mygroup;
  TypGroup far *netgroup;
  long int ArtNum;
  int PercentDone;

  if ((++RcvLineCount) % UPDATE_TITLE_FREQ == 0) {
	InvalidateRect (NetDoc.hDocWnd, NULL, FALSE);
	if (NetDoc.TotalLines > 0) {
	//  PercentDone = MulDiv (RcvLineCount, 100, NetDoc.TotalLines);
	    PercentDone = (int) ((RcvLineCount * 100) / NetDoc.TotalLines);
	  if (PercentDone <= 100)
		SetStatbarPercent (NetDoc.hWndFrame, PercentDone, &NetDoc, TRUE);
	}
	if (RcvLineCount % (UPDATE_TITLE_FREQ * 25) == 0) {
	  UpdateWindow (NetDoc.hDocWnd);
	}
  }

  /* Replace the first blank in the input line with a zero. */
  for (cptr = ListLine; *cptr && *cptr != ' '; cptr++);
  *cptr = '\0';
  restline = cptr + 1;			/* points to highest art # */

  hashval = HashGroup (ListLine);
checkhash:;
  if (!NetHashTable[hashval]) {
	/* This is a new group.
	 * Create a Group line from the information in this line.
	 */

	ListLine += BuildGroup(ListLine, (TypLine *) (mygroupline));
	mygroup = (TypGroup *) (mygroupline + sizeof (TypLine));
	GetNum (&restline, &(mygroup->ServerLast));
	GetNum (&restline, &(mygroup->ServerFirst));
	mygroup->ServerEstNum = mygroup->ServerLast - mygroup->ServerFirst + 1;
	//mygroup->HighestPrevSeen = 0; // redundant
	//mygroup->nRanges = 0;
	//mygroup->nSpareRanges = 0;
//    mygroup->nSpareRanges = SpareRanges;
	mygroup->Determined = TRUE;
	//mygroup->NumUnread = 0L; // redundant
	AddGroupToTable (mygroupline);
  }
  else {
	textptr = ((char far *) NetHashTable[hashval] + sizeof (TypLine) + sizeof (TypGroup));
	if (lstrcmp (textptr, ListLine)) {
	  hashval = (hashval + 1) % HashTableSize;
	  goto checkhash;
	}
	else {

	  /* This group is already present in NetDoc.
	     Update the ServerFirst and ServerLast fields.*/
	  netgroup = (TypGroup far *) ((char far *) NetHashTable[hashval] + sizeof (TypLine));
	  GetNum (&restline, &ArtNum);
	  netgroup->ServerLast = ArtNum;
	  GetNum (&restline, &ArtNum);
	  netgroup->ServerFirst = ArtNum;
	  netgroup->ServerEstNum = (netgroup->ServerLast - netgroup->ServerFirst + 1);
	  netgroup->Determined = TRUE;
	  netgroup->NumUnread = CalcNumUnread(netgroup);
	}
  }
}

/*--- function AddGroupToTable ----------------------------------------
 *
 *  Add a group line, formatted for eventual inclusion in NetDoc,
 *  to NewGroupTable.
 *
 *  Entry:  GroupLine      is the line to add to the table.
 *
 *  Exit:   NewGroupTable  contains the line
 *          nNewGroups     has been incremented.
 */
void
AddGroupToTable (char far * GroupLine)
{
  char huge *NextPtr;
  char huge *EndPtr;

  NextPtr = (char huge *) CurrentSpot + ((TypLine far *) GroupLine)->length;
  EndPtr = (char huge *) NewGroupData + NewGroupDataSize;

  /* Check to see if the current data will put us over the edge */
  if (NextPtr > EndPtr) {
	GlobalUnlock (hNewGroupData);
	NewGroupDataSize += CHUNKSIZE;
	hNewGroupData = GlobalReAlloc (hNewGroupData, NewGroupDataSize,GMEM_MOVEABLE);
	NewGroupData = GlobalLock (hNewGroupData);
	CurrentSpot = (char huge *) NewGroupData + BytesSoFar;
	NextPtr = (char huge *) CurrentSpot + ((TypLine far *) GroupLine)->length;
  }

  /* Create a copy of this line in far memory
   */
  MoveBytes ((char far *) GroupLine, CurrentSpot,
			 ((TypLine far *) GroupLine)->length);
  nNewGroups++;

  BytesSoFar += ((TypLine huge *) CurrentSpot)->length;
  CurrentSpot = NextPtr;

}

/*--- function HashGroup -------------------------------------------------
 *
 *  Hash a string into an unsigned integer.
 *
 *  This hash function is designed based on information from a
 *  handout for a UC Berkeley class CS 60C, Spring 1990, Clancy/
 *  Harrison.  I picked up the handout while wandering around on
 *  Berkeley's campus in May 1990.  The handout in turn is based
 *  on the McKenzie, et al., article "Selecting a Hashing Algorithm"
 *  in Software Practice and Experience, Vol 20, no 2, Feb 1990.
 *  The algorithm is similar to that used in the AT&T C++ compiler.
 *  /mrr
 */

unsigned long
HashGroup (unsigned char huge * gname)
{
  long unsigned int sum = 0;
  unsigned long hash;

  for (; *gname; gname++) {
	sum = (sum << 1) + *gname;
  }
  hash = (sum % HashTableSize);
  return (hash);
}

/*--- function BuildPtrList ------------------------------------------
 *
 *  Build both the array of pointers into the new group data, as well
 *  as build the hashtable.
 */
void
BuildPtrList ()
{
  unsigned long i;

  /* Build the pointer array after the fact */
  if (nNewGroups != 0) {
    hNewGroupTable = GlobalAlloc (GMEM_MOVEABLE, nNewGroups * sizeof (TypLine huge *));
  	NewGroupTable = (void huge * huge *) GlobalLock (hNewGroupTable);
  	if (NewGroupTable == NULL)
    for (i = 0; i < 10; i++) {
       NewGroupTable = (void huge * huge *) GlobalLock (hNewGroupTable);
       if (NewGroupTable) break;
    }
    
    if (NewGroupTable == NULL)
      {
      MessageBox (NetDoc.hDocWnd, "Failed to Get a Memory Lock on newly allocated \n"
                                  "memory for New Groups table after 10 attempts. \n"
                                  "You may need to add more memory or paging space \n"
                                  "to be able to receive a full group list from \n"
                                  "your News Server or turn off Sorting via the \n"
                                  "Config Group List menu. \n", "Global Lock Failed",
			                      MB_OK | MB_ICONEXCLAMATION);                       
      }
    else
      {
    	CurrentSpot = NewGroupData;

    	for (i = 0; i < nNewGroups; i++) {
	  		NewGroupTable[i] = CurrentSpot;
	  		CurrentSpot += ((TypLine huge *) CurrentSpot)->length;
    	}
    }
  }
}

/*--- function BuildHashTable ------------------------------------------
 *
 *  Build the hashtable from the NewGroupTable.
 */
void
BuildHashTable ()
{
  unsigned long i,hashval;
  char huge *textptr;

  for (i = 0; i < nNewGroups; i++) {
	/* Plus fill in the hash table */
	textptr = (char huge *) NewGroupTable[i] + sizeof (TypLine)
	  + sizeof (TypGroup);
	hashval = HashGroup (textptr);
	while (NetHashTable[hashval]) {
	  hashval = (hashval + 1) % HashTableSize;
	}
	NetHashTable[hashval] = NewGroupTable[i];
  }

}


/*--- function ProcEndList -------------------------------------------
 *
 *  Do the final processing when we have reached the end of the
 *  list of newsgroups sent us via the LIST command.
 */

void
ProcEndList ()
{
  DLGPROC lpfnWinVnGroupListDlg;
  WORD LockCount;

  /* Well, we need a new and different hash table now, so close out the
     old one */
  LockCount = GMEM_LOCKCOUNT & GlobalFlags (hNetHashTable);
  MyGlobalUnlock (hNetHashTable);
  GlobalFree (hNetHashTable);

  InitHashTable (nNewGroups);
  BuildPtrList ();
  BuildHashTable ();

  if (SortGroupList) {
  	ShellSort (NewGroupTable, nNewGroups, sizeof (void huge *), GroupCompare);
  }

  lpfnWinVnGroupListDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnGroupListDlg, hInst);

  /* Display dialog box of new groups.  */
  if (nNewGroups)
	  if ((nNewGroups > DEF_MaxNewGroups) || 
	      DialogBox (hInst, "WinVnGroupList", NetDoc.hDocWnd, lpfnWinVnGroupListDlg)) {
	/* The user has clicked OK or the number of new groups is too large for the
	 * user to bother with, so add all the new groups to the
	 * Net document.  Subscribed groups go at the end of the Subscribed
	 * section at the top of the doc.
	 * Unsubscribed groups go in the section below, in alphabetical order.
	 */
	MergeGroups (ADD_SUBSCRIBED_END_OF_SUB);
	NetDoc.LongestLine = 0;
	SetGroupActiveLines ();
  }

  /* Unlock and/or free memory in NetDoc and NewGroupTable.  */
  CleanUpGroupTable ();

  /* Unlock and free the hash table.   */
  LockCount = GMEM_LOCKCOUNT & GlobalFlags (hNetHashTable);
  MyGlobalUnlock (hNetHashTable);
  GlobalFree (hNetHashTable);
  InvalidateRect (NetDoc.hDocWnd, NULL, FALSE);
  SetNetDocTitle ();
  NewsrcDirty = TRUE;
}

/*--- function GroupCompare --------------------------------------------
 *
 *  Compare two group lines alphabetically by group name.
 */
int
GroupCompare (TypLine const huge * huge * g1,
			  TypLine const huge * huge * g2)
{
  char huge *gch1, huge * gch2;
  
  if ((g1 != NULL) && (g2 != NULL)) {
  	gch1 = (char huge *) *g1 + sizeof (TypLine) + sizeof (TypGroup);
 	gch2 = (char huge *) *g2 + sizeof (TypLine) + sizeof (TypGroup);
   return (lstrcmp (gch1, gch2)); 
   }
   else
   return (0);
}


/*-- function WinVnGroupListDlg ---------------------------------------
 *
 *  Dialog function to handle selection of new newsgroups to
 *  subscribe to.  (I know, don't end a sentence with "to".)
 */

BOOL FAR PASCAL
WinVnGroupListDlg (HWND hDlg, unsigned iMessage, WPARAM wParam, LPARAM lParam)
{
  unsigned long j,hashval;
  LRESULT nItem;
  char TmpBuf[80];
  char far *CurName;
  char huge *cptr;
  TypHier far *CurHier;
  static HANDLE hStartHier, hCurHier;
  TypGroup huge *group;
  HWND hDlgHierList;			/* Handle to child hierarchy list box window. */
  HWND hDlgSubList;
  HWND hDlgUnSubList;
  HDC  hListboxDC;
  static int maxSubExt, maxUnsubExt;
#ifdef WIN32
  SIZE size;
#else
  DWORD size;
#endif  
  int ext; 
  switch (iMessage) {

  case WM_INITDIALOG:
	/* First build the list of top-level hierarchies */
	CurHier = (TypHier *) NULL;
	hStartHier = hCurHier = (HANDLE) NULL;
	maxSubExt = maxUnsubExt = 0;
	for (j = 0; j < nNewGroups; j++) {
	  cptr = 0;
	  cptr = (NewGroupTable[j]);
	  cptr += sizeof (TypLine) + sizeof (TypGroup);
	  if ((CurHier == NULL) ||
		  (strnicmp (CurName, cptr, strcspn (cptr, "."))
		   != 0)) {
		HANDLE hTmpHandle;
		int NameLen;
		/* Need a new link */
		hTmpHandle = GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT,
								  sizeof (TypHier));
		if (CurHier) {
		  CurHier->hNext = hTmpHandle;
		  GlobalUnlock (CurHier->hName);
		  GlobalUnlock (hCurHier);
		  hCurHier = hTmpHandle;
		  CurHier = (TypHier far *) GlobalLock (hCurHier);
		}
		else {
		  hCurHier = hStartHier = hTmpHandle;
		  CurHier = (TypHier far *) GlobalLock (hCurHier);
		}
		/* And now for the actual hierarchy name */
		NameLen = strcspn (cptr, ".");
		CurHier->hName = GlobalAlloc (GMEM_MOVEABLE, NameLen + 1);
		CurName = GlobalLock (CurHier->hName);
		strntcpy (CurName, cptr, NameLen);
		/* And the start index */
		CurHier->Start = j;
	  }
	  /* Increment the number of groups _every_ time */
	  CurHier->NumGroups++;
	}
	GlobalUnlock (CurHier->hName);
	GlobalUnlock (hCurHier);

	/* Now, load the HIERARCY box */
	hDlgHierList = GetDlgItem (hDlg, IDD_HIERARCHY_LISTBOX);
	SendMessage (hDlgHierList, WM_SETREDRAW, FALSE, 0L);
	hCurHier = hStartHier;
	while (hCurHier) {
	  HANDLE hTmpHandle;
	  CurHier = (TypHier far *) GlobalLock (hCurHier);
	  CurName = GlobalLock (CurHier->hName);
	  SendMessage (hDlgHierList, LB_ADDSTRING, 0, (LPARAM) CurName);
	  hTmpHandle = CurHier->hNext;
	  GlobalUnlock (CurHier->hName);
	  GlobalUnlock (hCurHier);
	  hCurHier = hTmpHandle;
	}
	SendMessage (hDlgHierList, WM_SETREDRAW, TRUE, 0L);

	/* And select the 0th item to kick things off */
	SendMessage (hDlgHierList, LB_SETCURSEL, 0, 0);
#ifdef WIN32
	SendMessage (hDlg, WM_COMMAND, (WPARAM) MAKEWPARAM (IDD_HIERARCHY_LISTBOX,
		 LBN_SELCHANGE), (LPARAM) GetDlgItem (hDlg, IDD_HIERARCHY_LISTBOX));
#else
	SendMessage (hDlg, WM_COMMAND, IDD_HIERARCHY_LISTBOX,
			  (LPARAM) MAKELPARAM (GetDlgItem (hDlg, IDD_HIERARCHY_LISTBOX),
								   LBN_SELCHANGE));
#endif /* WIN32 */
	return TRUE;
	break;

  case WM_COMMAND:
	switch (LOWORD (wParam)) {
	case IDOK:
	  EndDialog (hDlg, TRUE);
	  break;
	case IDCANCEL:
	  EndDialog (hDlg, FALSE);
	  break;
	case IDD_SUBSCRIBED_GROUP_LISTBOX:
	  switch (GET_WM_COMMAND_CMD(wParam, lParam))
	  {
	  case LBN_DBLCLK:
		/* switch to unsubscribed */
		nItem = SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETCURSEL, 
					(WPARAM)0, (LPARAM)0);
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETTEXT, 
					(WPARAM)nItem, (LPARAM)TmpBuf);
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_DELETESTRING, 
					(WPARAM)nItem, (LPARAM)0);

		/* Now pull the stucture out of the hash table */
		hashval = HashGroup (TmpBuf);
		while (strcmp (
						(char huge *) NetHashTable[hashval] + sizeof (TypLine) + sizeof (TypGroup),
						TmpBuf) != 0) {
		  hashval = (hashval + 1) % HashTableSize;
		}
		group = (TypGroup huge *)
		  ((char huge *) NetHashTable[hashval] + sizeof (TypLine));
		group->Subscribed = 0;

		SendMessage (GetDlgItem (hDlg, IDD_UNSUBSCRIBED_GROUP_LISTBOX),
					 LB_ADDSTRING, 0, (LPARAM) TmpBuf);

		hListboxDC = GetDC(GetDlgItem (hDlg, IDD_UNSUBSCRIBED_GROUP_LISTBOX));
#ifdef WIN32
		GetTextExtentPoint32(hListboxDC, TmpBuf, strlen(TmpBuf), &size);
		ext = (int)size.cx;
#else
		size = GetTextExtent(hListboxDC, TmpBuf, strlen(TmpBuf));
		ext = (int)LOWORD(size);
#endif
		if (ext > maxUnsubExt) { 
			maxUnsubExt = ext;
			SendDlgItemMessage(hDlg, IDD_UNSUBSCRIBED_GROUP_LISTBOX, 
	            LB_SETHORIZONTALEXTENT,(WPARAM)maxUnsubExt,(LPARAM)0);
		}
		ReleaseDC(GetDlgItem (hDlg, IDD_UNSUBSCRIBED_GROUP_LISTBOX), hListboxDC);
		break;
	  default:
		return FALSE;

	  }
	  break;
	  case IDD_UNSUBSCRIBED_GROUP_LISTBOX:
	  switch (GET_WM_COMMAND_CMD(wParam, lParam))
	  {
	  case LBN_DBLCLK:
		/* switch to subscribed */
		nItem = SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETCURSEL, 
					(WPARAM)0, (LPARAM)0);
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETTEXT, 
					(WPARAM)nItem, (LPARAM)TmpBuf);
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_DELETESTRING, 
					(WPARAM)nItem, (LPARAM)0);
		/* Now pull the stucture out of the hash table */
		hashval = HashGroup (TmpBuf);
		while (strcmp ((char huge *) NetHashTable[hashval] +
					   sizeof (TypLine) + sizeof (TypGroup),
					   TmpBuf) != 0) {
		  hashval = (hashval + 1) % HashTableSize;
		}
		group = (TypGroup huge *)
		  ((char huge *) NetHashTable[hashval] + sizeof (TypLine));
		group->Subscribed = 1;

		SendMessage (GetDlgItem (hDlg, IDD_SUBSCRIBED_GROUP_LISTBOX),
					 LB_ADDSTRING, 0, (LPARAM) TmpBuf);
		hListboxDC = GetDC(GetDlgItem (hDlg, IDD_SUBSCRIBED_GROUP_LISTBOX));
#ifdef WIN32
		GetTextExtentPoint32(hListboxDC, TmpBuf, strlen(TmpBuf), &size);
		ext = (int)size.cx;
#else
		size = GetTextExtent(hListboxDC, TmpBuf, strlen(TmpBuf));
		ext = (int)LOWORD(size);
#endif
		if (ext > maxSubExt) { 
			maxSubExt = ext;
			SendDlgItemMessage(hDlg, IDD_SUBSCRIBED_GROUP_LISTBOX, 
	            LB_SETHORIZONTALEXTENT,(WPARAM)maxSubExt,(LPARAM)0);
		}
		ReleaseDC(GetDlgItem (hDlg, IDD_SUBSCRIBED_GROUP_LISTBOX), hListboxDC);
		break;
	  default:
		return FALSE;

	  }
	  break;
	  case IDD_HIERARCHY_LISTBOX:
	  switch (GET_WM_COMMAND_CMD(wParam, lParam))
	  {
	  case LBN_SELCHANGE:
		/* Find the info for this hierarchy */
		nItem = SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETCURSEL, 
					(WPARAM)0, (LPARAM)0);
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETTEXT, 
					(WPARAM)nItem, (LPARAM)TmpBuf);

		hCurHier = hStartHier;
		while (hCurHier) {
		  HANDLE hTmpHandle;
		  CurHier = (TypHier far *) GlobalLock (hCurHier);
		  CurName = GlobalLock (CurHier->hName);
		  GlobalUnlock (CurHier->hName);
		  if (stricmp (CurName, TmpBuf) == 0)
			break;
		  hTmpHandle = CurHier->hNext;
		  GlobalUnlock (hCurHier);
		  hCurHier = hTmpHandle;
		}
		/* clear the existing listboxes */
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), WM_SETREDRAW, FALSE, 0L);

		hDlgSubList = GetDlgItem (hDlg, IDD_SUBSCRIBED_GROUP_LISTBOX);
		hDlgUnSubList = GetDlgItem (hDlg, IDD_UNSUBSCRIBED_GROUP_LISTBOX);
		SendMessage (hDlgUnSubList, LB_RESETCONTENT, 0, 0);
		SendMessage (hDlgSubList, LB_RESETCONTENT, 0, 0);

		hListboxDC = GetDC(hDlgSubList);
		/* load the subscribed/unsubscribed boxes */
		for (j = CurHier->Start; j < (CurHier->Start + CurHier->NumGroups); j++) {
		  TypGroup huge *group;
		  group = (TypGroup huge *)
			((char huge *) NewGroupTable[j] + sizeof (TypLine));
		  cptr = (char huge *) group + sizeof (TypGroup);
#ifdef WIN32
		  GetTextExtentPoint32(hListboxDC, cptr, strlen(cptr), &size);
		  ext = (int)size.cx;
#else
		  size = GetTextExtent(hListboxDC, cptr, strlen(cptr));
		  ext = (int)LOWORD(size);
#endif

		  if (group->Subscribed) {
			SendMessage (hDlgSubList, LB_ADDSTRING, 0, (LPARAM)cptr);
			if (ext > maxSubExt) { 
				maxSubExt = ext;
			}
		  } else {
			SendMessage (hDlgUnSubList, LB_ADDSTRING, 0, (LPARAM)cptr);
			if (ext > maxUnsubExt) { 
				maxUnsubExt = ext;
			}
		  }			
		}
		ReleaseDC(hDlgSubList, hListboxDC);
		
		SendMessage(hDlgUnSubList,
		            LB_SETHORIZONTALEXTENT,(WPARAM)maxUnsubExt,(LPARAM)0);
		SendMessage(hDlgSubList,
		            LB_SETHORIZONTALEXTENT,(WPARAM)maxSubExt,(LPARAM)0);
	
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), WM_SETREDRAW, TRUE, 0L);

		GlobalUnlock (hCurHier);
		break;
	  default:
		return FALSE;
	  }
	  break;
	  default:
	  return FALSE;
	}
	break;

  case WM_DESTROY:
	/* Ok, now we tear down the hierarchy structure */
	hCurHier = hStartHier;
	while (hCurHier) {
	  HANDLE hTmpHandle;
	  CurHier = (TypHier far *) GlobalLock (hCurHier);
	  GlobalFree (CurHier->hName);
	  hTmpHandle = CurHier->hNext;
	  GlobalUnlock (hCurHier);
	  GlobalFree (hCurHier);
	  hCurHier = hTmpHandle;
	}
	break;

  default:
	return FALSE;
	break;
  }
  return TRUE;
}

/*--- function PositionEndSubscribed ----------------------------------
 *
 *  Position a pointer to the end of the subscribed section at the
 *  beginning of the net document.
 *
 *  Entry   None
 *
 *  Exit    BlockPtr and LinePtr  point to the place in NetDoc just
 *            beyond the last subscribed group.  We assume that
 *            all subscribed groups go at the beginning of the
 *            document.
 */
void
PositionEndSubscribed (TypBlock far ** BlockPtr, TypLine far ** LinePtr)
{
  BOOL advance;
  TypGroup far *group;

  if (TopOfDoc (&NetDoc, BlockPtr, LinePtr)) {
  	advance = TRUE;
  	do {
		group = GetGroup(*LinePtr);
		if (group->Subscribed) {
		  advance = NextLine (BlockPtr, LinePtr);
		}
		else {
		  advance = FALSE;
		}
  	}
  	while (advance);
  }
}

/*--- function PositionNextSelected ----------------------------------
 *
 *  Position a pointer to the next selected group of the net document.
 *
 *  Entry   None
 *
 *  Exit    BlockPtr and LinePtr point to the place in NetDoc at
 *          the next selected group.  
 */
void
PositionNextSelected (TypBlock far ** BlockPtr, TypLine far ** LinePtr)
{
  BOOL advance;
  TypGroup far *group;
 
  advance = TRUE;
  do {
	group = GetGroup(*LinePtr);
	if (group->Selected) {
	  advance = FALSE; 
	}
	else {
	  advance = NextLine (BlockPtr, LinePtr);
	}
  }
  while (advance);
}
 /*--- function PositionFirstSelected ----------------------------------
 *
 *  Position a pointer to the first selected group of the net document.
 *
 *  Entry   None
 *
 *  Exit    BlockPtr and LinePtr  point to the place in NetDoc at
 *          the first selected group.  
 */
void
PositionFirstSelected (TypBlock far ** BlockPtr, TypLine far ** LinePtr)
{
  if (TopOfDoc (&NetDoc, BlockPtr, LinePtr)) {
  	PositionNextSelected(BlockPtr,LinePtr);
  }
}

/*--- function MergeGroups ----------------------------------------
 *
 *  Merge a list of groups into NetDoc.
 *
 *  Entry:  NewGroupTable  is an array of pointers to TypGroup structures
 *                         of groups to be merged into NetDoc.
 *          hNewGroupTable is the handle to the above.
 *          nNewGroups     is the number of groups in the table.
 *          WhereSubscribed   indicates where new subscribed groups
 *                         should be added.
 *                         ADD_SUBSCRIBED_END_OF_SUB indicates that
 *                           they should be added at the end of the subscribed
 *                           list, before the unsubscribed groups.
 *                         ADD_SUBSCRIBED_TOP_OF_DOC indicates that they
 *                           should be added at the top of the document.
 *  Exit:   The groups in the table have been added to NetDoc, and
 *            the entries in GroupTable have been freed from memory.
 *            Also, GroupTable itself has been freed.
 */
void
MergeGroups (int WhereSubscribed)
{
  TypBlock far *BlockPtr;
  TypLine far *LinePtr;
  TypGroup far *group;
  char far *netcptr;
  char far *grpcptr;
  void far *AllocPtr;
  HANDLE hLine;
  unsigned int Offset;
  TypLineID MyLineID;
  char myline[BLOCK_SIZE];
  unsigned long j;
  int advance, at_end = 0;
  int percent,opercent;
  char szString[MAXFILENAME+20];

  sprintf(szString,"Sorting List of Newsgroups"); 
  SetStatbarText(NetDoc.hWndFrame,szString,&NetDoc, TRUE, TRUE);

  switch (WhereSubscribed) {
  case ADD_SUBSCRIBED_END_OF_SUB:
	PositionEndSubscribed (&BlockPtr, &LinePtr);
	break;
  case ADD_FIRST_SELECTED:
	PositionFirstSelected (&BlockPtr, &LinePtr);
	break;
  case ADD_SUBSCRIBED_TOP_OF_DOC:
	TopOfDoc (&NetDoc, &BlockPtr, &LinePtr);
	break;
  }

  /* BlockPtr and LinePtr point to the
   * place to add new subscribed groups.
   * Loop through the new groups; for subscribed groups, add
   * them to NetDoc at this point.
   * For each subscribed group, unlock and free the corresponding
   * line pointed to by NewGroupTable.  Set the table entry
   * to 0 to indicate that this group has been dealt with.
   */

  sprintf(szString,"Merging Subscribed Newsgroups"); 
  SetStatbarText(NetDoc.hWndFrame,szString,&NetDoc, TRUE, TRUE);
  SetStatbarPercent(NetDoc.hWndFrame,(percent = 0),&NetDoc,TRUE);
  opercent = percent;

  for (j = 0; j < nNewGroups; j++) {  
     percent = (int) (((float) (j + 1) / (float) nNewGroups) * 100);
     if (percent > (opercent + 5)) {  
        SetStatbarPercent(NetDoc.hWndFrame,percent,&NetDoc,TRUE);
        opercent = percent;
     } 
    
	AllocPtr = (char far *) NewGroupTable[j];
	group = GetGroup(AllocPtr);
	if (group->Subscribed) {
	  /* This group has been selected and should be subscribed to.*/
	  MoveBytes (AllocPtr, myline, ((TypLine far *) AllocPtr)->length);
	  LinePtr->active = TRUE;
	  if (WhereSubscribed == ADD_FIRST_SELECTED) {
	   DeleteLine (&BlockPtr, &LinePtr);
	   AddLine ((TypLine *) myline, &BlockPtr, &LinePtr);
	   PositionNextSelected (&BlockPtr, &LinePtr);
	  }
	  else {
	    AddLine ((TypLine *) myline, &BlockPtr, &LinePtr);
	    NetDoc.ActiveLines++;
	  }
	  NewGroupTable[j] = (void far *) 0;
	}
  }
  PositionEndSubscribed (&BlockPtr, &LinePtr);

  /* Now take a second pass through NewGroupTable, for the
   * unsubscribed groups.  If NewGroupTable[j] is non-zero, then
   * that group should be entered into the second, unsubscribed
   * section of NetDoc, merged in in alphabetical order.
   *
   * BlockPtr and LinePtr point to the first unsubscribed group.
   */

  sprintf(szString,"Merging UnSubscribed Newsgroups"); 
  SetStatbarText(NetDoc.hWndFrame,szString,&NetDoc, TRUE, TRUE);
  SetStatbarPercent(NetDoc.hWndFrame,(percent = 0),&NetDoc,TRUE);
  opercent = percent;
  
  for (j = 0; j < nNewGroups; j++) {
     percent = (int) (((float) (j + 1) / (float) nNewGroups) * 100);
     if (percent > opercent + 5) {  
        SetStatbarPercent(NetDoc.hWndFrame,percent,&NetDoc,TRUE);
        opercent = percent;
     } 
	if (NewGroupTable[j]) {
	  /* Search for the right place to add this line. */

	  AllocPtr = (char far *) NewGroupTable[j];
	  grpcptr = GetGroupName(AllocPtr);
	  advance = TRUE;

	  if (!at_end) {
		do {
		  netcptr = GetGroupName(LinePtr);
		  if (lstrcmp (grpcptr, netcptr) < 0) {
			advance = FALSE;
		  }
		  else {
			advance = NextLine (&BlockPtr, &LinePtr);
			if (!advance)
			  at_end = 1;		/* possible bug, getting bad netcptr (smr) */
		  }
		}
		while (advance);
	  }

	  /* Now add the new group at this point */
	  MoveBytes (AllocPtr, myline, ((TypLine far *) AllocPtr)->length);
	  LinePtr->active = ShowUnsubscribed;
	  if (WhereSubscribed == ADD_FIRST_SELECTED) {
	     PrevLine(&BlockPtr, &LinePtr);
	     DeleteLine (&BlockPtr, &LinePtr);
	     AddLine ((TypLine *) myline, &BlockPtr, &LinePtr);
		 }
	  else
	    AddLine ((TypLine *) myline, &BlockPtr, &LinePtr);
	}
  }

  UnlockLine (BlockPtr, LinePtr, &hLine, &Offset, &MyLineID);
  SetStatbarPercent(NetDoc.hWndFrame,0,&NetDoc,TRUE);
  SetStatbarText(NetDoc.hWndFrame,"",&NetDoc, TRUE, TRUE);

}

/*--- function CleanUpGroupTable ------------------------------------
 *
 *  Clean up after doing processing to add or move groups in NetDoc.
 */
void
CleanUpGroupTable ()
{
  HANDLE hBlock, hBlockNext;
  TypBlock far *BlockPtr;

  /* Unlock all blocks in the NetDoc document.
   */

  hBlock = NetDoc.hFirstBlock;
  do {
	BlockPtr = (TypBlock far *) GlobalLock (hBlock);
	hBlockNext = BlockPtr->hNextBlock;

	MyGlobalUnlock (hBlock);
	MyGlobalUnlock (hBlock);
	hBlock = hBlockNext;
  }
  while (hBlock);

  /* Unlock and free the NewGroupTable and NewGroupData.  */
  if (hNewGroupData){
  	GlobalUnlock (hNewGroupData);
  	GlobalFree (hNewGroupData);
  }
  if (hNewGroupTable) {
  	MyGlobalUnlock (hNewGroupTable);
  	GlobalFree (hNewGroupTable);
  }
}

/*--- function FindNextPrime ------------------------------------
 *
 *  Find the smallest prime that is larger than the given argument.
 *  Extreemly handy for those annoying dynamic hash tables.
 */
unsigned long
FindNextPrime (unsigned long OrigVal)
{

  int MaxPrimeIndex = (sizeof (prime) / sizeof (prime[0])) - 1;
  int IndexA = 0;
  int IndexB = MaxPrimeIndex;
  int TmpIndex;

  /* If we're larger than the max prime we know of, just return it */
  if (OrigVal >= prime[MaxPrimeIndex])
	return (prime[MaxPrimeIndex]);

  /* We do this by doing a binary search of the prime array */
  do {
	TmpIndex = IndexA + ((IndexB - IndexA) / 2);
	if (OrigVal == prime[TmpIndex])
	  return (prime[TmpIndex + 1]);
	if (OrigVal < prime[TmpIndex])
	  IndexB = TmpIndex;
	else
	  IndexA = TmpIndex;
  } while ((IndexB - IndexA) > 1);

  return (prime[IndexA + 1]);
}

//
// Local Variables:
// tab-width: 2
// end:
//
@


1.34
log
@don't display new newsgroups box if list is too large
@
text
@d2 1
a2 1
 * $Id: wvlist.c 1.33 1995/11/07 23:05:09 dumoulin Exp $
d33 1
a33 1
void huge *CurrentSpot;			/* The pointer to the next available spot in NewGroupData */
d41 1
a41 3
MRRGlobalUnlock (hWhat, wLine)
	 HANDLE hWhat;
	 WORD wLine;
d94 1
a94 1
InitHashTable (unsigned int Elements)
d101 1
a101 1
  HashTableSize = (unsigned int) FindNextPrime ((unsigned long) Elements * 2L);
d105 1
a105 1
							   (unsigned long) HashTableSize *
d131 1
a131 1
  nNewGroups = 0;
d145 1
a145 3
HashNetGroups (Doc, HashTable)
	 TypDoc *Doc;
	 TypLine huge * huge * HashTable;
d149 1
a149 1
  unsigned int hashval;
d198 1
a198 2
ProcListLine (ListLine)
	 unsigned char *ListLine;
d200 1
a200 1
  unsigned int hashval;
d212 2
a213 1
	  PercentDone = MulDiv (RcvLineCount, 100, NetDoc.TotalLines);
d234 1
a234 1
	CrackGroupLine (ListLine, (TypLine *) (mygroupline), NULL);
d239 3
a241 3
	mygroup->HighestPrevSeen = 0;
	mygroup->nRanges = 0;
	mygroup->nSpareRanges = 0;
d244 1
a244 1
	mygroup->NumUnread = 0L;
d305 1
a305 1
  (char huge *) CurrentSpot = NextPtr;
d323 1
a323 1
unsigned int
d327 1
a327 1
  unsigned int hash;
d332 1
a332 1
  hash = (unsigned int) (sum % HashTableSize);
d344 1
a344 1
  int i;
d348 1
a348 1
    hNewGroupTable = GlobalAlloc (GMEM_MOVEABLE, (long) nNewGroups * sizeof (TypLine huge *));
d362 2
a363 1
                                  "your News Server. \n", "Global Lock Failed",
d366 3
a368 2
    
    CurrentSpot = NewGroupData;
d370 4
a373 3
    for (i = 0; i < nNewGroups; i++) {
	  NewGroupTable[i] = CurrentSpot;
	  (char huge *) CurrentSpot += ((TypLine huge *) CurrentSpot)->length;
d385 1
a385 1
  unsigned int hashval;
a386 1
  int i;
d424 3
a426 1
  ShellSort (NewGroupTable, nNewGroups, sizeof (void huge *), GroupCompare);
d466 8
a473 5

  gch1 = (char huge *) *g1 + sizeof (TypLine) + sizeof (TypGroup);
  gch2 = (char huge *) *g2 + sizeof (TypLine) + sizeof (TypGroup);

  return (lstrcmp (gch1, gch2));
d484 1
a484 5
WinVnGroupListDlg (hDlg, iMessage, wParam, lParam)
	 HWND hDlg;
	 unsigned iMessage;
	 WPARAM wParam;
	 LPARAM lParam;
d486 1
a486 1
  int j;
a492 1
  unsigned int hashval;
a500 1
  int ext; 
d503 1
a504 1
#endif  
d883 2
a884 1
  int j, advance, at_end = 0;
d912 1
a912 1
  sprintf(szString,"Sorting Subscribed Newsgroups"); 
d952 1
a952 1
  sprintf(szString,"Sorting UnSubscribed Newsgroups"); 
@


1.33
log
@fixed problems with calling LockLine and failing to check where
lock was accomplished.
@
text
@d2 1
a2 1
 * $Id: wvlist.c 1.32 1995/08/23 23:38:29 dumoulin Exp $
d18 1
d238 1
a238 1
	CrackGroupLine (ListLine, (TypLine *) (mygroupline));
d431 5
a435 2
  if (nNewGroups && DialogBox (hInst, "WinVnGroupList", NetDoc.hDocWnd, lpfnWinVnGroupListDlg)) {
	/* The user has clicked OK, so add all the new groups to the
d1072 6
@


1.32
log
@fixed problems with updating the status bar too often
@
text
@d2 1
a2 1
 * $Id: wvlist.c 1.31 1995/08/16 22:38:21 dumoulin Exp $
d791 12
a802 10
  TopOfDoc (&NetDoc, BlockPtr, LinePtr);
  advance = TRUE;
  do {
	group = GetGroup(*LinePtr);
	if (group->Subscribed) {
	  advance = NextLine (BlockPtr, LinePtr);
	}
	else {
	  advance = FALSE;
	}
a803 1
  while (advance);
d845 3
a847 2
  TopOfDoc (&NetDoc, BlockPtr, LinePtr);
  PositionNextSelected(BlockPtr,LinePtr);
@


1.31
log
@added support for sorting list of newsgroups
@
text
@d2 1
a2 1
 * $Id: wvlist.c 1.30 1995/06/06 04:09:06 dumoulin Exp $
d46 7
a52 6
  if (!(LockCount = (GMEM_LOCKCOUNT & GlobalFlags (hWhat)))) {
  }
  else {
	GlobalUnlock (hWhat);
  }

d911 1
d913 1
a913 2
  for (j = 0; j < nNewGroups; j++) {
     opercent = percent;
d915 1
a915 1
     if (percent > (opercent * .05)) {  
d917 1
d951 2
a952 1

a953 1
     opercent = percent;
d955 1
a955 1
     if (percent > (opercent * .05)) {  
d957 1
d1025 8
a1032 4
  GlobalUnlock (hNewGroupData);
  GlobalFree (hNewGroupData);
  MyGlobalUnlock (hNewGroupTable);
  GlobalFree (hNewGroupTable);
@


1.30
log
@fixed problem with a typo in LinePtr that could cause list of
groups in Newsrc to get trashed when subscribing to a group.
@
text
@d2 1
a2 1
 * $Id: wvlist.c 1.29 1995/05/19 22:32:17 dumoulin Exp $
d804 43
d880 5
d890 3
d907 4
d912 6
d924 9
a932 2
	  AddLine ((TypLine *) myline, &BlockPtr, &LinePtr);
	  NetDoc.ActiveLines++;
d946 4
d951 5
d981 7
a987 1
	  AddLine ((TypLine *) myline, &BlockPtr, &LinePtr);
d992 3
@


1.29
log
@Cleaned up data structures so that access functions are used
instead of raw pointer math (JD)
@
text
@d2 1
a2 1
 * $Id: wvlist.c 1.28 1995/04/22 02:06:39 dumoulin Exp $
d243 2
a244 1
	mygroup->nSpareRanges = SpareRanges;
d793 1
a793 1
	group = GetGroup(LinePtr);
@


1.28
log
@Fix a formatting problem
@
text
@d2 1
a2 1
 * $Id: wvlist.c 1.27 1995/04/22 02:03:28 dumoulin Exp $
a63 2


a130 1

a165 2


a191 1

d243 1
d255 1
d257 1
a257 2
	     * Update the ServerFirst and ServerLast fields.
	   */
d293 1
a293 2
	hNewGroupData = GlobalReAlloc (hNewGroupData, NewGroupDataSize,
								   GMEM_MOVEABLE);
a439 1

a442 1

a445 1

d448 1
d792 1
a792 1
	group = (TypGroup far *) ((char far *) *LinePtr + sizeof (TypLine));
d857 1
a857 1
	group = (TypGroup far *) ((char far *) AllocPtr + sizeof (TypLine));
d859 1
a859 2
	  /* This group has been selected and should be subscribed to.
	   */
a866 1

d882 1
a882 1
	  grpcptr = ((char far *) AllocPtr) + sizeof (TypLine) + sizeof (TypGroup);
d887 1
a887 1
		  netcptr = ((char far *) LinePtr) + sizeof (TypLine) + sizeof (TypGroup);
a903 1

a934 1

a938 1

@


1.27
log
@Fix a problem that can overwrite memory if number of new groups
on the server is 0.
@
text
@d1 984
a984 984
/*
 * $Id: wvlist.c 1.26 1995/02/13 19:30:03 rushing Exp $
 */

/*-- WVLIST.C -- File containing functions to deal with the NNTP LIST
 *   command, which lists all the newsgroups and their status.
 *
 *   Mark Riordan   25 October 1990
 */

#include <windows.h>
#include <windowsx.h>
#include "wvglob.h"
#include "winvn.h"
#pragma hdrstop
#include "dos.h"
#include "primes.h"

#include <ctype.h>


/* The size of the chunks of memory that make up the new group list data */
#define CHUNKSIZE       64L*1024L

TypLine huge * huge * NetHashTable;
HANDLE hNetHashTable;

HANDLE htohNewGroupLines;
HANDLE far *lphNewGroupLines;	/* array of handles to new group lines */

DWORD NewGroupDataSize;			/* The size (in bytes) of NewGroupData */
void huge *CurrentSpot;			/* The pointer to the next available spot in NewGroupData */
unsigned long BytesSoFar;

#define MyGlobalUnlock(hWhat)  MRRGlobalUnlock(hWhat,__LINE__)

void MRRGlobalUnlock (HANDLE hWhat, WORD wLine);

void
MRRGlobalUnlock (hWhat, wLine)
	 HANDLE hWhat;
	 WORD wLine;
{
  WORD LockCount;

  if (!(LockCount = (GMEM_LOCKCOUNT & GlobalFlags (hWhat)))) {
  }
  else {
	GlobalUnlock (hWhat);
  }

}


/*--- function StartList -----------------------------------------------
 *
 *  Initiate the process of sending a LIST command and using its
 *  output to update our list of news groups.
 */

void
StartList ()
{


  CommState = ST_LIST_RESP;
  CommBusy = TRUE;
  PutCommLine ("LIST");
  Initializing = INIT_SCANNING_NETDOC;
  InvalidateRect (NetDoc.hDocWnd, NULL, FALSE);
  SendMessage (NetDoc.hWndFrame, WM_PAINT, 0, 0L);

  /* Set up table of pointers to new group lines. */
  InitGroupTable ();

  /* Initialize the hash table */
  InitHashTable (LinesInRC);

  /* And set up the hash table for stuff from the newsrc */
  HashNetGroups (&NetDoc, NetHashTable);
  InvalidateRect (NetDoc.hDocWnd, NULL, FALSE);
  Initializing = INIT_GETTING_LIST;
  SendMessage (NetDoc.hWndFrame, WM_PAINT, 0, 0L);
}

/*--- function InitHashTable -------------------------------------------
 *
 *  Allocate and zero the NetHashTable. The argument is the number of
 *  elements to be hashed (NOT the number of elements in the hash table)
 *
 *  Exit:   hNetHashTable     is the handle
 *          NetHashTable      points to the table
 *                      HashTableSize     The number of elements in the hash table
 */
void
InitHashTable (unsigned int Elements)
{

  /* First, figure out how large the hashtable should be.
   * The basic algorithm used here is to double the size of what you're
   * hashing, rounded up to the next nearest prime number
   */
  HashTableSize = (unsigned int) FindNextPrime ((unsigned long) Elements * 2L);

  /* Set up hash table for group names */
  hNetHashTable = GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT,
							   (unsigned long) HashTableSize *
							   sizeof (TypLine far *));
  NetHashTable = (TypLine huge * huge *) GlobalLock (hNetHashTable);

}


/*--- function InitGroupTable -------------------------------------------
 *
 *  Allocate the first CHUNKSIZE bytes of memory for the
 * new group lines.
 *
 *  Exit:   hNewGroupData    is the handle
 *          NewGroupData     points to the table
 *          nNewGroups        has been initialized to 0.
 *                      NewGroupDataSize  is the current size of the NewGroupData
 */
void
InitGroupTable (void)
{
  /* Allocate the first chunk */
  NewGroupDataSize = CHUNKSIZE;
  hNewGroupData = GlobalAlloc (GMEM_MOVEABLE, NewGroupDataSize);
  NewGroupData = (void far *) GlobalLock (hNewGroupData);
  CurrentSpot = NewGroupData;
  BytesSoFar = 0;

  nNewGroups = 0;
}


/*--- function HashNetGroups ------------------------------------------
 *
 *  Enter all the groups in the Net document into the hash table.
 *
 *  Exit    All blocks in the document are locked.
 *          HashTable   is (partially) filled with pointers to
 *                      each of the lines in "Doc".
 */

void
HashNetGroups (Doc, HashTable)
	 TypDoc *Doc;
	 TypLine huge * huge * HashTable;
{
  TypBlock far *BlockPtr;
  TypLine far *LinePtr;
  unsigned int hashval;
  HANDLE hBlock;
  unsigned int Offset;
  unsigned int TextOffset;
  unsigned char far *textptr;
  TypLineID MyLineID;

  /* Lock all blocks in the document */
  hBlock = Doc->hFirstBlock;
  do {
	BlockPtr = (TypBlock far *) GlobalLock (hBlock);
	hBlock = BlockPtr->hNextBlock;
  }
  while (hBlock);



  /* Now start at the beginning of the document, going through
   * each line in the document, hashing its group name into the table.
   */

  hBlock = Doc->hFirstBlock;
  Offset = sizeof (TypBlock);
  MyLineID = 0L;

  LockLine (hBlock, Offset, MyLineID, &BlockPtr, &LinePtr);

  TextOffset = Doc->OffsetToText;

  if (LinePtr->length != END_OF_BLOCK) {
	do {
	  textptr = ((unsigned char far *) LinePtr) + TextOffset;
	  hashval = HashGroup (textptr);
	  while (HashTable[hashval]) {
		hashval = (hashval + 1) % HashTableSize;
	  }
	  HashTable[hashval] = LinePtr;
	}
	while (NextLine (&BlockPtr, &LinePtr));
  }
  UnlockLine (BlockPtr, LinePtr, &hBlock, &Offset, &MyLineID);
}


/*--- function ProcListLine ---------------------------------------------
 *
 *  Process a line received from the NNTP LIST command output.
 *  Each line from the LIST command has the form:
 *   <groupname> <highest_art_#> <lowest_art_#> {y|n|m}
 */

void
ProcListLine (ListLine)
	 unsigned char *ListLine;
{
  unsigned int hashval;
  char far *textptr;
  unsigned char *cptr, *restline;
  char mygroupline[BLOCK_SIZE];
  TypGroup *mygroup;
  TypGroup far *netgroup;
  long int ArtNum;
  int PercentDone;

  if ((++RcvLineCount) % UPDATE_TITLE_FREQ == 0) {
	InvalidateRect (NetDoc.hDocWnd, NULL, FALSE);
	if (NetDoc.TotalLines > 0) {
	  PercentDone = MulDiv (RcvLineCount, 100, NetDoc.TotalLines);
	  if (PercentDone <= 100)
		SetStatbarPercent (NetDoc.hWndFrame, PercentDone, &NetDoc, TRUE);
	}
	if (RcvLineCount % (UPDATE_TITLE_FREQ * 25) == 0) {
	  UpdateWindow (NetDoc.hDocWnd);
	}
  }

  /* Replace the first blank in the input line with a zero. */
  for (cptr = ListLine; *cptr && *cptr != ' '; cptr++);
  *cptr = '\0';
  restline = cptr + 1;			/* points to highest art # */

  hashval = HashGroup (ListLine);
checkhash:;
  if (!NetHashTable[hashval]) {
	/* This is a new group.
	 * Create a Group line from the information in this line.
	 */

	CrackGroupLine (ListLine, (TypLine *) (mygroupline));
	mygroup = (TypGroup *) (mygroupline + sizeof (TypLine));
	GetNum (&restline, &(mygroup->ServerLast));
	GetNum (&restline, &(mygroup->ServerFirst));
	mygroup->ServerEstNum = mygroup->ServerLast - mygroup->ServerFirst + 1;
	mygroup->HighestPrevSeen = 0;
	mygroup->nRanges = 0;
	mygroup->Determined = TRUE;
	mygroup->NumUnread = 0L;
	AddGroupToTable (mygroupline);
  }
  else {
	textptr = ((char far *) NetHashTable[hashval] + sizeof (TypLine) + sizeof (TypGroup));
	if (lstrcmp (textptr, ListLine)) {
	  hashval = (hashval + 1) % HashTableSize;
	  goto checkhash;
	}
	else {
	  /* This group is already present in NetDoc.
	     * Update the ServerFirst and ServerLast fields.
	   */
	  netgroup = (TypGroup far *) ((char far *) NetHashTable[hashval] + sizeof (TypLine));
	  GetNum (&restline, &ArtNum);
	  netgroup->ServerLast = ArtNum;
	  GetNum (&restline, &ArtNum);
	  netgroup->ServerFirst = ArtNum;
	  netgroup->ServerEstNum = (netgroup->ServerLast - netgroup->ServerFirst + 1);
	  netgroup->Determined = TRUE;
	  netgroup->NumUnread = CalcNumUnread(netgroup);
	}
  }
}

/*--- function AddGroupToTable ----------------------------------------
 *
 *  Add a group line, formatted for eventual inclusion in NetDoc,
 *  to NewGroupTable.
 *
 *  Entry:  GroupLine      is the line to add to the table.
 *
 *  Exit:   NewGroupTable  contains the line
 *          nNewGroups     has been incremented.
 */
void
AddGroupToTable (char far * GroupLine)
{
  char huge *NextPtr;
  char huge *EndPtr;

  NextPtr = (char huge *) CurrentSpot + ((TypLine far *) GroupLine)->length;
  EndPtr = (char huge *) NewGroupData + NewGroupDataSize;

  /* Check to see if the current data will put us over the edge */
  if (NextPtr > EndPtr) {
	GlobalUnlock (hNewGroupData);
	NewGroupDataSize += CHUNKSIZE;
	hNewGroupData = GlobalReAlloc (hNewGroupData, NewGroupDataSize,
								   GMEM_MOVEABLE);
	NewGroupData = GlobalLock (hNewGroupData);
	CurrentSpot = (char huge *) NewGroupData + BytesSoFar;
	NextPtr = (char huge *) CurrentSpot + ((TypLine far *) GroupLine)->length;
  }

  /* Create a copy of this line in far memory
   */
  MoveBytes ((char far *) GroupLine, CurrentSpot,
			 ((TypLine far *) GroupLine)->length);
  nNewGroups++;

  BytesSoFar += ((TypLine huge *) CurrentSpot)->length;
  (char huge *) CurrentSpot = NextPtr;

}

/*--- function HashGroup -------------------------------------------------
 *
 *  Hash a string into an unsigned integer.
 *
 *  This hash function is designed based on information from a
 *  handout for a UC Berkeley class CS 60C, Spring 1990, Clancy/
 *  Harrison.  I picked up the handout while wandering around on
 *  Berkeley's campus in May 1990.  The handout in turn is based
 *  on the McKenzie, et al., article "Selecting a Hashing Algorithm"
 *  in Software Practice and Experience, Vol 20, no 2, Feb 1990.
 *  The algorithm is similar to that used in the AT&T C++ compiler.
 *  /mrr
 */

unsigned int
HashGroup (unsigned char huge * gname)
{
  long unsigned int sum = 0;
  unsigned int hash;

  for (; *gname; gname++) {
	sum = (sum << 1) + *gname;
  }
  hash = (unsigned int) (sum % HashTableSize);
  return (hash);
}

/*--- function BuildPtrList ------------------------------------------
 *
 *  Build both the array of pointers into the new group data, as well
 *  as build the hashtable.
 */
void
BuildPtrList ()
{
  int i;

  /* Build the pointer array after the fact */
  if (nNewGroups != 0) {
    hNewGroupTable = GlobalAlloc (GMEM_MOVEABLE, (long) nNewGroups * sizeof (TypLine huge *));
  	NewGroupTable = (void huge * huge *) GlobalLock (hNewGroupTable);
  	if (NewGroupTable == NULL)
    for (i = 0; i < 10; i++) {
       NewGroupTable = (void huge * huge *) GlobalLock (hNewGroupTable);
       if (NewGroupTable) break;
    }
    
    if (NewGroupTable == NULL)
      {
      MessageBox (NetDoc.hDocWnd, "Failed to Get a Memory Lock on newly allocated \n"
                                  "memory for New Groups table after 10 attempts. \n"
                                  "You may need to add more memory or paging space \n"
                                  "to be able to receive a full group list from \n"
                                  "your News Server. \n", "Global Lock Failed",
			                      MB_OK | MB_ICONEXCLAMATION);                       
      }
    
    CurrentSpot = NewGroupData;

    for (i = 0; i < nNewGroups; i++) {
	  NewGroupTable[i] = CurrentSpot;
	  (char huge *) CurrentSpot += ((TypLine huge *) CurrentSpot)->length;
    }
  }
}

/*--- function BuildHashTable ------------------------------------------
 *
 *  Build the hashtable from the NewGroupTable.
 */
void
BuildHashTable ()
{
  unsigned int hashval;
  char huge *textptr;
  int i;

  for (i = 0; i < nNewGroups; i++) {
	/* Plus fill in the hash table */
	textptr = (char huge *) NewGroupTable[i] + sizeof (TypLine)
	  + sizeof (TypGroup);
	hashval = HashGroup (textptr);
	while (NetHashTable[hashval]) {
	  hashval = (hashval + 1) % HashTableSize;
	}
	NetHashTable[hashval] = NewGroupTable[i];
  }

}


/*--- function ProcEndList -------------------------------------------
 *
 *  Do the final processing when we have reached the end of the
 *  list of newsgroups sent us via the LIST command.
 */

void
ProcEndList ()
{
  DLGPROC lpfnWinVnGroupListDlg;
  WORD LockCount;

  /* Well, we need a new and different hash table now, so close out the
     old one */
  LockCount = GMEM_LOCKCOUNT & GlobalFlags (hNetHashTable);
  MyGlobalUnlock (hNetHashTable);
  GlobalFree (hNetHashTable);

  InitHashTable (nNewGroups);
  BuildPtrList ();
  BuildHashTable ();

  ShellSort (NewGroupTable, nNewGroups, sizeof (void huge *), GroupCompare);

  lpfnWinVnGroupListDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnGroupListDlg, hInst);

  /* Display dialog box of new groups.  */
  if (nNewGroups && DialogBox (hInst, "WinVnGroupList", NetDoc.hDocWnd, lpfnWinVnGroupListDlg)) {
	/* The user has clicked OK, so add all the new groups to the
	 * Net document.  Subscribed groups go at the end of the Subscribed
	 * section at the top of the doc.
	 * Unsubscribed groups go in the section below, in alphabetical order.
	 */
	MergeGroups (ADD_SUBSCRIBED_END_OF_SUB);
	NetDoc.LongestLine = 0;
	SetGroupActiveLines ();
  }

  /* Unlock and/or free memory in NetDoc and NewGroupTable.  */

  CleanUpGroupTable ();

  /* Unlock and free the hash table.   */

  LockCount = GMEM_LOCKCOUNT & GlobalFlags (hNetHashTable);
  MyGlobalUnlock (hNetHashTable);
  GlobalFree (hNetHashTable);

  InvalidateRect (NetDoc.hDocWnd, NULL, FALSE);
  SetNetDocTitle ();
}

/*--- function GroupCompare --------------------------------------------
 *
 *  Compare two group lines alphabetically by group name.
 */
int
GroupCompare (TypLine const huge * huge * g1,
			  TypLine const huge * huge * g2)
{
  char huge *gch1, huge * gch2;

  gch1 = (char huge *) *g1 + sizeof (TypLine) + sizeof (TypGroup);
  gch2 = (char huge *) *g2 + sizeof (TypLine) + sizeof (TypGroup);

  return (lstrcmp (gch1, gch2));
}


/*-- function WinVnGroupListDlg ---------------------------------------
 *
 *  Dialog function to handle selection of new newsgroups to
 *  subscribe to.  (I know, don't end a sentence with "to".)
 */

BOOL FAR PASCAL
WinVnGroupListDlg (hDlg, iMessage, wParam, lParam)
	 HWND hDlg;
	 unsigned iMessage;
	 WPARAM wParam;
	 LPARAM lParam;
{
  int j;
  LRESULT nItem;
  char TmpBuf[80];
  char far *CurName;
  char huge *cptr;
  TypHier far *CurHier;
  static HANDLE hStartHier, hCurHier;
  unsigned int hashval;
  TypGroup huge *group;
  HWND hDlgHierList;			/* Handle to child hierarchy list box window. */
  HWND hDlgSubList;
  HWND hDlgUnSubList;
  HDC  hListboxDC;
  static int maxSubExt, maxUnsubExt;
#ifdef WIN32
  SIZE size;
  int ext; 
#else
  DWORD size;
  int ext; 
#endif  
  switch (iMessage) {

  case WM_INITDIALOG:
	/* First build the list of top-level hierarchies */
	CurHier = (TypHier *) NULL;
	hStartHier = hCurHier = (HANDLE) NULL;
	maxSubExt = maxUnsubExt = 0;
	for (j = 0; j < nNewGroups; j++) {
	  cptr = 0;
	  cptr = (NewGroupTable[j]);
	  cptr += sizeof (TypLine) + sizeof (TypGroup);
	  if ((CurHier == NULL) ||
		  (strnicmp (CurName, cptr, strcspn (cptr, "."))
		   != 0)) {
		HANDLE hTmpHandle;
		int NameLen;
		/* Need a new link */
		hTmpHandle = GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT,
								  sizeof (TypHier));
		if (CurHier) {
		  CurHier->hNext = hTmpHandle;
		  GlobalUnlock (CurHier->hName);
		  GlobalUnlock (hCurHier);
		  hCurHier = hTmpHandle;
		  CurHier = (TypHier far *) GlobalLock (hCurHier);
		}
		else {
		  hCurHier = hStartHier = hTmpHandle;
		  CurHier = (TypHier far *) GlobalLock (hCurHier);
		}
		/* And now for the actual hierarchy name */
		NameLen = strcspn (cptr, ".");
		CurHier->hName = GlobalAlloc (GMEM_MOVEABLE, NameLen + 1);
		CurName = GlobalLock (CurHier->hName);
		strntcpy (CurName, cptr, NameLen);
		/* And the start index */
		CurHier->Start = j;
	  }
	  /* Increment the number of groups _every_ time */
	  CurHier->NumGroups++;
	}
	GlobalUnlock (CurHier->hName);
	GlobalUnlock (hCurHier);

	/* Now, load the HIERARCY box */
	hDlgHierList = GetDlgItem (hDlg, IDD_HIERARCHY_LISTBOX);
	SendMessage (hDlgHierList, WM_SETREDRAW, FALSE, 0L);
	hCurHier = hStartHier;
	while (hCurHier) {
	  HANDLE hTmpHandle;
	  CurHier = (TypHier far *) GlobalLock (hCurHier);
	  CurName = GlobalLock (CurHier->hName);
	  SendMessage (hDlgHierList, LB_ADDSTRING, 0, (LPARAM) CurName);
	  hTmpHandle = CurHier->hNext;
	  GlobalUnlock (CurHier->hName);
	  GlobalUnlock (hCurHier);
	  hCurHier = hTmpHandle;
	}
	SendMessage (hDlgHierList, WM_SETREDRAW, TRUE, 0L);

	/* And select the 0th item to kick things off */
	SendMessage (hDlgHierList, LB_SETCURSEL, 0, 0);
#ifdef WIN32
	SendMessage (hDlg, WM_COMMAND, (WPARAM) MAKEWPARAM (IDD_HIERARCHY_LISTBOX,
		 LBN_SELCHANGE), (LPARAM) GetDlgItem (hDlg, IDD_HIERARCHY_LISTBOX));
#else
	SendMessage (hDlg, WM_COMMAND, IDD_HIERARCHY_LISTBOX,
			  (LPARAM) MAKELPARAM (GetDlgItem (hDlg, IDD_HIERARCHY_LISTBOX),
								   LBN_SELCHANGE));
#endif /* WIN32 */
	return TRUE;
	break;

  case WM_COMMAND:
	switch (LOWORD (wParam)) {
	case IDOK:
	  EndDialog (hDlg, TRUE);
	  break;
	case IDCANCEL:
	  EndDialog (hDlg, FALSE);
	  break;
	case IDD_SUBSCRIBED_GROUP_LISTBOX:
	  switch (GET_WM_COMMAND_CMD(wParam, lParam))
	  {
	  case LBN_DBLCLK:
		/* switch to unsubscribed */
		nItem = SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETCURSEL, 
					(WPARAM)0, (LPARAM)0);
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETTEXT, 
					(WPARAM)nItem, (LPARAM)TmpBuf);
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_DELETESTRING, 
					(WPARAM)nItem, (LPARAM)0);

		/* Now pull the stucture out of the hash table */
		hashval = HashGroup (TmpBuf);
		while (strcmp (
						(char huge *) NetHashTable[hashval] + sizeof (TypLine) + sizeof (TypGroup),
						TmpBuf) != 0) {
		  hashval = (hashval + 1) % HashTableSize;
		}
		group = (TypGroup huge *)
		  ((char huge *) NetHashTable[hashval] + sizeof (TypLine));
		group->Subscribed = 0;

		SendMessage (GetDlgItem (hDlg, IDD_UNSUBSCRIBED_GROUP_LISTBOX),
					 LB_ADDSTRING, 0, (LPARAM) TmpBuf);

		hListboxDC = GetDC(GetDlgItem (hDlg, IDD_UNSUBSCRIBED_GROUP_LISTBOX));
#ifdef WIN32
		GetTextExtentPoint32(hListboxDC, TmpBuf, strlen(TmpBuf), &size);
		ext = (int)size.cx;
#else
		size = GetTextExtent(hListboxDC, TmpBuf, strlen(TmpBuf));
		ext = (int)LOWORD(size);
#endif
		if (ext > maxUnsubExt) { 
			maxUnsubExt = ext;
			SendDlgItemMessage(hDlg, IDD_UNSUBSCRIBED_GROUP_LISTBOX, 
	            LB_SETHORIZONTALEXTENT,(WPARAM)maxUnsubExt,(LPARAM)0);
		}
		ReleaseDC(GetDlgItem (hDlg, IDD_UNSUBSCRIBED_GROUP_LISTBOX), hListboxDC);
		break;
	  default:
		return FALSE;

	  }
	  break;
	  case IDD_UNSUBSCRIBED_GROUP_LISTBOX:
	  switch (GET_WM_COMMAND_CMD(wParam, lParam))
	  {
	  case LBN_DBLCLK:
		/* switch to subscribed */
		nItem = SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETCURSEL, 
					(WPARAM)0, (LPARAM)0);
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETTEXT, 
					(WPARAM)nItem, (LPARAM)TmpBuf);
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_DELETESTRING, 
					(WPARAM)nItem, (LPARAM)0);
		/* Now pull the stucture out of the hash table */
		hashval = HashGroup (TmpBuf);
		while (strcmp ((char huge *) NetHashTable[hashval] +
					   sizeof (TypLine) + sizeof (TypGroup),
					   TmpBuf) != 0) {
		  hashval = (hashval + 1) % HashTableSize;
		}
		group = (TypGroup huge *)
		  ((char huge *) NetHashTable[hashval] + sizeof (TypLine));
		group->Subscribed = 1;

		SendMessage (GetDlgItem (hDlg, IDD_SUBSCRIBED_GROUP_LISTBOX),
					 LB_ADDSTRING, 0, (LPARAM) TmpBuf);
		hListboxDC = GetDC(GetDlgItem (hDlg, IDD_SUBSCRIBED_GROUP_LISTBOX));
#ifdef WIN32
		GetTextExtentPoint32(hListboxDC, TmpBuf, strlen(TmpBuf), &size);
		ext = (int)size.cx;
#else
		size = GetTextExtent(hListboxDC, TmpBuf, strlen(TmpBuf));
		ext = (int)LOWORD(size);
#endif
		if (ext > maxSubExt) { 
			maxSubExt = ext;
			SendDlgItemMessage(hDlg, IDD_SUBSCRIBED_GROUP_LISTBOX, 
	            LB_SETHORIZONTALEXTENT,(WPARAM)maxSubExt,(LPARAM)0);
		}
		ReleaseDC(GetDlgItem (hDlg, IDD_SUBSCRIBED_GROUP_LISTBOX), hListboxDC);
		break;
	  default:
		return FALSE;

	  }
	  break;
	  case IDD_HIERARCHY_LISTBOX:
	  switch (GET_WM_COMMAND_CMD(wParam, lParam))
	  {
	  case LBN_SELCHANGE:
		/* Find the info for this hierarchy */
		nItem = SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETCURSEL, 
					(WPARAM)0, (LPARAM)0);
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETTEXT, 
					(WPARAM)nItem, (LPARAM)TmpBuf);

		hCurHier = hStartHier;
		while (hCurHier) {
		  HANDLE hTmpHandle;
		  CurHier = (TypHier far *) GlobalLock (hCurHier);
		  CurName = GlobalLock (CurHier->hName);
		  GlobalUnlock (CurHier->hName);
		  if (stricmp (CurName, TmpBuf) == 0)
			break;
		  hTmpHandle = CurHier->hNext;
		  GlobalUnlock (hCurHier);
		  hCurHier = hTmpHandle;
		}
		/* clear the existing listboxes */
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), WM_SETREDRAW, FALSE, 0L);

		hDlgSubList = GetDlgItem (hDlg, IDD_SUBSCRIBED_GROUP_LISTBOX);
		hDlgUnSubList = GetDlgItem (hDlg, IDD_UNSUBSCRIBED_GROUP_LISTBOX);
		SendMessage (hDlgUnSubList, LB_RESETCONTENT, 0, 0);
		SendMessage (hDlgSubList, LB_RESETCONTENT, 0, 0);

		hListboxDC = GetDC(hDlgSubList);
		/* load the subscribed/unsubscribed boxes */
		for (j = CurHier->Start; j < (CurHier->Start + CurHier->NumGroups); j++) {
		  TypGroup huge *group;
		  group = (TypGroup huge *)
			((char huge *) NewGroupTable[j] + sizeof (TypLine));
		  cptr = (char huge *) group + sizeof (TypGroup);
#ifdef WIN32
		  GetTextExtentPoint32(hListboxDC, cptr, strlen(cptr), &size);
		  ext = (int)size.cx;
#else
		  size = GetTextExtent(hListboxDC, cptr, strlen(cptr));
		  ext = (int)LOWORD(size);
#endif

		  if (group->Subscribed) {
			SendMessage (hDlgSubList, LB_ADDSTRING, 0, (LPARAM)cptr);
			if (ext > maxSubExt) { 
				maxSubExt = ext;
			}
		  } else {
			SendMessage (hDlgUnSubList, LB_ADDSTRING, 0, (LPARAM)cptr);
			if (ext > maxUnsubExt) { 
				maxUnsubExt = ext;
			}
		  }			
		}
		ReleaseDC(hDlgSubList, hListboxDC);
		
		SendMessage(hDlgUnSubList,
		            LB_SETHORIZONTALEXTENT,(WPARAM)maxUnsubExt,(LPARAM)0);
		SendMessage(hDlgSubList,
		            LB_SETHORIZONTALEXTENT,(WPARAM)maxSubExt,(LPARAM)0);
	
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), WM_SETREDRAW, TRUE, 0L);

		GlobalUnlock (hCurHier);
		break;
	  default:
		return FALSE;
	  }
	  break;
	  default:
	  return FALSE;
	}
	break;

  case WM_DESTROY:
	/* Ok, now we tear down the hierarchy structure */
	hCurHier = hStartHier;
	while (hCurHier) {
	  HANDLE hTmpHandle;
	  CurHier = (TypHier far *) GlobalLock (hCurHier);
	  GlobalFree (CurHier->hName);
	  hTmpHandle = CurHier->hNext;
	  GlobalUnlock (hCurHier);
	  GlobalFree (hCurHier);
	  hCurHier = hTmpHandle;
	}
	break;

  default:
	return FALSE;
	break;
  }
  return TRUE;
}

/*--- function PositionEndSubscribed ----------------------------------
 *
 *  Position a pointer to the end of the subscribed section at the
 *  beginning of the net document.
 *
 *  Entry   None
 *
 *  Exit    BlockPtr and LinePtr  point to the place in NetDoc just
 *            beyond the last subscribed group.  We assume that
 *            all subscribed groups go at the beginning of the
 *            document.
 */
void
PositionEndSubscribed (TypBlock far ** BlockPtr, TypLine far ** LinePtr)
{
  BOOL advance;
  TypGroup far *group;

  TopOfDoc (&NetDoc, BlockPtr, LinePtr);
  advance = TRUE;
  do {
	group = (TypGroup far *) ((char far *) *LinePtr + sizeof (TypLine));
	if (group->Subscribed) {
	  advance = NextLine (BlockPtr, LinePtr);
	}
	else {
	  advance = FALSE;
	}
  }
  while (advance);
}

/*--- function MergeGroups ----------------------------------------
 *
 *  Merge a list of groups into NetDoc.
 *
 *  Entry:  NewGroupTable  is an array of pointers to TypGroup structures
 *                         of groups to be merged into NetDoc.
 *          hNewGroupTable is the handle to the above.
 *          nNewGroups     is the number of groups in the table.
 *          WhereSubscribed   indicates where new subscribed groups
 *                         should be added.
 *                         ADD_SUBSCRIBED_END_OF_SUB indicates that
 *                           they should be added at the end of the subscribed
 *                           list, before the unsubscribed groups.
 *                         ADD_SUBSCRIBED_TOP_OF_DOC indicates that they
 *                           should be added at the top of the document.
 *  Exit:   The groups in the table have been added to NetDoc, and
 *            the entries in GroupTable have been freed from memory.
 *            Also, GroupTable itself has been freed.
 */
void
MergeGroups (int WhereSubscribed)
{
  TypBlock far *BlockPtr;
  TypLine far *LinePtr;
  TypGroup far *group;
  char far *netcptr;
  char far *grpcptr;
  void far *AllocPtr;
  HANDLE hLine;
  unsigned int Offset;
  TypLineID MyLineID;
  char myline[BLOCK_SIZE];
  int j, advance, at_end = 0;

  switch (WhereSubscribed) {
  case ADD_SUBSCRIBED_END_OF_SUB:
	PositionEndSubscribed (&BlockPtr, &LinePtr);
	break;
  case ADD_SUBSCRIBED_TOP_OF_DOC:
	TopOfDoc (&NetDoc, &BlockPtr, &LinePtr);
	break;
  }

  /* BlockPtr and LinePtr point to the
   * place to add new subscribed groups.
   * Loop through the new groups; for subscribed groups, add
   * them to NetDoc at this point.
   * For each subscribed group, unlock and free the corresponding
   * line pointed to by NewGroupTable.  Set the table entry
   * to 0 to indicate that this group has been dealt with.
   */

  for (j = 0; j < nNewGroups; j++) {
	AllocPtr = (char far *) NewGroupTable[j];
	group = (TypGroup far *) ((char far *) AllocPtr + sizeof (TypLine));
	if (group->Subscribed) {
	  /* This group has been selected and should be subscribed to.
	   */
	  MoveBytes (AllocPtr, myline, ((TypLine far *) AllocPtr)->length);
	  LinePtr->active = TRUE;
	  AddLine ((TypLine *) myline, &BlockPtr, &LinePtr);
	  NetDoc.ActiveLines++;
	  NewGroupTable[j] = (void far *) 0;
	}
  }

  PositionEndSubscribed (&BlockPtr, &LinePtr);

  /* Now take a second pass through NewGroupTable, for the
   * unsubscribed groups.  If NewGroupTable[j] is non-zero, then
   * that group should be entered into the second, unsubscribed
   * section of NetDoc, merged in in alphabetical order.
   *
   * BlockPtr and LinePtr point to the first unsubscribed group.
   */

  for (j = 0; j < nNewGroups; j++) {
	if (NewGroupTable[j]) {
	  /* Search for the right place to add this line. */

	  AllocPtr = (char far *) NewGroupTable[j];
	  grpcptr = ((char far *) AllocPtr) + sizeof (TypLine) + sizeof (TypGroup);
	  advance = TRUE;

	  if (!at_end) {
		do {
		  netcptr = ((char far *) LinePtr) + sizeof (TypLine) + sizeof (TypGroup);
		  if (lstrcmp (grpcptr, netcptr) < 0) {
			advance = FALSE;
		  }
		  else {
			advance = NextLine (&BlockPtr, &LinePtr);
			if (!advance)
			  at_end = 1;		/* possible bug, getting bad netcptr (smr) */
		  }
		}
		while (advance);
	  }

	  /* Now add the new group at this point */
	  MoveBytes (AllocPtr, myline, ((TypLine far *) AllocPtr)->length);
	  LinePtr->active = ShowUnsubscribed;
	  AddLine ((TypLine *) myline, &BlockPtr, &LinePtr);

	}
  }

  UnlockLine (BlockPtr, LinePtr, &hLine, &Offset, &MyLineID);
}

/*--- function CleanUpGroupTable ------------------------------------
 *
 *  Clean up after doing processing to add or move groups in NetDoc.
 */
void
CleanUpGroupTable ()
{
  HANDLE hBlock, hBlockNext;
  TypBlock far *BlockPtr;

  /* Unlock all blocks in the NetDoc document.
   */

  hBlock = NetDoc.hFirstBlock;
  do {
	BlockPtr = (TypBlock far *) GlobalLock (hBlock);
	hBlockNext = BlockPtr->hNextBlock;

	MyGlobalUnlock (hBlock);
	MyGlobalUnlock (hBlock);
	hBlock = hBlockNext;
  }
  while (hBlock);

  /* Unlock and free the NewGroupTable and NewGroupData.  */

  GlobalUnlock (hNewGroupData);
  GlobalFree (hNewGroupData);
  MyGlobalUnlock (hNewGroupTable);
  GlobalFree (hNewGroupTable);

}

/*--- function FindNextPrime ------------------------------------
 *
 *  Find the smallest prime that is larger than the given argument.
 *  Extreemly handy for those annoying dynamic hash tables.
 */
unsigned long
FindNextPrime (unsigned long OrigVal)
{

  int MaxPrimeIndex = (sizeof (prime) / sizeof (prime[0])) - 1;
  int IndexA = 0;
  int IndexB = MaxPrimeIndex;
  int TmpIndex;

  /* If we're larger than the max prime we know of, just return it */
  if (OrigVal >= prime[MaxPrimeIndex])
	return (prime[MaxPrimeIndex]);

  /* We do this by doing a binary search of the prime array */
  do {
	TmpIndex = IndexA + ((IndexB - IndexA) / 2);
	if (OrigVal == prime[TmpIndex])
	  return (prime[TmpIndex + 1]);
	if (OrigVal < prime[TmpIndex])
	  IndexB = TmpIndex;
	else
	  IndexA = TmpIndex;
  } while ((IndexB - IndexA) > 1);

  return (prime[IndexA + 1]);
}
@


1.26
log
@Changed argument for HashGroup back to huge, Just In Case.
@
text
@d1 984
a984 966
/*
 * $Id: wvlist.c 1.25 1995/02/07 22:43:03 jglasser Exp $
 */

/*-- WVLIST.C -- File containing functions to deal with the NNTP LIST
 *   command, which lists all the newsgroups and their status.
 *
 *   Mark Riordan   25 October 1990
 */

#include <windows.h>
#include <windowsx.h>
#include "wvglob.h"
#include "winvn.h"
#pragma hdrstop
#include "dos.h"
#include "primes.h"

#include <ctype.h>


/* The size of the chunks of memory that make up the new group list data */
#define CHUNKSIZE       64L*1024L

TypLine huge * huge * NetHashTable;
HANDLE hNetHashTable;

HANDLE htohNewGroupLines;
HANDLE far *lphNewGroupLines;	/* array of handles to new group lines */

DWORD NewGroupDataSize;			/* The size (in bytes) of NewGroupData */
void huge *CurrentSpot;			/* The pointer to the next available spot in NewGroupData */
unsigned long BytesSoFar;

#define MyGlobalUnlock(hWhat)  MRRGlobalUnlock(hWhat,__LINE__)

void MRRGlobalUnlock (HANDLE hWhat, WORD wLine);

void
MRRGlobalUnlock (hWhat, wLine)
	 HANDLE hWhat;
	 WORD wLine;
{
  WORD LockCount;

  if (!(LockCount = (GMEM_LOCKCOUNT & GlobalFlags (hWhat)))) {
  }
  else {
	GlobalUnlock (hWhat);
  }

}


/*--- function StartList -----------------------------------------------
 *
 *  Initiate the process of sending a LIST command and using its
 *  output to update our list of news groups.
 */

void
StartList ()
{


  CommState = ST_LIST_RESP;
  CommBusy = TRUE;
  PutCommLine ("LIST");
  Initializing = INIT_SCANNING_NETDOC;
  InvalidateRect (NetDoc.hDocWnd, NULL, FALSE);
  SendMessage (NetDoc.hWndFrame, WM_PAINT, 0, 0L);

  /* Set up table of pointers to new group lines. */
  InitGroupTable ();

  /* Initialize the hash table */
  InitHashTable (LinesInRC);

  /* And set up the hash table for stuff from the newsrc */
  HashNetGroups (&NetDoc, NetHashTable);
  InvalidateRect (NetDoc.hDocWnd, NULL, FALSE);
  Initializing = INIT_GETTING_LIST;
  SendMessage (NetDoc.hWndFrame, WM_PAINT, 0, 0L);
}

/*--- function InitHashTable -------------------------------------------
 *
 *  Allocate and zero the NetHashTable. The argument is the number of
 *  elements to be hashed (NOT the number of elements in the hash table)
 *
 *  Exit:   hNetHashTable     is the handle
 *          NetHashTable      points to the table
 *                      HashTableSize     The number of elements in the hash table
 */
void
InitHashTable (unsigned int Elements)
{

  /* First, figure out how large the hashtable should be.
   * The basic algorithm used here is to double the size of what you're
   * hashing, rounded up to the next nearest prime number
   */
  HashTableSize = (unsigned int) FindNextPrime ((unsigned long) Elements * 2L);

  /* Set up hash table for group names */
  hNetHashTable = GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT,
							   (unsigned long) HashTableSize *
							   sizeof (TypLine far *));
  NetHashTable = (TypLine huge * huge *) GlobalLock (hNetHashTable);

}


/*--- function InitGroupTable -------------------------------------------
 *
 *  Allocate the first CHUNKSIZE bytes of memory for the
 * new group lines.
 *
 *  Exit:   hNewGroupData    is the handle
 *          NewGroupData     points to the table
 *          nNewGroups        has been initialized to 0.
 *                      NewGroupDataSize  is the current size of the NewGroupData
 */
void
InitGroupTable (void)
{
  /* Allocate the first chunk */
  NewGroupDataSize = CHUNKSIZE;
  hNewGroupData = GlobalAlloc (GMEM_MOVEABLE, NewGroupDataSize);
  NewGroupData = (void far *) GlobalLock (hNewGroupData);
  CurrentSpot = NewGroupData;
  BytesSoFar = 0;

  nNewGroups = 0;
}


/*--- function HashNetGroups ------------------------------------------
 *
 *  Enter all the groups in the Net document into the hash table.
 *
 *  Exit    All blocks in the document are locked.
 *          HashTable   is (partially) filled with pointers to
 *                      each of the lines in "Doc".
 */

void
HashNetGroups (Doc, HashTable)
	 TypDoc *Doc;
	 TypLine huge * huge * HashTable;
{
  TypBlock far *BlockPtr;
  TypLine far *LinePtr;
  unsigned int hashval;
  HANDLE hBlock;
  unsigned int Offset;
  unsigned int TextOffset;
  unsigned char far *textptr;
  TypLineID MyLineID;

  /* Lock all blocks in the document */
  hBlock = Doc->hFirstBlock;
  do {
	BlockPtr = (TypBlock far *) GlobalLock (hBlock);
	hBlock = BlockPtr->hNextBlock;
  }
  while (hBlock);



  /* Now start at the beginning of the document, going through
   * each line in the document, hashing its group name into the table.
   */

  hBlock = Doc->hFirstBlock;
  Offset = sizeof (TypBlock);
  MyLineID = 0L;

  LockLine (hBlock, Offset, MyLineID, &BlockPtr, &LinePtr);

  TextOffset = Doc->OffsetToText;

  if (LinePtr->length != END_OF_BLOCK) {
	do {
	  textptr = ((unsigned char far *) LinePtr) + TextOffset;
	  hashval = HashGroup (textptr);
	  while (HashTable[hashval]) {
		hashval = (hashval + 1) % HashTableSize;
	  }
	  HashTable[hashval] = LinePtr;
	}
	while (NextLine (&BlockPtr, &LinePtr));
  }
  UnlockLine (BlockPtr, LinePtr, &hBlock, &Offset, &MyLineID);
}


/*--- function ProcListLine ---------------------------------------------
 *
 *  Process a line received from the NNTP LIST command output.
 *  Each line from the LIST command has the form:
 *   <groupname> <highest_art_#> <lowest_art_#> {y|n|m}
 */

void
ProcListLine (ListLine)
	 unsigned char *ListLine;
{
  unsigned int hashval;
  char far *textptr;
  unsigned char *cptr, *restline;
  char mygroupline[BLOCK_SIZE];
  TypGroup *mygroup;
  TypGroup far *netgroup;
  long int ArtNum;
  int PercentDone;

  if ((++RcvLineCount) % UPDATE_TITLE_FREQ == 0) {
	InvalidateRect (NetDoc.hDocWnd, NULL, FALSE);
	if (NetDoc.TotalLines > 0) {
	  PercentDone = MulDiv (RcvLineCount, 100, NetDoc.TotalLines);
	  if (PercentDone <= 100)
		SetStatbarPercent (NetDoc.hWndFrame, PercentDone, &NetDoc, TRUE);
	}
	if (RcvLineCount % (UPDATE_TITLE_FREQ * 25) == 0) {
	  UpdateWindow (NetDoc.hDocWnd);
	}
  }

  /* Replace the first blank in the input line with a zero. */
  for (cptr = ListLine; *cptr && *cptr != ' '; cptr++);
  *cptr = '\0';
  restline = cptr + 1;			/* points to highest art # */

  hashval = HashGroup (ListLine);
checkhash:;
  if (!NetHashTable[hashval]) {
	/* This is a new group.
	 * Create a Group line from the information in this line.
	 */

	CrackGroupLine (ListLine, (TypLine *) (mygroupline));
	mygroup = (TypGroup *) (mygroupline + sizeof (TypLine));
	GetNum (&restline, &(mygroup->ServerLast));
	GetNum (&restline, &(mygroup->ServerFirst));
	mygroup->ServerEstNum = mygroup->ServerLast - mygroup->ServerFirst + 1;
	mygroup->HighestPrevSeen = 0;
	mygroup->nRanges = 0;
	mygroup->Determined = TRUE;
	mygroup->NumUnread = 0L;
	AddGroupToTable (mygroupline);
  }
  else {
	textptr = ((char far *) NetHashTable[hashval] + sizeof (TypLine) + sizeof (TypGroup));
	if (lstrcmp (textptr, ListLine)) {
	  hashval = (hashval + 1) % HashTableSize;
	  goto checkhash;
	}
	else {
	  /* This group is already present in NetDoc.
	     * Update the ServerFirst and ServerLast fields.
	   */
	  netgroup = (TypGroup far *) ((char far *) NetHashTable[hashval] + sizeof (TypLine));
	  GetNum (&restline, &ArtNum);
	  netgroup->ServerLast = ArtNum;
	  GetNum (&restline, &ArtNum);
	  netgroup->ServerFirst = ArtNum;
	  netgroup->ServerEstNum = (netgroup->ServerLast - netgroup->ServerFirst + 1);
	  netgroup->Determined = TRUE;
	  netgroup->NumUnread = CalcNumUnread(netgroup);
	}
  }
}

/*--- function AddGroupToTable ----------------------------------------
 *
 *  Add a group line, formatted for eventual inclusion in NetDoc,
 *  to NewGroupTable.
 *
 *  Entry:  GroupLine      is the line to add to the table.
 *
 *  Exit:   NewGroupTable  contains the line
 *          nNewGroups     has been incremented.
 */
void
AddGroupToTable (char far * GroupLine)
{
  char huge *NextPtr;
  char huge *EndPtr;

  NextPtr = (char huge *) CurrentSpot + ((TypLine far *) GroupLine)->length;
  EndPtr = (char huge *) NewGroupData + NewGroupDataSize;

  /* Check to see if the current data will put us over the edge */
  if (NextPtr > EndPtr) {
	GlobalUnlock (hNewGroupData);
	NewGroupDataSize += CHUNKSIZE;
	hNewGroupData = GlobalReAlloc (hNewGroupData, NewGroupDataSize,
								   GMEM_MOVEABLE);
	NewGroupData = GlobalLock (hNewGroupData);
	CurrentSpot = (char huge *) NewGroupData + BytesSoFar;
	NextPtr = (char huge *) CurrentSpot + ((TypLine far *) GroupLine)->length;
  }

  /* Create a copy of this line in far memory
   */
  MoveBytes ((char far *) GroupLine, CurrentSpot,
			 ((TypLine far *) GroupLine)->length);
  nNewGroups++;

  BytesSoFar += ((TypLine huge *) CurrentSpot)->length;
  (char huge *) CurrentSpot = NextPtr;

}

/*--- function HashGroup -------------------------------------------------
 *
 *  Hash a string into an unsigned integer.
 *
 *  This hash function is designed based on information from a
 *  handout for a UC Berkeley class CS 60C, Spring 1990, Clancy/
 *  Harrison.  I picked up the handout while wandering around on
 *  Berkeley's campus in May 1990.  The handout in turn is based
 *  on the McKenzie, et al., article "Selecting a Hashing Algorithm"
 *  in Software Practice and Experience, Vol 20, no 2, Feb 1990.
 *  The algorithm is similar to that used in the AT&T C++ compiler.
 *  /mrr
 */

unsigned int
HashGroup (unsigned char huge * gname)
{
  long unsigned int sum = 0;
  unsigned int hash;

  for (; *gname; gname++) {
	sum = (sum << 1) + *gname;
  }
  hash = (unsigned int) (sum % HashTableSize);
  return (hash);
}

/*--- function BuildPtrList ------------------------------------------
 *
 *  Build both the array of pointers into the new group data, as well
 *  as build the hashtable.
 */
void
BuildPtrList ()
{
  int i;

  /* Build the pointer array after the fact */
  hNewGroupTable = GlobalAlloc (GMEM_MOVEABLE, (long) nNewGroups * sizeof (TypLine huge *));
  NewGroupTable = (void huge * huge *) GlobalLock (hNewGroupTable);
  CurrentSpot = NewGroupData;

  for (i = 0; i < nNewGroups; i++) {
	NewGroupTable[i] = CurrentSpot;
	(char huge *) CurrentSpot += ((TypLine huge *) CurrentSpot)->length;
  }
}

/*--- function BuildHashTable ------------------------------------------
 *
 *  Build the hashtable from the NewGroupTable.
 */
void
BuildHashTable ()
{
  unsigned int hashval;
  char huge *textptr;
  int i;

  for (i = 0; i < nNewGroups; i++) {
	/* Plus fill in the hash table */
	textptr = (char huge *) NewGroupTable[i] + sizeof (TypLine)
	  + sizeof (TypGroup);
	hashval = HashGroup (textptr);
	while (NetHashTable[hashval]) {
	  hashval = (hashval + 1) % HashTableSize;
	}
	NetHashTable[hashval] = NewGroupTable[i];
  }

}


/*--- function ProcEndList -------------------------------------------
 *
 *  Do the final processing when we have reached the end of the
 *  list of newsgroups sent us via the LIST command.
 */

void
ProcEndList ()
{
  DLGPROC lpfnWinVnGroupListDlg;
  WORD LockCount;

  /* Well, we need a new and different hash table now, so close out the
     old one */
  LockCount = GMEM_LOCKCOUNT & GlobalFlags (hNetHashTable);
  MyGlobalUnlock (hNetHashTable);
  GlobalFree (hNetHashTable);

  InitHashTable (nNewGroups);
  BuildPtrList ();
  BuildHashTable ();

  ShellSort (NewGroupTable, nNewGroups, sizeof (void huge *), GroupCompare);

  lpfnWinVnGroupListDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnGroupListDlg, hInst);

  /* Display dialog box of new groups.  */
  if (nNewGroups && DialogBox (hInst, "WinVnGroupList", NetDoc.hDocWnd, lpfnWinVnGroupListDlg)) {
	/* The user has clicked OK, so add all the new groups to the
	 * Net document.  Subscribed groups go at the end of the Subscribed
	 * section at the top of the doc.
	 * Unsubscribed groups go in the section below, in alphabetical order.
	 */
	MergeGroups (ADD_SUBSCRIBED_END_OF_SUB);
	NetDoc.LongestLine = 0;
	SetGroupActiveLines ();
  }

  /* Unlock and/or free memory in NetDoc and NewGroupTable.  */

  CleanUpGroupTable ();

  /* Unlock and free the hash table.   */

  LockCount = GMEM_LOCKCOUNT & GlobalFlags (hNetHashTable);
  MyGlobalUnlock (hNetHashTable);
  GlobalFree (hNetHashTable);

  InvalidateRect (NetDoc.hDocWnd, NULL, FALSE);
  SetNetDocTitle ();
}

/*--- function GroupCompare --------------------------------------------
 *
 *  Compare two group lines alphabetically by group name.
 */
int
GroupCompare (TypLine const huge * huge * g1,
			  TypLine const huge * huge * g2)
{
  char huge *gch1, huge * gch2;

  gch1 = (char huge *) *g1 + sizeof (TypLine) + sizeof (TypGroup);
  gch2 = (char huge *) *g2 + sizeof (TypLine) + sizeof (TypGroup);

  return (lstrcmp (gch1, gch2));
}


/*-- function WinVnGroupListDlg ---------------------------------------
 *
 *  Dialog function to handle selection of new newsgroups to
 *  subscribe to.  (I know, don't end a sentence with "to".)
 */

BOOL FAR PASCAL
WinVnGroupListDlg (hDlg, iMessage, wParam, lParam)
	 HWND hDlg;
	 unsigned iMessage;
	 WPARAM wParam;
	 LPARAM lParam;
{
  int j;
  LRESULT nItem;
  char TmpBuf[80];
  char far *CurName;
  char huge *cptr;
  TypHier far *CurHier;
  static HANDLE hStartHier, hCurHier;
  unsigned int hashval;
  TypGroup huge *group;
  HWND hDlgHierList;			/* Handle to child hierarchy list box window. */
  HWND hDlgSubList;
  HWND hDlgUnSubList;
  HDC  hListboxDC;
  static int maxSubExt, maxUnsubExt;
#ifdef WIN32
  SIZE size;
  int ext; 
#else
  DWORD size;
  int ext; 
#endif  
  switch (iMessage) {

  case WM_INITDIALOG:
	/* First build the list of top-level hierarchies */
	CurHier = (TypHier *) NULL;
	hStartHier = hCurHier = (HANDLE) NULL;
	maxSubExt = maxUnsubExt = 0;
	for (j = 0; j < nNewGroups; j++) {
	  cptr = 0;
	  cptr = (NewGroupTable[j]);
	  cptr += sizeof (TypLine) + sizeof (TypGroup);
	  if ((CurHier == NULL) ||
		  (strnicmp (CurName, cptr, strcspn (cptr, "."))
		   != 0)) {
		HANDLE hTmpHandle;
		int NameLen;
		/* Need a new link */
		hTmpHandle = GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT,
								  sizeof (TypHier));
		if (CurHier) {
		  CurHier->hNext = hTmpHandle;
		  GlobalUnlock (CurHier->hName);
		  GlobalUnlock (hCurHier);
		  hCurHier = hTmpHandle;
		  CurHier = (TypHier far *) GlobalLock (hCurHier);
		}
		else {
		  hCurHier = hStartHier = hTmpHandle;
		  CurHier = (TypHier far *) GlobalLock (hCurHier);
		}
		/* And now for the actual hierarchy name */
		NameLen = strcspn (cptr, ".");
		CurHier->hName = GlobalAlloc (GMEM_MOVEABLE, NameLen + 1);
		CurName = GlobalLock (CurHier->hName);
		strntcpy (CurName, cptr, NameLen);
		/* And the start index */
		CurHier->Start = j;
	  }
	  /* Increment the number of groups _every_ time */
	  CurHier->NumGroups++;
	}
	GlobalUnlock (CurHier->hName);
	GlobalUnlock (hCurHier);

	/* Now, load the HIERARCY box */
	hDlgHierList = GetDlgItem (hDlg, IDD_HIERARCHY_LISTBOX);
	SendMessage (hDlgHierList, WM_SETREDRAW, FALSE, 0L);
	hCurHier = hStartHier;
	while (hCurHier) {
	  HANDLE hTmpHandle;
	  CurHier = (TypHier far *) GlobalLock (hCurHier);
	  CurName = GlobalLock (CurHier->hName);
	  SendMessage (hDlgHierList, LB_ADDSTRING, 0, (LPARAM) CurName);
	  hTmpHandle = CurHier->hNext;
	  GlobalUnlock (CurHier->hName);
	  GlobalUnlock (hCurHier);
	  hCurHier = hTmpHandle;
	}
	SendMessage (hDlgHierList, WM_SETREDRAW, TRUE, 0L);

	/* And select the 0th item to kick things off */
	SendMessage (hDlgHierList, LB_SETCURSEL, 0, 0);
#ifdef WIN32
	SendMessage (hDlg, WM_COMMAND, (WPARAM) MAKEWPARAM (IDD_HIERARCHY_LISTBOX,
		 LBN_SELCHANGE), (LPARAM) GetDlgItem (hDlg, IDD_HIERARCHY_LISTBOX));
#else
	SendMessage (hDlg, WM_COMMAND, IDD_HIERARCHY_LISTBOX,
			  (LPARAM) MAKELPARAM (GetDlgItem (hDlg, IDD_HIERARCHY_LISTBOX),
								   LBN_SELCHANGE));
#endif /* WIN32 */
	return TRUE;
	break;

  case WM_COMMAND:
	switch (LOWORD (wParam)) {
	case IDOK:
	  EndDialog (hDlg, TRUE);
	  break;
	case IDCANCEL:
	  EndDialog (hDlg, FALSE);
	  break;
	case IDD_SUBSCRIBED_GROUP_LISTBOX:
	  switch (GET_WM_COMMAND_CMD(wParam, lParam))
	  {
	  case LBN_DBLCLK:
		/* switch to unsubscribed */
		nItem = SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETCURSEL, 
					(WPARAM)0, (LPARAM)0);
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETTEXT, 
					(WPARAM)nItem, (LPARAM)TmpBuf);
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_DELETESTRING, 
					(WPARAM)nItem, (LPARAM)0);

		/* Now pull the stucture out of the hash table */
		hashval = HashGroup (TmpBuf);
		while (strcmp (
						(char huge *) NetHashTable[hashval] + sizeof (TypLine) + sizeof (TypGroup),
						TmpBuf) != 0) {
		  hashval = (hashval + 1) % HashTableSize;
		}
		group = (TypGroup huge *)
		  ((char huge *) NetHashTable[hashval] + sizeof (TypLine));
		group->Subscribed = 0;

		SendMessage (GetDlgItem (hDlg, IDD_UNSUBSCRIBED_GROUP_LISTBOX),
					 LB_ADDSTRING, 0, (LPARAM) TmpBuf);

		hListboxDC = GetDC(GetDlgItem (hDlg, IDD_UNSUBSCRIBED_GROUP_LISTBOX));
#ifdef WIN32
		GetTextExtentPoint32(hListboxDC, TmpBuf, strlen(TmpBuf), &size);
		ext = (int)size.cx;
#else
		size = GetTextExtent(hListboxDC, TmpBuf, strlen(TmpBuf));
		ext = (int)LOWORD(size);
#endif
		if (ext > maxUnsubExt) { 
			maxUnsubExt = ext;
			SendDlgItemMessage(hDlg, IDD_UNSUBSCRIBED_GROUP_LISTBOX, 
	            LB_SETHORIZONTALEXTENT,(WPARAM)maxUnsubExt,(LPARAM)0);
		}
		ReleaseDC(GetDlgItem (hDlg, IDD_UNSUBSCRIBED_GROUP_LISTBOX), hListboxDC);
		break;
	  default:
		return FALSE;

	  }
	  break;
	  case IDD_UNSUBSCRIBED_GROUP_LISTBOX:
	  switch (GET_WM_COMMAND_CMD(wParam, lParam))
	  {
	  case LBN_DBLCLK:
		/* switch to subscribed */
		nItem = SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETCURSEL, 
					(WPARAM)0, (LPARAM)0);
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETTEXT, 
					(WPARAM)nItem, (LPARAM)TmpBuf);
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_DELETESTRING, 
					(WPARAM)nItem, (LPARAM)0);
		/* Now pull the stucture out of the hash table */
		hashval = HashGroup (TmpBuf);
		while (strcmp ((char huge *) NetHashTable[hashval] +
					   sizeof (TypLine) + sizeof (TypGroup),
					   TmpBuf) != 0) {
		  hashval = (hashval + 1) % HashTableSize;
		}
		group = (TypGroup huge *)
		  ((char huge *) NetHashTable[hashval] + sizeof (TypLine));
		group->Subscribed = 1;

		SendMessage (GetDlgItem (hDlg, IDD_SUBSCRIBED_GROUP_LISTBOX),
					 LB_ADDSTRING, 0, (LPARAM) TmpBuf);
		hListboxDC = GetDC(GetDlgItem (hDlg, IDD_SUBSCRIBED_GROUP_LISTBOX));
#ifdef WIN32
		GetTextExtentPoint32(hListboxDC, TmpBuf, strlen(TmpBuf), &size);
		ext = (int)size.cx;
#else
		size = GetTextExtent(hListboxDC, TmpBuf, strlen(TmpBuf));
		ext = (int)LOWORD(size);
#endif
		if (ext > maxSubExt) { 
			maxSubExt = ext;
			SendDlgItemMessage(hDlg, IDD_SUBSCRIBED_GROUP_LISTBOX, 
	            LB_SETHORIZONTALEXTENT,(WPARAM)maxSubExt,(LPARAM)0);
		}
		ReleaseDC(GetDlgItem (hDlg, IDD_SUBSCRIBED_GROUP_LISTBOX), hListboxDC);
		break;
	  default:
		return FALSE;

	  }
	  break;
	  case IDD_HIERARCHY_LISTBOX:
	  switch (GET_WM_COMMAND_CMD(wParam, lParam))
	  {
	  case LBN_SELCHANGE:
		/* Find the info for this hierarchy */
		nItem = SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETCURSEL, 
					(WPARAM)0, (LPARAM)0);
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), LB_GETTEXT, 
					(WPARAM)nItem, (LPARAM)TmpBuf);

		hCurHier = hStartHier;
		while (hCurHier) {
		  HANDLE hTmpHandle;
		  CurHier = (TypHier far *) GlobalLock (hCurHier);
		  CurName = GlobalLock (CurHier->hName);
		  GlobalUnlock (CurHier->hName);
		  if (stricmp (CurName, TmpBuf) == 0)
			break;
		  hTmpHandle = CurHier->hNext;
		  GlobalUnlock (hCurHier);
		  hCurHier = hTmpHandle;
		}
		/* clear the existing listboxes */
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), WM_SETREDRAW, FALSE, 0L);

		hDlgSubList = GetDlgItem (hDlg, IDD_SUBSCRIBED_GROUP_LISTBOX);
		hDlgUnSubList = GetDlgItem (hDlg, IDD_UNSUBSCRIBED_GROUP_LISTBOX);
		SendMessage (hDlgUnSubList, LB_RESETCONTENT, 0, 0);
		SendMessage (hDlgSubList, LB_RESETCONTENT, 0, 0);

		hListboxDC = GetDC(hDlgSubList);
		/* load the subscribed/unsubscribed boxes */
		for (j = CurHier->Start; j < (CurHier->Start + CurHier->NumGroups); j++) {
		  TypGroup huge *group;
		  group = (TypGroup huge *)
			((char huge *) NewGroupTable[j] + sizeof (TypLine));
		  cptr = (char huge *) group + sizeof (TypGroup);
#ifdef WIN32
		  GetTextExtentPoint32(hListboxDC, cptr, strlen(cptr), &size);
		  ext = (int)size.cx;
#else
		  size = GetTextExtent(hListboxDC, cptr, strlen(cptr));
		  ext = (int)LOWORD(size);
#endif

		  if (group->Subscribed) {
			SendMessage (hDlgSubList, LB_ADDSTRING, 0, (LPARAM)cptr);
			if (ext > maxSubExt) { 
				maxSubExt = ext;
			}
		  } else {
			SendMessage (hDlgUnSubList, LB_ADDSTRING, 0, (LPARAM)cptr);
			if (ext > maxUnsubExt) { 
				maxUnsubExt = ext;
			}
		  }			
		}
		ReleaseDC(hDlgSubList, hListboxDC);
		
		SendMessage(hDlgUnSubList,
		            LB_SETHORIZONTALEXTENT,(WPARAM)maxUnsubExt,(LPARAM)0);
		SendMessage(hDlgSubList,
		            LB_SETHORIZONTALEXTENT,(WPARAM)maxSubExt,(LPARAM)0);
	
		SendMessage (GET_WM_COMMAND_HWND(wParam, lParam), WM_SETREDRAW, TRUE, 0L);

		GlobalUnlock (hCurHier);
		break;
	  default:
		return FALSE;
	  }
	  break;
	  default:
	  return FALSE;
	}
	break;

  case WM_DESTROY:
	/* Ok, now we tear down the hierarchy structure */
	hCurHier = hStartHier;
	while (hCurHier) {
	  HANDLE hTmpHandle;
	  CurHier = (TypHier far *) GlobalLock (hCurHier);
	  GlobalFree (CurHier->hName);
	  hTmpHandle = CurHier->hNext;
	  GlobalUnlock (hCurHier);
	  GlobalFree (hCurHier);
	  hCurHier = hTmpHandle;
	}
	break;

  default:
	return FALSE;
	break;
  }
  return TRUE;
}

/*--- function PositionEndSubscribed ----------------------------------
 *
 *  Position a pointer to the end of the subscribed section at the
 *  beginning of the net document.
 *
 *  Entry   None
 *
 *  Exit    BlockPtr and LinePtr  point to the place in NetDoc just
 *            beyond the last subscribed group.  We assume that
 *            all subscribed groups go at the beginning of the
 *            document.
 */
void
PositionEndSubscribed (TypBlock far ** BlockPtr, TypLine far ** LinePtr)
{
  BOOL advance;
  TypGroup far *group;

  TopOfDoc (&NetDoc, BlockPtr, LinePtr);
  advance = TRUE;
  do {
	group = (TypGroup far *) ((char far *) *LinePtr + sizeof (TypLine));
	if (group->Subscribed) {
	  advance = NextLine (BlockPtr, LinePtr);
	}
	else {
	  advance = FALSE;
	}
  }
  while (advance);
}

/*--- function MergeGroups ----------------------------------------
 *
 *  Merge a list of groups into NetDoc.
 *
 *  Entry:  NewGroupTable  is an array of pointers to TypGroup structures
 *                         of groups to be merged into NetDoc.
 *          hNewGroupTable is the handle to the above.
 *          nNewGroups     is the number of groups in the table.
 *          WhereSubscribed   indicates where new subscribed groups
 *                         should be added.
 *                         ADD_SUBSCRIBED_END_OF_SUB indicates that
 *                           they should be added at the end of the subscribed
 *                           list, before the unsubscribed groups.
 *                         ADD_SUBSCRIBED_TOP_OF_DOC indicates that they
 *                           should be added at the top of the document.
 *  Exit:   The groups in the table have been added to NetDoc, and
 *            the entries in GroupTable have been freed from memory.
 *            Also, GroupTable itself has been freed.
 */
void
MergeGroups (int WhereSubscribed)
{
  TypBlock far *BlockPtr;
  TypLine far *LinePtr;
  TypGroup far *group;
  char far *netcptr;
  char far *grpcptr;
  void far *AllocPtr;
  HANDLE hLine;
  unsigned int Offset;
  TypLineID MyLineID;
  char myline[BLOCK_SIZE];
  int j, advance, at_end = 0;

  switch (WhereSubscribed) {
  case ADD_SUBSCRIBED_END_OF_SUB:
	PositionEndSubscribed (&BlockPtr, &LinePtr);
	break;
  case ADD_SUBSCRIBED_TOP_OF_DOC:
	TopOfDoc (&NetDoc, &BlockPtr, &LinePtr);
	break;
  }

  /* BlockPtr and LinePtr point to the
   * place to add new subscribed groups.
   * Loop through the new groups; for subscribed groups, add
   * them to NetDoc at this point.
   * For each subscribed group, unlock and free the corresponding
   * line pointed to by NewGroupTable.  Set the table entry
   * to 0 to indicate that this group has been dealt with.
   */

  for (j = 0; j < nNewGroups; j++) {
	AllocPtr = (char far *) NewGroupTable[j];
	group = (TypGroup far *) ((char far *) AllocPtr + sizeof (TypLine));
	if (group->Subscribed) {
	  /* This group has been selected and should be subscribed to.
	   */
	  MoveBytes (AllocPtr, myline, ((TypLine far *) AllocPtr)->length);
	  LinePtr->active = TRUE;
	  AddLine ((TypLine *) myline, &BlockPtr, &LinePtr);
	  NetDoc.ActiveLines++;
	  NewGroupTable[j] = (void far *) 0;
	}
  }

  PositionEndSubscribed (&BlockPtr, &LinePtr);

  /* Now take a second pass through NewGroupTable, for the
   * unsubscribed groups.  If NewGroupTable[j] is non-zero, then
   * that group should be entered into the second, unsubscribed
   * section of NetDoc, merged in in alphabetical order.
   *
   * BlockPtr and LinePtr point to the first unsubscribed group.
   */

  for (j = 0; j < nNewGroups; j++) {
	if (NewGroupTable[j]) {
	  /* Search for the right place to add this line. */

	  AllocPtr = (char far *) NewGroupTable[j];
	  grpcptr = ((char far *) AllocPtr) + sizeof (TypLine) + sizeof (TypGroup);
	  advance = TRUE;

	  if (!at_end) {
		do {
		  netcptr = ((char far *) LinePtr) + sizeof (TypLine) + sizeof (TypGroup);
		  if (lstrcmp (grpcptr, netcptr) < 0) {
			advance = FALSE;
		  }
		  else {
			advance = NextLine (&BlockPtr, &LinePtr);
			if (!advance)
			  at_end = 1;		/* possible bug, getting bad netcptr (smr) */
		  }
		}
		while (advance);
	  }

	  /* Now add the new group at this point */
	  MoveBytes (AllocPtr, myline, ((TypLine far *) AllocPtr)->length);
	  LinePtr->active = ShowUnsubscribed;
	  AddLine ((TypLine *) myline, &BlockPtr, &LinePtr);

	}
  }

  UnlockLine (BlockPtr, LinePtr, &hLine, &Offset, &MyLineID);
}

/*--- function CleanUpGroupTable ------------------------------------
 *
 *  Clean up after doing processing to add or move groups in NetDoc.
 */
void
CleanUpGroupTable ()
{
  HANDLE hBlock, hBlockNext;
  TypBlock far *BlockPtr;

  /* Unlock all blocks in the NetDoc document.
   */

  hBlock = NetDoc.hFirstBlock;
  do {
	BlockPtr = (TypBlock far *) GlobalLock (hBlock);
	hBlockNext = BlockPtr->hNextBlock;

	MyGlobalUnlock (hBlock);
	MyGlobalUnlock (hBlock);
	hBlock = hBlockNext;
  }
  while (hBlock);

  /* Unlock and free the NewGroupTable and NewGroupData.  */

  GlobalUnlock (hNewGroupData);
  GlobalFree (hNewGroupData);
  MyGlobalUnlock (hNewGroupTable);
  GlobalFree (hNewGroupTable);

}

/*--- function FindNextPrime ------------------------------------
 *
 *  Find the smallest prime that is larger than the given argument.
 *  Extreemly handy for those annoying dynamic hash tables.
 */
unsigned long
FindNextPrime (unsigned long OrigVal)
{

  int MaxPrimeIndex = (sizeof (prime) / sizeof (prime[0])) - 1;
  int IndexA = 0;
  int IndexB = MaxPrimeIndex;
  int TmpIndex;

  /* If we're larger than the max prime we know of, just return it */
  if (OrigVal >= prime[MaxPrimeIndex])
	return (prime[MaxPrimeIndex]);

  /* We do this by doing a binary search of the prime array */
  do {
	TmpIndex = IndexA + ((IndexB - IndexA) / 2);
	if (OrigVal == prime[TmpIndex])
	  return (prime[TmpIndex + 1]);
	if (OrigVal < prime[TmpIndex])
	  IndexB = TmpIndex;
	else
	  IndexA = TmpIndex;
  } while ((IndexB - IndexA) > 1);

  return (prime[IndexA + 1]);
}
@


1.25
log
@Fix progress bar in main window for win16
@
text
@d2 1
a2 1
 * $Id: wvlist.c 1.24 1995/02/02 21:29:30 rushing Exp jglasser $
d331 1
a331 1
HashGroup (char * gname)
@


1.24
log
@changed HashGroup()'s argument type from 'unsigned char huge *' to 'char *'
@
text
@d2 1
a2 1
 * $Id: wvlist.c 1.23 1995/01/19 02:47:25 jglasser Exp rushing $
d221 1
a221 1
	  PercentDone = RcvLineCount * 100 / NetDoc.TotalLines;
@


1.23
log
@Jody Glasser's changes of 950113
@
text
@d2 1
a2 1
 * $Id: wvlist.c 1.22 1994/12/12 19:39:13 jcooper Exp $
d331 1
a331 2
HashGroup (gname)
	 unsigned char huge *gname;
@


1.22
log
@0.9.99 update
@
text
@d2 1
a2 1
 * $Id: wvlist.c 1.21 1994/11/21 21:20:46 jcooper Exp $
d216 1
d220 5
@


1.21
log
@93.7 update
@
text
@d2 1
a2 1
 * $Id: wvlist.c 1.20 1994/11/10 01:53:16 rushing Exp $
d25 1
a25 1
TypLine far *far * NetHashTable;
d109 1
a109 1
  NetHashTable = (TypLine far * far *) GlobalLock (hNetHashTable);
d150 1
a150 1
	 TypLine far *far * HashTable;
@


1.20
log
@restart
@
text
@a83 2


d244 1
a244 1

d264 1
a264 1

a266 1

d478 9
d493 1
a556 1

d569 1
a569 5
#ifdef WIN32
	  switch (HIWORD (wParam))
#else
	  switch (HIWORD (lParam))
#endif /* WIN32 */
d573 6
a578 6
#ifdef WIN32
		nItem = SendMessage ((HWND) lParam, LB_GETCURSEL, 0, 0);
		SendMessage ((HWND) lParam, LB_GETTEXT, (WPARAM) nItem,
					 (LPARAM) TmpBuf);
		SendMessage ((HWND) lParam, LB_DELETESTRING, (WPARAM) nItem,
					 (LPARAM) 0);
a579 7
#else
		nItem = SendMessage ((HWND) LOWORD (lParam), LB_GETCURSEL, 0, 0);
		SendMessage ((HWND) LOWORD (lParam), LB_GETTEXT, (WPARAM) nItem,
					 (LPARAM) TmpBuf);
		SendMessage ((HWND) LOWORD (lParam), LB_DELETESTRING, (WPARAM) nItem,
					 (LPARAM) 0);
#endif /* WIN32 */
d593 15
d615 1
a615 5
#ifdef WIN32
	  switch (HIWORD (wParam))
#else
	  switch (HIWORD (lParam))
#endif /* WIN32 */
d619 6
a624 13
#ifdef WIN32
		nItem = SendMessage ((HWND) lParam, LB_GETCURSEL, 0, 0);
		SendMessage ((HWND) lParam, LB_GETTEXT, (WPARAM) nItem,
					 (LPARAM) TmpBuf);
		SendMessage ((HWND) lParam, LB_DELETESTRING, (WPARAM) nItem,
					 (LPARAM) 0);
#else
		nItem = SendMessage ((HWND) LOWORD (lParam), LB_GETCURSEL, 0, 0);
		SendMessage ((HWND) LOWORD (lParam), LB_GETTEXT, (WPARAM) nItem,
					 (LPARAM) TmpBuf);
		SendMessage ((HWND) LOWORD (lParam), LB_DELETESTRING, (WPARAM) nItem,
					 (LPARAM) 0);
#endif /* WIN32 */
d638 14
d659 1
a659 5
#ifdef WIN32
	  switch (HIWORD (wParam))
#else
	  switch (HIWORD (lParam))
#endif /* WIN32 */
d663 5
a667 9
#ifdef WIN32
		nItem = SendMessage ((HWND) lParam, LB_GETCURSEL, 0, 0);
		SendMessage ((HWND) lParam, LB_GETTEXT, (WPARAM) nItem,
					 (LPARAM) TmpBuf);
#else
		nItem = SendMessage ((HWND) LOWORD (lParam), LB_GETCURSEL, 0, 0);
		SendMessage ((HWND) LOWORD (lParam), LB_GETTEXT, (WPARAM) nItem,
					 (LPARAM) TmpBuf);
#endif /* WIN32 */
d681 2
a682 5
#ifdef WIN32
		SendMessage ((HWND) lParam, WM_SETREDRAW, FALSE, 0L);
#else
		SendMessage ((HWND) LOWORD (lParam), WM_SETREDRAW, FALSE, 0L);
#endif /* WIN32 */
d687 2
d694 20
a713 6
		  if (group->Subscribed)
			SendMessage (hDlgSubList, LB_ADDSTRING, 0,
						 (LPARAM) ((char huge *) group + sizeof (TypGroup)));
		  else
			SendMessage (hDlgUnSubList, LB_ADDSTRING, 0,
						 (LPARAM) ((char huge *) group + sizeof (TypGroup)));
d715 8
a723 18
		//  Horizontal scrolling doesn't work.   These are all attempts to
		//  fix it that don't work.  However, it isn't worth holding up
		//  the release of .92-3 for this one....JD 8/26/94


		//  SendDlgItemMessage(GetDlgItem(hDlg,IDD_SUBSCRIBED_GROUP_LISTBOX), IDD_SUBSCRIBED_GROUP_LISTBOX,       // JD 8/25/94
		//                         LB_SETHORIZONTALEXTENT,(WPARAM)200,(LPARAM)0);
		//  SetScrollRange(GetDlgItem(hDlg,IDD_SUBSCRIBED_GROUP_LISTBOX),
		//             SB_CTL, (int) 0, (int) 1200, TRUE);   // JD 8/26/94
		//
		//  SetScrollRange(GetDlgItem(hDlg,IDD_UNSUBSCRIBED_GROUP_LISTBOX),
		//             SB_HORZ, (int) 0, (int) 20, TRUE);   // JD 8/26/94

#ifdef WIN32
		SendMessage ((HWND) lParam, WM_SETREDRAW, TRUE, 0L);
#else
		SendMessage ((HWND) LOWORD (lParam), WM_SETREDRAW, TRUE, 0L);
#endif /* WIN32 */
@
