head	1.24;
access;
symbols
	V0-99-8:1.22
	V0-99-7:1.21
	V0-99-6:1.21
	V0-99-5:1.21
	V0-99-4:1.21
	V0-99-2:1.21
	V0-99-1:1.21
	V0-93-14:1.21
	V0-93-13:1.21
	V0-93-12:1.21
	V0-93-11:1.21
	V0-93-10:1.21
	V0-93-9:1.21
	V0-93-8:1.20
	V0-93-7:1.20
	V0-93-5:1.19
	V80:1.2
	V76d:1.1;
locks; strict;
comment	@ * @;


1.24
date	97.02.14.20.12.31;	author dumoulin;	state Exp;
branches;
next	1.23;

1.23
date	97.02.06.17.31.01;	author dumoulin;	state Exp;
branches;
next	1.22;

1.22
date	96.08.13.05.03.26;	author dumoulin;	state Exp;
branches;
next	1.21;

1.21
date	94.11.30.22.22.08;	author jcooper;	state Exp;
branches;
next	1.20;

1.20
date	94.11.21.21.20.46;	author jcooper;	state Exp;
branches;
next	1.19;

1.19
date	94.11.10.23.00.19;	author jcooper;	state Exp;
branches;
next	1.18;

1.18
date	94.11.10.01.51.34;	author rushing;	state Exp;
branches;
next	;


desc
@winvn version 0.76 placed into RCS
@


1.24
log
@Add patches for WinVN .99-9 Beta 2
@
text
@/*
 * $Id: wvscreen.c 1.23 1997/02/06 17:31:01 dumoulin Exp $
 */

/*-- First Line of WVSCREEN.C -- Contains Screen-related functions.  */
#include <windows.h>
#include <windowsx.h>
#include "wvglob.h"
#include "winvn.h"
#pragma hdrstop

/*--- function ScreenDown ----------------------------------------------
 *
 *  Advance a pointer "nLines" lines through the textlines.
 *  However, do not go so far that less than LinesOnScreen lines
 *  are left past the pointer.
 *
 *  This is used to implement "PageDown" and "LineDown" functions.
 *
 *    Entry    nLines         Number of lines to move the pointer.
 *             LinesOnScreen  is the number of lines on the screen.
 *             BlockPtr       Pointer to block containing line.
 *             LinePtr        Pointer to the given line.
 *
 *    Exit     BlockPtr and LinePtr (may) have been moved to a new line.
 *             LinesAdvanced  is the number of lines actually moved--can be
 *                            less than nLines if we hit the top of the
 *                            last screen.
 */
void
ScreenDown (nLines, LinesOnScreen, BlockPtr, LinePtr, LinesAdvanced)
	 long nLines;
	 long LinesOnScreen;
	 TypBlock far **BlockPtr;
	 TypLine far **LinePtr;
	 long *LinesAdvanced;
{
  TypBlock far *MyBlock = *BlockPtr;
  TypLine far *MyLine = *LinePtr;
  long LinesGone, TestAdvance;
  HANDLE hBlock, hBlockGarbage;
  unsigned int Offset, OffsetGarbage;
  TypLineID LineIDGarbage, MyLineID;

  /* Skip forward nLines, plus one screen's worth, just to see      */
  /* if there are enough lines ahead of us in the document.         */

  PtrToOffset (MyBlock, MyLine, &hBlock, &Offset, &MyLineID);
  TestAdvance = nLines + LinesOnScreen - 1;
  for (LinesGone = TestAdvance; LinesGone;) {
	if (!NextLine (&MyBlock, &MyLine))
	  break;
	/* Count only active lines. */
	if (MyLine->active)
	  LinesGone--;
  }
  UnlockLine (MyBlock, MyLine, &hBlockGarbage, &OffsetGarbage, &LineIDGarbage);

  nLines -= LinesGone;
  if (nLines < 0)
	nLines = 0;
  *LinesAdvanced = nLines;

  LockLine (hBlock, Offset, MyLineID, &MyBlock, &MyLine);
  while (nLines) {
	NextLine (BlockPtr, LinePtr);
	if ((*LinePtr)->active)
	  nLines--;
  }
}

/*--- function ScreenUp ----------------------------------------------
 *
 *  Back up a pointer "nLines" lines through the textlines.
 *  However, do not go past the beginning of the document.
 *
 *  This is used to implement "PageUp" and "LineUp" functions.
 *
 *    Entry    nLines         Number of lines to move the pointer.
 *             BlockPtr       Pointer to block containing line.
 *             LinePtr        Pointer to the given line.
 *
 *    Exit     BlockPtr and LinePtr (may) have been moved to a new line.
 *             LinesBackedUp  is the number of lines actually moved--can be
 *                            less than nLines if we hit beginning of doc.
 */
void
ScreenUp (nLines, BlockPtr, LinePtr, LinesBackedUp)
	 long nLines;
	 TypBlock far **BlockPtr;
	 TypLine far **LinePtr;
	 long *LinesBackedUp;
{
  *LinesBackedUp = 0;

  while (nLines && PrevLine (BlockPtr, LinePtr)) {
	if ((*LinePtr)->active) {
	  nLines--;
	  (*LinesBackedUp)++;
	}
  }
}

/*--- function NewScrollIt ----------------------------------------------
 *
 *  Perform a scrolling action.
 *
 *    Entry    Document points to a document
 *             wParam   is the wParam argument given from a WM_VSCROLL
 *                      window message.  (One of the SB_ symbols.)
 *             lParam   is the lParam argument.
 *
 *   except in WIN32 ...
 *
 *          wParam   LOWORD: SB_code, HIWORD: position.
 */
void
NewScrollIt (Document, wParam, lParam)
	 TypDoc *Document;
	 WPARAM wParam;
	 LPARAM lParam;
{
  long LinesGone;
  unsigned int LineOrd;
  RECT Rect;      
  int window_lineheight, window_topspace;

  if (Document->DocType == DOCTYPE_ARTICLE) {
	window_lineheight = ArtLineHeight;
	window_topspace = ArtTopSpace;
  }
  else {
	window_lineheight = LineHeight;
	window_topspace = TopSpace;
  }

  switch (LOWORD (wParam)) {
  case SB_LINEUP:
	/* Move up a line by scrolling the window down one line     */
	/* and introducing 1 new line at the top.                   */

	if (Document->TopLineOrd > 0) {
	  LinesGone = 1;
	}
	else
	  LinesGone = 0;

  doscrollup:;
	if (LinesGone) {
	  Rect.left = 0;
	  Rect.right = Document->ScXWidth;
	  Document->TopLineOrd -= LinesGone;

	  ScrollWindow (Document->hDocWnd, 0, (int) (LinesGone * window_lineheight), NULL, NULL);

	  Rect.top = window_topspace;
	  Rect.bottom = (int) (window_topspace + LinesGone * window_lineheight);

	  InvalidateRect (Document->hDocWnd, &Rect, FALSE);

	  /* Make sure garbage at bottom is erased in WM_PAINT processing */
	  Rect.top = window_topspace + Document->ScYLines * window_lineheight;
	  Rect.bottom = Document->ScYHeight;
	  InvalidateRect (Document->hDocWnd, &Rect, FALSE);
	}
	break;

  case SB_LINEDOWN:
	/* Should change TotalLines below to ActiveLines for 
	 * suppression of already-read articles, but it's not that simple.
	 *  /mrr
	 */
	if (Document->TopLineOrd < (Document->ActiveLines - Document->ScYLines)) {
	  LinesGone = 1;
	}
	else
	  LinesGone = 0;
	/*
	 * If ActiveLines happens to be less than ScYLines, LinesGone will now
	 * be one, and we will GPF for running off the end of the data.  Check
	 * and fix this condition. -gkt
	 */
	if ((LinesGone) && (Document->ActiveLines < Document->ScYLines))
	  LinesGone = 0;

  doscrolldown:;
	if (LinesGone) {
	  Document->TopLineOrd += LinesGone;
	  Rect.left = 0;
	  Rect.right = Document->ScXWidth;
	  ScrollWindow (Document->hDocWnd, 0, (int) (-LinesGone * window_lineheight), NULL, NULL);
	  Rect.top = (int) (window_topspace + (Document->ScYLines - LinesGone) * window_lineheight);
	  Rect.bottom = Document->ScYHeight;
	  InvalidateRect (Document->hDocWnd, &Rect, FALSE);
	  /* Make sure garbage at top is erased in WM_PAINT processing */
	  Rect.top = 0;
	  Rect.bottom = window_topspace;
	  InvalidateRect (Document->hDocWnd, &Rect, FALSE);
	}
	break;

  case SB_PAGEUP:
/*      LockLine (Document->hCurTopScBlock, Document->TopScOffset, Document->TopScLineID, &BlockPtr, &LinePtr); */
/*      ScreenUp (Document->ScYLines - 1, &BlockPtr, &LinePtr, &LinesGone); */
	LinesGone = Document->TopLineOrd - (Document->ScYLines - 1);
	if (LinesGone > 0) {
	  LinesGone = Document->ScYLines - 1;
	}
	else {
	  LinesGone = Document->TopLineOrd;
	}

	Document->TopLineOrd -= LinesGone;
	InvalidateRect (Document->hDocWnd, NULL, FALSE);
	break;

  case SB_PAGEDOWN:

	if (Document->ActiveLines > Document->ScYLines) {	/* do we even need to scroll? */
	  if ((Document->ActiveLines -
		   (Document->TopLineOrd + Document->ScYLines)) > Document->ScYLines)
		LinesGone = Document->ScYLines - 1;
	  else
		LinesGone = Document->ActiveLines - (Document->TopLineOrd + Document->ScYLines);

	  /*
	   * If ActiveLines happens to be less than TopLineOrd + ScYLines,
	   * Adding LinesGone to TopLineOrd would take us beyond the end
	   * of data and would cause a GPF.  Correct this condition by
	   * making TopLineOrd either 1 (if ActiveLines < ScYLines )
	   * or ActiveLines - ScYLines (the last "page" of data).  -gkt
	   */
	  if (Document->TopLineOrd + Document->ScYLines > Document->ActiveLines) {
		if (Document->ActiveLines > Document->ScYLines)
		  Document->TopLineOrd = Document->ActiveLines - Document->ScYLines;
		else
		  Document->TopLineOrd = 1;
	  }
	  else {
		Document->TopLineOrd += LinesGone;
	  }

	  InvalidateRect (Document->hDocWnd, NULL, FALSE);
	}
	break;

  case SB_THUMBPOSITION:
#ifdef _WIN32
	LineOrd = (int) HIWORD (wParam);
#else
	LineOrd = LOWORD (lParam);
#endif
  SetScrollPos (Document->hDocWnd, SB_VERT, LineOrd, TRUE);
  Document->ThumbTracking = FALSE;
  doposition:;
//	Document->TopLineOrd = LineOrd;
    Document->TopLineOrd = ScrollToOrd(Document->ActiveLines, LineOrd);
	InvalidateRect (Document->hDocWnd, NULL, FALSE);
	break;

  case SB_THUMBTRACK:

#ifdef _WIN32
	LineOrd = (int) HIWORD (wParam);
#else
	LineOrd = LOWORD (lParam);
#endif
//	LinesGone = LineOrd - Document->TopLineOrd;
	LinesGone = ScrollToOrd(Document->ActiveLines,LineOrd) - Document->TopLineOrd;
	Document->ThumbTracking = TRUE;
	if (LinesGone > 0) {
	  if (LinesGone >= (long) (Document->ScYLines - 1)) {
		goto doposition;
	  }
	  else {
		goto doscrolldown;
	  }
	}
	else if (LinesGone < 0) {
	  LinesGone = -LinesGone;
	  if (LinesGone >= (long) (Document->ScYLines - 1)) {
		goto doposition;
	  }
	  else {
		goto doscrollup;
	  }
	}

	break;

  default:
	return;
	break;
  }
}  

/*--- function ScrollIt ----------------------------------------------
 *
 *  Perform a scrolling action.
 *
 *    Entry    Document points to a document
 *             wParam   is the wParam argument given from a WM_VSCROLL
 *                      window message.  (One of the SB_ symbols.)
 *             lParam   is the lParam argument.
 */
void
ScrollIt (Document, wParam, lParam)
	 TypDoc *Document;
	 WPARAM wParam;
	 LPARAM lParam;
{
  TypBlock far *BlockPtr;
  TypLine far *LinePtr;
  long LinesGone;
  unsigned int LineOrd;
  RECT Rect;
  int window_lineheight, window_topspace;

  if (Document->DocType == DOCTYPE_ARTICLE) {
	window_lineheight = ArtLineHeight;
	window_topspace = ArtTopSpace;
  }
  else {
	window_lineheight = LineHeight;
	window_topspace = TopSpace;
  }

  switch (LOWORD (wParam)) {
  case SB_LINEUP:
	/* Move up a line by scrolling the window down one line     */
	/* and introducing 1 new line at the top.                   */
	LockLine (Document->hCurTopScBlock, Document->TopScOffset, Document->TopScLineID, &BlockPtr, &LinePtr);
	AdvanceToActive (&BlockPtr, &LinePtr);
	ScreenUp (1, &BlockPtr, &LinePtr, &LinesGone);
  doscrollup:;
	if (LinesGone) {
	  Rect.left = 0;
	  Rect.right = Document->ScXWidth;
	  Document->TopLineOrd -= LinesGone;
	  ScrollWindow (Document->hDocWnd, 0, (int) (LinesGone * (window_lineheight)), NULL, NULL);

	  Rect.top = window_topspace;
	  Rect.bottom = (int) (window_topspace + LinesGone * window_lineheight);

	  InvalidateRect (Document->hDocWnd, &Rect, FALSE);
	  /* Make sure garbage at bottom is erased in WM_PAINT processing */
	  Rect.top = window_topspace + Document->ScYLines * window_lineheight;
	  Rect.bottom = Document->ScYHeight;
	  InvalidateRect (Document->hDocWnd, &Rect, FALSE);
	}
	break;

  case SB_LINEDOWN:
	LockLine (Document->hCurTopScBlock, Document->TopScOffset, Document->TopScLineID, &BlockPtr, &LinePtr);
	AdvanceToActive (&BlockPtr, &LinePtr);
	ScreenDown (1, Document->ScYLines, &BlockPtr, &LinePtr, &LinesGone);
  doscrolldown:;
	if (LinesGone) {
	  Document->TopLineOrd += LinesGone;
	  Rect.left = 0;
	  Rect.right = Document->ScXWidth;
	  ScrollWindow (Document->hDocWnd, 0, (int) (-LinesGone * (window_lineheight)), NULL, NULL);
	  Rect.top = (int) (window_topspace + (Document->ScYLines - LinesGone) * window_lineheight);
	  Rect.bottom = Document->ScYHeight;
	  InvalidateRect (Document->hDocWnd, &Rect, FALSE);
	  /* Make sure garbage at top is erased in WM_PAINT processing */
	  Rect.top = 0;
	  Rect.bottom = window_topspace;
	  InvalidateRect (Document->hDocWnd, &Rect, FALSE);
	}
	break;

  case SB_PAGEUP:
	LockLine (Document->hCurTopScBlock, Document->TopScOffset, Document->TopScLineID, &BlockPtr, &LinePtr);
	AdvanceToActive (&BlockPtr, &LinePtr);
	ScreenUp (Document->ScYLines - 1, &BlockPtr, &LinePtr, &LinesGone);
	Document->TopLineOrd -= LinesGone;
	InvalidateRect (Document->hDocWnd, NULL, FALSE);
	break;

  case SB_PAGEDOWN:
	LockLine (Document->hCurTopScBlock, Document->TopScOffset, Document->TopScLineID, &BlockPtr, &LinePtr);
	AdvanceToActive (&BlockPtr, &LinePtr);     // shimomai
	if (Document->NextTopLine > 0 && Document->NextTopLine < Document->TotalLines) {
	  LinesGone = Document->NextTopLine - Document->TopLineOrd;
	  while (LinesGone--) 
	  	NextLine (&BlockPtr, &LinePtr);
	  Document->TopLineOrd = Document->NextTopLine;
	}
	else {
		ScreenDown (Document->ScYLines - 1, Document->ScYLines,
				&BlockPtr, &LinePtr, &LinesGone);
		Document->TopLineOrd += LinesGone;
	}
	InvalidateRect (Document->hDocWnd, NULL, FALSE);
	break;

  case SB_THUMBPOSITION:
#ifdef _WIN32
	LineOrd = (int) HIWORD (wParam);
#else
	LineOrd = LOWORD (lParam);
#endif
	if (!FindLineOrd (Document, ScrollToOrd(Document->ActiveLines,LineOrd), &BlockPtr, &LinePtr)) {
	  return;
	}
  SetScrollPos (Document->hDocWnd, SB_VERT, LineOrd, TRUE);
  Document->ThumbTracking = FALSE;
  doposition:;
//	Document->TopLineOrd = LineOrd;
    Document->TopLineOrd = ScrollToOrd(Document->ActiveLines,LineOrd);
	InvalidateRect (Document->hDocWnd, NULL, FALSE);
	break;

  case SB_THUMBTRACK:

#ifdef _WIN32
	LineOrd = (int) HIWORD (wParam);
#else
	LineOrd = LOWORD (lParam);
#endif
	if (!FindLineOrd (Document, ScrollToOrd(Document->ActiveLines,LineOrd), &BlockPtr, &LinePtr)) {
	  return;
	}
	Document->ThumbTracking = TRUE;
	LinesGone = ScrollToOrd(Document->ActiveLines,LineOrd) - Document->TopLineOrd;
	if (LinesGone > 0) {
	  if (LinesGone >= (int) (Document->ScYLines - 1)) {
		goto doposition;
	  }
	  else {
		goto doscrolldown;
	  }
	}
	else if (LinesGone < 0) {
	  LinesGone = -LinesGone;
	  if (LinesGone >= (int) (Document->ScYLines - 1)) {
		goto doposition;
	  }
	  else {
		goto doscrollup;
	  }
	}

	break;

  default:
	return;
	break;
  }
  UnlockLine (BlockPtr, LinePtr, &(Document->hCurTopScBlock),
			  &(Document->TopScOffset), &(Document->TopScLineID));

}



/*--- function HScrollIt ----------------------------------------------
 *
 *  Perform a horizontal scrolling action.
 *
 *    Entry    Document points to a document
 *             wParam   is the wParam argument given from a WM_HSCROLL
 *                      window message.  (One of the SB_ symbols.)
 *             lParam   is the lParam argument (scroll box position).
 */
void
HScrollIt (Document, wParam, lParam)
	 TypDoc *Document;
	 WPARAM wParam;
	 LPARAM lParam;
{

  switch (LOWORD (wParam)) {

  case SB_LINEUP:
	if (Document->ScXOffset > 0) {
	  RECT Rect;

	  Document->ScXOffset--;
	  Rect.top = 0;
	  Rect.bottom = Document->ScYHeight;

	  if (Document->DocType == DOCTYPE_ARTICLE) {
		Rect.left = -((int) ArtCharWidth + 1);
	  }
	  else {
		Rect.left = -((int) CharWidth + 1);
	  }
	  Rect.right = Document->ScXWidth - Rect.left;
	  ScrollWindow (Document->hDocWnd, -Rect.left, 0, &Rect, NULL);
//shimomai	  Rect.right = -Rect.left;
	  Rect.right = -Rect.left + 1;

	  InvalidateRect (Document->hDocWnd, &Rect, FALSE);
	}
	break;

  case SB_LINEDOWN:
	if (Document->LongestLine > Document->ScXChars &&
		Document->ScXOffset < Document->LongestLine - Document->ScXChars) {
	  RECT Rect;

	  Document->ScXOffset++;
	  Rect.top = 0;
	  Rect.bottom = Document->ScYHeight;

	  if (Document->DocType == DOCTYPE_ARTICLE) {
		Rect.left = ArtCharWidth + 1;
	  }
	  else {
		Rect.left = CharWidth + 1;
	  }
	  Rect.right = Document->ScXWidth + Rect.left;
	  ScrollWindow (Document->hDocWnd, -Rect.left, 0, &Rect, NULL);
//shiomai	  Rect.right = Rect.left;
//	  Rect.left = 0;
	  Rect.right = Document->ScXWidth;
	  Rect.left = Rect.right - Rect.left -1;

	  InvalidateRect (Document->hDocWnd, &Rect, FALSE);
	}
	break;

  case SB_PAGEUP:
	if (((int) Document->ScXOffset - (int) Document->ScXChars) > 0) {
	  Document->ScXOffset = Document->ScXOffset -
		Document->ScXChars + 5;
	}
	else {
	  Document->ScXOffset = 0;
	}
	InvalidateRect (Document->hDocWnd, NULL, FALSE);
	break;

  case SB_PAGEDOWN:
	if ((Document->ScXOffset + Document->ScXChars) <
		(Document->LongestLine - Document->ScXChars)) {
	  Document->ScXOffset = Document->ScXOffset +
		Document->ScXChars - 5;
	}
	else {
	  Document->ScXOffset = (int) (Document->LongestLine - Document->ScXChars);
	}
	InvalidateRect (Document->hDocWnd, NULL, FALSE);
	break;

  case SB_THUMBPOSITION:
  	Document->ThumbTracking = FALSE;
#ifdef _WIN32
	Document->ScXOffset = (int) HIWORD (wParam);
#else
	Document->ScXOffset = LOWORD (lParam);
#endif
	InvalidateRect (Document->hDocWnd, NULL, FALSE);
	break;
	
  case SB_THUMBTRACK:
#ifdef _WIN32
	Document->ScXOffset = (int) HIWORD (wParam);
#else
	Document->ScXOffset = LOWORD (lParam);
#endif
  	Document->ThumbTracking = TRUE;
	break;


  default:
	return;
	break;

  }
}




/*--- function LineOnScreen ----------------------------------------
 *
 *  Determine whether a given line is displayed on the screen.
 *  If it is, give the ordinal line number on the screen.
 *
 *  Entry   Doc         points to the document.
 *          hTargBlock  is the handle of the block containing the line.
 *          TargOffset  is the offset of the target line.
 *          TargLineID  is the line's ID.
 *
 *  Exit    returns -1 if the line is not on the screen, else
 *          the ordinal line number (0 = top line, etc.)
 */
int
LineOnScreen (Doc, hTargBlock, TargOffset, TargLineID)
	 TypDoc *Doc;
	 HANDLE hTargBlock;
	 unsigned int TargOffset;
	 TypLineID TargLineID;
{
  TypBlock far *CurBlockPtr, far * TargBlockPtr;
  TypLine far *CurLinePtr, far * TargLinePtr;
  int iline;
  BOOL found = FALSE, gotnext = TRUE;
  HANDLE hBlock;
  unsigned int Offset;
  TypLineID MyLineID;

  LockLine (Doc->hCurTopScBlock, Doc->TopScOffset, Doc->TopScLineID, &CurBlockPtr, &CurLinePtr);
  LockLine (hTargBlock, TargOffset, TargLineID, &TargBlockPtr, &TargLinePtr);

  for (iline = 0; gotnext && !found && (unsigned) iline < Doc->ScYLines;) {
	found = (TargLinePtr == CurLinePtr);
	if (CurLinePtr->active)
	  iline++;
	if (!found) {
	  gotnext = NextLine (&CurBlockPtr, &CurLinePtr);
	}
  }

  UnlockLine (CurBlockPtr, CurLinePtr, &hBlock, &Offset, &MyLineID);
  UnlockLine (TargBlockPtr, TargLinePtr, &hBlock, &Offset, &MyLineID);

  if (!found)
	iline = 0;
  return (iline - 1);
}

/*--- function NextWindow ----------------------------------------------
 *
 *  Makes another window the active window with input focus.
 *  This function would typically be used to implement a keystroke
 *  (usually F6) that switches windows.
 *
 *    Entry    Doc   points to the current document.
 */
void
NextWindow (HWND hCurWnd, int docType)
{
  register int i;
  int tryWndType;
  HWND hNewWnd;
  BOOL foundNext = FALSE;

  /* First, locate the current window in our data structures.       */
  switch (docType) {
  case DOCTYPE_GROUP:
	for (i = 0; i < MAXGROUPWNDS && hCurWnd != GroupDocs[i].hWndFrame; i++);
	if (i >= MAXGROUPWNDS) {
	  MessageBox (hCurWnd, "Error finding next window", "System error", MB_ICONHAND | MB_OK);
	}
	tryWndType = DOCTYPE_GROUP;
	i++;
	break;

  case DOCTYPE_ARTICLE:
	for (i = 0; i < MAXARTICLEWNDS && hCurWnd != ArticleDocs[i].hWndFrame; i++);
	if (i >= MAXARTICLEWNDS) {
	  MessageBox (hCurWnd, "Error finding next window", "System error", MB_ICONHAND | MB_OK);
	}
	tryWndType = DOCTYPE_ARTICLE;
	i++;
	break;

  case DOCTYPE_MAIL:
  case DOCTYPE_FORWARD:
	for (i = 0; i < MAXMAILWNDS && hCurWnd != WndMails[i].hWnd; i++);
	if (i >= MAXMAILWNDS) {
	  MessageBox (hCurWnd, "Error finding next window", "System error", MB_ICONHAND | MB_OK);
	}
	tryWndType = DOCTYPE_MAIL;
	i++;
	break;

  case DOCTYPE_POSTING:
	for (i = 0; i < MAXPOSTWNDS && hCurWnd != WndPosts[i].hWnd; i++);
	if (i >= MAXPOSTWNDS) {
	  MessageBox (hCurWnd, "Error finding next window", "System error", MB_ICONHAND | MB_OK);
	}
	tryWndType = DOCTYPE_POSTING;
	i++;
	break;

  case DOCTYPE_NET:
  default:
	i = 0;
	tryWndType = DOCTYPE_GROUP;
	break;
  }

  /* Now, find the next window in the sequence.                     */
  if (!foundNext && tryWndType == DOCTYPE_GROUP) {
	for (; i < MAXGROUPWNDS && !foundNext; i++) {
	  if (GroupDocs[i].InUse) {
		ActiveGroupDoc = &(GroupDocs[i]);
		hNewWnd = ActiveGroupDoc->hWndFrame;
		foundNext = TRUE;
	  }
	}
	i = 0;
	tryWndType = DOCTYPE_ARTICLE;
  }

  /* Not found yet--try to find an Article doc.                     */
  if (!foundNext && tryWndType == DOCTYPE_ARTICLE) {
	for (; i < MAXARTICLEWNDS && !foundNext; i++) {
	  if (ArticleDocs[i].InUse) {
		ActiveArticleDoc = &(ArticleDocs[i]);
		hNewWnd = ActiveArticleDoc->hWndFrame;
		foundNext = TRUE;
	  }
	}
	i = 0;
	tryWndType = DOCTYPE_MAIL;
  }

  if (!foundNext && tryWndType == DOCTYPE_MAIL) {
	for (; i < MAXMAILWNDS && !foundNext; i++) {
	  if (WndMails[i].hWnd) {
		hNewWnd = WndMails[i].hWnd;
		foundNext = TRUE;
	  }
	}
	i = 0;
	tryWndType = DOCTYPE_POSTING;
  }

  if (!foundNext && tryWndType == DOCTYPE_POSTING) {
	for (; i < MAXPOSTWNDS && !foundNext; i++) {
	  if (WndPosts[i].hWnd) {
		hNewWnd = WndPosts[i].hWnd;
		foundNext = TRUE;
	  }
	}
  }

  /* Still not found--just make the Net document the next one.      */
  if (!foundNext) {
	hNewWnd = NetDoc.hWndFrame;
  }

  SetActiveWindow (hNewWnd);
  SetFocus (hNewWnd);
}

/*--- function AdjustScTop -----------------------------------
 *
 *  Adjust the top line of the screen so that a given line is sure
 *  to appear on the screen.
 *  Don't do anything if the document is one screen's length or smaller.
 *
 *    Entry
 *             BlockPtr and LinePtr  point to the line we want to
 *                      make sure is visible.
 *
 *    Exit     Doc's TopSc fields have been set to ensure that
 *               the line will appear on the screen.
 *             The line has been unlocked.
 */
void
AdjustTopSc (BlockPtr, LinePtr)
	 TypBlock far *BlockPtr;
	 TypLine far *LinePtr;
{
  unsigned int lineord;
  TypDoc *Doc;
  HANDLE hBlock;
  unsigned int Offset;
  TypLineID MyLineID;

  Doc = BlockPtr->OwnerDoc;
  if (Doc->TotalLines > Doc->ScYLines)
	//if (Doc->ActiveLines > Doc->ScYLines)  //??
  {
	lineord = WhatLine (BlockPtr, LinePtr);

	while (lineord > Doc->TotalLines - Doc->ScYLines)
	  //while (lineord > Doc->ActiveLines - Doc->ScYLines)  //??
	{
	  PrevLine (&BlockPtr, &LinePtr);
	  lineord--;
	}
	Doc->TopLineOrd = lineord;
	Doc->ThumbTracking = FALSE;	/* if thumb tracking, release it */

	UnlockLine (BlockPtr, LinePtr, &(Doc->hCurTopScBlock),
				&(Doc->TopScOffset), &(Doc->TopScLineID));
  }
  else {
	UnlockLine (BlockPtr, LinePtr, &hBlock, &Offset, &MyLineID);
  }
}

void 
AdjustMidSc (TypBlock far * BlockPtr, TypLine far * LinePtr)
{
  unsigned int lineord;
  TypDoc *Doc;
  HANDLE hBlock;
  unsigned int Offset;
  TypLineID MyLineID;
  unsigned int i;

  Doc = BlockPtr->OwnerDoc;

  if (Doc->ActiveLines > Doc->ScYLines) {
	lineord = WhatLine (BlockPtr, LinePtr);

	if (lineord < Doc->TopLineOrd || lineord >= (Doc->TopLineOrd + Doc->ScYLines - 1)) {
	  if (lineord > Doc->ActiveLines - Doc->ScYLines) {
		while (lineord > (Doc->ActiveLines - Doc->ScYLines) + 1)	//??
		 {
		  PrevActiveLine (&BlockPtr, &LinePtr);
		  lineord--;
		}
	  }
	  else {
		if (lineord >= Doc->ScYLines) {
		  for (i = 0; i < Doc->ScYLines / 2; i++) {
			PrevActiveLine (&BlockPtr, &LinePtr);
			lineord--;
		  }
		}
		else {
		  while (lineord) {
			PrevActiveLine (&BlockPtr, &LinePtr);
			lineord--;
		  }
		}
	  }
	  Doc->TopLineOrd = lineord;
	  Doc->ThumbTracking = FALSE;	/* if thumb tracking, release it */
	  UnlockLine (BlockPtr, LinePtr, &(Doc->hCurTopScBlock),
				  &(Doc->TopScOffset), &(Doc->TopScLineID));
	}
  }
  else {
	UnlockLine (BlockPtr, LinePtr, &hBlock, &Offset, &MyLineID);
  }
  InvalidateRect (Doc->hDocWnd, NULL, FALSE);
  UpdateWindow (Doc->hDocWnd);
}

/*
 * This is a Doc/line-index version of AdjustScTop
 * Don't you wish we could overload the function?!
 * JSC 8/13/94
 */
void
AdjustTopScByDoc (TypDoc * aDoc, TypLineID index)
{
  if (aDoc->TotalLines < aDoc->ScYLines ||
	  index >= (TypLineID) aDoc->TopLineOrd && index < (TypLineID) (aDoc->TopLineOrd + aDoc->ScYLines))
	return;						// already on screen

  if (index <= (TypLineID) aDoc->ScYLines / 2)
	aDoc->TopLineOrd = 0;
  else
	aDoc->TopLineOrd = (unsigned int) (index - (TypLineID) aDoc->ScYLines / 2);		// center it

  aDoc->ThumbTracking = FALSE;	/* if thumb tracking, release it */
  InvalidateRect (aDoc->hDocWnd, NULL, FALSE);
}

/*--- function ScreenToTop -------------------------------------
 *
 *  Sets a document so that the screen is scrolled to the top.
 *
 *  Entry   Doc     points to the document.
 *
 *  Exit    The document has been set to display starting at
 *            the first line.
 */

void
ScreenToTop (TypDoc * Doc)
{
  TypBlock far *BlockPtr;
  TypLine far *LinePtr;

  Doc->hCurTopScBlock = Doc->hFirstBlock;
  Doc->TopScOffset = sizeof (TypBlock);
  Doc->TopScLineID = 0;
  Doc->TopLineOrd = 0;
  Doc->ThumbTracking = FALSE;	/* if thumb tracking, release it */

  LockLine (Doc->hFirstBlock, Doc->TopScOffset, Doc->TopScLineID, &BlockPtr, &LinePtr);
  AdvanceToActive (&BlockPtr, &LinePtr);
  UnlockLine (BlockPtr, LinePtr, &(Doc->hFirstBlock), &(Doc->TopScOffset), &(Doc->TopScLineID));
}

/*--- function AdvanceToActive ---------------------------------------
 *
 *  Advances a block/line pointer pair to an active line.
 *  The pointers are unchanged if the current line is active.
 *
 *  Entry:  BlockPtr, LinePtr points to a line.
 *
 *  Exit:   BlockPtr,LinePtr  points to an active line, if possible.
 *          Returns TRUE if successful, else FALSE if no line from
 *            this point to the end of the document was active.
 */
BOOL
AdvanceToActive (BlockPtr, LinePtr)
	 TypBlock far **BlockPtr;
	 TypLine far **LinePtr;
{
  BOOL ok = TRUE;

  while (!((*LinePtr)->active)) {
	if (!NextLine (BlockPtr, LinePtr)) {
	  ok = FALSE;
	  break;
	}
  }

  return ok;
}


/*--- function SetHandleBkBrush ---------------------------------------
 *
 *  Sets a new handle of a background brush.
 *  This uses SetClassWord in a portable way and makes code look tidier.
 *
 *  Entry:  hwnd  Identifies window whose brush is to be changed.
 *       handle   Handle to the new brush.
 *
 */
void 
SetHandleBkBrush (HWND hwnd, HBRUSH handle)
{
#ifdef _WIN32
  SetClassLong (hwnd, GCL_HBRBACKGROUND, (LONG) handle);
#else
  SetClassWord (hwnd, GCW_HBRBACKGROUND, (WORD) handle);
#endif
}

/*--- Function ScrollToOrd ---------------------------------------
 *
 *  Converts the position on the Vertical or Horizontal Scroll Bar from a 
 *  relative screen position into a line location of the newsgroup in the 
 *  window, the article in the group window or the line of an article.  This 
 *  conversion is necessary because Windows scroll bars can't exceed 32K 
 *  elements but the number of newsgroups, article numbers or lines in a 
 *  message can. Hopefully, the Horizontal Scroll bar doesn't need this but
 *  we use it anyway to be safe. (JD 1/9/97) */ 

unsigned long
ScrollToOrd (unsigned long MaxLinesOrChars, int ScrollPos) {
if (MaxLinesOrChars <= 10000) { 
    	return((unsigned long) ScrollPos);
    }
    else {
        return (min (MaxLinesOrChars, (unsigned long) (MaxLinesOrChars * (float) ScrollPos/10000)));
    }
 }   
 
/*--- Function OrdToScroll ---------------------------------------
 *
 *  Converts the active newsgroup index in the newsgroup list, article index
 *  in the Group window or line index in the article window into its relative
 *  position on the Vertical or Horizontal Scroll Bar.  This conversion is necessary
 *  because Windows scroll bars can't exceed 32K elements but the number of
 *  newsgroups, article numbers or lines in a message can. (JD 1/9/97) */

int
OrdToScroll (unsigned long MaxLinesOrChars, unsigned long LineOrd) {
if (MaxLinesOrChars <= 10000) { 
    	return((int) LineOrd);
    }
    else {
        return (min (9999, (int) (LineOrd * (float) 10000/MaxLinesOrChars)));
    }
}

/*-- Last Line of WVSCREEN.C ----------------- */
@


1.23
log
@fixed scrolling problems when object to scroll is larger than
32K.  There is still some bugs if horizontal scrolling of
a single line exceeds 32K.
@
text
@d2 1
a2 1
 * $Id: wvscreen.c 1.22 1996/08/13 05:03:26 dumoulin Exp $
d949 1
a949 1
if (MaxLinesOrChars <= 1000) { 
d967 1
a967 1
if (MaxLinesOrChars <= 1000) { 
@


1.22
log
@modifications to support header editing
@
text
@d2 1
a2 1
 * $Id: wvscreen.c 1.21 1994/11/30 22:22:08 jcooper Exp $
d32 2
a33 2
	 int nLines;
	 int LinesOnScreen;
d36 1
a36 1
	 int *LinesAdvanced;
d40 1
a40 2
  int LinesGone;
  int TestAdvance;
d89 1
a89 1
	 int nLines;
d92 1
a92 1
	 int *LinesBackedUp;
d123 1
a123 1
  int LinesGone;
d154 1
a154 1
	  ScrollWindow (Document->hDocWnd, 0, LinesGone * window_lineheight, NULL, NULL);
d157 1
a157 1
	  Rect.bottom = window_topspace + LinesGone * window_lineheight;
d191 2
a192 2
	  ScrollWindow (Document->hDocWnd, 0, -LinesGone * window_lineheight, NULL, NULL);
	  Rect.top = window_topspace + (Document->ScYLines - LinesGone) * window_lineheight;
d248 1
a248 1
#ifdef WIN32
a252 5
/*       if (!FindLineOrd (Document, LineOrd, &BlockPtr, &LinePtr))
   {
   return;
   }
 */
d256 2
a257 1
	Document->TopLineOrd = LineOrd;
d263 1
a263 1
#ifdef WIN32
d268 2
a269 6
/*      if (!FindLineOrd (Document, LineOrd, &BlockPtr, &LinePtr))
   {
   return;
   }
 */
	LinesGone = LineOrd - Document->TopLineOrd;
d272 1
a272 1
	  if (LinesGone >= (int) (Document->ScYLines - 1)) {
d281 1
a281 1
	  if (LinesGone >= (int) (Document->ScYLines - 1)) {
d295 1
a295 4

/*  UnlockLine (BlockPtr, LinePtr, &(Document->hCurTopScBlock),
   &(Document->TopScOffset), &(Document->TopScLineID));
 */
a296 1
}
d314 1
a314 1
  int LinesGone;
d340 1
a340 1
	  ScrollWindow (Document->hDocWnd, 0, LinesGone * (window_lineheight), NULL, NULL);
d343 1
a343 1
	  Rect.bottom = window_topspace + LinesGone * window_lineheight;
d362 2
a363 2
	  ScrollWindow (Document->hDocWnd, 0, -LinesGone * (window_lineheight), NULL, NULL);
	  Rect.top = window_topspace + (Document->ScYLines - LinesGone) * window_lineheight;
d383 1
a383 2
	AdvanceToActive (&BlockPtr, &LinePtr);
// shimomai
d399 1
a399 1
#ifdef WIN32
d404 1
a404 1
	if (!FindLineOrd (Document, LineOrd, &BlockPtr, &LinePtr)) {
d410 2
a411 1
	Document->TopLineOrd = LineOrd;
d417 1
a417 1
#ifdef WIN32
d422 1
a422 1
	if (!FindLineOrd (Document, LineOrd, &BlockPtr, &LinePtr)) {
d426 1
a426 1
	LinesGone = LineOrd - Document->TopLineOrd;
d543 1
a543 2
	  Document->ScXOffset = Document->LongestLine -
		Document->ScXChars;
d937 37
@


1.21
log
@93.9 changes
@
text
@d2 1
a2 1
 * $Id: wvscreen.c 1.20 1994/11/21 21:20:46 jcooper Exp $
d397 9
a405 1
	ScreenDown (Document->ScYLines - 1, Document->ScYLines,
d407 2
a408 1
	Document->TopLineOrd += LinesGone;
d505 2
a506 1
	  Rect.right = -Rect.left;
d529 4
a532 2
	  Rect.right = Rect.left;
	  Rect.left = 0;
@


1.20
log
@93.7 update
@
text
@d2 1
a2 1
 * $Id: wvscreen.c 1.19 1994/11/10 23:00:19 jcooper Exp $
d551 9
a560 1

d566 2
a569 3
	InvalidateRect (Document->hDocWnd, NULL, FALSE);
	break;

d783 2
d831 1
d860 1
d884 1
@


1.19
log
@93.5 update
@
text
@d2 1
a2 1
 * $Id: wvscreen.c 1.18 1994/11/10 01:51:34 rushing Exp $
d126 1
a126 1
  RECT Rect;
d259 2
d279 1
d412 2
d429 1
a454 1

@


1.18
log
@restart
@
text
@d498 2
a499 1
	if (Document->ScXOffset < Document->LongestLine - Document->ScXChars) {
@
