head	1.1;
access;
symbols;
locks; strict;
comment	@ * @;


1.1
date	97.02.06.17.35.43;	author dumoulin;	state Exp;
branches;
next	;


desc
@WinVN splash screen.  Off in standard compile
@


1.1
log
@Initial revision
@
text
@/* Module to add a splash screen */

#include <windows.h>
#include <windowsx.h>
#include "wvglob.h"
#include "winvn.h"
#pragma hdrstop
#define IDD_PAINT     30     /* The static control onto which we paint */

/* This is the function you call.  Call it from WinMain, with the    */
/* owner hInstance and hwnd, and an integer of the number of seconds */
/* the Splash screen should appear.                                  */
void DisplaySplashScreen (HINSTANCE hInstance, HWND hwnd, int delay);

/* Don't call any of the following */
BOOL FAR PASCAL _export SplashDlgProc (HWND, UINT, UINT, LONG) ;
void PaintWindow   (HWND hwnd);

HWND hDlgModeless ;
HBITMAP   hb;

/*------------------------------*/
/* Function DisplaySplashScreen */
/*------------------------------*/

void DisplaySplashScreen (HINSTANCE hInstance, HWND hwnd, int delay)
     {
     int         i;
     DWORD       dwTicks;
     FARPROC     dlgProc;
     
     /* Do nothing if number not in range 1-9 seconds */
     if (delay < 1 || delay > 9) return;

     /* Get the bitmap resource, "Splash", in, and make the dialog */
     hb = LoadBitmap(hInstance, "Splash");
     dlgProc = MakeProcInstance ((FARPROC) SplashDlgProc, hInstance);
     hDlgModeless = CreateDialog (hInstance, "SplashDlg", hwnd, (DLGPROC)dlgProc);

     /* Wait for splash to subside */
     dwTicks = GetTickCount();
     for (i=0;i<1;i++)  /* no of seconds = delay */
	 { 
	 while ( GetTickCount() < dwTicks+(1000 * delay) );
	 dwTicks += 1000;
	 } 

     /* Tell it to zap the splash screen */
     SendMessage(hDlgModeless, WM_CLOSE, 0, 0);
     FreeProcInstance(dlgProc);
     DeleteObject(hb);
} /* End of DisplaySplashScreen */

/*----------------------------------------------------------------------*/

BOOL FAR PASCAL _export SplashDlgProc (HWND hDlg, UINT message, UINT wParam,
							      LONG lParam)
/* See 'DialogProc' in SDK help for info on this sort of function */
     {
     HWND         hwndParent;
     BITMAP       bm;
     static HWND  hCtrlBlock ;

     switch (message)
	  {
	  case WM_INITDIALOG:
	    /* Do things to the parent - like hide it, or disable it */
	    hwndParent = GetParent( hDlg);
	    /* EnableWindow( hwndParent, FALSE ); */

	    /* Centre the Splash dialog */
	    GetObject(hb, sizeof(BITMAP), &bm);
		MoveWindow( hDlg,
				(xScreen - bm.bmWidth) >> 1,
				(yScreen - bm.bmHeight) >> 1,
				bm.bmWidth, bm.bmHeight, 0 );

	    /* Get a handle to the frame we're using for alignment */
	    hCtrlBlock = GetDlgItem (hDlg, IDD_PAINT) ;
		MoveWindow( hCtrlBlock, 0, 0,
				bm.bmWidth, bm.bmHeight, 0 );
	    SetFocus (hCtrlBlock) ;
	  return FALSE ;

	  case WM_PAINT:
	       PaintWindow (hCtrlBlock) ;
	       return FALSE;

	  case WM_CLOSE:
	    DestroyWindow(hDlg);
	  return 0L;
	  }
     return FALSE ;
     }
/*----------------------------------------------------------------------*/

void PaintWindow (HWND hwnd)
     {
     HDC          hdc, BitsDC;
     HBITMAP      ob;
     BITMAP       bm;

     InvalidateRect (hwnd, NULL, TRUE) ;
     UpdateWindow (hwnd) ;
     hdc = GetDC (hwnd) ;
     BitsDC = CreateCompatibleDC(hdc);
     GetObject(hb, sizeof(BITMAP), &bm);
     ob = SelectObject(BitsDC, hb);
     BitBlt(hdc, 0, 0, bm.bmWidth, bm.bmHeight,
	    BitsDC, 0, 0, SRCCOPY);
     SelectObject(BitsDC, ob);
     DeleteDC(BitsDC);
     ReleaseDC (hwnd, hdc) ;
     }
/*----------------------------------------------------------------------*/

@
