head	1.8;
access;
symbols;
locks; strict;
comment	@// @;


1.8
date	97.03.18.19.30.04;	author dumoulin;	state Exp;
branches;
next	1.7;

1.7
date	97.03.07.02.25.53;	author dumoulin;	state Exp;
branches;
next	1.6;

1.6
date	97.02.28.19.25.40;	author dumoulin;	state Exp;
branches;
next	1.5;

1.5
date	97.02.28.01.22.07;	author dumoulin;	state Exp;
branches;
next	1.4;

1.4
date	97.02.14.20.11.48;	author dumoulin;	state Exp;
branches;
next	1.3;

1.3
date	97.02.14.20.05.27;	author dumoulin;	state Exp;
branches;
next	1.2;

1.2
date	97.02.08.11.25.02;	author dumoulin;	state Exp;
branches;
next	1.1;

1.1
date	97.02.06.21.16.31;	author dumoulin;	state Exp;
branches;
next	;


desc
@new string handling routines using c++ objects
@


1.8
log
@Harvey moved the Latest structure and also took out
all exception handling code.
@
text
@/* Filename: WVString.cpp */

/*
* $Id: wvstring.cpp 1.7 1997/03/07 02:25:53 dumoulin Exp $
 */

#include <windows.h>
#include <windowsx.h>
#include "wvglob.h"
#include "winvn.h"

#pragma hdrstop

#include <limits.h>
#include "wvclass.h"

// WVString memory management

WMemPool WVString::m_ClassPool(sizeof(WVString), POOLBLOCKSIZE / sizeof(WVString));

WMemPool Pool16 ( 16, POOLBLOCKSIZE / 16);
WMemPool Pool24 ( 24, POOLBLOCKSIZE / 24);
WMemPool Pool32 ( 32, POOLBLOCKSIZE / 32);
WMemPool Pool48 ( 48, POOLBLOCKSIZE / 48);
WMemPool Pool64 ( 64, POOLBLOCKSIZE / 64);
WMemPool Pool80 ( 80, POOLBLOCKSIZE / 80);
WMemPool Pool96 ( 96, POOLBLOCKSIZE / 96);
WMemPool Pool112(112, POOLBLOCKSIZE /112);
WMemPool Pool128(128, POOLBLOCKSIZE /128);
WMemPool Pool160(160, POOLBLOCKSIZE /160);
WMemPool Pool192(192, POOLBLOCKSIZE /192);
WMemPool Pool256(256, POOLBLOCKSIZE /256);

LATEST Latest;

void*WVString::operator new(size_t size)
{
#ifdef _DEBUG
  if(size != sizeof(WVString))
  {
    DEBUG_BREAK; //  derived classes must provide their own operator new
  }
#endif

  return m_ClassPool.AllocElement();
}


void WVString::operator delete(void*p)
{
#ifdef _DEBUG
  if(p == 0)  // this should never happen...
  {
    DEBUG_BREAK;
    return;
  }
#endif
  m_ClassPool.FreeElement(p);
}


WVString::WVString(const char*s, const uint32 uLen)
{
  if(s)
  {
    if(uLen)
    {
      m_data = new char[1 + uLen];
      if(m_data)
      {
        strncpy(m_data, s, uLen);
        m_data[uLen] = '\0';
      }
    }
    else
    {
      m_data = new char[1+strlen(s)];
      if(m_data)
        strcpy(m_data, s);
    }
  }
  else
  {
    m_data = new char[1];
    if(m_data)
      *m_data = '\0';
  }
}


//WVString::WVString(const WVString&rhs)
//{
//  m_data = new char[1 + strlen(rhs.m_data)];
//  if(m_data)
//    strcpy(m_data, rhs.m_data);
//}
//    Add a few extra checks - JD 2/14/97

WVString::WVString(const WVString&rhs)
{
  int ilen;
  
  if (rhs.m_data) {
    ilen = strlen(rhs.m_data);
    if (ilen > 0) {
      m_data = new char[1 + strlen(rhs.m_data)];
      if(m_data)
        strcpy(m_data, rhs.m_data);
    }
  }
  else {
    m_data = new char[1];
    if(m_data)
      *m_data = '\0';
  }
}



WVString::WVString(const WVString&lhs, const WVString&rhs)
{
  m_data = new char[1 + strlen(lhs.m_data) + strlen(rhs.m_data)];
  if(m_data)
  {
    strcpy(m_data, lhs.m_data);
    strcat(m_data, rhs.m_data);
  }
}


WVString::~WVString()
{
  delete [] m_data;
}


WVString& WVString::operator=(const WVString& rhs)
{
  uint32 iNewSize;

  //if(strcmp(m_data, rhs.m_data) != 0) // value compare
  if(this != &rhs) // address compare
  {
    if(rhs.m_data) {
	  iNewSize = 1 + strlen(rhs.m_data);
      if(AllocSize() < iNewSize)
      {
        delete [] m_data;
        m_data = new char[iNewSize];
      }
      if(m_data)
        strcpy(m_data, rhs.m_data);
    }
    else
    {
      if(!m_data)
      {
        m_data = new char[1];
      }
      if(m_data)
        *m_data = '\0';
    }
  }
  return *this;
}


WVString& WVString::operator=(const char* rhs)
{
  uint32 iNewSize;
  
  //if((rhs) && (strlen(rhs) > 0))           // JD 2/14/97
  if(rhs)  // okay if strlen(rhs) == 0
  {
    iNewSize = 1 + strlen(rhs);
    if(AllocSize() < iNewSize)
    {
      delete [] m_data;
      m_data = new char[iNewSize];
    }
    if(m_data)
      strcpy(m_data, rhs);
  }
  else
  {
    if(!m_data)
    {
      m_data = new char[1];
    }
    if(m_data)
      *m_data = '\0';
  }
  return *this;
}


WVString& WVString::operator+=(const WVString& rhs)
{
  char*tmp;
  uint32 iNewSize = 1 + strlen(m_data) + strlen(rhs.m_data);
  
  if(iNewSize > AllocSize())
  {
    tmp = new char[iNewSize];
    if(tmp)
    {
      strcpy(tmp, m_data);
      strcat(tmp, rhs.m_data);
      delete [] m_data;
      m_data = tmp;
    }
  }
  else
  {
    strcat(m_data, rhs.m_data);
  }
  return *this;
}


WVString& WVString::operator+=(const char* rhs)
{
  if(rhs)
  {
    char*tmp;
    uint32 iNewSize = 1 + strlen(m_data) + strlen(rhs);

    if(iNewSize > AllocSize())
    {
      tmp = new char[iNewSize];
      if(tmp)
      {
        strcpy(tmp, m_data);
        strcat(tmp, rhs);
        delete [] m_data;
        m_data = tmp;
      }
    }
    else
    {
      strcat(m_data, rhs);
    }
  }
  return *this;
}


uint32 WVString::AllocSize()
{
  NewStruct* pNS = (NewStruct*) m_data;
  if(!pNS)
    return 0;
  pNS--;
  return pNS->iAllocSize;
}


/*

  C++ Memory management routines

  Written July 1996 H. Brydon

*/


// C++ fixed size memory pool implementation

WMemPool::WMemPool(uint32 uElementSize, unsigned uNumElements)
: m_FreeList(NULL), m_pBlock(NULL),
  m_uElmSize(((uElementSize + sizeof(WMemPool::MemPoolElement)-1) /
    sizeof(WMemPool::MemPoolElement)) * sizeof(WMemPool::MemPoolElement)),
  m_uBlkSize(uNumElements * m_uElmSize)
{
#ifdef _DEBUG
  if(!(m_uElmSize && m_uBlkSize))
    DEBUG_BREAK;
#endif
  //AllocBlock();
}


WMemPool::~WMemPool()
{
  MemPoolBlock*p;

  while(m_pBlock)
  {
#ifdef DEBUGMEMUSAGE
    TRACE2("AllocBlock(): Block of size %u/%u freed\n",
      m_uElmSize, m_uBlkSize);
#endif
    p = m_pBlock->next;
    //delete m_pBlock;
    GlobalFreePtr(m_pBlock);
    m_pBlock = p;
  }
}


void WMemPool::AllocBlock()  // 335.11
{
  unsigned iSize = sizeof(MemPoolBlock) + m_uBlkSize;
  unsigned num;

  MemPoolBlock* pBlk = (MemPoolBlock *) GlobalAllocPtr(GMEM_FIXED, iSize);
  if(pBlk)
  {
#ifdef DEBUGMEMUSAGE
    TRACE3("AllocBlock(): Block of size %u/%u (%u total) allocated\n",
      m_uElmSize, m_uBlkSize, iSize);
#endif    
    pBlk->next = m_pBlock;
    m_pBlock = pBlk;
    MemPoolElement*pe = &pBlk->pe;

    num = m_uBlkSize/m_uElmSize;
    while(--num > 0)
    {
      pe->next = (MemPoolElement*) ((char*) pe + m_uElmSize);
      pe = pe->next;
    }
    pe->next = m_FreeList;
    m_FreeList = &pBlk->pe;
  }
#ifdef DEBUGMEMUSAGE
  else
  {
    TRACE1("AllocBlock(): No memory for block of size %u!\n", iSize);
    DEBUG_BREAK;
  }
#endif
}


void*operator new(size_t iReqSize)
{
  uint32 iGetSize;
  NewStruct*memory = NULL;
  if(iReqSize == 0)
  {
    iReqSize = 1;
  }
  iGetSize = iReqSize + sizeof(NewStruct);
  
  if(iGetSize <= 16)
  {
    static uint32 iAllocSize = 16 - sizeof(NewStruct);
    if(memory = (NewStruct*) Pool16.AllocElement())
      memory->iAllocSize = iAllocSize;
  }
  else if(iGetSize <= 24)
  {
    static uint32 iAllocSize = 24 - sizeof(NewStruct);
    if(memory = (NewStruct*) Pool24.AllocElement())
      memory->iAllocSize = iAllocSize;
  }
  else if(iGetSize <= 32)
  {
    static uint32 iAllocSize = 32 - sizeof(NewStruct);
    if(memory = (NewStruct*) Pool32.AllocElement())
      memory->iAllocSize = iAllocSize;
  }
  else if(iGetSize <= 48)
  {
    static uint32 iAllocSize = 48 - sizeof(NewStruct);
    if(memory = (NewStruct*) Pool48.AllocElement())
      memory->iAllocSize = iAllocSize;
  }
  else if(iGetSize <= 64)
  {
    static uint32 iAllocSize = 64 - sizeof(NewStruct);
    if(memory = (NewStruct*) Pool64.AllocElement())
      memory->iAllocSize = iAllocSize;
  }
  else if(iGetSize <= 80)
  {
    static uint32 iAllocSize = 80 - sizeof(NewStruct);
    if(memory = (NewStruct*) Pool80.AllocElement())
      memory->iAllocSize = iAllocSize;
  }
  else if(iGetSize <= 96)
  {
    static uint32 iAllocSize = 96 - sizeof(NewStruct);
    if(memory = (NewStruct*) Pool96.AllocElement())
      memory->iAllocSize = iAllocSize;
  }
  else if(iGetSize <= 112)
  {
    static uint32 iAllocSize = 112 - sizeof(NewStruct);
    if(memory = (NewStruct*) Pool112.AllocElement())
      memory->iAllocSize = iAllocSize;
  }
  else if(iGetSize <= 128)
  {
    static uint32 iAllocSize = 128 - sizeof(NewStruct);
    if(memory = (NewStruct*) Pool128.AllocElement())
      memory->iAllocSize = iAllocSize;
  }
  else if(iGetSize <= 160)
  {
    static uint32 iAllocSize = 160 - sizeof(NewStruct);
    if(memory = (NewStruct*) Pool160.AllocElement())
      memory->iAllocSize = iAllocSize;
  }
  else if(iGetSize <= 192)
  {
    static uint32 iAllocSize = 192 - sizeof(NewStruct);
    if(memory = (NewStruct*) Pool192.AllocElement())
      memory->iAllocSize = iAllocSize;
  }
  else if(iGetSize <= 256)
  {
    static uint32 iAllocSize = 256 - sizeof(NewStruct);
    if(memory = (NewStruct*) Pool256.AllocElement())
      memory->iAllocSize = iAllocSize;
  }
  if (!memory)
  {
    if(memory = (NewStruct*) GlobalAllocPtr(GMEM_FIXED, iGetSize))
    {
#ifdef DEBUGMEMUSAGE
      TRACE2("operator new: Memory block of size %u/%u allocated\n",
        iReqSize, iGetSize);
#endif      
      memory->iAllocSize = iGetSize - sizeof(NewStruct);
    }
  }
#ifdef DEBUGMEMUSAGE
  if(memory)
  {
    static uint32 iSeqNo = 0;
    memory->iSeqCtr = ++iSeqNo;
  }
#endif
  return (void*) &memory[1];
}

// A Huge pointer version of the new operator to fix
// allocation problems with Win16. (JD 1/7/97)
#ifdef _WIN32
 void __far *operator new(unsigned int lReqSize, size_t ReqSize1)
#else
 void __huge *operator new(unsigned long lReqSize, size_t ReqSize1)
#endif

{
  unsigned long lGetSize;
  NewStruct*memory = NULL;
  if(lReqSize == 0)          
  {
    lReqSize = 1;
  }
  lGetSize = (lReqSize * ReqSize1) + sizeof(NewStruct);

  if(memory = (NewStruct*) GlobalAllocPtr(GMEM_FIXED, lGetSize))
    {
#ifdef DEBUGMEMUSAGE
      TRACE2("operator new: Memory block of size %lu/%lu allocated\n",
        lReqSize, lGetSize);
#endif      
      memory->iAllocSize = lGetSize - sizeof(NewStruct);
    }
#ifdef DEBUGMEMUSAGE 
  if(memory)
  {
    static int iSeqNo = 0;
    memory->iSeqCtr = ++iSeqNo;
  }
#endif
  return (void*) &memory[1];
}


void operator delete(void*p)
{
  if(p)
  {
    NewStruct* pNS = (NewStruct*) p;
    
    pNS--;
    switch(pNS->iAllocSize)
    {
    case  16 - sizeof(NewStruct):
      Pool16.FreeElement(pNS);
      break;
    case  24 - sizeof(NewStruct):
      Pool24.FreeElement(pNS);
      break;
    case  32 - sizeof(NewStruct):
      Pool32.FreeElement(pNS);
      break;
    case  48 - sizeof(NewStruct):
      Pool48.FreeElement(pNS);
      break;
    case  64 - sizeof(NewStruct):
      Pool64.FreeElement(pNS);
      break;
    case  80 - sizeof(NewStruct):
      Pool80.FreeElement(pNS);
      break;
    case  96 - sizeof(NewStruct):
      Pool96.FreeElement(pNS);
      break;
    case  112 - sizeof(NewStruct):
      Pool112.FreeElement(pNS);
      break;
    case  128 - sizeof(NewStruct):
      Pool128.FreeElement(pNS);
      break;
    case  160 - sizeof(NewStruct):
      Pool160.FreeElement(pNS);
      break;
    case  192 - sizeof(NewStruct):
      Pool192.FreeElement(pNS);
      break;
    case  256 - sizeof(NewStruct):
      Pool256.FreeElement(pNS);
      break;
    default:
#ifdef DEBUGMEMUSAGE
      TRACE1("operator delete: Memory block of size %lu being freed\n",
        pNS->iAllocSize + sizeof(NewStruct));
#endif
      if ((pNS->iAllocSize < 64000)  && (pNS->iAllocSize > 0))
      {
        GlobalFreePtr(pNS);
      }
      else
      {
        TRACE2("operator delete failed: Memory block of size %lu (Hex %Z08) too big\n",
          pNS->iAllocSize + sizeof(NewStruct), pNS->iAllocSize + sizeof(NewStruct));
        DEBUG_BREAK;
      }
    }
  }
}



@


1.7
log
@moved <limits.h> so that precompiled headers will work.
@
text
@d4 1
a4 1
 * $Id: wvstring.cpp 1.6 1997/02/28 19:25:40 dumoulin Exp $
d11 1
d34 2
d37 1
a37 1
 {
a81 2
 //  Somehow this is causing a GPF when
 //  we are exiting.  (JD 2/17/97)
d83 1
a83 1
 {
d102 1
a102 1

d104 6
a109 6
	 ilen = strlen(rhs.m_data);
	 if (ilen > 0) {
        m_data = new char[1 + strlen(rhs.m_data)];
        if(m_data)
           strcpy(m_data, rhs.m_data);
	 }
d112 3
a114 3
	 m_data = new char[1];
     if(m_data)
       *m_data = '\0';
d119 1
d133 1
a133 1
	delete [] m_data;
a138 1
  //size_t iNewSize; 
d153 10
a162 1
	}
d170 4
a173 3
  uint32 iNewSize; 
   
  if((rhs) && (strlen(rhs) > 0))           // JD 2/14/97
a199 1
 // size_t iNewSize = 1 + strlen(m_data) + strlen(rhs.m_data);
d226 1
a226 2
  //  size_t iNewSize;
    uint32 iNewSize;
a227 1
    iNewSize = 1 + strlen(m_data) + strlen(rhs);
a247 1
//size_t WVString::AllocSize() 
d250 5
a254 18
 // Wrapped an exception handler around this code
 // since this was causing a GPF (JD 2/17/97)
 // 
	NewStruct* pNS = (NewStruct*) m_data;
	if(!pNS)
	 return 0;
#ifdef _WIN32 
	try{ 
#endif
	  pNS--;
	  return pNS->iAllocSize; 
#ifdef _WIN32 
	}
	catch(...){
		return 0;
	}
#endif
 return 0;
d257 1
d275 4
d303 1
a303 1
  unsigned iSize; 
a305 17
  // It shouldn't happen but somehow I was getting a divide by zero 
  // during initialization of WinVN (m_uElmSize was 0).  Called from 
  // WinMainCRTStartup line 196 during C++ Initializations of 
  // _cinit and _initterm.  I placed extra check and just set it to
  // 1 if size is 0. (JD 12/30/96)
  
  if ((m_uBlkSize == 0) || (m_uElmSize == 0)){
#ifdef DEBUGMEMUSAGE
    TRACE2("AllocBlock(): Block size = %u, Element size = %u!\n",
		   m_uBlkSize, m_uElmSize);
//    DEBUG_BREAK;
#endif
  m_uBlkSize = 1;
  m_uElmSize = 1;
  }

  iSize = sizeof(MemPoolBlock) + m_uBlkSize;
d308 1
a308 1
	{
d310 2
a311 2
		TRACE3("AllocBlock(): Block of size %u/%u (%u total) allocated\n",
		m_uElmSize, m_uBlkSize, iSize);
d313 13
a325 12
		pBlk->next = m_pBlock;
		m_pBlock = pBlk;
		MemPoolElement*pe = &pBlk->pe;
		num = m_uBlkSize/m_uElmSize;
		while(--num > 0)
		{
		  pe->next = (MemPoolElement*) ((char*) pe + m_uElmSize);
		  pe = pe->next;
		}
		pe->next = m_FreeList;
		m_FreeList = &pBlk->pe;
     }
d340 1
a340 1
  if(iReqSize == 0)          
d418 1
a418 2
  // do a catchall for larger memory sizes - (JD 2/20/97)
  else if(iGetSize <= INT_MAX)
d420 1
a420 1
	if(memory = (NewStruct*) GlobalAllocPtr(GMEM_FIXED, iGetSize))
d427 1
a427 13
	}
  }

  if (!memory)
  {
//    if(memory = (NewStruct*) GlobalAllocPtr(GMEM_FIXED, iGetSize))
//    {
#ifdef DEBUGMEMUSAGE
      TRACE2("operator new failed: Memory block of size %u/%u too large\n",
        iReqSize, iGetSize);
#endif      
//      memory->iAllocSize = iGetSize - sizeof(NewStruct);
//    }
d459 1
a459 1
      TRACE2("operator new: Memory block of size %u/%u allocated\n",
d474 1
d477 1
a477 2
  NewStruct* pNS = (NewStruct*) p;
  if(p == 0)
d479 3
a481 6
    return;
  }
#ifdef _WIN32 
  try {
#endif
	pNS--;
d521 2
a522 12
	  // There is still some debuging needed here.  This is a
	  // sanity check because something is going terribly wrong
	  // with iAllocSize and attempting to freeup large chunks
	  // that were never allocated. Seems to happen when
	  // References header has a bogus reference of just <>
	  // This is either really saving us from crashing or
	  // producing one big memory leak.  I don't know how
	  // high a valid iAllocSize can get. (JD 2/14/97)
	  //
	  if ((pNS->iAllocSize < INT_MAX)  && (pNS->iAllocSize > 0)) {
  #ifdef DEBUGMEMUSAGE
      TRACE1("operator delete: Memory block of size %u freed\n",
a523 3
  #endif 
#ifdef _WIN32 
	    try {
d525 12
a536 17
           GlobalFreePtr(pNS);
#ifdef _WIN32 
		}
		catch (...) {
#ifdef DEBUGMEMUSAGE
			TRACE0("operator delete failed: GlobalFreePtr Exception caught\n");
#endif
		}
#endif
	  }
#ifdef DEBUGMEMUSAGE
	  else
      TRACE2("operator delete failed: Memory block of size %lu (Hex %Z08) out of range\n",
        pNS->iAllocSize,pNS->iAllocSize);
#endif
	}
#ifdef _WIN32 
d538 3
a540 7
catch (...) {
#ifdef DEBUGMEMUSAGE
      TRACE0("operator delete failed: Exception caught\n");
#endif
 }
#endif
}
@


1.6
log
@fixed places where string class could gpf on bad header data
@
text
@d4 1
a4 1
 * $Id: wvstring.cpp 1.5 1997/02/28 01:22:07 dumoulin Exp dumoulin $
a8 1
#include <limits.h>
a10 1

d13 2
a14 1
#include "WVClass.h"
@


1.5
log
@add extra error checking to string class
@
text
@d4 1
a4 1
 * $Id: wvstring.cpp 1.4 1997/02/14 20:11:48 dumoulin Exp $
d9 1
d35 1
a35 1
{
d60 1
a60 1
WVString::WVString(const char*s, const size_t uLen)
d103 1
a103 1
  if (rhs && rhs.m_data) {
d139 1
a139 1
  long iNewSize;
d161 1
a161 2
 // size_t iNewSize;
  long iNewSize; 
d191 1
a191 1
    long iNewSize = 1 + strlen(m_data) + strlen(rhs.m_data);
d218 1
a218 1
    long iNewSize;
d242 1
a242 1
long WVString::AllocSize()
d244 1
a244 1
 // Wrapped an execption handler around this code
d250 3
a252 1
	try{
d254 2
a255 1
	  return pNS->iAllocSize;
d260 1
d275 1
a275 1
WMemPool::WMemPool(size_t uElementSize, unsigned uNumElements)
d344 7
d356 1
a356 1
  long iGetSize;
d366 1
a366 1
    static long iAllocSize = 16 - sizeof(NewStruct);
d372 1
a372 1
    static int iAllocSize = 24 - sizeof(NewStruct);
d378 1
a378 1
    static int iAllocSize = 32 - sizeof(NewStruct);
d384 1
a384 1
    static int iAllocSize = 48 - sizeof(NewStruct);
d390 1
a390 1
    static int iAllocSize = 64 - sizeof(NewStruct);
d396 1
a396 1
    static int iAllocSize = 80 - sizeof(NewStruct);
d402 1
a402 1
    static int iAllocSize = 96 - sizeof(NewStruct);
d408 1
a408 1
    static int iAllocSize = 112 - sizeof(NewStruct);
d414 1
a414 1
    static int iAllocSize = 128 - sizeof(NewStruct);
d420 1
a420 1
    static int iAllocSize = 160 - sizeof(NewStruct);
d426 1
a426 1
    static int iAllocSize = 192 - sizeof(NewStruct);
d432 1
a432 1
    static int iAllocSize = 256 - sizeof(NewStruct);
d437 1
a437 1
  else if(iGetSize <= 32000)
d463 1
a463 1
    static int iSeqNo = 0;
d512 1
d514 1
d564 1
a564 1
	  if ((pNS->iAllocSize < 64000)  && (pNS->iAllocSize > 0)) {
d568 13
a580 2
  #endif
        GlobalFreePtr(pNS);
d582 1
a582 1
  #ifdef DEBUGMEMUSAGE
d584 3
a586 3
      TRACE1("operator delete failed: Memory block of size %u out of range\n",
        pNS->iAllocSize);
  #endif
d588 1
d591 1
a591 1
  #ifdef DEBUGMEMUSAGE
d593 1
a593 1
  #endif
d595 1
@


1.4
log
@Add extra checks for bad strings
@
text
@d4 1
a4 1
 * $Id: wvstring.cpp 1.3 1997/02/06 17:31:01 dumoulin Exp $
a15 1

d20 12
d79 2
d82 1
a82 1
  {
d110 5
a117 1

a130 2
  if(m_data)                // extra check JD 2/24/97
  {
a131 1
  }
d143 10
a152 8
    iNewSize = 1 + strlen(rhs.m_data);
    if(AllocSize() < iNewSize)
    {
      delete [] m_data;
      m_data = new char[iNewSize];
    }
    if(m_data)
      strcpy(m_data, rhs.m_data);
d163 1
a163 1
  if(rhs)
d244 14
a257 5
  NewStruct* pNS = (NewStruct*) m_data;
  if(!pNS)
    return 0;
  pNS--;
  return pNS->iAllocSize;
d301 1
a301 1
  unsigned iSize = sizeof(MemPoolBlock) + m_uBlkSize;
d304 17
d323 1
a323 1
  {
d325 2
a326 2
    TRACE3("AllocBlock(): Block of size %u/%u (%u total) allocated\n",
      m_uElmSize, m_uBlkSize, iSize);
d328 3
a330 11
    pBlk->next = m_pBlock;
    m_pBlock = pBlk;
    MemPoolElement*pe = &pBlk->pe;

	// It shouldn't happen but somehow this gave me a divide by zero 
        // during initialization of WinVN (m_uElmSize was 0).  Called from 
        // WinMainCRTStartup line 196 during C++ Initializations of 
        // _cinit and _initterm.  I placed extra check for divide by zero.
        //  (JD 12/30/96)

	if (m_uElmSize > 0) {
d334 2
a335 2
		pe->next = (MemPoolElement*) ((char*) pe + m_uElmSize);
		pe = pe->next;
d339 1
a339 14
	}
	else {
#ifdef DEBUGMEMUSAGE
    TRACE1("AllocBlock(): No memory for block of size %u!\n", iSize);
    DEBUG_BREAK;
#endif
	// JD 2/13/97 test code to stop GPF
   	    pe->next = (MemPoolElement*) ((char*) pe);
		pe = pe->next;
		pe->next = m_FreeList;
		m_FreeList = &pBlk->pe;
  }
  }

a342 13
WMemPool Pool16 ( 16, POOLBLOCKSIZE / 16);
WMemPool Pool24 ( 24, POOLBLOCKSIZE / 24);
WMemPool Pool32 ( 32, POOLBLOCKSIZE / 32);
WMemPool Pool48 ( 48, POOLBLOCKSIZE / 48);
WMemPool Pool64 ( 64, POOLBLOCKSIZE / 64);
WMemPool Pool80 ( 80, POOLBLOCKSIZE / 80);
WMemPool Pool96 ( 96, POOLBLOCKSIZE / 96);
WMemPool Pool112(112, POOLBLOCKSIZE /112);
WMemPool Pool128(128, POOLBLOCKSIZE /128);
WMemPool Pool160(160, POOLBLOCKSIZE /160);
WMemPool Pool192(192, POOLBLOCKSIZE /192);
WMemPool Pool256(256, POOLBLOCKSIZE /256);

d425 2
a426 1
  if (!memory)
d428 1
a428 1
    if(memory = (NewStruct*) GlobalAllocPtr(GMEM_FIXED, iGetSize))
d435 13
a447 1
    }
d501 62
a562 55
  pNS--;
  switch(pNS->iAllocSize)
  {
  case  16 - sizeof(NewStruct):
    Pool16.FreeElement(pNS);
    break;
  case  24 - sizeof(NewStruct):
    Pool24.FreeElement(pNS);
    break;
  case  32 - sizeof(NewStruct):
    Pool32.FreeElement(pNS);
    break;
  case  48 - sizeof(NewStruct):
    Pool48.FreeElement(pNS);
    break;
  case  64 - sizeof(NewStruct):
    Pool64.FreeElement(pNS);
    break;
  case  80 - sizeof(NewStruct):
    Pool80.FreeElement(pNS);
    break;
  case  96 - sizeof(NewStruct):
    Pool96.FreeElement(pNS);
    break;
  case  112 - sizeof(NewStruct):
    Pool112.FreeElement(pNS);
    break;
  case  128 - sizeof(NewStruct):
    Pool128.FreeElement(pNS);
    break;
  case  160 - sizeof(NewStruct):
    Pool160.FreeElement(pNS);
    break;
  case  192 - sizeof(NewStruct):
    Pool192.FreeElement(pNS);
    break;
  case  256 - sizeof(NewStruct):
    Pool256.FreeElement(pNS);
    break;
  default:
	// There is still some debuging needed here.  This is a
	// sanity check because something is going terribly wrong
	// with iAllocSize and attempting to freeup large chunks
	// that were never allocated. Seems to happen when
	// References header has a bogus reference of just <>
	// This is either really saving us from crashing or
	// producing one big memory leak.  I don't know how
	// high a valid iAllocSize can get. (JD 2/14/97)
	//
	if ((pNS->iAllocSize < 64000)  && (pNS->iAllocSize > 0)) {
#ifdef DEBUGMEMUSAGE
    TRACE1("operator delete: Memory block of size %u freed\n",
      pNS->iAllocSize + sizeof(NewStruct));
#endif
      GlobalFreePtr(pNS);
d564 6
a569 6
#ifdef DEBUGMEMUSAGE
	else
    TRACE1("operator delete failed: Memory block of size %u too big\n",
      pNS->iAllocSize + sizeof(NewStruct));
#endif
  }
@


1.3
log
@add extra checks for strings of zero length
@
text
@d3 4
d75 8
a82 8


//WVString::WVString(const WVString&rhs)
//{
//  m_data = new char[1 + strlen(rhs.m_data)];
//  if(m_data)
//    strcpy(m_data, rhs.m_data);
//}
d86 6
a91 6
{
  int ilen;

  if (rhs && rhs.m_data) {
	 ilen = strlen(rhs.m_data);
	 if (ilen > 0) {
d94 2
a95 2
           strcpy(m_data, rhs.m_data);
	 }
d113 2
a114 2
{
  if(m_data)                // extra check JD 2/24/97
d116 1
a116 1
	delete [] m_data;
d305 11
a315 11
	}
	else {
#ifdef DEBUGMEMUSAGE
    TRACE1("AllocBlock(): No memory for block of size %u!\n", iSize);
    DEBUG_BREAK;
#endif
	// JD 2/13/97 test code to stop GPF
   	    pe->next = (MemPoolElement*) ((char*) pe);
		pe = pe->next;
		pe->next = m_FreeList;
		m_FreeList = &pBlk->pe;
d519 14
a532 14
  default:
	// There is still some debuging needed here.  This is a
	// sanity check because something is going terribly wrong
	// with iAllocSize and attempting to freeup large chunks
	// that were never allocated. Seems to happen when
	// References header has a bogus reference of just <>
	// This is either really saving us from crashing or
	// producing one big memory leak.  I don't know how
	// high a valid iAllocSize can get. (JD 2/14/97)
	//
	if ((pNS->iAllocSize < 64000)  && (pNS->iAllocSize > 0)) {
#ifdef DEBUGMEMUSAGE
    TRACE1("operator delete: Memory block of size %u freed\n",
      pNS->iAllocSize + sizeof(NewStruct));
d534 6
a539 6
      GlobalFreePtr(pNS);
	}
#ifdef DEBUGMEMUSAGE
	else
    TRACE1("operator delete failed: Memory block of size %u too big\n",
      pNS->iAllocSize + sizeof(NewStruct));
@


1.2
log
@optimize C++ class to support variable length strings
@
text
@d71 9
a80 1

d82 11
a92 4
{
  m_data = new char[1 + strlen(rhs.m_data)];
  if(m_data)
    strcpy(m_data, rhs.m_data);
d109 5
a113 2
{
  delete [] m_data;
d301 11
a311 1
	}
a312 5
#ifdef DEBUGMEMUSAGE
  else
  {
    TRACE1("AllocBlock(): No memory for block of size %u!\n", iSize);
    DEBUG_BREAK;
d314 1
a314 1
#endif
d515 21
a535 4
  default:
#ifdef DEBUGMEMUSAGE
    TRACE1("operator delete: Memory block of size %u freed\n",
      pNS->iAllocSize + sizeof(NewStruct));
a536 1
    GlobalFreePtr(pNS);
@


1.1
log
@Initial revision
@
text
@d131 1
a131 1
      m_data = new char[1 + strlen(rhs)];
d268 5
a272 4
	// Harvy, this gave me a divide by zero during initialization
	// of WinVN.  CAlled from WinMainCRTStartup line 196
	// during C++ Initializations of _cinit and _initterm   (JD 12/30/96)
	// I placed extra check for divide by zero.
@
