#! /usr/local/bin/python
# fixes RCS dates so GNU rcs5.6 can handle them.

import sys
import os
import regex
import regsub

# transform '1994.01.21.23.17.18' to '94.01.21.23.17.18'
date_fixer = '19\(..\)\.\([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+\)'

def usage ():
	print 'fixrcs.py file1 [file2]'
	sys.exit()

if len(sys.argv) < 2:
	usage()
	
fin = open(sys.argv[1], 'r')

if len(sys.argv) == 2:
	outname = 'tmp.'+str(os.getpid())
else:
	outname = sys.argv[2]

fout = open(outname, 'w')


while 1:
	line = fin.readline()
	if line == '':
		break
	fout.write (regsub.sub(date_fixer, '\\1.\\2', line))

fin.close()
fout.close()

if len(sys.argv) == 2:
	os.unlink (sys.argv[1])
	os.rename (outname, sys.argv[1])
	
