/*
 * $Id: winvn.c 1.81 1997/02/08 11:09:43 dumoulin Exp $
 */

/*  WinVn.c
 *  This program is a visual Usenet news reader for Microsoft Windows.
 *  It bears a vague similarity to the Unix program "vn"; hence the
 *  name WINVN.
 *
 *  WinVN talks NNTP (Network News Transfer Protocol) to a news
 *  server, which must be running the NNTP program.
 *
 *  NNTP servers for many platforms are freely available.
 *
 *  For more information, see WINVN.WRI and WVDOC.C.
 *
 *  Mark Riordan    September - October 1989    riordanmr@clvax1.cl.msu.edu
 *  1100 Parker  Lansing, MI  48912
 *  
 *  Major modifications and additions were made by Sam Rushing and Jim Dumoulin
 *  of NASA/Kennedy Space Center.  WinVN is currently being maintained by Jim
 *  Dumoulin and a number of folks on the WinVN mailing list.  For more information
 *  send e-mail to "winvn@news.ksc.nasa.gov"   */

#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#define WINMAIN
#include "wvglob.h"
#include "winvn.h"
#include "ctype.h"
#include "defaults.h"			// default profile settings
#include <stdlib.h>
#include <time.h>               // for TimeZone info
#include <io.h>					// for _access
#ifdef COMMCTRL         // For ToolTips if available
#include <commctrl.h>
#else
#include "wvtb\wvtb.h"			// for toolbar
#endif
#ifdef USE_3D_CONTROLS
#include "ctl3d.h"
#endif

void ReadWinvnProfile ();

// (jsc) undefine this when pre v.90 is obsolete
#define PROFILE_PRE90_UPGRADE
void UpgradePre90Profile ();

// (jsc) undefine this when pre v.93 is obsolete
#define PROFILE_PRE93_UPGRADE
void UpgradePre93Profile ();

/*--- function WinMain -----------------------------------------------
 *
 *  Main program for WinVN.
 *  Initialize, then execute main loop.
 *
 *    Entry    hInstance      is a handle to this instance of execution
 *                            of this program.
 *             hPrevInstance  is a handle to a previous instance
 *                            of execution of this program (usually
 *                            0, i.e., none.  Few people would have
 *                            two copies of WinVN running simultaneously.)
 *             lpCmdLine      points to the command line--currently
 *                            not used.  (Not to useful for Windows programs.)
 *             nCmdShow       is a flag indicating that the main window
 *                            should be displayed.  (Fairly worthless.)
 */

int PASCAL
WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
  int x, y, width, height;
  char mybuf[MAXINTERNALLINE];
#ifdef _WIN32
  OSVERSIONINFO osv;
#endif

#ifdef USE_3D_CONTROLS
  Ctl3dRegister (hInstance);
  Ctl3dAutoSubclass (hInstance);
#endif

#ifdef COMMCTRL
  InitCommonControls();
#endif

  if (!hPrevInstance)
	if (!WinVnInit (hInstance, lpCmdLine)) {
#ifdef USE_3D_CONTROLS
	  Ctl3dUnregister (hInstance);
#endif
	if (GroupFilter)
	  GlobalFreePtr (GroupFilter);
	return (0);
  }

  hInst = hInstance;

  /* Initialize the document that will contain the list of          */
  /* newsgroups.  This will be the main window.                     */

  InitDoc (&NetDoc, (HWND) 0, (TypDoc *) NULL, DOCTYPE_NET);

  /* Create and display the main window.  At first, the window      */
  /* just has an initialization message in it.                      */

  /* Compute default window position and size. */
  x = 0;
  y = 0;
  width = (int) (xScreen * 1 / 2);
  height = (int) (yScreen * 9 / 10);

  /* If the window position and size have been saved, use that
   * info instead.
   */
  GetPrivateProfileString (GROUPLIST, "UsenetWindowPos", "!",
						   mybuf, MAXINTERNALLINE, szAppProFile);
  if (mybuf[0] != '!') {
	sscanf (mybuf, "%d,%d,%d,%d", &x, &y, &width, &height);
  }

  NetDoc.hWndFrame = CreateWindow ("WinVnFrame",
								   "WinVN -- Usenet News Reader",
								   WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
								   x,	/* Initial X position */
								   y,	/* Initial Y position */
								   width,	/* Initial X width */
								   height,	/* Initial Y height */
								   NULL,
								   NULL,
								   hInstance,
								   NULL);

  if (!NetDoc.hWndFrame) {
#ifdef USE_3D_CONTROLS
	Ctl3dUnregister (hInstance);
#endif
	if (GroupFilter)
	  GlobalFreePtr (GroupFilter);
	return (0);
  }
  
#ifdef _WIN32
  /* can't make toolbar work in Win32s, so lets not run */
//if (GetVersion () & 0x80000000) {
  osv.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
  GetVersionEx(&osv);
  if (osv.dwPlatformId == VER_PLATFORM_WIN32s) {
	MessageBox (NetDoc.hWndFrame,
				"There is no advantage to running the \n" \
				"32 bit version of WinVN under Win32s \n" \
				"In fact, it is less functional, so...\n" \
				"\n" \
				"   Please run the 16 bit version!    ",
				"Please run the 16 bit version!", MB_OK | MB_ICONSTOP);
	DestroyWindow (NetDoc.hWndFrame);
  }
  else {
#endif

	InitStatBar (&StatbarPntData);

	ShowWindow (NetDoc.hWndFrame, nCmdShow);

	SetHandleBkBrush (NetDoc.hDocWnd, hListBackgroundBrush);
	SetUserMenus (&NetDoc, DISABLE);	// menus disabled until connection made

//  hConfWnd = NetDoc.hDocWnd;
	//  NetDoc.hDocWnd = hWnd;   /* mrr */
	//  NetDoc.hWndFrame = hParentWnd;  /* jlg */

	/* Make sure we have a host name (JSC) */
	while (NNTPHost[0] == '\0' || !strcmp (NNTPHost, DEF_NNTPHost))
	  if (!DialogBox (hInst, (LPCSTR) "WinVnComm", NetDoc.hWndFrame, (DLGPROC) lpfnWinVnCommDlg))
		break;


	/* Make sure we have a valid user name (JD) */
	while (UserName[0] == '\0' || !strcmp (UserName, DEF_UserName)
		   || !strcmp (UserName, "Unknown"))
	  if (!DialogBox (hInst, (LPCSTR) "WinVnPersonal", NetDoc.hWndFrame, (DLGPROC) lpfnWinVnPersonalInfoDlg))
		break;

	MoreInit ();

	ShowWindow (NetDoc.hDocWnd, nCmdShow);

	UpdateWindow (NetDoc.hDocWnd);
	UpdateWindow (NetDoc.hWndFrame);
	SendMessage (NetDoc.hDocWnd, WM_SIZE, 0, 0L);

#ifdef USE_SPLASH
	if (ShowSplashScreen)
		DisplaySplashScreen(hInstance, NetDoc.hWndFrame, 3);
#endif

	/* Read the NEWSRC file and display its contents in the           */
	/* main window.                                                   */

	if (!ReadNewsrc ()) {
	  MessageBox (NetDoc.hDocWnd, "Cannot open the NEWSRC file.", "Fatal error", MB_OK | MB_ICONHAND);
	  PostQuitMessage (0);
	}

#if 0							// we are now ruling out win32s version altogether - see above
#ifdef WIN32
	/* no MAPI support in win32s */
	if ((GetVersion () & 0x80000000) && MailForceType == MT_MAPI) {
	  MailForceType = MT_NONE;
	  MessageBox (NetDoc.hDocWnd, "WinVN does not support MAPI under Win32s", "MAPI Disabled", MB_OK | MB_ICONINFORMATION);
	}
#endif
#endif

	Initializing = INIT_NOT_CONNECTED;

	if (ConnectAtStartup)
	  Connect ();

	InvalidateRect (NetDoc.hDocWnd, NULL, TRUE);
	UpdateWindow (NetDoc.hDocWnd);
	SetFocus (NetDoc.hDocWnd);

	/* And now for the main loop, which appears in all Windows programs. */
	hAccel = LoadAccelerators (hInstance, "WinVNAccel");

#ifdef WIN32
  }								/* end of if GetVersion != win32 */
#endif

  while (MainLoopPass ());

#ifdef USE_3D_CONTROLS
  Ctl3dUnregister (hInstance);
#endif
  if (GroupFilter)
	GlobalFreePtr (GroupFilter);

  return (MainMsg.wParam);
}

/* --- FUNCTION Connect ---------------------------------------------
 * Connect inits comm services and starts connection process
 */
void 
Connect ()
{
  if (Initializing != INIT_NOT_CONNECTED)
	return;

  Initializing = INIT_ESTAB_CONN;

  /* disable the connect menu item during connect attempt */
  SetConnectMenuItems (&NetDoc, DISABLE);	// connect item has reverse attributes
  /* disable toolbar button during connect, SetUserMenus will enable */
  SendMessage (NetDoc.hWndTB, TB_ENABLEBUTTON, IDB_TOGGLE_CONNECT, FALSE);

  SetStatbarText (NetDoc.hWndFrame, "Connecting to news server...", &NetDoc, TRUE, TRUE);

  InvalidateRect (NetDoc.hDocWnd, NULL, TRUE);
  UpdateWindow (NetDoc.hDocWnd);

  if (MRRInitComm () != 0) {	/* Set up communications */
	Initializing = INIT_NOT_CONNECTED;
	MRRCloseComm ();
	SetConnectMenuItems (&NetDoc, ENABLE);
	UpdateWindow (NetDoc.hDocWnd);
	return;
  }
  /* Set up the timer which will wake us up every so often
   * so we can check to see if new characters have arrived from
   * the server.
   */
  idTimer = SetTimer (NetDoc.hDocWnd, ID_TIMER, COMM_TIMER_INTERVAL, (TIMERPROC) NULL);

  if (!idTimer) {
	MessageBox (NetDoc.hDocWnd, "Couldn't create timer!", "Fatal WinVN Error", MB_OK | MB_ICONASTERISK);
	Initializing = INIT_NOT_CONNECTED;
	MRRCloseComm ();
	SetConnectMenuItems (&NetDoc, ENABLE);
	return;
  }
  CommDoc = &NetDoc;

  /* MRRInitComm causes CommState to be ST_ESTABLISH_COMM.  DoCommState 
   * begins processing when DoCommInput (started by the timer) sees data
   * from the server.  DoCommState will set Initializing back to 
   * INIT_NOT_CONNECTED if any error.
   * Initializing is INIT_DONE when we're connected and happy
   */
}

/*---  FUNCTION: AbortAllComm -------------------------------------------
 *
 *  Aborts and cleans up internal comm state
 *  jsc 9/12/94
 */
void
AbortAllComm ()
{
  if (Decoding) {
	CompleteThisDecode ();
	DecodeDone ();
  }
  if (SendingPost)				// don't abort if sending mail

	DoSend (ABORT);

  CommDoc = (TypDoc *) NULL;
  CommBusy = FALSE;
  CommState = ST_NONE;
}


/* --- FUNCTION Disconnect ------------------------------------------ --
 * This is kills all comm.  Does not send a QUIT, or check any state.
 * jsc 9/29/94
 */
void 
Disconnect ()
{
  AbortAllComm ();

  KillTimer (NetDoc.hDocWnd, ID_TIMER);
  Initializing = INIT_NOT_CONNECTED;

  CloseArticleWnds ();
  CloseGroupWnds ();
  CloseStatusWnds ();

  SetUserMenus (&NetDoc, DISABLE);
  InvalidateRect (NetDoc.hDocWnd, NULL, TRUE);
  UpdateWindow (NetDoc.hDocWnd);

  MRRCloseComm ();				/* blammo */
}


/* --- FUNCTION Reconnect ------------------------------------------ --
 *  uh, reconnect.
 * jsc 11/12/94
 */
void 
Reconnect ()
{
	SendMessage (NetDoc.hWndTB, TB_ENABLEBUTTON, IDB_TOGGLE_CONNECT, TRUE);
	SendMessage (NetDoc.hWndTB, TB_CHECKBUTTON, IDB_TOGGLE_CONNECT, TRUE);
	Disconnect();
	Connect();
}

/* --- FUNCTION WinVnInit ---------------------------------------------

 *    Initialize the program (first stage).
 *    This routine does some initialization needed before the
 *    creation of the main window.
 *    I put off additional initialization until after the main
 *    window is created.
 *
 *    Entry    hInstance   is a handle to the current instance of
 *                         execution.
 *
 *    Exit     Window classes have been registered, and a small
 *             amount of other window- and comm-related initialization
 *             is done.
 */

BOOL
WinVnInit (HINSTANCE hInstance, LPSTR lpCmdLine)
{
  WNDCLASS wndClass;
  HDC hDC;
  BOOL bSuccess;

  Initializing = INIT_READING_NEWSRC;
  NewsrcDirty = FALSE;
  CommLineLWAp1 = CommLineIn + MAXCOMMLINE;
  LineHeight = 30;				/* kludge so Net window doesn't get divide-by-zero */

  szAppName = "WinVN";

  // locate newsrc and winvn.ini
  if (fnLocateFiles (hInstance, lpCmdLine))
	return (0);

  /* ok we found the files... now make sure they're writeable */
  if (_access (szAppProFile, 2) == -1) {
	sprintf (str, "Unable to write to file %s.  Aborting WinVN.\nPlease check your startup configuration.", szAppProFile);
	MessageBox (NULL, str, "Read-Only File", MB_OK | MB_ICONSTOP);
	return (0);
  }
  if (_access (szNewsSrc, 2) == -1) {
	sprintf (str, "Unable to write to file %s.  Aborting WinVN.\nPlease check your startup configuration.", szNewsSrc);
	MessageBox (NULL, str, "Read-Only File", MB_OK | MB_ICONSTOP);
	return (0);
  }

  if ((GroupFilter = (char *) GlobalAllocPtr (GMEM_MOVEABLE, MAXGROUPFILTERSIZE)) == NULL) {
	EnableGroupFilter = FALSE;
  }

  ReadWinvnProfile ();

  // obtain point-to-logical-units conversion constants for screen and printer
  hDC = GetDC (NetDoc.hDocWnd);
  ScreenYPixels = GetDeviceCaps (hDC, LOGPIXELSY);
  LimitedColor = GetDeviceCaps (hDC, RASTERCAPS) & RC_PALETTE;
  ReleaseDC (NetDoc.hDocWnd, hDC);

  PrinterInit ();

  // initialize fonts
  InitAllFonts ();

  /* Create pointers to the dialog box functions, needed   */
  /* for routine processing of dialog boxes.               */

  lpfnWinVnArticleActionDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnArticleActionDlg, hInstance);
  lpfnWinVnCommDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnCommDlg, hInstance);
  lpfnWinVnSaveArtDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnSaveArtDlg, hInstance);
  lpfnWinVnSaveArtsDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnSaveArtsDlg, hInstance);
  lpfnWinVnFindDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnFindDlg, hInstance);
  lpfnWinVnPersonalInfoDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnPersonalInfoDlg, hInstance);
  lpfnWinVnExecuteInfoDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnExecuteInfoDlg, hInstance);
  lpfnWinVnConfirmationDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnConfigConfirmationDlg, hInstance);
  lpfnWinVnControlSubclass = (DLGPROC) MakeProcInstance ((FARPROC) WinVnControlIntercept, hInst);
  lpfnWinVnThresholdDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnThresholdDlg, hInstance);
  lpfnWinVnLogOptDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnLogOptDlg, hInstance);
  lpfnWinVnDecodeArtsDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnDecodeArtsDlg, hInstance);
  lpfnWinVnAttachDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnAttachDlg, hInstance);
  lpfnWinVnComposePrefsDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnComposePrefsDlg, hInstance);
  lpfnWinVnAttachPrefsDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnAttachPrefsDlg, hInstance);
  lpfnWinVnEncodeDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnEncodeDlg, hInstance);
  lpfnWinVnExitDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnExitDlg, hInstance);
  lpfnWinVnMailDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnMailDlg, hInstance);
  lpfnWinVnSmartFilerDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnSmartFilerDlg, hInstance);
  lpfnWinVnSelectPathDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnSelectPathDlg, hInstance);

  lpfnWinVnArticleDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnConfigArticleDlg, hInstance);
  lpfnWinVnCodingPrefsDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnConfigCodingPrefsDlg, hInstance);
  lpfnWinVnArtListDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnConfigArticleListDlg, hInstance);
  lpfnWinVnGroupListDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnConfigGroupListDlg, hInstance);
  lpfnWinVnHeadersDlg = (DLGPROC) MakeProcInstance ((FARPROC) WinVnHeadersDlg, hInstance);	// shimomai

  xScreen = GetSystemMetrics (SM_CXSCREEN);
  yScreen = GetSystemMetrics (SM_CYSCREEN);
  CaptionHeight = GetSystemMetrics (SM_CYCAPTION);

  CommDoc = &NetDoc;
  Authenticated = FALSE;

  hListBackgroundBrush = CreateSolidBrush (ListBackgroundColor);
  hArticleBackgroundBrush = CreateSolidBrush (ArticleBackgroundColor);
  hStatusBackgroundBrush = CreateSolidBrush (StatusBackgroundColor);

  memset (&wndClass, 0, sizeof (WNDCLASS));

  wndClass.hCursor = LoadCursor (NULL, IDC_ARROW);
  wndClass.hIcon = LoadIcon (hInstance, (LPSTR) "winvn");
  wndClass.lpszMenuName = (LPSTR) "ConfMenu";
  wndClass.lpszClassName = (LPSTR) "WinVnFrame";
  wndClass.hbrBackground = GetStockObject (WHITE_BRUSH);
  wndClass.hInstance = hInstance;
  wndClass.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
  wndClass.lpfnWndProc = WinVnConfFrameWndProc;
  bSuccess = RegisterClass (&wndClass);

  if (bSuccess) {
	wndClass.hCursor = LoadCursor (NULL, IDC_ARROW);
	wndClass.hIcon = LoadIcon (hInstance, (LPSTR) "winvn");
	wndClass.lpszMenuName = (LPSTR) "ConfMenu";
	wndClass.lpszClassName = (LPSTR) "WinVn";
	wndClass.hbrBackground = GetStockObject (WHITE_BRUSH);
	wndClass.hInstance = hInstance;
	wndClass.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndClass.lpfnWndProc = WinVnConfWndProc;
	bSuccess = RegisterClass (&wndClass);
  }

  if (bSuccess) {
	wndClass.hCursor = LoadCursor (NULL, IDC_ARROW);
	wndClass.hIcon = LoadIcon (hInstance, (LPSTR) "wvgroup");
	wndClass.lpszMenuName = (LPSTR) "ViewMenu";
	wndClass.lpszClassName = (LPSTR) "WinVnViewFrame";
	wndClass.hbrBackground = GetStockObject (WHITE_BRUSH);
	wndClass.hInstance = hInstance;
	wndClass.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndClass.lpfnWndProc = WinVnViewFrameWndProc;
	bSuccess = RegisterClass (&wndClass);
  }

  if (bSuccess) {
	wndClass.hCursor = LoadCursor (NULL, IDC_ARROW);
	wndClass.hIcon = LoadIcon (hInstance, (LPSTR) "wvgroup");
	wndClass.lpszMenuName = (LPSTR) "ViewMenu";
	wndClass.lpszClassName = (LPSTR) "WinVnView";
	wndClass.hbrBackground = GetStockObject (WHITE_BRUSH);
	wndClass.hInstance = hInstance;
	wndClass.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndClass.lpfnWndProc = WinVnViewWndProc;
	bSuccess = RegisterClass (&wndClass);
  }

  if (bSuccess) {
	wndClass.hCursor = LoadCursor (NULL, IDC_ARROW);
	wndClass.hIcon = LoadIcon (hInstance, (LPSTR) "wvart");
	wndClass.lpszMenuName = (LPSTR) "ArtMenu";
	wndClass.lpszClassName = (LPSTR) "WinVnArtFrame";
	wndClass.hbrBackground = GetStockObject (WHITE_BRUSH);
	wndClass.hInstance = hInstance;
	wndClass.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndClass.lpfnWndProc = WinVnArtFrameWndProc;

	bSuccess = RegisterClass (&wndClass);
  }

  if (bSuccess) {
	wndClass.hCursor = LoadCursor (NULL, IDC_ARROW);
	wndClass.hIcon = LoadIcon (hInstance, (LPSTR) "wvart");
	wndClass.lpszMenuName = (LPSTR) "ArtMenu";
	wndClass.lpszClassName = (LPSTR) "WinVnArt";
	wndClass.hbrBackground = GetStockObject (WHITE_BRUSH);
	wndClass.hInstance = hInstance;
	wndClass.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndClass.lpfnWndProc = WinVnArtWndProc;

	bSuccess = RegisterClass (&wndClass);
  }

  if (bSuccess) {				/* identical to wvmail except for the icon */
	wndClass.hCursor = LoadCursor (NULL, IDC_ARROW);
	wndClass.hIcon = LoadIcon (hInstance, (LPSTR) "wvpost");
	wndClass.lpszMenuName = (LPSTR) "ComposeMenu";
	wndClass.lpszClassName = (LPSTR) "WinVnPost";
	wndClass.hbrBackground = GetStockObject (WHITE_BRUSH);
	wndClass.hInstance = hInstance;
	wndClass.style = CS_HREDRAW | CS_VREDRAW;
	wndClass.lpfnWndProc = WinVnComposeWndProc;

	bSuccess = RegisterClass (&wndClass);
  }

  if (bSuccess) {				/* identical to wvpost except for the icon */
	wndClass.hCursor = LoadCursor (NULL, IDC_ARROW);
	wndClass.hIcon = LoadIcon (hInstance, (LPSTR) "wvmail");
	wndClass.lpszMenuName = (LPSTR) "ComposeMenu";
	wndClass.lpszClassName = (LPSTR) "WinVnMail";
	wndClass.hbrBackground = GetStockObject (WHITE_BRUSH);
	wndClass.hInstance = hInstance;
	wndClass.style = CS_HREDRAW | CS_VREDRAW;
	wndClass.lpfnWndProc = WinVnComposeWndProc;

	bSuccess = RegisterClass (&wndClass);
  }

  if (bSuccess) {
	wndClass.hCursor = LoadCursor (NULL, IDC_ARROW);
	wndClass.hIcon = LoadIcon (hInstance, (LPSTR) "wvcstat2");
	wndClass.lpszMenuName = (LPSTR) "StatMenu";
	wndClass.lpszClassName = (LPSTR) "WinVnCoding";
	wndClass.hbrBackground = GetStockObject (WHITE_BRUSH);
	wndClass.hInstance = hInstance;
	wndClass.style = CS_HREDRAW | CS_VREDRAW;
	wndClass.lpfnWndProc = WinVnCodingWndProc;

	bSuccess = RegisterClass (&wndClass);
  }
  if (bSuccess) {
	wndClass.hCursor = LoadCursor (NULL, IDC_ARROW);
	wndClass.hIcon = LoadIcon (hInstance, (LPSTR) "wvcstat1");
	wndClass.lpszMenuName = NULL;
	wndClass.lpszClassName = (LPSTR) "WinVnBlockCoding";
	wndClass.hbrBackground = GetStockObject (WHITE_BRUSH);
	wndClass.hInstance = hInstance;
	wndClass.style = CS_HREDRAW | CS_VREDRAW;
	wndClass.lpfnWndProc = WinVnCodedBlockWndProc;

	bSuccess = RegisterClass (&wndClass);
  }

  return (bSuccess);
}

/* --- Function MoreInit -----------------------------------------------

 *    Finish up initializing the program.
 *    I do as much initialization here as possible.  I'd rather
 *    have code run after the main window is created (in WinVNInit),
 *    so I have someplace to display error messages if necessary.
 *
 *    I read quite a few profile strings (from WIN.INI)
 *    here and act appropriately (usually means setting a global variable).
 *    I try to read as many as possible of the profile strings used by this
 *    program here.
 */
BOOL
MoreInit ()
{
  register int j;
//  extern char uuTable[CODINGTABLESIZE], xxTable[CODINGTABLESIZE], base64Table[CODINGTABLESIZE];
//  CheckView (NetDoc.hDocWnd);     /* modify menu as necessary           */

  /* Initialize some document and article related globals */

  for (j = 0; j < 16; j++)		// set custom colors to white

	CustomColors[j] = RGB (255, 255, 255);

  ActiveGroupDoc = (TypDoc *) NULL;
  ActiveArticleDoc = (TypDoc *) NULL;
  for (j = 0; j < MAXGROUPWNDS; j++) {
	GroupDocs[j].InUse = FALSE;
	GroupDocs[j].numArtsSaved = 0;
	GroupDocs[j].savingArtIndex = -1;
	}

  for (j = 0; j < MAXARTICLEWNDS; j++){
	ArticleDocs[j].InUse = FALSE;
	ArticleDocs[j].numArtsSaved = 0;
	ArticleDocs[j].savingArtIndex = -1;	 /* reset to non-saving state */
	}

  for (j = 0; j < MAXPOSTWNDS; j++)
	memset (&WndPosts[j], 0, sizeof (WndEdit));

  for (j = 0; j < MAXMAILWNDS; j++)
	memset (&WndMails[j], 0, sizeof (WndEdit));

  ComposeWnd = (WndEdit *) NULL;

  *SaveArtFileName = '\0';

  CodingState = INACTIVE;
  CommDecoding = FALSE;
  SendingMail = SendingPost = FALSE;

  CreateCodingMap (uuMap, uuTable);
  uuMap[' '] = 0;				// decode both quote and space to 0 in UU

  CodingMap[CODE_UU] = uuMap;
  CreateCodingMap (xxMap, xxTable);
  CodingMap[CODE_XX] = xxMap;
  CreateCodingMap (base64Map, base64Table);
  CodingMap[CODE_BASE64] = base64Map;
  // the custom map is just a pointer.  The map is defined if/when a
  // custom table is read in during decoding
  CodingMap[CODE_CUSTOM] = customMap;

  Signature = InitTextBlock (NetDoc.hDocWnd);
  if (*SigFileName)
	if (ReadFileToTextBlock (NetDoc.hDocWnd, Signature, SigFileName) == FAIL) {
	  MessageBox (NetDoc.hDocWnd, "Signatures disabled", "Signature File Failure", MB_OK);
	  EnableSig = FALSE;
	}

  NumGroupWnds = NumArticleWnds = NumPostWnds = NumMailWnds = NumStatusTexts = 0;
  hCodedBlockWnd = NULL;
  for (j = 0; j < MAX_DECODE_THREADS; j++)
	CodingStatusText[j] = NULL;

  return (TRUE);
}


/* --- InitFont Functions -----------------------------------------------
 *    Initialize global fonts and metrics
 * Be sure to delete any existing font objects before replacing them
 * Convert points representation to logical units for sizes
 * JSC 1/10/93
 */
void 
InitAllFonts ()
{
  hWinVnFont = hCompositionFont = hListFont = hFontArtNormal = 
  hFontArtQuote = hFontPrint = hFontPrintB = hFontPrintS = 
  hFontPrintI = hStatusFont = (HFONT) NULL;

  InitWinVnFonts ();
  InitCompositionFonts ();
  InitListFonts ();
  InitArticleFonts ();
//  InitPrintFonts();
  InitStatusFonts ();
}

void
InitWinVnFonts ()
{
  TEXTMETRIC tmFontInfo;
  HFONT hOldFont;
  HDC hDC;

  /* Unless user specified the system font, create a font as per
   * the user's specifications.
   */

  if (hWinVnFont)
	DeleteObject (hWinVnFont);

  hWinVnFont = (HFONT) NULL;
  if (WinVnFontSize) {
	hWinVnFont = CreateFont
	  (-MulDiv (WinVnFontSize, ScreenYPixels, 72),
	   0,						/* width */
	   0,						/* escapement */
	   0,						/* orientation */
	   strstr (WinVnFontStyle, "Bold") ? FW_BOLD : FW_MEDIUM,
	   (BYTE) (strstr (WinVnFontStyle, "Italic") ? 1 : 0),
	   0,						/* no underline */
	   0,						/* no strikeout */
	   0,
	   OUT_DEFAULT_PRECIS,
	   CLIP_DEFAULT_PRECIS,
	   0,						/* no PROOF_QUALITY */
	   0,
	   WinVnFontFace);
  }

  if (!hWinVnFont)
	hWinVnFont = GetStockObject (OEM_FIXED_FONT);

  /*  Get information about the font.  LineHeight and CharWidth
   *  are pretty self-explanatory and the methods of determining these
   *  are standard.  TopSpace and SideSpace are the top and left margins
   *  in pixels; I compute them by a method I determined empirically.
   */

  hDC = GetDC (NetDoc.hDocWnd);
  hOldFont = SelectObject (hDC, hWinVnFont);
  GetTextMetrics (hDC, (LPTEXTMETRIC) & tmFontInfo);
  WinVnLineHeight = tmFontInfo.tmExternalLeading + tmFontInfo.tmHeight;
  WinVnCharWidth = tmFontInfo.tmAveCharWidth;
  SelectObject (hDC, hOldFont);
  ReleaseDC (NetDoc.hDocWnd, hDC);
}

void
InitCompositionFonts ()
{
  TEXTMETRIC tmFontInfo;
  HFONT hOldFont;
  HDC hDC;

  /* Unless user specified the system font, create a font as per
   * the user's specifications.
   */

  if (hCompositionFont)
	DeleteObject (hCompositionFont);

  hCompositionFont = (HFONT) NULL;
  if (CompositionFontSize) {
	hCompositionFont = CreateFont
	  (-MulDiv (CompositionFontSize, ScreenYPixels, 72),
	   0,						/* width */
	   0,						/* escapement */
	   0,						/* orientation */
	   strstr (CompositionFontStyle, "Bold") ? FW_BOLD : FW_MEDIUM,
	   (BYTE) (strstr (CompositionFontStyle, "Italic") ? 1 : 0),
	   0,						/* no underline */
	   0,						/* no strikeout */
	   0,
	   OUT_DEFAULT_PRECIS,
	   CLIP_DEFAULT_PRECIS,
	   0,						/* no PROOF_QUALITY */
	   0,
	   CompositionFontFace);
  }

  if (!hCompositionFont)
	hCompositionFont = GetStockObject (OEM_FIXED_FONT);

  /*  Get information about the font.  LineHeight and CharWidth
   *  are pretty self-explanatory and the methods of determining these
   *  are standard.  TopSpace and SideSpace are the top and left margins
   *  in pixels; I compute them by a method I determined empirically.
   */

  hDC = GetDC (NetDoc.hDocWnd);
  hOldFont = SelectObject (hDC, hCompositionFont);
  GetTextMetrics (hDC, (LPTEXTMETRIC) & tmFontInfo);
  CompositionLineHeight = tmFontInfo.tmExternalLeading + tmFontInfo.tmHeight;
  CompositionCharWidth = tmFontInfo.tmAveCharWidth;
  SelectObject (hDC, hOldFont);
  ReleaseDC (NetDoc.hDocWnd, hDC);
}

void
InitListFonts ()
{
  TEXTMETRIC tmFontInfo;
  HFONT hOldFont;
  HDC hDC;

  /* Unless user specified the system font, create a font as per
   * the user's specifications.
   */

  if (hListFont)
	DeleteObject (hListFont);

  hListFont = (HFONT) NULL;
  if (ListFontSize) {
	hListFont = CreateFont
	  (-MulDiv (ListFontSize, ScreenYPixels, 72),
	   0,						/* width */
	   0,						/* escapement */
	   0,						/* orientation */
	   strstr (ListFontStyle, "Bold") ? FW_BOLD : FW_MEDIUM,
	   (BYTE) (strstr (ListFontStyle, "Italic") ? 1 : 0),
	   0,						/* no underline */
	   0,						/* no strikeout */
	   0,
	   OUT_DEFAULT_PRECIS,
	   CLIP_DEFAULT_PRECIS,
	   0,						/* no PROOF_QUALITY */
	   0,
	   ListFontFace);
  }

  if (!hListFont)
	hListFont = hWinVnFont;

  /*  Get information about the font.  LineHeight and CharWidth
   *  are pretty self-explanatory and the methods of determining these
   *  are standard.  TopSpace and SideSpace are the top and left margins
   *  in pixels; I compute them by a method I determined empirically.
   */

  hDC = GetDC (NetDoc.hDocWnd);
  hOldFont = SelectObject (hDC, hListFont);
  GetTextMetrics (hDC, (LPTEXTMETRIC) & tmFontInfo);

  LineHeight = tmFontInfo.tmExternalLeading + tmFontInfo.tmHeight;
  CharWidth = tmFontInfo.tmAveCharWidth;
//TopSpace = tmFontInfo.tmExternalLeading;
  TopSpace = LineHeight >> 2;
  StartPen = TopSpace;
  SideSpace = CharWidth >> 1;
  SelectObject (hDC, hOldFont);
  ReleaseDC (NetDoc.hDocWnd, hDC);
}

void
InitArticleFonts ()
{
  TEXTMETRIC tmFontInfo;
  HFONT hOldFont;
  HDC hDC;

  if (hFontArtNormal) {
	DeleteObject (hFontArtNormal);
	DeleteObject (hFontArtQuote);
  }
  hFontArtNormal = hFontArtQuote = (HFONT) NULL;

  if (ArticleFontSize) {		/*  && !ArticleFixedFont */
	hFontArtNormal = CreateFont (
							   -MulDiv (ArticleFontSize, ScreenYPixels, 72),
								  0,	/* width */
								  0,	/* escapement */
								  0,	/* orientation */
					strstr (ArticleFontStyle, "Bold") ? FW_BOLD : FW_MEDIUM,
					   (BYTE) (strstr (ArticleFontStyle, "Italic") ? 1 : 0),
								  0,	/* no underline */
								  0,	/* no strikeout */
								  0,
								  OUT_DEFAULT_PRECIS,
								  CLIP_DEFAULT_PRECIS,
								  0,	/* no PROOF_QUALITY */
								  0,
								  ArticleFontFace);

	hFontArtQuote = CreateFont (
							   -MulDiv (ArticleFontSize, ScreenYPixels, 72),
								 0,		/* width */
								 0,		/* escapement */
								 0,		/* orientation */
					strstr (ArticleFontStyle, "Bold") ? FW_BOLD : FW_MEDIUM,
					   (BYTE) (strstr (ArticleFontStyle, "Italic") ? 0 : 1),	// opposite to above italics
								  0,	/* no underline */
								 0,		/* no strikeout */
								 0,
								 OUT_DEFAULT_PRECIS,
								 CLIP_DEFAULT_PRECIS,
								 0,		/* no PROOF_QUALITY */
								 0,
								 ArticleFontFace);
  }

  if (!hFontArtNormal)
	hFontArtNormal = hWinVnFont;

  if (!hFontArtQuote) 
	hFontArtQuote = hFontArtNormal;

  hDC = GetDC (NetDoc.hDocWnd);
  hOldFont = SelectObject (hDC, hFontArtNormal);
  GetTextMetrics (hDC, (LPTEXTMETRIC) & tmFontInfo);

  ArtLineHeight = tmFontInfo.tmExternalLeading + tmFontInfo.tmHeight;
  ArtCharWidth = tmFontInfo.tmAveCharWidth;

  SelectObject (hDC, hFontArtQuote);
  GetTextMetrics (hDC, (LPTEXTMETRIC) & tmFontInfo);

  ArtLineHeight = max (ArtLineHeight, (unsigned int)(tmFontInfo.tmExternalLeading + tmFontInfo.tmHeight));
  ArtCharWidth = max (ArtCharWidth, (unsigned int) (tmFontInfo.tmAveCharWidth));

  ArtTopSpace = ArtLineHeight / 4;
  ArtSideSpace = ArtCharWidth / 2;

  SelectObject (hDC, hOldFont);
  ReleaseDC (NetDoc.hDocWnd, hDC);
}

void
InitStatusFonts ()
{
  TEXTMETRIC tmFontInfo;
  HDC hDC;
  HFONT hOldFont;

  if (hStatusFont)
	DeleteObject (hStatusFont);

  hStatusFont = (HFONT) NULL;
  if (StatusFontSize) {
	hStatusFont = CreateFont
	  (-MulDiv (StatusFontSize, ScreenYPixels, 72),
	   0,						/* width */
	   0,						/* escapement */
	   0,						/* orientation */
	   strstr (StatusFontStyle, "Bold") ? FW_BOLD : FW_MEDIUM,
	   (BYTE) (strstr (StatusFontStyle, "Italic") ? 1 : 0),
	   0,						/* no underline */
	   0,						/* no strikeout */
	   0,
	   OUT_DEFAULT_PRECIS,
	   CLIP_DEFAULT_PRECIS,
	   0,						/* no PROOF_QUALITY */
	   0,
	   StatusFontFace);
  }
  if (!hStatusFont)
	hStatusFont = hWinVnFont;

  /*  Get information about the font.  LineHeight and CharWidth
   *  are pretty self-explanatory and the methods of determining these
   *  are standard.  TopSpace and SideSpace are the top and left margins
   *  in pixels; I compute them by a method I determined empirically.
   */

  hDC = GetDC (NetDoc.hDocWnd);
  hOldFont = SelectObject (hDC, hStatusFont);
  GetTextMetrics (hDC, (LPTEXTMETRIC) & tmFontInfo);

  StatusLineHeight = tmFontInfo.tmExternalLeading + tmFontInfo.tmHeight;
  StatusCharWidth = tmFontInfo.tmAveCharWidth;
  SelectObject (hDC, hOldFont);
  ReleaseDC (NetDoc.hDocWnd, hDC);
}

void
InitPrintFonts ()
{
  HDC hDC;

  if (hFontPrint) {
	DeleteObject (hFontPrint);
	DeleteObject (hFontPrintB);
	DeleteObject (hFontPrintI);
	DeleteObject (hFontPrintS);
  }

  hFontPrint = hFontPrintB = hFontPrintI = hFontPrintS = (HFONT) NULL;

  hDC = (pd.hDC) ? pd.hDC : GetPrinterDC (NULL);
  PrinterYPixels = GetDeviceCaps (hDC, LOGPIXELSY);
  if (!pd.hDC)
	DeletePrinterDC (hDC);

  if (PrintFontSize) {
	hFontPrint = CreateFont (
							  -MulDiv (PrintFontSize, PrinterYPixels, 72),
							  0,	/* width */
							  0,	/* escapement */
							  0,	/* orientation */
							  FW_MEDIUM,
							  0,	/* no italics */
							  0,	/* no underline */
							  0,	/* no strikeout */
							  0,
							  OUT_DEFAULT_PRECIS,
							  CLIP_DEFAULT_PRECIS,
							  0,	/* no PROOF_QUALITY */
							  0,
							  PrintFontFace);

	hFontPrintB = CreateFont (
							   -MulDiv (PrintFontSize, PrinterYPixels, 72),
							   0,	/* width */
							   0,	/* escapement */
							   0,	/* orientation */
							   FW_BOLD,
							   0,	/* no italics */
							   0,	/* no underline */
							   0,	/* no strikeout */
							   0,
							   OUT_DEFAULT_PRECIS,
							   CLIP_DEFAULT_PRECIS,
							   0,	/* no PROOF_QUALITY */
							   0,
							   PrintFontFace);

	hFontPrintI = CreateFont (
				  -MulDiv ((int) (0.9 * PrintFontSize), PrinterYPixels, 72),
							   0,	/* width */
							   0,	/* escapement */
							   0,	/* orientation */
							   FW_LIGHT,
							   1,	/* italics */
							   0,	/* no underline */
							   0,	/* no strikeout */
							   0,
							   OUT_DEFAULT_PRECIS,
							   CLIP_DEFAULT_PRECIS,
							   0,	/* no PROOF_QUALITY */
							   0,
							   PrintFontFace);

	hFontPrintS = CreateFont (
				  -MulDiv ((int) (1.5 * PrintFontSize), PrinterYPixels, 72),
							   0,	/* width */
							   0,	/* escapement */
							   0,	/* orientation */
							   FW_EXTRABOLD,
							   0,	/* no italics */
							   1,	/* underline */
							   0,	/* no strikeout */
							   0,
							   OUT_DEFAULT_PRECIS,
							   CLIP_DEFAULT_PRECIS,
							   0,	/* no PROOF_QUALITY */
							   0,
							   PrintFontFace);
  }
  else {
	hFontPrint = CreateFont (
							  -MulDiv (8, PrinterYPixels, 72),
	//    40,    /* default Font Size */
							  0,	/* width */
							  0,	/* escapement */
							  0,	/* orientation */
							  FW_MEDIUM,
							  0,	/* no italics */
							  0,	/* no underline */
							  0,	/* no strikeout */
							  0,
							  OUT_DEFAULT_PRECIS,
							  CLIP_DEFAULT_PRECIS,
							  0,	/* no PROOF_QUALITY */
							  0,
							  0);	/* Default Font Face */

	hFontPrintB = CreateFont (
							   -MulDiv (8, PrinterYPixels, 72),
	//    40,    /* default font size */
							   0,	/* width */
							   0,	/* escapement */
							   0,	/* orientation */
							   FW_BOLD,
							   0,	/* no italics */
							   0,	/* no underline */
							   0,	/* no strikeout */
							   0,
							   OUT_DEFAULT_PRECIS,
							   CLIP_DEFAULT_PRECIS,
							   0,	/* no PROOF_QUALITY */
							   0,
							   0);	/* default font face */

	hFontPrintI = CreateFont (
							   -MulDiv ((int) (0.9 * 8), PrinterYPixels, 72),
	//    36,    /* default font size */
							   0,	/* width */
							   0,	/* escapement */
							   0,	/* orientation */
							   FW_LIGHT,
							   1,	/* italics */
							   0,	/* no underline */
							   0,	/* no strikeout */
							   0,
							   OUT_DEFAULT_PRECIS,
							   CLIP_DEFAULT_PRECIS,
							   0,	/* no PROOF_QUALITY */
							   0,
							   0);	/* default font face */

	hFontPrintS = CreateFont (
							   -MulDiv (8, PrinterYPixels, 72),
	//    60,
							   0,	/* width */
							   0,	/* escapement */
							   0,	/* orientation */
							   FW_EXTRABOLD,
							   0,	/* no italics */
							   1,	/* underline */
							   0,	/* no strikeout */
							   0,
							   OUT_DEFAULT_PRECIS,
							   CLIP_DEFAULT_PRECIS,
							   0,	/* no PROOF_QUALITY */
							   0,
							   "Arial");
  }
  if (!hFontPrint)
	hFontPrint = hWinVnFont;

  if (!hFontPrintB)
	hFontPrintB = hWinVnFont;

  if (!hFontPrintI)
	hFontPrintI = hWinVnFont;

  if (!hFontPrintS)
	hFontPrintS = hWinVnFont;
}

void
DestroyFonts ()
{
  HDC hDC = GetDC (NetDoc.hDocWnd);

  /* at this point, NetDoc.hDocWnd should be the only open window */
  SelectObject (hDC, GetStockObject (SYSTEM_FONT));
  ReleaseDC (NetDoc.hDocWnd, hDC);

  if (hWinVnFont)
	DeleteObject (hWinVnFont);
  if (hCompositionFont)
	DeleteObject (hCompositionFont);
  if (hListFont)
	DeleteObject (hListFont);
  if (hFontArtNormal)
	DeleteObject (hFontArtNormal);
  if (hFontArtQuote)
	DeleteObject (hFontArtQuote);
  if (hStatusFont)
	DeleteObject (hStatusFont);
  if (hFontPrint)
	DeleteObject (hFontPrint);
  if (hFontPrintB)
	DeleteObject (hFontPrintB);
  if (hFontPrintS)
	DeleteObject (hFontPrintS);
  if (hFontPrintI)
	DeleteObject (hFontPrintI);
}

/*-------------------------------------------------------------
 *
 *  Bitmap resource handlers
 *  jsc 9/10/94
 */
void
InitBitmaps ()
{
  register int i;

  // Load drive and folder bitmaps
  for (i = IDB_DRIVEMIN; i <= IDB_DRIVEMAX; i++)
	DiskBitmaps[i - IDB_DRIVEMIN] = LoadBitmap (hInst, MAKEINTRESOURCE (i));

  for (i = IDB_FOLDERMIN; i <= IDB_FOLDERMAX; i++)
	FolderBitmaps[i - IDB_FOLDERMIN] = LoadBitmap (hInst, MAKEINTRESOURCE (i));

}

void
DestroyBitmaps ()
{
  register int i;
  for (i = IDB_DRIVEMIN; i <= IDB_DRIVEMAX; i++)
	if (DiskBitmaps[i - IDB_DRIVEMIN])
	  DeleteObject (DiskBitmaps[i - IDB_DRIVEMIN]);

  for (i = IDB_FOLDERMIN; i <= IDB_FOLDERMAX; i++)
	if (FolderBitmaps[i - IDB_FOLDERMIN])
	  DeleteObject (FolderBitmaps[i - IDB_FOLDERMIN]);
}

/*--- function MainLoopPass ---------------------------------------------
 *
 *    Do one pass of the main loop.
 *
 *    Entry
 *
 *    Exit     returns result of GetMessage()
 */
BOOL
MainLoopPass ()
{
  BOOL NoQuit, next;
  register int i;

  if (NoQuit = GetMessage (&MainMsg, (HWND) NULL, 0, 0)) {
	if (!TranslateAccelerator (MainMsg.hwnd, hAccel, &MainMsg)) {
	  next = FALSE;
	  if (NumPostWnds) {
		for (i = 0; !next && i < MAXPOSTWNDS; i++) {
			if (GetFocus() != WndPosts[i].hWndEdit &&
			    WndPosts[i].hWnd != NULL &&
				IsDialogMessage(WndPosts[i].hWnd, &MainMsg)) {
				next = TRUE;
			}
		}
	  }
	  if (!next && NumMailWnds) {
		for (i = 0; !next && i < MAXMAILWNDS; i++) {
			if (GetFocus() != WndMails[i].hWndEdit &&
			    WndMails[i].hWndEdit != NULL && 
				IsDialogMessage(WndMails[i].hWnd, &MainMsg)) {
				next = TRUE;
			}
		}
	  }
	  if (!next) {
		TranslateMessage (&MainMsg);
		DispatchMessage (&MainMsg);
	  }
	}
  }
  return (NoQuit);
}

#ifndef __OS2_PROFILE__
/*--- function ReadWinvnProfile -----------------------------------------
 *
 *    Read the profile values into global vars 
 *    (JSC 1/8/94)
 */
void
ReadWinvnProfile ()
{
  char buf[MAILLEN];
  char buff2[MAXDIALOGSTRING];
  char *ptr;
#ifndef WIN32 
  char TimeZoneBuf[MAXTZONESIZE+5];
#endif
  int j;

  /* mail address list */
  MailList = InitTextBlock (NetDoc.hDocWnd);
  for (j = 1;; j++) {
	sprintf (str, "Address%d", j);
	GetPrivateProfileString (MAIL_ADDRESSES, str, "", buf, MAILLEN, szAppProFile);
	if (!strcmp (buf, ""))
	  break;
	AddLineToTextBlock (MailList, buf);
  }
  MailListOrigNum = (int) MailList->numLines;

  /* smart filer extension list  -- jsc 9/10/94 */
  ExtMapSourceList = InitTextBlock (NetDoc.hDocWnd);
  ExtMapDosList = InitTextBlock (NetDoc.hDocWnd);
  for (j = 1;; j++) {
	sprintf (str, "ExtConvert%d", j);
	GetPrivateProfileString (SMARTFILER, str, "", buf, MAXINTERNALLINE, szAppProFile);
	if (!buf[0])
	  break;
	if ((ptr = strchr (buf, ',')) != NULL) {
	  *ptr = '\0';				/* replace comma with null */
      strcpy(buff2, ".");
      strcat(buff2, ('.' == buf[0]) ? &buf[1] : &buf[0]);
	  ptr++;					/* skip comma, and any whitespace */
	  while (*ptr && isspace (*ptr))
		++ptr;
      if('.' != *ptr)
        --ptr;
      *ptr = '.';
	  /* only add entries to lists if we had two tokens, comma-separated  */
	  if (*ptr) {
		AddLineToTextBlock (ExtMapSourceList, buff2);
		AddLineToTextBlock (ExtMapDosList, ptr);
	  }
	}
  }
  ExtListOrigNum = (int) ExtMapSourceList->numLines;

#ifdef PROFILE_PRE90_UPGRADE
  /* test for existence of Comm section in ini file
   * if doesn't exist but they do have a [WinVn] section, then we need to 
   * upgrade their INI file
   */
  if (GetPrivateProfileString (COMM, NULL, "", buf, MAXINTERNALLINE, szAppProFile) == 0) {
	if (GetPrivateProfileString (OLD, NULL, "", buf, MAXINTERNALLINE, szAppProFile) != 0) {
	  UpgradePre90Profile ();
	  return;
	}
  }
#endif

  GetPrivateProfileString (PERSONAL, "UserName", DEF_UserName, UserName, MAILLEN, szAppProFile);
  GetPrivateProfileString (PERSONAL, "MailAddress", DEF_MailAddr, MailAddress, MAILLEN, szAppProFile);
  GetPrivateProfileString (PERSONAL, "Organization", DEF_Organization, Organization, MAILLEN, szAppProFile);
  GetPrivateProfileString (PERSONAL, "ReplyTo", DEF_ReplyTo, ReplyTo, MAILLEN, szAppProFile);

  UsingSocket =
	GetPrivateProfileInt (COMM, "UseSocket", DEF_UsingSocket, szAppProFile);
  GetPrivateProfileString (COMM, "NNTPHost", DEF_NNTPHost, NNTPHost, MAXNNTPSIZE, szAppProFile);
  GetPrivateProfileString (COMM, "SMTPHost", DEF_SMTPHost, SMTPHost, MAXNNTPSIZE, szAppProFile);
  GetPrivateProfileString (COMM, "NNTPService", DEF_NNTPService, NNTPService, MAXNNTPSIZE, szAppProFile);
  ConnectAtStartup =
	GetPrivateProfileInt (COMM, "ConnectAtStartup", DEF_ConnectAtStartup, szAppProFile);
  force_xhdr =
	GetPrivateProfileInt (COMM, "ForceXhdr", DEF_ForceXhdr, szAppProFile);
  MailDemandLogon =
	GetPrivateProfileInt (COMM, "MailDemandLogon", DEF_MailDemandLogon, szAppProFile);
  MailForceType =
	GetPrivateProfileInt (COMM, "MailForceType", DEF_MailForceType, szAppProFile);
  GetPrivateProfileString (COMM, "GenSockDLL", DEF_GenSockDLL, GenSockDLL, MAXFILENAME, szAppProFile);
  DebugComm =
	GetPrivateProfileInt (COMM, "DebugComm", DEF_DebugComm, szAppProFile);

  GetPrivateProfileString (COMM, "MAPIPrefix", DEF_MAPIPrefix, MAPIPrefix, MAXPREFIXSIZE,szAppProFile);
	
#ifdef WIN32                                 /* get values from NT control panel */
//  GetPrivateProfileString (COMM, "TimeZone", NULL,TimeZone, MAXTZONESIZE,szAppProFile);
//  if (TimeZone[0] == 0) {
//     _tzset();
//	 ptr = getenv("TZ");
//	 if (ptr) strncpy(TimeZone,ptr,MAXTZONESIZE);
//  }
//  else 
//    {
//	  strcpy(TimeZoneBuf,"TZ=");
//	  strcat(TimeZoneBuf,TimeZone);
//	  _putenv(TimeZoneBuf);
//	} 
        					
#else	  
  GetPrivateProfileString (COMM, "TimeZone", (getenv("TZ")!=NULL) ? getenv("TZ"):DEF_TimeZone,
	                         TimeZone, MAXTZONESIZE,szAppProFile);
  if (TimeZone[0] != 0) {
     strcpy(TimeZoneBuf,"TZ=");
	 strcat(TimeZoneBuf,TimeZone);
	 _putenv(TimeZoneBuf);
  }
#endif

  GetPrivateProfileString (AUTH, "NNTPUserName", DEF_NNTPUserName, NNTPUserName, MAXNNTPSIZE, szAppProFile);
  GetPrivateProfileString (AUTH, "NNTPPassword", DEF_NNTPPassword, NNTPPasswordEncrypted, 2 * MAXNNTPSIZE, szAppProFile);
  NNTPSavePassword =
	GetPrivateProfileInt (AUTH, "NNTPSavePassword", DEF_NNTPSavePassword, szAppProFile);

  AuthReqPost = GetPrivateProfileInt (AUTH, "AuthReqPost", DEF_AuthReqPost, szAppProFile);
  AuthReqMail = GetPrivateProfileInt (AUTH, "AuthReqMail", DEF_AuthReqMail, szAppProFile);

  MailLog =
	GetPrivateProfileInt (LOGGING, "MailLog", DEF_MailLog, szAppProFile);
  GetPrivateProfileString (LOGGING, "MailLogFile", DEF_MailLogFile, MailLogFile, MAXFILENAME, szAppProFile);
  PostLog =
	GetPrivateProfileInt (LOGGING, "PostLog", DEF_PostLog, szAppProFile);
  GetPrivateProfileString (LOGGING, "PostLogFile", DEF_PostLogFile, PostLogFile, MAXFILENAME, szAppProFile);

  ConfirmBatchOps =
	GetPrivateProfileInt (CONFIRM, "ConfirmBatchOps", DEF_ConfirmBatchOps, szAppProFile);
  ConfirmDisconnect =
	GetPrivateProfileInt (CONFIRM, "ConfirmDisconnect", DEF_ConfirmDisconnect, szAppProFile);
  ConfirmSaveOnExit =
	GetPrivateProfileInt (CONFIRM, "ConfirmSaveOnExit", DEF_ConfirmSaveOnExit, szAppProFile);
  ConfirmReplyTo =
	GetPrivateProfileInt (CONFIRM, "ConfirmReplyTo", DEF_ConfirmReplyTo, szAppProFile);

  DoList =
	GetPrivateProfileInt (GROUPLIST, "DoList", DEF_DoList, szAppProFile);
  GroupListMultiSelect =
	GetPrivateProfileInt (GROUPLIST, "GroupListMultiSelect", DEF_GroupListMultiSelect, szAppProFile);
  ShowUnsubscribed =
	GetPrivateProfileInt (GROUPLIST, "ShowUnsubscribed", DEF_ShowUnsubscribed, szAppProFile);
  SortGroupList =
	GetPrivateProfileInt (GROUPLIST, "SortGroupList", DEF_SortGroupList, szAppProFile);
  GroupListSeparator =
	GetPrivateProfileInt (GROUPLIST, "GroupListSeparator", 0, szAppProFile);
  if (GroupFilter) {
	GetPrivateProfileString (GROUPLIST, "GroupFilter", DEF_GroupFilter, GroupFilter, MAXGROUPFILTERSIZE - 1, szAppProFile);
	EnableGroupFilter =
	  GetPrivateProfileInt (GROUPLIST, "EnableGroupFilter", DEF_EnableGroupFilter, szAppProFile);
  }
  article_threshold =
	GetPrivateProfileLong (ARTLIST, "ArticleThreshold", DEF_ArticleThreshold, szAppProFile);
  min_to_retrieve =
	GetPrivateProfileLong (ARTLIST, "MinArticlesToRetrieve", DEF_MinToRetrieve, szAppProFile);
  FullNameFrom =
	GetPrivateProfileInt (ARTLIST, "FullNameFrom", DEF_FullNameFrom, szAppProFile);
  threadp =
	GetPrivateProfileInt (ARTLIST, "EnableThreading", DEF_EnableThreading, szAppProFile);
  ShowUnreadOnly =
	GetPrivateProfileInt (ARTLIST, "ShowUnreadOnly", DEF_ShowUnreadOnly, szAppProFile);
  SaveArtAppend =
	GetPrivateProfileInt (ARTLIST, "SaveArtAppend", DEF_SaveArtAppend, szAppProFile);
  SaveNewsrcOnClose =
	GetPrivateProfileInt (ARTLIST, "SaveNewsrcOnClose", DEF_SaveNewsrcOnClose, szAppProFile);
//  ShowReadArticles = 
  //     GetPrivateProfileInt (ARTLIST,"ShowReadArticles", DEF_ShowReadArticles, szAppProFile);
  ViewNew =
	GetPrivateProfileInt (ARTLIST, "NewWndGroup", DEF_NewWndGroup, szAppProFile);
  ThreadFullSubject =
	GetPrivateProfileInt (ARTLIST, "ThreadFullSubject", DEF_ThreadFullSubject, szAppProFile);
  GetPrivateProfileString (ARTLIST, "ThreadDepthIndicator", DEF_ThreadDepthIndicator, ThreadDepthIndicator, 2, szAppProFile);
  ThreadDepthIndicator[1] = '\0';
  bEnableArticleAction =
	GetPrivateProfileInt (ARTLIST, "EnableArticleAction", DEF_EnableArticleAction, szAppProFile);

  ArtListMultiSelect =
	GetPrivateProfileInt (ARTLIST, "ArtListMultiSelect", DEF_ArtListMultiSelect, szAppProFile);
  TrimHeaders =
	GetPrivateProfileInt (ARTICLE, "TrimHeaders", DEF_TrimHeaders, szAppProFile);
  WrapIncomingArticleText =
	GetPrivateProfileInt (ARTICLE, "WrapIncomingArticleText", DEF_WrapIncomingArticleText, szAppProFile);
  WrapIncomingArticleTextLength =
	GetPrivateProfileInt (ARTICLE, "WrapIncomingArticleTextLength", DEF_WrapIncomingArticleTextLength, szAppProFile);
  NewArticleWindow =
	GetPrivateProfileInt (ARTICLE, "NewWndArticle", DEF_NewWndArticle, szAppProFile);
  ScrollPastHeaders =
	GetPrivateProfileInt (ARTICLE, "ScrollPastHeaders", DEF_ScrollPastHeaders, szAppProFile);
  ItalicizeQuotes =
	GetPrivateProfileInt (ARTICLE, "ItalicizeQuotes", DEF_ItalicizeQuotes, szAppProFile);
  SpareRanges =
	GetPrivateProfileInt (ARTLIST, "SpareRanges", DEF_SpareRanges, szAppProFile);
  TrackSubscribedCrossposts =
	GetPrivateProfileInt (ARTLIST, "TrackSubscribedCrossposts", DEF_TrackSubscribedCrossposts, szAppProFile);
  TrackUnsubscribedCrossposts =
	GetPrivateProfileInt (ARTLIST, "TrackUnsubscribedCrossposts", DEF_TrackUnsubscribedCrossposts, szAppProFile);
  ArtListSeparator1 =
	GetPrivateProfileInt (ARTLIST, "ArtListSeparator1", 0, szAppProFile);
  ArtListSeparator2 =
	GetPrivateProfileInt (ARTLIST, "ArtListSeparator2", 0, szAppProFile);
  ArtListSeparator3 =
	GetPrivateProfileInt (ARTLIST, "ArtListSeparator3", 0, szAppProFile);

  WordWrap =
	GetPrivateProfileInt (COMPOSE, "WordWrap", DEF_WordWrap, szAppProFile);
  PrefillCcAddress =
	GetPrivateProfileInt (COMPOSE, "PrefillCcAddress", DEF_PrefillCcAddress, szAppProFile);
  ShowOrgHdr =
	GetPrivateProfileInt (COMPOSE, "ShowOrgHdr", DEF_ShowOrgHdr, szAppProFile);
  ShowReplyToHdr =
	GetPrivateProfileInt (COMPOSE, "ShowReplyToHdr", DEF_ShowReplyToHdr, szAppProFile);
  ShowFollowupToHdr =
	GetPrivateProfileInt (COMPOSE, "ShowFollowupToHdr", DEF_ShowFollowupToHdr, szAppProFile);
  ShowKeywordsHdr =
	GetPrivateProfileInt (COMPOSE, "ShowKeywordsHdr", DEF_ShowKeywordsHdr, szAppProFile);
  ShowSummaryHdr =
	GetPrivateProfileInt (COMPOSE, "ShowSummaryHdr", DEF_ShowSummaryHdr, szAppProFile);
  ShowDistributionHdr =
	GetPrivateProfileInt (COMPOSE, "ShowDistributionHdr", DEF_ShowDistributionHdr, szAppProFile);
  ShowFromHdr =
	GetPrivateProfileInt (COMPOSE, "ShowFromHdr", DEF_ShowFromHdr, szAppProFile);
  GetPrivateProfileString (COMPOSE, "FollowupSaysTemplate", DEF_FollowupSaysTemplate, FollowupSaysTemplate, MAXINTERNALLINE, szAppProFile);
  GetPrivateProfileString (COMPOSE, "ReplySaysTemplate", DEF_ReplySaysTemplate, ReplySaysTemplate, MAXINTERNALLINE, szAppProFile);

  GetPrivateProfileString (COMPOSE, "SignatureFile", DEF_SignatureFile, SigFileName, MAXFILENAME, szAppProFile);
  EnableSig =
	GetPrivateProfileInt (COMPOSE, "EnableSignature", DEF_EnableSignature, szAppProFile);

  GetPrivateProfileString (CODING, "DecodePath", DEF_DecodePath, DecodePathName, MAXFILENAME, szAppProFile);
  CodingStatusVerbose =
	GetPrivateProfileInt (CODING, "CodingStatusVerbose", DEF_CodingStatusVerbose, szAppProFile);
  DumbDecode =
	GetPrivateProfileInt (CODING, "DumbDecode", DEF_DumbDecode, szAppProFile);
  AlsoDecodeOpenArticles =
	GetPrivateProfileInt (CODING, "AlsoDecodeOpenArticles", DEF_AlsoDecodeOpenArticles, szAppProFile);
  ExecuteDecodedFiles =
	GetPrivateProfileInt (CODING, "ExecuteDecodedFiles", DEF_ExecuteDecodedFiles, szAppProFile);
  KeepArticleHeaderVisible =
	GetPrivateProfileInt (CODING, "KeepArticleHeaderVisible", DEF_KeepArticleHeaderVisible, szAppProFile);
  BlockCodingStatusAlwaysOnTop =
	GetPrivateProfileInt (CODING, "BlockCodingStatusAlwaysOnTop", DEF_BlockCodingStatusAlwaysOnTop, szAppProFile);
  MinimizeStatusWindows =
	GetPrivateProfileInt (CODING, "MinimizeStatusWindows", DEF_MinimizeStatusWindows, szAppProFile);

  DefaultAttachInNewArt =
	GetPrivateProfileInt (ATTACH, "DefaultAttachInNewArt", DEF_DefaultAttachInNewArt, szAppProFile);
  ArticleSplitLength =
	GetPrivateProfileLong (ATTACH, "ArticleSplitLength", DEF_ArticleSplitLength, szAppProFile);
  GetPrivateProfileString (ATTACH, "SubjectTemplate", DEF_SubjectTemplate, SubjectTemplate, CODINGTABLESIZE + 1, szAppProFile);
  GenerateMIME =
	GetPrivateProfileInt (ATTACH, "GenerateMIME", DEF_GenerateMIME, szAppProFile);
  MIMEUsageSuggestions =
	GetPrivateProfileInt (ATTACH, "MIMEUsageSuggestions", DEF_MIMEUsageSuggestions, szAppProFile);
  GetPrivateProfileString (ATTACH, "MIMEUUType", DEF_MIMEUUType, MIMEUUType, MAXENCODINGTYPELEN, szAppProFile);
  GetPrivateProfileString (ATTACH, "MIMEXXType", DEF_MIMEXXType, MIMEXXType, MAXENCODINGTYPELEN, szAppProFile);
  GetPrivateProfileString (ATTACH, "MIMECustomType", DEF_MIMECustomType, MIMECustomType, MAXENCODINGTYPELEN, szAppProFile);
  GetPrivateProfileString (ATTACH, "MIMECharset", DEF_MIMECharset, MIMECharset, 80, szAppProFile);
  GetPrivateProfileString (ATTACH, "DefaultEncodingType", DEF_DefaultEncodingType, DefaultEncodingType, MAXENCODINGTYPELEN, szAppProFile);
  GetPrivateProfileString (ATTACH, "DefaultContentType", DEF_DefaultContentType, DefaultContentType, MAXCONTENTTYPELEN, szAppProFile);
  GetPrivateProfileString (ATTACH, "EncodingTable", DEF_EncodingTable, UserCodingTable, CODINGTABLESIZE + 1, szAppProFile);

  GetPrivateProfileString (INTERFACE, "WinVnFontFace", DEF_WinVnFontFace, WinVnFontFace, 32, szAppProFile);
  WinVnFontSize =
	GetPrivateProfileInt (INTERFACE, "WinVnFontSize", DEF_WinVnFontSize, szAppProFile);
  GetPrivateProfileString (INTERFACE, "WinVnFontStyle", DEF_WinVnFontStyle, WinVnFontStyle, 32, szAppProFile);
  GetPrivateProfileString (INTERFACE, "CompositionFontFace", DEF_CompositionFontFace, CompositionFontFace, 32, szAppProFile);
  CompositionFontSize =
	GetPrivateProfileInt (INTERFACE, "CompositionFontSize", DEF_CompositionFontSize, szAppProFile);
  GetPrivateProfileString (INTERFACE, "CompositionFontStyle", DEF_CompositionFontStyle, CompositionFontStyle, 32, szAppProFile);
  GetPrivateProfileString (INTERFACE, "ListFontFace", DEF_ListFontFace, ListFontFace, 32, szAppProFile);
  ListFontSize =
	GetPrivateProfileInt (INTERFACE, "ListFontSize", DEF_ListFontSize, szAppProFile);
  GetPrivateProfileString (INTERFACE, "ListFontStyle", DEF_ListFontStyle, ListFontStyle, 32, szAppProFile);
//  FontBold = 
  //     GetPrivateProfileInt (INTERFACE, "FontBold", TRUE, szAppProFile);
  GetPrivateProfileString (INTERFACE, "ArticleFontFace", DEF_ArticleFontFace, ArticleFontFace, 32, szAppProFile);
  ArticleFontSize =
	GetPrivateProfileInt (INTERFACE, "ArticleFontSize", DEF_ArticleFontSize, szAppProFile);
  GetPrivateProfileString (INTERFACE, "ArticleFontStyle", DEF_ArticleFontStyle, ArticleFontStyle, 32, szAppProFile);
  GetPrivateProfileString (INTERFACE, "StatusFontFace", DEF_StatusFontFace, StatusFontFace, 32, szAppProFile);
  StatusFontSize =
	GetPrivateProfileInt (INTERFACE, "StatusFontSize", DEF_StatusFontSize, szAppProFile);
  GetPrivateProfileString (INTERFACE, "StatusFontStyle", DEF_StatusFontStyle, StatusFontStyle, 32, szAppProFile);
  GetPrivateProfileString (INTERFACE, "PrintFontFace", DEF_PrintFontFace, PrintFontFace, 32, szAppProFile);
  PrintFontSize =
	GetPrivateProfileInt (INTERFACE, "PrintFontSize", DEF_PrintFontSize, szAppProFile);
//  ArticleFixedFont = 
  //     GetPrivateProfileInt (INTERFACE, "ArticleFixedFont", FALSE, szAppProFile);
  ArticleFixedFont = 0;
  GetPrivateProfileString (INTERFACE, "NetUnSubscribedColor", DEF_NetUnSubscribedColor, buf, 32, szAppProFile);
  NetUnSubscribedColor = StrToRGB (buf);
  GetPrivateProfileString (INTERFACE, "NetSubscribedColor", DEF_NetSubscribedColor, buf, 32, szAppProFile);
  NetSubscribedColor = StrToRGB (buf);
  GetPrivateProfileString (INTERFACE, "ArticleUnSeenColor", DEF_ArticleUnSeenColor, buf, 32, szAppProFile);
  ArticleUnSeenColor = StrToRGB (buf);
  GetPrivateProfileString (INTERFACE, "ArticleSeenColor", DEF_ArticleSeenColor, buf, 32, szAppProFile);
  ArticleSeenColor = StrToRGB (buf);
  GetPrivateProfileString (INTERFACE, "ArticleKilledColor", DEF_ArticleKilledColor, buf, 32, szAppProFile);
  ArticleKilledColor = StrToRGB (buf);
  GetPrivateProfileString (INTERFACE, "ArticleTextColor", DEF_ArticleTextColor, buf, 32, szAppProFile);
  ArticleTextColor = StrToRGB (buf);
  GetPrivateProfileString (INTERFACE, "StatusTextColor", DEF_StatusTextColor, buf, 32, szAppProFile);
  StatusTextColor = StrToRGB (buf);
  GetPrivateProfileString (INTERFACE, "ArticleBackgroundColor", DEF_ArticleBackgroundColor, buf, 32, szAppProFile);
  ArticleBackgroundColor = StrToRGB (buf);
  GetPrivateProfileString (INTERFACE, "ListBackgroundColor", DEF_ListBackgroundColor, buf, 32, szAppProFile);
  ListBackgroundColor = StrToRGB (buf);
  GetPrivateProfileString (INTERFACE, "StatusBackgroundColor", DEF_StatusBackgroundColor, buf, 32, szAppProFile);
  StatusBackgroundColor = StrToRGB (buf);
  UseInverseSelections =
	GetPrivateProfileInt (INTERFACE, "UseInverseSelections", DEF_UseInverseSelections, szAppProFile);
  ThumbTrack =
	GetPrivateProfileInt (INTERFACE, "ThumbTrack", DEF_ThumbTrack, szAppProFile);
#ifdef USE_SPLASH
  ShowSplashScreen =
	GetPrivateProfileInt (INTERFACE, "ShowSplashScreen", DEF_ShowSplashScreen, szAppProFile);
#endif

  GetPrivateProfileString (SEARCHES, "LastArticleTextFind", "", LastArticleTextFind, MAXFINDSTRING, szAppProFile);
  GetPrivateProfileString (SEARCHES, "LastArticleHeaderFind", "", LastArticleHeaderFind, MAXFINDSTRING, szAppProFile);
  GetPrivateProfileString (SEARCHES, "LastGroupNameFind", "", LastGroupNameFind, MAXFINDSTRING, szAppProFile);

  OnDupeName =
	GetPrivateProfileInt (SMARTFILER, "OnDupeName", DEF_OnDupeName, szAppProFile);
  OnNameTooLong =
	GetPrivateProfileInt (SMARTFILER, "OnNameTooLong", DEF_OnNameTooLong, szAppProFile);
  MaxFileNameLen =
	GetPrivateProfileInt (SMARTFILER, "MaxFileNameLen", DEF_MaxFileNameLen, szAppProFile);
  MaxFileExtLen =
	GetPrivateProfileInt (SMARTFILER, "MaxFileExtLen", DEF_MaxFileExtLen, szAppProFile);
  EnableExtensionConversion =
	GetPrivateProfileInt (SMARTFILER, "EnableExtensionConversion", DEF_EnableExtensionConversion, szAppProFile);

// from Mitsuo Shimomai - Kagoshima University, Japan
// Support for WWW access.   User interface, WAIS and GOPHER
// support added by Jim Dumoulin, NASA/Kennedy Space Center

  GetPrivateProfileString (EXECUTE, "HttpClient", DEF_HttpClient, HttpClient,MAXFILENAME,szAppProFile);
  GetPrivateProfileString (EXECUTE, "FtpClient", DEF_FtpClient, FtpClient,MAXFILENAME,szAppProFile);
  GetPrivateProfileString (EXECUTE, "GopherClient", DEF_GopherClient, GopherClient,MAXFILENAME,szAppProFile);
  GetPrivateProfileString (EXECUTE, "WaisClient", DEF_WaisClient, WaisClient,MAXFILENAME,szAppProFile);

// fix a typo introduced in a prerelease version of WinVN .99-6 (still called
// WinVN .99-5) for the load at Kennedy Space Center.  This can be removed
// in a few versions.   The Internet didn't get this version.

  if (HttpClient) {
	  GetPrivateProfileString (ADMIN, "Version", "", buf,MAXFILENAME, szAppProFile);
	  if ((stricmp(buf, "WinVN 0.99.5") == 0) &&
	      (stricmp(HttpClient, "%INTERNET%:\\mosaic %u") == 0)) {
	   strcpy(HttpClient,"%INTERNET%:\\mosaic\\mosaic %u");
	  }
  }	
  
#ifdef PROFILE_PRE93_UPGRADE
  /* kludgey upgrade ability
   * if the Compose section doesn't exist, read in from the pre.93.0 sections
   */
  if (GetPrivateProfileString (COMPOSE, NULL, "", buf, MAXINTERNALLINE, szAppProFile) == 0) {
	UpgradePre93Profile ();
  }
#endif

  // The following is in WIN.INI (??)
  GetProfileString (INTERNATIONAL, "sDate", ".", fmtDateDelim, 2);
//  fmtDateDelim[1]=0 ;
  fmtDaysB4Mth = (1 == GetProfileInt (INTERNATIONAL, "iDate", 0 /* US Date Format */ ));


#if 0
// Disabled serial comm stuff
  AskComm =
	GetPrivateProfileInt (COMM, "AskComm", ASK_COMM_INITIAL, szAppProFile);
  GetPrivateProfileString (COMM, "CommString", "COM1:9600,e,7", szCommString, MAXCOMMCHARS, szAppProFile);
  errptr = CommStrtoID (szCommString, &CommPortID, &CommParityID, pszCommSpeed);
  if (errptr) {
	strcpy (mesbuf, "Error parsing ");
	strcat (mesbuf, szCommString);
	MessageBox (NetDoc.hDocWnd, errptr, mesbuf, MB_OK | MB_ICONEXCLAMATION);
  }
#endif
}

/*--- function WriteWinvnProfile -----------------------------------------
 *
 *    Write the values modifiable in WinVn menus to the profile 
 *    (JSC 1/8/94)
 */
void
WriteWinvnProfile ()
{
  char buf[MAXINTERNALLINE];
  register int j;

  WritePrivateProfileString (ADMIN, "Version", WINVN_VERSION, szAppProFile);

  WritePrivateProfileString (PERSONAL, "UserName", UserName, szAppProFile);
  WritePrivateProfileString (PERSONAL, "MailAddress", MailAddress, szAppProFile);
  WritePrivateProfileString (PERSONAL, "Organization", Organization, szAppProFile);
  WritePrivateProfileString (PERSONAL, "ReplyTo", ReplyTo, szAppProFile);

  WritePrivateProfileInt (COMM, "UseSocket", UsingSocket, szAppProFile);
  WritePrivateProfileString (COMM, "NNTPHost", NNTPHost, szAppProFile);
  WritePrivateProfileString (COMM, "SMTPHost", SMTPHost, szAppProFile);
  WritePrivateProfileString (COMM, "NNTPService", NNTPService, szAppProFile);
  WritePrivateProfileInt (COMM, "ConnectAtStartup", ConnectAtStartup, szAppProFile);
  WritePrivateProfileInt (COMM, "ForceXhdr", force_xhdr, szAppProFile);
  WritePrivateProfileInt (COMM, "MailDemandLogon", MailDemandLogon, szAppProFile);
  WritePrivateProfileInt (COMM, "MailForceType", MailForceType, szAppProFile);
  //WritePrivateProfileString (COMM, "GenSockDLL", GenSockDLL, szAppProFile);
  WritePrivateProfileInt (COMM, "DebugComm", DebugComm, szAppProFile);
  if (TimeZone[0] != 0)
     WritePrivateProfileString (COMM, "TimeZone", TimeZone, szAppProFile);
  WritePrivateProfileString (COMM, "MAPIPrefix", MAPIPrefix, szAppProFile);
  
  WritePrivateProfileString (AUTH, "NNTPUserName", NNTPUserName, szAppProFile);
  WritePrivateProfileInt    (AUTH, "NNTPSavePassword", NNTPSavePassword, szAppProFile);
  if (NNTPSavePassword)
       WritePrivateProfileString (AUTH, "NNTPPassword", NNTPPasswordEncrypted, szAppProFile);
  else
       WritePrivateProfileString (AUTH, "NNTPPassword", DEF_NNTPPassword, szAppProFile);

  WritePrivateProfileInt (LOGGING, "MailLog", MailLog, szAppProFile);
  WritePrivateProfileString (LOGGING, "MailLogFile", MailLogFile, szAppProFile);
  WritePrivateProfileInt (LOGGING, "PostLog", PostLog, szAppProFile);
  WritePrivateProfileString (LOGGING, "PostLogFile", PostLogFile, szAppProFile);

  WritePrivateProfileInt (CONFIRM, "ConfirmBatchOps", ConfirmBatchOps, szAppProFile);
  WritePrivateProfileInt (CONFIRM, "ConfirmDisconnect", ConfirmDisconnect, szAppProFile);
  WritePrivateProfileInt (CONFIRM, "ConfirmSaveOnExit", ConfirmSaveOnExit, szAppProFile);
  WritePrivateProfileInt (CONFIRM, "ConfirmReplyTo", ConfirmReplyTo, szAppProFile);

  WritePrivateProfileInt (GROUPLIST, "DoList", DoList, szAppProFile);
  WritePrivateProfileInt (GROUPLIST, "ShowUnsubscribed", ShowUnsubscribed, szAppProFile);
  WritePrivateProfileInt (GROUPLIST, "SortGroupList", SortGroupList, szAppProFile);
  WritePrivateProfileInt (GROUPLIST, "GroupListMultiSelect", GroupListMultiSelect, szAppProFile);
  WritePrivateProfileInt (GROUPLIST, "GroupListSeparator", GroupListSeparator, szAppProFile);
  //WritePrivateProfileInt (GROUPLIST, "SortGroupList",SortGroupList,szAppProFile);

// these aren't changeable from within winvn yet
  //  WritePrivateProfileString (GROUPLIST, "GroupFilter", GroupFilter, szAppProFile);
  //  WritePrivateProfileInt    (GROUPLIST, "EnableGroupFilter", EnableGroupFilter, szAppProFile);

  WritePrivateProfileLong (ARTLIST, "ArticleThreshold", article_threshold, szAppProFile);
  WritePrivateProfileLong (ARTLIST, "MinArticlesToRetrieve", min_to_retrieve, szAppProFile);
  WritePrivateProfileInt (ARTLIST, "FullNameFrom", FullNameFrom, szAppProFile);
  WritePrivateProfileInt (ARTLIST, "EnableThreading", threadp, szAppProFile);
  WritePrivateProfileInt (ARTLIST, "ShowUnreadOnly", ShowUnreadOnly, szAppProFile);
  WritePrivateProfileInt (ARTLIST, "NewWndGroup", ViewNew, szAppProFile);
  WritePrivateProfileInt (ARTLIST, "ThreadFullSubject", ThreadFullSubject, szAppProFile);
  WritePrivateProfileString (ARTLIST, "ThreadDepthIndicator", ThreadDepthIndicator, szAppProFile);

  WritePrivateProfileInt (ARTLIST, "SaveArtAppend", SaveArtAppend, szAppProFile);
  WritePrivateProfileInt (ARTLIST, "SaveNewsrcOnClose", SaveNewsrcOnClose, szAppProFile);
  WritePrivateProfileInt (ARTLIST, "ArtListMultiSelect", ArtListMultiSelect, szAppProFile);
  WritePrivateProfileInt (ARTLIST, "TrackSubscribedCrossposts", TrackSubscribedCrossposts, szAppProFile);
  WritePrivateProfileInt (ARTLIST, "TrackUnsubscribedCrossposts", TrackUnsubscribedCrossposts, szAppProFile);
  WritePrivateProfileInt (ARTLIST, "SpareRanges", SpareRanges, szAppProFile);
  WritePrivateProfileInt (ARTLIST, "ArtListSeparator1", ArtListSeparator1, szAppProFile);
  WritePrivateProfileInt (ARTLIST, "ArtListSeparator2", ArtListSeparator2, szAppProFile);
  WritePrivateProfileInt (ARTLIST, "ArtListSeparator3", ArtListSeparator3, szAppProFile);
  WritePrivateProfileInt (ARTLIST, "EnableArticleAction", bEnableArticleAction, szAppProFile);
  
  WritePrivateProfileInt (ARTICLE, "NewWndArticle", NewArticleWindow, szAppProFile);
  WritePrivateProfileInt (ARTICLE, "WrapIncomingArticleText", WrapIncomingArticleText, szAppProFile);
  WritePrivateProfileInt (ARTICLE, "WrapIncomingArticleTextLength", WrapIncomingArticleTextLength, szAppProFile);
  WritePrivateProfileInt (ARTICLE, "TrimHeaders", TrimHeaders, szAppProFile);
  WritePrivateProfileInt (ARTICLE, "ScrollPastHeaders", ScrollPastHeaders, szAppProFile);
  WritePrivateProfileInt (ARTICLE, "ItalicizeQuotes", ItalicizeQuotes, szAppProFile);
  
  WritePrivateProfileInt (COMPOSE, "WordWrap", WordWrap, szAppProFile);
  WritePrivateProfileInt (COMPOSE, "PrefillCcAddress", PrefillCcAddress, szAppProFile);
  WritePrivateProfileInt (COMPOSE, "ShowOrgHdr", ShowOrgHdr, szAppProFile);
  WritePrivateProfileInt (COMPOSE, "ShowReplyToHdr", ShowReplyToHdr, szAppProFile);
  WritePrivateProfileInt (COMPOSE, "ShowFollowupToHdr", ShowFollowupToHdr, szAppProFile);
  WritePrivateProfileInt (COMPOSE, "ShowKeywordsHdr", ShowKeywordsHdr, szAppProFile);
  WritePrivateProfileInt (COMPOSE, "ShowSummaryHdr", ShowSummaryHdr, szAppProFile);
  WritePrivateProfileInt (COMPOSE, "ShowDistributionHdr", ShowDistributionHdr, szAppProFile);
  WritePrivateProfileInt (COMPOSE, "ShowFromHdr", ShowFromHdr, szAppProFile);
  WritePrivateProfileString (COMPOSE, "FollowupSaysTemplate", FollowupSaysTemplate, szAppProFile);
  WritePrivateProfileString (COMPOSE, "ReplySaysTemplate", ReplySaysTemplate, szAppProFile);

  WritePrivateProfileString (COMPOSE, "SignatureFile", SigFileName, szAppProFile);
  WritePrivateProfileInt (COMPOSE, "EnableSignature", EnableSig, szAppProFile);

  WritePrivateProfileString (CODING, "DecodePath", DecodePathName, szAppProFile);
  WritePrivateProfileInt (CODING, "CodingStatusVerbose", CodingStatusVerbose, szAppProFile);
  WritePrivateProfileInt (CODING, "AlsoDecodeOpenArticles", AlsoDecodeOpenArticles, szAppProFile);
  WritePrivateProfileInt (CODING, "DumbDecode", DumbDecode, szAppProFile);
  WritePrivateProfileInt (CODING, "BlockCodingStatusAlwaysOnTop", BlockCodingStatusAlwaysOnTop, szAppProFile);
  WritePrivateProfileInt (CODING, "MinimizeStatusWindows", MinimizeStatusWindows, szAppProFile);
  WritePrivateProfileInt (CODING, "ExecuteDecodedFiles", ExecuteDecodedFiles, szAppProFile);
  WritePrivateProfileInt (CODING, "KeepArticleHeaderVisible", KeepArticleHeaderVisible, szAppProFile);

  WritePrivateProfileInt    (ATTACH, "DefaultAttachInNewArt", DefaultAttachInNewArt, szAppProFile);
  WritePrivateProfileLong   (ATTACH, "ArticleSplitLength", ArticleSplitLength, szAppProFile);
  WritePrivateProfileString (ATTACH, "SubjectTemplate", SubjectTemplate, szAppProFile);
  WritePrivateProfileInt    (ATTACH, "GenerateMIME", GenerateMIME, szAppProFile);
  WritePrivateProfileInt    (ATTACH, "MIMEUsageSuggestions", MIMEUsageSuggestions, szAppProFile);
  WritePrivateProfileString (ATTACH, "MIMEUUType", MIMEUUType, szAppProFile);
  WritePrivateProfileString (ATTACH, "MIMEXXType", MIMEXXType, szAppProFile);
  WritePrivateProfileString (ATTACH, "MIMECustomType", MIMECustomType, szAppProFile);
  WritePrivateProfileString (ATTACH, "MIMECharset", MIMECharset, szAppProFile);
  WritePrivateProfileString (ATTACH, "DefaultEncodingType", DefaultEncodingType, szAppProFile);
  WritePrivateProfileString (ATTACH, "DefaultContentType", DefaultContentType, szAppProFile);
  WritePrivateProfileString (ATTACH, "EncodingTable", UserCodingTable, szAppProFile);

  WritePrivateProfileString (INTERFACE, "WinVnFontFace", WinVnFontFace, szAppProFile);
  WritePrivateProfileInt    (INTERFACE, "WinVnFontSize", WinVnFontSize, szAppProFile);
  WritePrivateProfileString (INTERFACE, "WinVnFontStyle", WinVnFontStyle, szAppProFile);
  WritePrivateProfileString (INTERFACE, "CompositionFontFace", CompositionFontFace, szAppProFile);
  WritePrivateProfileInt    (INTERFACE, "CompositionFontSize", CompositionFontSize, szAppProFile);
  WritePrivateProfileString (INTERFACE, "CompositionFontStyle", CompositionFontStyle, szAppProFile);
  WritePrivateProfileString (INTERFACE, "ListFontFace", ListFontFace, szAppProFile);
  WritePrivateProfileInt    (INTERFACE, "ListFontSize", ListFontSize, szAppProFile);
  WritePrivateProfileString (INTERFACE, "ListFontStyle", ListFontStyle, szAppProFile);
  WritePrivateProfileString (INTERFACE, "ArticleFontFace", ArticleFontFace, szAppProFile);
  WritePrivateProfileInt    (INTERFACE, "ArticleFontSize", ArticleFontSize, szAppProFile);
  WritePrivateProfileString (INTERFACE, "ArticleFontStyle", ArticleFontStyle, szAppProFile);
  WritePrivateProfileString (INTERFACE, "StatusFontFace", StatusFontFace, szAppProFile);
  WritePrivateProfileInt    (INTERFACE, "StatusFontSize", StatusFontSize, szAppProFile);
  WritePrivateProfileString (INTERFACE, "StatusFontStyle", StatusFontStyle, szAppProFile);
  WritePrivateProfileString (INTERFACE, "PrintFontFace", PrintFontFace, szAppProFile);
  WritePrivateProfileInt    (INTERFACE, "PrintFontSize", PrintFontSize, szAppProFile);
//  WritePrivateProfileInt    (INTERFACE, "FontBold", FontBold, szAppProFile);
//  WritePrivateProfileInt    (INTERFACE, "ArticleFixedFont", ArticleFixedFont, szAppProFile);
  WritePrivateProfileString (INTERFACE, "NetUnSubscribedColor", RGBToStr (str, NetUnSubscribedColor), szAppProFile);
  WritePrivateProfileString (INTERFACE, "NetSubscribedColor", RGBToStr (str, NetSubscribedColor), szAppProFile);
  WritePrivateProfileString (INTERFACE, "ArticleUnSeenColor", RGBToStr (str, ArticleUnSeenColor), szAppProFile);
  WritePrivateProfileString (INTERFACE, "ArticleSeenColor", RGBToStr (str, ArticleSeenColor), szAppProFile);
  WritePrivateProfileString (INTERFACE, "ArticleKilledColor", RGBToStr (str, ArticleKilledColor), szAppProFile);
  WritePrivateProfileString (INTERFACE, "ArticleTextColor", RGBToStr (str, ArticleTextColor), szAppProFile);
  WritePrivateProfileString (INTERFACE, "StatusTextColor", RGBToStr (str, StatusTextColor), szAppProFile);
  WritePrivateProfileString (INTERFACE, "ArticleBackgroundColor", RGBToStr (str, ArticleBackgroundColor), szAppProFile);
  WritePrivateProfileString (INTERFACE, "ListBackgroundColor", RGBToStr (str, ListBackgroundColor), szAppProFile);
  WritePrivateProfileString (INTERFACE, "StatusBackgroundColor", RGBToStr (str, StatusBackgroundColor), szAppProFile);
  WritePrivateProfileInt (INTERFACE, "UseInverseSelections", UseInverseSelections, szAppProFile);
  WritePrivateProfileInt (INTERFACE, "ThumbTrack", ThumbTrack, szAppProFile);
#ifdef USE_SPLASH
  WritePrivateProfileInt (INTERFACE, "ShowSplashScreen", ShowSplashScreen, szAppProFile);
#endif
  WritePrivateProfileString (SEARCHES, "LastArticleTextFind", LastArticleTextFind, szAppProFile);
  WritePrivateProfileString (SEARCHES, "LastArticleHeaderFind", LastArticleHeaderFind, szAppProFile);
  WritePrivateProfileString (SEARCHES, "LastGroupNameFind", LastGroupNameFind, szAppProFile);

// from Mitsuo Shimomai - Kagoshima University, Japan
  WritePrivateProfileString (EXECUTE, "HttpClient", HttpClient, szAppProFile);
  WritePrivateProfileString (EXECUTE, "FtpClient", FtpClient, szAppProFile);
  
  WritePrivateProfileString (EXECUTE, "GopherClient", GopherClient, szAppProFile);
  WritePrivateProfileString (EXECUTE, "WaisClient", WaisClient, szAppProFile);

  WritePrivateProfileInt (SMARTFILER, "OnDupeName", OnDupeName, szAppProFile);
  WritePrivateProfileInt (SMARTFILER, "OnNameTooLong", OnNameTooLong, szAppProFile);
  WritePrivateProfileInt (SMARTFILER, "MaxFileNameLen", MaxFileNameLen, szAppProFile);
  WritePrivateProfileInt (SMARTFILER, "MaxFileExtLen", MaxFileExtLen, szAppProFile);
  WritePrivateProfileInt (SMARTFILER, "EnableExtensionConversion", EnableExtensionConversion, szAppProFile);

  if (MailList) {
	for (j = 0; j < max (MailListOrigNum, (int) MailList->numLines); j++) {
	  sprintf (str, "Address%d", j + 1);
	  WritePrivateProfileString (MAIL_ADDRESSES, str,
								 (j >= (int) MailList->numLines) ? "" : TextBlockLine (MailList, j), szAppProFile);
	}
  }

  if (ExtMapSourceList && ExtMapDosList) {
	for (j = 0; j < max (ExtListOrigNum, (int) ExtMapSourceList->numLines); j++) {
	  sprintf (str, "ExtConvert%d", j + 1);
	  if (j >= (int) ExtMapSourceList->numLines)
		*buf = '\0';
	  else
		_snprintf (buf, MAXINTERNALLINE - 1, "%s,%s",
				   TextBlockLine (ExtMapSourceList, j), TextBlockLine (ExtMapDosList, j));

	  WritePrivateProfileString (SMARTFILER, str, buf, szAppProFile);
	}
  }
}

void
SaveWindowPositions ()
{
  RECT rect;
  char mybuf[MAXINTERNALLINE];
  BOOL found;
  int idoc;

  /* Save position and size of Usenet window. */
  if (!IsMinimized(NetDoc.hWndFrame)) {
	  GetWindowRect (NetDoc.hWndFrame, &rect);
	  sprintf (mybuf, "%d,%d,%d,%d", rect.left, rect.top,
			   RectWidth (rect), RectHeight (rect));
	  WritePrivateProfileString (GROUPLIST, "UsenetWindowPos", mybuf, szAppProFile);
  }

  /* Save position and size of first Group window */
  for (found = FALSE, idoc = 0; !found && idoc < MAXGROUPWNDS; idoc++) {
	if (GroupDocs[idoc].InUse && !IsMinimized(GroupDocs[idoc].hWndFrame)) {
	  GetWindowRect (GroupDocs[idoc].hWndFrame, &rect);
	  found = TRUE;
	  sprintf (mybuf, "%d,%d,%d,%d", rect.left, rect.top,
			   RectWidth (rect), RectHeight (rect));
	  WritePrivateProfileString (ARTLIST, "GroupWindowPos", mybuf, szAppProFile);
	}
  }

  /* Save position and size of first Article window */
  for (found = FALSE, idoc = 0; !found && idoc < MAXARTICLEWNDS; idoc++) {
	if (ArticleDocs[idoc].InUse && !IsMinimized(ArticleDocs[idoc].hWndFrame)) {
	  GetWindowRect (ArticleDocs[idoc].hWndFrame, &rect);
	  found = TRUE;
	  sprintf (mybuf, "%d,%d,%d,%d", rect.left, rect.top,
			   RectWidth (rect), RectHeight (rect));
	  WritePrivateProfileString (ARTICLE, "ArticleWindowPos", mybuf, szAppProFile);
	}
  }

  /* Save position and size of first post/mail window */
  for (found = FALSE, idoc = 0; !found && idoc < MAXPOSTWNDS; idoc++) {
	if (WndPosts[idoc].hWnd && !IsMinimized(WndPosts[idoc].hWnd)) {
	  GetWindowRect (WndPosts[idoc].hWnd, &rect);
	  found = TRUE;
	  sprintf (mybuf, "%d,%d,%d,%d", rect.left, rect.top,
			   RectWidth (rect), RectHeight (rect));
	  WritePrivateProfileString (COMPOSE, "PostWindowPos", mybuf, szAppProFile);
	}
  }
  for (found = FALSE, idoc = 0; !found && idoc < MAXMAILWNDS; idoc++) {
	if (WndMails[idoc].hWnd && !IsMinimized(WndMails[idoc].hWnd)) {
	  GetWindowRect (WndMails[idoc].hWnd, &rect);
	  found = TRUE;
	  sprintf (mybuf, "%d,%d,%d,%d", rect.left, rect.top,
			   RectWidth (rect), RectHeight (rect));
	  WritePrivateProfileString (COMPOSE, "MailWindowPos", mybuf, szAppProFile);
	}
  }

  /* save position of first decoding thread status window */
  for (found = FALSE, idoc = 0; !found && idoc < NumStatusTexts; idoc++) {
	if (CodingStatusText[idoc]->hTextWnd && !IsMinimized(CodingStatusText[idoc]->hTextWnd)) {
	  GetWindowRect (CodingStatusText[idoc]->hTextWnd, &rect);
	  found = TRUE;
	  sprintf (mybuf, "%d,%d,%d,%d", rect.left, rect.top,
			   RectWidth (rect), RectHeight (rect));
	  WritePrivateProfileString (CODING, "DecodeStatusWindowPos", mybuf, szAppProFile);
	}
  }

  /* save the position of the block status window */
  if (hCodedBlockWnd && !IsMinimized(hCodedBlockWnd)) {
	  GetWindowRect (hCodedBlockWnd, &rect);
	  sprintf (mybuf, "%d,%d", rect.left, rect.top);
	  WritePrivateProfileString (CODING, "BlockStatusWindowPos", mybuf, szAppProFile);
  }
}

#ifdef PROFILE_PRE90_UPGRADE
/*--- function UpgradePre90Profile -----------------------------------------
 *
 *    Upgrades a user's old (pre v.90) style of WinVn.ini to the new style
 *    (JSC 1/8/94)
 */
void
UpgradePre90Profile ()
{
  char buf[512];



  GetPrivateProfileString (OLD, "UserName", DEF_UserName, UserName, MAILLEN, szAppProFile);
  GetPrivateProfileString (OLD, "MailAddress", DEF_MailAddr, MailAddress, MAILLEN, szAppProFile);
  GetPrivateProfileString (OLD, "Organization", DEF_Organization, Organization, MAILLEN, szAppProFile);
  GetPrivateProfileString (OLD, "ReplyTo", DEF_ReplyTo, ReplyTo, MAILLEN, szAppProFile);

  UsingSocket =
	GetPrivateProfileInt (OLD, "UseSocket", DEF_UsingSocket, szAppProFile);
  GetPrivateProfileString (OLD, "NNTPHost", DEF_NNTPHost, NNTPHost, MAXNNTPSIZE, szAppProFile);
  GetPrivateProfileString (OLD, "SMTPHost", DEF_SMTPHost, SMTPHost, MAXNNTPSIZE, szAppProFile);
  GetPrivateProfileString (OLD, "NNTPService", DEF_NNTPService, NNTPService, MAXNNTPSIZE, szAppProFile);
  NNTPSavePassword =
	GetPrivateProfileInt (OLD, "NNTPSavePassword", DEF_NNTPSavePassword, szAppProFile);
  DebugComm =
	GetPrivateProfileInt (OLD, "DebugComm", DEF_DebugComm, szAppProFile);
  MailDemandLogon =
	GetPrivateProfileInt (OLD, "MailDemandLogon", DEF_MailDemandLogon, szAppProFile);
  MailForceType =
	GetPrivateProfileInt (OLD, "MailForceType", DEF_MailForceType, szAppProFile);
  GetPrivateProfileString (OLD, "NNTPUserName", DEF_NNTPUserName, NNTPUserName, MAXNNTPSIZE, szAppProFile);
  GetPrivateProfileString (OLD, "NNTPPassword", DEF_NNTPPassword, NNTPPasswordEncrypted, 2 * MAXNNTPSIZE, szAppProFile);

  threadp =
	GetPrivateProfileInt (OLD, "EnableThreading", DEF_EnableThreading, szAppProFile);
  GetPrivateProfileString (OLD, "SignatureFile", DEF_SignatureFile, SigFileName, MAXFILENAME + 1, szAppProFile);
//  GetPrivateProfileString (OLD, "MailListFile", DEF_MailFileName, MailFileName, MAXFILENAME+1,szAppProFile);
  EnableSig =
	GetPrivateProfileInt (OLD, "EnableSignature", DEF_EnableSignature, szAppProFile);

  MailLog =
	GetPrivateProfileInt (OLD, "MailLog", DEF_MailLog, szAppProFile);
  GetPrivateProfileString (OLD, "MailLogFile", DEF_MailLogFile, MailLogFile, MAXFILENAME, szAppProFile);
  PostLog =
	GetPrivateProfileInt (OLD, "PostLog", DEF_PostLog, szAppProFile);
  GetPrivateProfileString (OLD, "PostLogFile", DEF_PostLogFile, PostLogFile, MAXFILENAME, szAppProFile);

  ConnectAtStartup =
	GetPrivateProfileInt (OLD, "ConnectAtStartup", DEF_ConnectAtStartup, szAppProFile);
  FullNameFrom =
	GetPrivateProfileInt (OLD, "FullNameFrom", DEF_FullNameFrom, szAppProFile);
  article_threshold =
	GetPrivateProfileLong (OLD, "ArticleThreshold", DEF_ArticleThreshold, szAppProFile);
  min_to_retrieve =
	GetPrivateProfileLong (OLD, "MinArticlesToRetrieve", DEF_MinToRetrieve, szAppProFile);
  ShowUnsubscribed =
	GetPrivateProfileInt (OLD, "ShowUnsubscribed", DEF_ShowUnsubscribed, szAppProFile);
  SortGroupList =
	GetPrivateProfileInt (OLD, "SortGroupList", DEF_SortGroupList, szAppProFile);

//  ShowReadArticles = 
  //     GetPrivateProfileInt (OLD,"ShowReadArticles", DEF_ShowReadArticles, szAppProFile);
  GetPrivateProfileString (OLD, "GroupFilter", DEF_GroupFilter, GroupFilter, MAXGROUPFILTERSIZE - 1, szAppProFile);
  EnableGroupFilter =
	GetPrivateProfileInt (OLD, "EnableGroupFilter", DEF_EnableGroupFilter, szAppProFile);
  ConfirmBatchOps =
	GetPrivateProfileInt (OLD, "ConfirmBatchOps", DEF_ConfirmBatchOps, szAppProFile);
  ConfirmDisconnect =
	GetPrivateProfileInt (OLD, "ConfirmDisconnect", DEF_ConfirmDisconnect, szAppProFile);
  ConfirmSaveOnExit =
	GetPrivateProfileInt (OLD, "ConfirmSaveOnExit", DEF_ConfirmSaveOnExit, szAppProFile);
  ConfirmReplyTo =
	GetPrivateProfileInt (OLD, "ConfirmReplyTo", DEF_ConfirmReplyTo, szAppProFile);
  ThreadFullSubject =
	GetPrivateProfileInt (OLD, "ThreadFullSubject", DEF_ThreadFullSubject, szAppProFile);
  GetPrivateProfileString (OLD, "ThreadDepthIndicator", DEF_ThreadDepthIndicator, ThreadDepthIndicator, 2, szAppProFile);
  ThreadDepthIndicator[1] = '\0';
  ViewNew =
	GetPrivateProfileInt (OLD, "NewWndGroup", DEF_NewWndGroup, szAppProFile);
  NewArticleWindow =
	GetPrivateProfileInt (OLD, "NewWndArticle", DEF_NewWndArticle, szAppProFile);
  SaveArtAppend =
	GetPrivateProfileInt (OLD, "SaveArtAppend", DEF_SaveArtAppend, szAppProFile);
  ShowUnreadOnly =
	GetPrivateProfileInt (OLD, "ShowUnreadOnly", DEF_ShowUnreadOnly, szAppProFile);
  ArtListMultiSelect =
	GetPrivateProfileInt (OLD, "ArtListMultiSelect", DEF_ArtListMultiSelect, szAppProFile);
  GroupListMultiSelect =
	GetPrivateProfileInt (OLD, "GroupListMultiSelect", DEF_GroupListMultiSelect, szAppProFile);
  TrimHeaders =
	GetPrivateProfileInt (OLD, "TrimHeaders", DEF_TrimHeaders, szAppProFile);
  WordWrap =
	GetPrivateProfileInt (OLD, "WordWrap", DEF_WordWrap, szAppProFile);
  ShowOrgHdr =
	GetPrivateProfileInt (OLD, "ShowOrgHdr", DEF_ShowOrgHdr, szAppProFile);
  ShowReplyToHdr =
	GetPrivateProfileInt (OLD, "ShowReplyToHdr", DEF_ShowReplyToHdr, szAppProFile);
  ShowFollowupToHdr =
	GetPrivateProfileInt (OLD, "ShowFollowupToHdr", DEF_ShowFollowupToHdr, szAppProFile);
  ShowKeywordsHdr =
	GetPrivateProfileInt (OLD, "ShowKeywordsHdr", DEF_ShowKeywordsHdr, szAppProFile);
  ShowSummaryHdr =
	GetPrivateProfileInt (OLD, "ShowSummaryHdr", DEF_ShowSummaryHdr, szAppProFile);
  ShowDistributionHdr =
	GetPrivateProfileInt (OLD, "ShowDistributionHdr", DEF_ShowDistributionHdr, szAppProFile);
  SpareRanges =
	GetPrivateProfileInt (OLD, "SpareRanges", DEF_SpareRanges, szAppProFile);
  TrackSubscribedCrossposts =
	GetPrivateProfileInt (OLD, "TrackSubscribedCrossposts", DEF_TrackSubscribedCrossposts, szAppProFile);
  TrackUnsubscribedCrossposts =
	GetPrivateProfileInt (OLD, "TrackUnsubscribedCrossposts", DEF_TrackUnsubscribedCrossposts, szAppProFile);
  MinimizeStatusWindows =
	GetPrivateProfileInt (OLD, "MinimizeStatusWindows", DEF_MinimizeStatusWindows, szAppProFile);
  ScrollPastHeaders =
	GetPrivateProfileInt (OLD, "ScrollPastHeaders", DEF_ScrollPastHeaders, szAppProFile);
  ItalicizeQuotes =
	GetPrivateProfileInt (OLD, "ItalicizeQuotes", DEF_ItalicizeQuotes, szAppProFile);
  WrapIncomingArticleText =
	GetPrivateProfileInt (OLD, "WrapIncomingArticleText", DEF_WrapIncomingArticleText, szAppProFile);
  WrapIncomingArticleTextLength =
	GetPrivateProfileInt (OLD, "WrapIncomingArticleTextLength", DEF_WrapIncomingArticleTextLength, szAppProFile);

  GetPrivateProfileString (OLD, "DecodePath", DEF_DecodePath, DecodePathName, MAXFILENAME, szAppProFile);
  CodingStatusVerbose =
	GetPrivateProfileInt (OLD, "CodingStatusVerbose", DEF_CodingStatusVerbose, szAppProFile);
  BlockCodingStatusAlwaysOnTop =
	GetPrivateProfileInt (OLD, "BlockCodingStatusAlwaysOnTop", DEF_BlockCodingStatusAlwaysOnTop, szAppProFile);
  AlsoDecodeOpenArticles =
	GetPrivateProfileInt (OLD, "AlsoDecodeOpenArticles", DEF_AlsoDecodeOpenArticles, szAppProFile);
  DumbDecode =
	GetPrivateProfileInt (OLD, "DumbDecode", DEF_DumbDecode, szAppProFile);
//  ReviewAttach = 
  //     GetPrivateProfileInt (OLD, "ReviewAttach", DEF_ReviewAttach, szAppProFile);
  GenerateMIME =
	GetPrivateProfileInt (OLD, "GenerateMIME", DEF_GenerateMIME, szAppProFile);
  MIMEUsageSuggestions =
	GetPrivateProfileInt (OLD, "MIMEUsageSuggestions", DEF_MIMEUsageSuggestions, szAppProFile);

  GetPrivateProfileString (OLD, "DefaultEncodingType", DEF_DefaultEncodingType, DefaultEncodingType, MAXENCODINGTYPELEN, szAppProFile);
  GetPrivateProfileString (OLD, "MIMEUUType", DEF_MIMEUUType, MIMEUUType, MAXENCODINGTYPELEN, szAppProFile);
  GetPrivateProfileString (OLD, "MIMEXXType", DEF_MIMEXXType, MIMEXXType, MAXENCODINGTYPELEN, szAppProFile);
  GetPrivateProfileString (OLD, "MIMECustomType", DEF_MIMECustomType, MIMECustomType, MAXENCODINGTYPELEN, szAppProFile);
  GetPrivateProfileString (OLD, "MIMECharset", DEF_MIMECharset, MIMECharset, 80, szAppProFile);

  GetPrivateProfileString (OLD, "DefaultContentType", DEF_DefaultContentType, DefaultContentType, MAXCONTENTTYPELEN, szAppProFile);

  DefaultAttachInNewArt =
	GetPrivateProfileInt (OLD, "DefaultAttachInNewArt", DEF_DefaultAttachInNewArt, szAppProFile);
  ExecuteDecodedFiles =
	GetPrivateProfileInt (OLD, "ExecuteDecodedFiles", DEF_ExecuteDecodedFiles, szAppProFile);
  KeepArticleHeaderVisible =
	GetPrivateProfileInt (OLD, "KeepArticleHeaderVisible", DEF_KeepArticleHeaderVisible, szAppProFile);

  ArticleSplitLength =
	GetPrivateProfileLong (OLD, "ArticleSplitLength", DEF_ArticleSplitLength, szAppProFile);
  GetPrivateProfileString (OLD, "EncodingTable", DEF_EncodingTable, UserCodingTable, CODINGTABLESIZE + 1, szAppProFile);
  GetPrivateProfileString (OLD, "SubjectTemplate", DEF_SubjectTemplate, SubjectTemplate, CODINGTABLESIZE + 1, szAppProFile);
  GetPrivateProfileString (OLD, "FollowupSaysTemplate", DEF_FollowupSaysTemplate, FollowupSaysTemplate, MAXINTERNALLINE, szAppProFile);
  GetPrivateProfileString (OLD, "ReplySaysTemplate", DEF_ReplySaysTemplate, ReplySaysTemplate, MAXINTERNALLINE, szAppProFile);

  GetPrivateProfileString (OLD, "WinVnFontFace", DEF_WinVnFontFace, WinVnFontFace, 32, szAppProFile);
  WinVnFontSize =
	GetPrivateProfileInt (OLD, "WinVnFontSize", DEF_WinVnFontSize, szAppProFile);
  GetPrivateProfileString (OLD, "WinVnFontStyle", DEF_WinVnFontStyle, WinVnFontStyle, 32, szAppProFile);
  GetPrivateProfileString (OLD, "CompositionFontFace", DEF_CompositionFontFace, CompositionFontFace, 32, szAppProFile);
  CompositionFontSize =
	GetPrivateProfileInt (OLD, "CompositionFontSize", DEF_CompositionFontSize, szAppProFile);
  GetPrivateProfileString (OLD, "CompositionFontStyle", DEF_CompositionFontStyle, CompositionFontStyle, 32, szAppProFile);
  GetPrivateProfileString (OLD, "ListFontFace", DEF_ListFontFace, ListFontFace, 32, szAppProFile);
  ListFontSize =
	GetPrivateProfileInt (OLD, "ListFontSize", DEF_ListFontSize, szAppProFile);
  GetPrivateProfileString (OLD, "ListFontStyle", DEF_ListFontStyle, ListFontStyle, 32, szAppProFile);
//  FontBold = 
  //     GetPrivateProfileInt (OLD, "FontBold", TRUE, szAppProFile);
  GetPrivateProfileString (OLD, "ArticleFontFace", DEF_ArticleFontFace, ArticleFontFace, 32, szAppProFile);
  ArticleFontSize =
	GetPrivateProfileInt (OLD, "ArticleFontSize", DEF_ArticleFontSize, szAppProFile);
  GetPrivateProfileString (OLD, "ArticleFontStyle", DEF_ArticleFontStyle, ArticleFontStyle, 32, szAppProFile);
  GetPrivateProfileString (OLD, "StatusFontFace", DEF_StatusFontFace, StatusFontFace, 32, szAppProFile);
  StatusFontSize =
	GetPrivateProfileInt (OLD, "StatusFontSize", DEF_StatusFontSize, szAppProFile);
  GetPrivateProfileString (OLD, "StatusFontStyle", DEF_StatusFontStyle, StatusFontStyle, 32, szAppProFile);
  GetPrivateProfileString (OLD, "PrintFontFace", DEF_PrintFontFace, PrintFontFace, 32, szAppProFile);
  PrintFontSize =
	GetPrivateProfileInt (OLD, "PrintFontSize", DEF_PrintFontSize, szAppProFile);
//
  // Previous versions of WINVN.INI stored fonts in Device dependent units
  // instead of Device Independent font sizes.  Since we can't safely 
  // convert, set font to something reasonable.   (JD 4/22/94)
  //
  if (ArticleFontSize && (ArticleFontSize == 0 || ArticleFontSize > 16))
	ArticleFontSize = 10;
  if (ListFontSize && (ListFontSize == 0 || ListFontSize > 16))
	ListFontSize = 10;
  if (StatusFontSize && (StatusFontSize == 0 || StatusFontSize > 16))
	StatusFontSize = 11;
  if (PrintFontSize && (PrintFontSize == 0 || PrintFontSize > 16))
	PrintFontSize = 10;

  ArticleFixedFont = 0;
  GetPrivateProfileString (OLD, "NetUnSubscribedColor", DEF_NetUnSubscribedColor, buf, 32, szAppProFile);
  NetUnSubscribedColor = StrToRGB (buf);
  GetPrivateProfileString (OLD, "NetSubscribedColor", DEF_NetSubscribedColor, buf, 32, szAppProFile);
  NetSubscribedColor = StrToRGB (buf);
  GetPrivateProfileString (OLD, "ArticleUnSeenColor", DEF_ArticleUnSeenColor, buf, 32, szAppProFile);
  ArticleUnSeenColor = StrToRGB (buf);
  GetPrivateProfileString (OLD, "ArticleSeenColor", DEF_ArticleSeenColor, buf, 32, szAppProFile);
  ArticleSeenColor = StrToRGB (buf);
  GetPrivateProfileString (OLD, "ArticleKilledColor", DEF_ArticleKilledColor, buf, 32, szAppProFile);
  ArticleKilledColor = StrToRGB (buf);
  GetPrivateProfileString (OLD, "ArticleTextColor", DEF_ArticleTextColor, buf, 32, szAppProFile);
  ArticleTextColor = StrToRGB (buf);
  GetPrivateProfileString (OLD, "StatusTextColor", DEF_StatusTextColor, buf, 32, szAppProFile);
  StatusTextColor = StrToRGB (buf);
  GetPrivateProfileString (OLD, "ArticleBackgroundColor", DEF_ArticleBackgroundColor, buf, 32, szAppProFile);
  ArticleBackgroundColor = StrToRGB (buf);
  GetPrivateProfileString (OLD, "ListBackgroundColor", DEF_ListBackgroundColor, buf, 32, szAppProFile);
  ListBackgroundColor = StrToRGB (buf);
  GetPrivateProfileString (OLD, "StatusBackgroundColor", DEF_StatusBackgroundColor, buf, 32, szAppProFile);
  UseInverseSelections =
	GetPrivateProfileInt (OLD, "UseInverseSelections", DEF_UseInverseSelections, szAppProFile);

  StatusBackgroundColor = StrToRGB (buf);
  ThumbTrack =
	GetPrivateProfileInt (OLD, "ThumbTrack", DEF_ThumbTrack, szAppProFile);
#ifdef USE_SPLASH
  ShowSplashScreen =
	GetPrivateProfileInt (OLD, "ShowSplashScreen", DEF_ShowSplashScreen, szAppProFile);
#endif

  GetPrivateProfileString (OLD, "LastArticleTextFind", "", LastArticleTextFind, MAXFINDSTRING, szAppProFile);
  GetPrivateProfileString (OLD, "LastArticleHeaderFind", "", LastArticleHeaderFind, MAXFINDSTRING, szAppProFile);
  GetPrivateProfileString (OLD, "LastGroupNameFind", "", LastGroupNameFind, MAXFINDSTRING, szAppProFile);

  OnDupeName =
	GetPrivateProfileInt (OLD, "OnDupeName", DEF_OnDupeName, szAppProFile);
  OnNameTooLong =
	GetPrivateProfileInt (OLD, "OnNameTooLong", DEF_OnNameTooLong, szAppProFile);
  MaxFileNameLen =
	GetPrivateProfileInt (OLD, "MaxFileNameLen", DEF_MaxFileNameLen, szAppProFile);
  MaxFileExtLen =
	GetPrivateProfileInt (OLD, "MaxFileExtLen", DEF_MaxFileExtLen, szAppProFile);
  EnableExtensionConversion =
	GetPrivateProfileInt (OLD, "EnableExtensionConversion", DEF_EnableExtensionConversion, szAppProFile);

  GetPrivateProfileString (COMM, "GenSockDLL", DEF_GenSockDLL, GenSockDLL, MAXFILENAME + 1, szAppProFile);
  if (!GenSockDLL) {
	WritePrivateProfileString (COMM, "GenSockDLL", "gensock.dll", szAppProFile);
	strcpy (GenSockDLL, "gensock.dll");
  }
  WriteWinvnProfile ();
  WritePrivateProfileString (OLD, "Notice1", "**** The [winvn] section is no longer needed unless    ****", szAppProFile);
  WritePrivateProfileString (OLD, "Notice2", "**** you want compatibility with old versions of WinVn ****", szAppProFile);

  strlwr (szAppProFile);
  sprintf (buf, "WinVN has discovered your configuration file is from an older release."
  "  Your configuration file %s has been updated.\nIf something doesn't work"
		   " as expected, please review the changes.", szAppProFile);
  MessageBox (NetDoc.hDocWnd, buf, "WinVn Configuration", MB_OK);
}
#endif

#ifdef PROFILE_PRE93_UPGRADE
/*--- function UpgradePre93Profile -----------------------------------------
 *
 *    Upgrades a user's pre v.93 style of WinVn.ini to the new style
 *    This is used if the ini appears newer the v.90 but older than v.93
 *    (jsc 11/3/94)
 */

#define PREF "Preferences"

void
UpgradePre93Profile ()
{
  // used to bundle all this stuff under Preferences
  threadp =
	GetPrivateProfileInt (PREF, "EnableThreading", DEF_EnableThreading, szAppProFile);
  GetPrivateProfileString (PREF, "SignatureFile", DEF_SignatureFile, SigFileName, MAXFILENAME + 1, szAppProFile);

  EnableSig =
	GetPrivateProfileInt (PREF, "EnableSignature", DEF_EnableSignature, szAppProFile);

  MailLog =
	GetPrivateProfileInt (PREF, "MailLog", DEF_MailLog, szAppProFile);
  GetPrivateProfileString (PREF, "MailLogFile", DEF_MailLogFile, MailLogFile, MAXFILENAME, szAppProFile);
  PostLog =
	GetPrivateProfileInt (PREF, "PostLog", DEF_PostLog, szAppProFile);
  GetPrivateProfileString (PREF, "PostLogFile", DEF_PostLogFile, PostLogFile, MAXFILENAME, szAppProFile);

  DoList =
	GetPrivateProfileInt (PREF, "DoList", DEF_DoList, szAppProFile);
  ConnectAtStartup =
	GetPrivateProfileInt (PREF, "ConnectAtStartup", DEF_ConnectAtStartup, szAppProFile);
  FullNameFrom =
	GetPrivateProfileInt (PREF, "FullNameFrom", DEF_FullNameFrom, szAppProFile);
  article_threshold =
	GetPrivateProfileLong (PREF, "ArticleThreshold", DEF_ArticleThreshold, szAppProFile);
  ShowUnsubscribed =
	GetPrivateProfileInt (PREF, "ShowUnsubscribed", DEF_ShowUnsubscribed, szAppProFile);
  SortGroupList =
	GetPrivateProfileInt (PREF, "SortGroupList", DEF_SortGroupList, szAppProFile);
//  ShowReadArticles =
//	GetPrivateProfileInt (PREF, "ShowReadArticles", DEF_ShowReadArticles, szAppProFile);
  ConfirmBatchOps =
	GetPrivateProfileInt (PREF, "ConfirmBatchOps", DEF_ConfirmBatchOps, szAppProFile);
  ConfirmSaveOnExit =
	GetPrivateProfileInt (PREF, "ConfirmExit", DEF_ConfirmSaveOnExit, szAppProFile);
  ConfirmReplyTo =
	GetPrivateProfileInt (PREF, "ConfirmReplyTo", DEF_ConfirmReplyTo, szAppProFile);
  ViewNew =
	GetPrivateProfileInt (PREF, "NewWndGroup", DEF_NewWndGroup, szAppProFile);
  NewArticleWindow =
	GetPrivateProfileInt (PREF, "NewWndArticle", DEF_NewWndArticle, szAppProFile);
  SaveArtAppend =
	GetPrivateProfileInt (PREF, "SaveArtAppend", DEF_SaveArtAppend, szAppProFile);
  ShowUnreadOnly =
	GetPrivateProfileInt (PREF, "ShowUnreadOnly", DEF_ShowUnreadOnly, szAppProFile);

  ThreadFullSubject =
	GetPrivateProfileInt (PREF, "ThreadFullSubject", DEF_ThreadFullSubject, szAppProFile);

  GroupListMultiSelect =
	GetPrivateProfileInt (PREF, "GroupMultiSelect", DEF_GroupListMultiSelect, szAppProFile);

  // these items got moves to Attachments
  ArticleSplitLength =
	GetPrivateProfileUInt (CODING, "ArticleSplitLength", (unsigned int) DEF_ArticleSplitLength, szAppProFile);
  GetPrivateProfileString (CODING, "EncodingTable", DEF_EncodingTable, UserCodingTable, CODINGTABLESIZE + 1, szAppProFile);
  GetPrivateProfileString (CODING, "SubjectTemplate", DEF_SubjectTemplate, SubjectTemplate, CODINGTABLESIZE + 1, szAppProFile);
  GenerateMIME =
	GetPrivateProfileInt (CODING, "GenerateMIME", DEF_GenerateMIME, szAppProFile);
  MIMEUsageSuggestions =
	GetPrivateProfileInt (CODING, "MIMEUsageSuggestions", DEF_MIMEUsageSuggestions, szAppProFile);
  GetPrivateProfileString (CODING, "EncodingType", DEF_DefaultEncodingType, DefaultEncodingType, MAXINTERNALLINE, szAppProFile);
  GetPrivateProfileString (CODING, "MIMEUUType", DEF_MIMEUUType, MIMEUUType, MAXENCODINGTYPELEN, szAppProFile);
  GetPrivateProfileString (CODING, "MIMEXXType", DEF_MIMEXXType, MIMEXXType, MAXENCODINGTYPELEN, szAppProFile);
  GetPrivateProfileString (CODING, "MIMECustomType", DEF_MIMECustomType, MIMECustomType, MAXENCODINGTYPELEN, szAppProFile);
  GetPrivateProfileString (CODING, "DefaultContentType", DEF_DefaultContentType, DefaultContentType, MAXINTERNALLINE, szAppProFile);
}

#endif
#endif // #ifdef __OS2_PROFILE__

/*
 * Local Variables:
 * tab-width: 2
 * end:
 */
