/********************************************************************
 *                                                                  *
 *  MODULE    :  WVGLOB.H                                           *
 *                                                                  *
 *  PURPOSE   :  Contains all the global types and variables for    *
 *               WinVN.  Stylistically, this should probably be     *
 *               separated into several header files, but this is   *
 *               what you've got for now. WVDOC.C describes         *
 *               some of these structures.                          *
 *                                                                  *
 *******************************************************************/

/*
 * $Id: wvglob.h 1.87 1997/04/05 00:18:04 dumoulin Exp $
 */

#ifndef __WVGLOB__
#define __WVGLOB__

#ifdef _WIN32
#ifndef WIN32
#define WIN32
#endif
#endif

#ifdef WIN32
#ifndef _WIN32
#define _WIN32
#endif
#endif

/* these are supposed be defined in windowsx.h, but they aren't in mine! */
#ifndef GET_WM_COMMAND_CMD
#ifdef WIN32
#define GET_WM_COMMAND_CMD(wp, lp)  HIWORD(wp)
#define GET_WM_COMMAND_ID(wp, lp)   LOWORD(wp)
#define GET_WM_COMMAND_HWND(wp, lp) (HWND)(lp)
#else
#define GET_WM_COMMAND_CMD(wp, lp)  HIWORD(lp)
#define GET_WM_COMMAND_ID(wp, lp)   (wp)
#define GET_WM_COMMAND_HWND(wp, lp) ((HWND)LOWORD(lp))
#endif
#endif

#ifdef WIN32
#define huge far
#define LOPEN_READ	OF_READ
#define LOPEN_WRITE	OF_WRITE
#else
/*#define _int16 int */ /* (not defined in any 16 bit MSVC or MSVCNT 1.10) */
#define LOPEN_READ	READ
#define LOPEN_WRITE	WRITE
#endif

#ifndef _int16
#define _int16 short int
#endif

#ifndef _int32
#define _int32 long int
#endif

#define int16 _int16
#define int32 _int32
#define uint16 unsigned _int16
#define uint32 unsigned _int32

#define USE_3D_CONTROLS			/* define this to use 3d controls (ctl3d.dll) */

#define COMM_TIMER_INTERVAL 250	/* in milliseconds */

#define BUFSIZE			1024
#define TEMPBUFSIZE		1240
#define MAXHEADERLINE		800
#define MAXFINDSTRING		80
#define MAXDIALOGSTRING		255
#define MAXFILENAME		255
#define MAXENVVAR       40
#define MAXGROUPFILTERSIZE 1500
#define MAXFILTERS      1000

#ifndef WIN32
#define MAX_PATH			1024
#endif

/* this has been increased for XOVER - some lines are *very* long */
#define MAXCOMMLINE		1536
#define MAXINTERNALLINE		180
#define BIGMAXINTERNALLINE  1024
#define MAXOUTLINE		255
#define MAXPOSTLENGTH		60000	/* max length for a posting/mail edit window */
#define MAXBOUNDARYLEN		70	/* max length for MIME boundary  */
#define MAXNEWGROUPSASK		200	/* limit of groups in newgroups dialog box */
#define MAXENCODINGTYPELEN	24	/* max len for encoding type - i.e. Base-64 */
#define MAXCONTENTTYPELEN	48	/* max len for content type - i.e. Application/Postscript */
#define MAXBOUNDARYLINE		70	/* max len for MIME boundary */
#define TOOLBARHEIGHT		27	/* height of toolbar */
#define MAXSTATBARTEXT		60	/* maximum number of chars in status bar text  */
#define MAXTBBUTTONS		20	/* maximum number of tool bar buttons */

#ifdef __cplusplus
extern "C" {

class WVSeenDB;
class WVString;
class WVArticleAction;
#endif

#include <time.h>
#include <commdlg.h>

/* Profile section headings */
#define OLD				"Winvn"
#define ADMIN			"Admin"
#define COMM 			"Communications"
#define AUTH 			"Authorization"
#define INTERFACE		"Interface"
#define PERSONAL 		"Personal"
#define CONFIRM 		"Confirmation"
#define LOGGING 		"Logging"
#define MAIL_ADDRESSES	"Mail Addresses"
#define SMARTFILER 		"Smart Filer"
#define SEARCHES 		"Searches"
#define GROUPLIST   	"Group List"
#define ARTLIST			"Article List"
#define ARTICLE			"Article"
#define COMPOSE			"Compose"
#define CODING 			"Coding"
#define ATTACH			"Attachments"
#define INTERNATIONAL 	"intl"
#define EXECUTE         "URL Execute" 

/* Group sort choices */
#define STR_SORT_DATE      "Date"
#define STR_SORT_SUBJECT   "Subject"
#define STR_SORT_LINES     "Lines"
#define STR_SORT_THREADS   "Threads (strict)"
#define STR_SORT_THREADSUB "Thread/Subject"
#define STR_SORT_ARTNUM    "Article Number"
#define STR_SORT_FROM      "Author"


typedef long TypLineID;

typedef struct structtextselect {
  long LineNum;					/* Line number when selecting text -- Line Ord  */
  int CharNum;					/* Character number when selecting text         */
  /* The 1st LineNum in the Doc and the 1st CharNum in the line are 0   */
} TextSelect;

typedef struct structdoc {
  HANDLE hFirstBlock;			/* handle to first textblock in doc.        */
  HANDLE hLastBlock;			/* unused.                                  */
  unsigned long TotalLines;		/* total # of lines in doc.                 */
  unsigned long LongestLine;		/* # of bytes in the longest line of doc    */
  unsigned long HeaderLines;		/* total number of lines in header of doc
								   (incl. blank line) */
  unsigned long ActiveLines;		/* # of selected or otherwise active lines  */
  unsigned long CountedLines;	/* # of counted lines, as in subscr. groups */
  unsigned long BlockSize;		/* # of bytes in a textblock                */
  unsigned long SplitSize;		/* textblock split point in bytes           */
  HANDLE hCurAddBlock;			/* hBlock to point at which to add lines.   */
  unsigned int AddOffset;		/* offset in bytes for point to add lines   */
  TypLineID AddLineID;			/* LineID of place to add lines.            */
  HANDLE hCurTopScBlock;		/* hBlock of current top line of window     */
  unsigned int TopScOffset;
  TypLineID TopScLineID;
  unsigned long TopLineOrd;		/* ordinal in doc of top line in window     */
  HANDLE hLastSeenBlock;
  unsigned int LastSeenOffset;
  TypLineID LastSeenLineID;
  HANDLE hFindBlock;			/* location of place to start next search   */
  unsigned int FindOffset;		/* for "SearchStr"                          */
  TypLineID FindLineID;
  unsigned int FindTextOffset;
  char SearchStr[MAXFINDSTRING];	/* Search string for current search    */
  unsigned int ScXOffset;		/* # of chars offset for horizontal scroll  */
  unsigned int ScXChars;		/* # of chars/line for current window size  */
  unsigned int ScYLines;		/* # of lines that fit in current window    */
  unsigned int ScXWidth;		/* current size of client area of window    */
  unsigned int ScYHeight;
  HWND hDocWnd;
  struct structdoc *ParentDoc;	/* pointer to parent document            */
  HANDLE hParentBlock;			/* points to line in parent doc          */
  unsigned int ParentOffset;	/* that corresponds to/describes this    */
  TypLineID ParentLineID;		/* document                              */
  unsigned int OffsetToText;
  BOOL InUse;					/* TRUE if this TypDoc in use.           */
  int DocType;					/* DOCTYPE_xxx                           */
  BOOL TextSelected;			/* Indicates text selected               */
  TextSelect BeginSelect;		/* Line and Char where selection began   */
  TextSelect EndSelect;			/* Line and Char where selection ended   */
  HWND hWndTB;					/* Handle of the toolbar child window  (jlg)  */
  HWND hWndFrame;				/* Handle of the parent frame window     */
  char szStatBarText[MAXSTATBARTEXT];	/* status bar text string        */
  int  StatBarPercent;			/* 0 - 100 for thermometer in status bar */
  TypLineID ActiveLineID;		/* Line ID of "active" line in multi-select list (jlg)  */
  TypLineID AnchorLineID;		/* Line ID of "anchor" line in multi-select list        */
  unsigned int SelectedLines;	/* num lines selected (jsc) */
  char ThumbTracking;			/* = TRUE if currently thumb tracking (jsc) */
  int numArtsSaved;				/* used when saving selected articles */
  int savingArtIndex;           /* used when saving/decoding selected articles */

  unsigned long NextTopLine;		/* > 0 if page feed by CTRL-L (shimomai) */

} TypDoc;

typedef struct structblock {
  HANDLE hPrevBlock;			/* handle of previous block, or 0               */
  HANDLE hNextBlock;			/* handle of next block in document, or 0       */
  HANDLE hCurBlock;				/* handle of this block                         */
  long LWAp1;					/* # of used data bytes in block, inc header    */
  long NumLines;				/* # of lines in this block                     */
  long NumActiveLines;			/* # of active lines in this block.             */
  TypDoc *OwnerDoc;				/* pointer to document this block is in.        */
  int eob;						/* end-of-block; must be just before 1st line.  */
  /* Text lines */
  /* Another EOB marker */
} TypBlock;

typedef struct structline {
  int length;					/* Total # of bytes in line, all-inclusive    */
  TypLineID LineID;				/* Unique identifier for this line.           */
  int active;					/* =1 if line should be displayed, else 0     */
  /* Bytes of text */
  /* Another copy of length */
} TypLine;

typedef struct structtext {
  int NameLen;					/* # of bytes of text                          */
} TypText;

typedef struct structgroup {
  char Subscribed;				/* =TRUE if subscribed to this group.   */
  char Selected;				/* =TRUE if selected                    */
  char Determined;				/* =TRUE if group info has been retrieved */
  char Threaded;				/* =TRUE if has thread references */
  int NameLen;					/* # of bytes in group name             */
  TypDoc *SubjDoc;				/* points to doc containing subjs       */
  unsigned long ServerEstNum;	/* est # of arts in server              */
  unsigned long ServerFirst;	/* # of first art that server has.      */
  unsigned long ServerLast;		/* # of last art that server has.       */
  unsigned long uLoadFirst;     /* # of first art loaded from server    */
  unsigned long uLoadLast;      /* # of last art loaded from server     */
  unsigned long HighestPrevSeen;	/* # of highest art server had in last  */
  /* session, from "s<num>" newsrc field  */
  HANDLE header_handle;			/* handle to global block of header array mem */
  HANDLE thread_handle;			/* handle to global block of thread ind. pointers */
  long total_headers;		/* total # of headers in array */
  unsigned long NumUnread;		/* num unseen arts (jsc) */
#ifdef __cplusplus
  //WVString*pGrpName;
  WVArticleAction*pAA;
  WVSeenDB*pSeendb;
#else
  //unsigned int nRanges;			/* # of TypRanges describing seen arts  */
  //unsigned int nSpareRanges;    /* # of extra ranges to overflow before a forced regrow */
  //void*pTmp1;
  void*pTmp2;
  void*pTmp3;
  /* Name of group *//* name of group, zero-terminated       */
  /* Ranges of articles seen *//* array of TypRanges, of seen articles */
  /* Spare Range area so nRanges array can grow if necessary */ 
#endif
} TypGroup;

typedef struct structarticle {
  unsigned long Number;			/* Server's number for this article    */
  char Seen;					/* =TRUE if article seen               */
  char Selected;				/* =TRUE if article selected           */
  TypDoc *ArtDoc;				/* points to doc with actual article   */
  int NameLen;					/* # of bytes in subject line */
  /* Subject line of article */
} TypArticle;

#define HEADER_MESSAGE_ID_LENGTH 100

typedef long huge *thread_array;

typedef thread_array huge *thread_array_p;

typedef char huge *char_p;

typedef struct structrange {
  unsigned long int First;
  unsigned long int Last;
} TypRange;

/* TypMRRFile is used to describe a file; I use it because Windows */
/* doesn't provide much in the way of disk I/O support.  */

typedef struct structMRRfile {
  HFILE hFile;					/* handle to file                            */
  OFSTRUCT of;
  char buf[BUFSIZE];			/* my I/O buffer.                            */
  int bufidx;					/* Index to next place in buf                */
  int bytesread;				/* for reads, # of bytes read in last read   */
  int mode;						/* mode in which to open file.               */
  int eofflag;					/* whether we have reached EOF (read)        */
} TypMRRFile;

#define CtoX(c) (c*CharWidth + SideSpace)
#define LtoY(l) (l*LineHeight + TopSpace)
#define EDITID   1				/* ID of edit box, to identify for return values */
#define MAXMEMONAME 15			/* Number of chars in memo name */
#define MEMONAMECHARS (MAXMEMONAME+2)
#define MAXVIEWS 10
#define END_OF_BLOCK (-1)
#define BLOCK_SIZE  4096
/*  RangeOffset gives the number of bytes from the beginning of
 *  a Group structure to the first Range field, given the length
 *  of the name entry.
 */

// Modified by Holger Liebig (Holger.Liebig@mch.sni.de) to support WinVN compiling
// on MIPS platform.  was: #define RangeOffset(nlen) (((nlen+2)/2)*2 + sizeof(TypGroup))

//#define RangeOffset(nlen) (((nlen+sizeof(int))/sizeof(int))*sizeof(int)+sizeof(TypGroup))
#define GetGroup(LinePtr) (TypGroup far *) (((char far *) LinePtr) + sizeof (TypLine))
#define GetGroupName(LinePtr) (char far *) (((char far *) LinePtr) + sizeof (TypLine) + sizeof (TypGroup))
//#define GetRangePtr(Group) (TypRange far *) ((char far *) Group + RangeOffset (Group->NameLen))
//#define GetSpareRangePtr(Group) (TypRange far *) ((char far *) Group + RangeOffset (Group->NameLen) + sizeof (TypRange) * (Group->nRanges))
//#define CalcGroupLen(Group) (sizeof (TypLine) + RangeOffset (Group->NameLen) + sizeof (TypRange) * (Group->nRanges) + sizeof (TypRange) * (Group->nSpareRanges) + sizeof (int))
#define GroupLenPtr(LinePtr) (*(int *) ((char *) LinePtr + LinePtr->length - sizeof (int)))
#define GetTextPtr(LinePtr) (char far *) ((char far *) (LinePtr) + sizeof (TypLine) + sizeof (TypText))
#define GetTextLen(LinePtr) ((TypText far *) ((char far *) (LinePtr) + sizeof (TypLine)))->NameLen

#ifdef WINMAIN
#define DEF
#else
#define DEF extern
#endif

DEF TypDoc NetDoc;

#define MRR_SCROLL_LINEUP    0
#define MRR_SCROLL_LINEDOWN  1
#define MRR_SCROLL_PAGEUP    2
#define MRR_SCROLL_PAGEDOWN  3

/* This structure maps between keystrokes and mouse events.
 * From an idea on p. 137 of Charles Petzold's book.
 * If you change the definition, be sure to update NUMKEYS.
 */
#define NUMKEYS 6
#ifndef MAC
DEF struct {
  WORD wVirtKey;
  int CtlState;
  int iMessage;
  WPARAM wRequest;
} key2scroll[NUMKEYS]

#ifdef WINMAIN
=
{
  VK_PRIOR, 0, WM_VSCROLL, SB_PAGEUP,
	VK_NEXT, 0, WM_VSCROLL, SB_PAGEDOWN,
	VK_UP, 0, WM_VSCROLL, SB_LINEUP,
	VK_DOWN, 0, WM_VSCROLL, SB_LINEDOWN,
	VK_LEFT, 0, WM_HSCROLL, SB_LINEUP,
	VK_RIGHT, 0, WM_HSCROLL, SB_LINEDOWN
}

#endif
;
#endif

DEF BOOL Initializing;
#define INIT_DONE                0
#define INIT_READING_NEWSRC      1
#define INIT_ESTAB_CONN          2
#define INIT_SCANNING_NETDOC     3
#define INIT_GETTING_LIST        4
#define INIT_NOT_CONNECTED       5
#define INIT_READY               6

#define MAXGROUPWNDS   4
#define MAXARTICLEWNDS 4
#define MAXPOSTWNDS    4
#define MAXMAILWNDS    4

DEF TypDoc GroupDocs[MAXGROUPWNDS];
DEF TypDoc ArticleDocs[MAXARTICLEWNDS];
DEF int NumGroupWnds;
DEF int NumArticleWnds;

typedef struct textBlockStruct {
  HWND hTextWnd;
  BOOL IsBusy;
  unsigned long numLines;
  unsigned long maxLines;
  unsigned long numBytes;
  unsigned long maxBytes;
  unsigned int maxLineLen;
  char huge *text;				/* big text of all lines */
  unsigned long huge *offset;	/* array of offsets into text array */
} TypTextBlock;

typedef struct _attachmentStruct {
  char fileName[MAXFILENAME];
  char contentType[32];
  char encodingType[16];
  unsigned long numBytes;		/* this is size of fileName */
  BOOL attachInNewArt;
} TypAttachment;

#define HDR_NUM_CONTROLS 12
/* these are indexes into the UI control array */
#define HDR_TO			0		/* has a browse button */
#define HDR_GROUPS		1
#define HDR_SUBJECT		2
#define HDR_FROM		3
#define HDR_ORG			4
#define HDR_REPLYTO		5
#define HDR_CC			6		/* has a browse button */
#define HDR_KEYWORDS	7
#define HDR_SUMMARY		8
#define HDR_DIST		9
#define HDR_FOLLOWTO	10
#define HDR_ATTACH	 	11

#define HDR_NUM_BUTTONS	2
/* these are indexes into the button control array */
#define BTN_TO			0
#define BTN_CC			1

typedef struct _HeaderControlStruct {
  HWND title[HDR_NUM_CONTROLS];
  HWND UI[HDR_NUM_CONTROLS];
  HWND button[HDR_NUM_BUTTONS];
  int yEdge;					/* y-coordinate of bottom of last control */
} TypHeaderControls;

DEF BOOL PrefillCcAddress;
DEF BOOL ShowFromHdr;
DEF BOOL ShowOrgHdr;
DEF BOOL ShowReplyToHdr;
DEF BOOL ShowKeywordsHdr;
DEF BOOL ShowSummaryHdr;
DEF BOOL ShowDistributionHdr;
DEF BOOL ShowFollowupToHdr;

#define MAX_NUM_ATTACHMENTS 10
typedef struct WndEditStruct {
  HWND hWnd;
  HWND hWndEdit;
  int composeType;				/* a doctype.  lets us tell if it's MAIL or FORWARD */
  char dirty;
  char busy;					/* TRUE if busy sending */
  unsigned long bodyOffset;		/* # bytes to skip in body for extra headers */
  TypDoc *Doc;
  TypHeaderControls *headerControls;
  TypAttachment *attachment[MAX_NUM_ATTACHMENTS];
  TypTextBlock *extraHeaders;
  HWND hLastFocusWnd;
  int numAttachments;
  int nextBatchIndex;	    /* for batch post/mails */
} WndEdit;

#define DT_CLEAN 0
#define DT_DIRTY 1

DEF WndEdit WndPosts[MAXPOSTWNDS];
DEF WndEdit WndMails[MAXMAILWNDS];
DEF int NumPostWnds;
DEF int NumMailWnds;

#define DOCTYPE_UNKNOWN  0
#define DOCTYPE_NET      1
#define DOCTYPE_GROUP    2
#define DOCTYPE_ARTICLE  4
#define DOCTYPE_POSTING  8
#define DOCTYPE_MAIL     16
#define DOCTYPE_FORWARD  32
#define DOCTYPE_CANCEL   64

/* Temp buffer for trace info */
#ifdef _DEBUG
DEF char szDebugBuffer[120];
#endif

/* Variables and constants for handling the FSA used to deal with    */
/* talking to the NNTP server.                                       */

DEF int CommState;				/* current state in comm FSA */
DEF BOOL CommBusy;				/* =TRUE if comm line busy interacting w/ server */
DEF BOOL CommDecoding;			/* =TRUE if comm line busy decoding lines from server */
DEF TypDoc *CommDoc;			/* Document currently receiving lines from server   */
DEF HWND hVerDlgList;			/* Handle to info in the Version Dialog Box */

DEF char CommLineIn[MAXCOMMLINE];	/* current input line being built by FSA   */
DEF char *CommLinePtr;			/* pointer to next place to put char in CommLineIn  */
DEF char *CommLineLWAp1;		/* if we get this far, we're at end of buffer       */
DEF char IgnoreCommCh;			/* char to ignore when reading from server          */
DEF char EOLCommCh;				/* char that indicates end of line upon input       */
DEF TypDoc *ActiveGroupDoc;
DEF TypDoc *ActiveArticleDoc;
DEF WndEdit *ComposeWnd;		/* active compose window */

DEF BOOL SendingMail, SendingPost;

#define MAXGROUPNAME 120
DEF char CurrentGroup[MAXGROUPNAME];	/* name of group currently selected on
										   server */
DEF int iSortOption;            /* Article sorting option */

DEF BOOL UsingSocket;			/* =TRUE if using PC/TCP rather than serial I/O     */

DEF BOOL threadp;
DEF BOOL xoverp;


#define HDR_XHDR    1			/* Use XHDR to talk to news server */
#define HDR_XOVER   2			/* Use XOVER to talk to news server */
#define HDR_AUTO    0           /* Try XOVER and if fails use XHDR */
DEF unsigned int force_xhdr;

#define MAXNNTPSIZE 120
#define MAXPREFIXSIZE 40
#define MAXTZONESIZE 60
DEF char NNTPHost[MAXNNTPSIZE];
DEF char NNTPService[MAXNNTPSIZE];
DEF char SMTPHost[MAXNNTPSIZE];
DEF char NNTPUserName[MAXNNTPSIZE];
DEF char NNTPPasswordEncrypted[2 * MAXNNTPSIZE];
DEF char TimeZone[MAXTZONESIZE];
DEF char MAPIPrefix[MAXPREFIXSIZE];
DEF BOOL NNTPSavePassword;
DEF BOOL AuthReqPost;			/* TRUE if we may not post at all unless authenticated */
DEF BOOL AuthReqMail;			/* TRUE if we may not send mail unless authenticated */
DEF BOOL Authenticated			/* TRUE if we've been authenticated by NNTP server */
#ifdef WINMAIN
= FALSE
#endif
 ;
/* This is the name that was successfully authenticated by the NNTP server.
 * It might not be the same as NNTPUserName, if the user has changed the
 * username since the beginning of the session.
 */
DEF char AuthenticatedName[MAXNNTPSIZE];

#define MAILLEN 256
DEF char MailAddress[MAILLEN];
DEF char ReplyTo[MAILLEN];
DEF char UserName[MAILLEN];
DEF char Organization[MAILLEN];

DEF char GenSockDLL[MAXFILENAME];
DEF int ConnectAtStartup;

DEF BOOL EnableGroupFilter;
DEF char *GroupFilter;

/* moved state defns to a separate include file to associate stringtable (jlg) */
#include "wvstates.h"

#define LFN_HELP "WINVN.HLP"

/* variables used in an ad hoc attempt to optimize updating of windows
 * by the input cracking FSA. */

#define UPDATE_TITLE_FREQ	10
#define UPDATE_ART_FREQ		12
#define MAX_IMMEDIATE_UPDATE	2
#define STATUS_UPDATE_FREQ	20

//DEF unsigned int RcvLineCount;
DEF long RcvLineCount;

DEF TypLineID NextLineID		/* LineID to assign to next created line */
#ifdef WINMAIN
= 10664L
#endif
 ;

DEF HINSTANCE hInst;
DEF HWND hWndConf;
//DEF HWND hWndSk;
//DEF HWND hDosWnd;
//DEF HWND hWndDebugComm;       /* handle to Debug Comm window */
//DEF int CommDevice;       /* comm device ID, if using serial I/O */

DEF HANDLE hAccel;				/* handle to main accelerator table */
DEF MSG MainMsg;				/* message returned from GetMessage */


DEF char str[MAXHEADERLINE];	/* general-purpose string buffer */


DEF HCURSOR hSaveCursor;		/* handle to current cursor      */
DEF HCURSOR hHourGlass;			/* handle to hourglass cursor    */


//DEF int X, Y;         /* last cursor position          */
DEF int DragMouseAction;		/* mouse action for dragging      */

#define DRAG_NONE                  0
#define DRAG_SELECT                1
#define DRAG_DESELECT              2
#define SEEN_SELECT                3
#define SEEN_DESELECT              4

DEF POINT ptCursor;				/* x and y coordinates of cursor */

DEF int ViewNew;
DEF int NewArticleWindow;
DEF int SelectAll;
DEF int DoList;
DEF int did_list;
DEF unsigned long article_threshold;
DEF unsigned long min_to_retrieve;
DEF unsigned long est_num_unread;
DEF unsigned long arts_to_retrieve;

// DEF int savingArtIndex; 		/* get rid of global to stop GPF's when multi-tasking */
// DEF int numArtsSaved;        /* now in TypeDoc structure JD 10/30/95 */
// DEF int nextBatchIndex;	    /* for batch post/mails */

DEF BOOL FullNameFrom;
DEF BOOL TrimHeaders;
DEF BOOL ScrollPastHeaders;
DEF BOOL ItalicizeQuotes;
DEF BOOL WrapIncomingArticleText;
DEF int WrapIncomingArticleTextLength;
DEF BOOL WordWrap;
DEF BOOL ConfirmBatchOps;
DEF BOOL ConfirmSaveOnExit;
DEF BOOL ConfirmReplyTo;
DEF BOOL ConfirmDisconnect;
DEF BOOL ShowUnsubscribed;
DEF BOOL SortGroupList;
//DEF BOOL ShowReadArticles;
DEF BOOL DebugComm;
DEF BOOL ShowUnreadOnly;
DEF BOOL SaveNewsrc;
DEF BOOL NewsrcDirty;
DEF BOOL SaveConfig;
DEF BOOL bEnableArticleAction;
DEF char LastArticleTextFind[MAXFINDSTRING];
DEF char LastArticleHeaderFind[MAXFINDSTRING];
DEF char LastGroupNameFind[MAXFINDSTRING];

#define THREAD_COMPLETE    1
#define THREAD_INCOMPLETE  2

/* AskComm says whether to put up the communications dialog box
 * upon starting up.  Options are never, always, and yes, because
 * this is the first time the program has been run.
 #define ASK_COMM_NEVER    0
 #define ASK_COMM_ALWAYS   1
 #define ASK_COMM_INITIAL  2
 DEF int AskComm;
 */
DEF BOOL ArticleFixedFont;

DEF int xScreen, yScreen;
DEF int CaptionHeight;
DEF HFONT hWinVnFont;			/* handle to font for WinVN status bar/etc */
DEF HFONT hCompositionFont;		/* handle to font for Composition body text */
DEF HFONT hListFont;			/* handle to font used in group/art lists */
DEF HFONT hFontArtNormal;		/* handle to font used in Article window - normal
								   text mode. */
DEF HFONT hFontArtQuote;		/* handle to font used in Article window - 
								   comments == Italics. */
DEF HFONT hFontPrint;			/* handle to font used for printing. */
DEF HFONT hFontPrintB;			/* handle to font used for bold printing. */
DEF HFONT hFontPrintS;			/* handle to font used for printing Subject line. */
DEF HFONT hFontPrintI;			/* handle to font used for printing Quoted lines. */
DEF HFONT hStatusFont;			/* handle to font used in status windows */

DEF int WinVnFontSize;
DEF char WinVnFontFace[32];
DEF char WinVnFontStyle[32];
DEF int WinVnLineHeight, WinVnCharWidth;	/* # of windows units for WinVn font */

DEF int CompositionFontSize;
DEF char CompositionFontFace[32];
DEF char CompositionFontStyle[32];
DEF int CompositionLineHeight, CompositionCharWidth;

DEF int ListFontSize;
DEF char ListFontFace[32];
DEF char ListFontStyle[32];
DEF int LineHeight, CharWidth;	/* # of window units for list font */
DEF int TopSpace, SideSpace;	/* # of window units to leave at top and side  */
							   /* of window (for aesthetic purposes)          */

DEF int ArticleFontSize;
DEF char ArticleFontFace[32];
DEF char ArticleFontStyle[32];
DEF unsigned int ArtLineHeight, ArtCharWidth;	/* # of windows units for article font */
DEF unsigned int ArtTopSpace, ArtSideSpace;	/* # of window units to leave at top and side  */

DEF int PrintFontSize;
DEF char PrintFontFace[32];

DEF int StatusFontSize;
DEF char StatusFontFace[32];
DEF char StatusFontStyle[32];
DEF int StatusLineHeight, StatusCharWidth;	/* # of window units for status font */

DEF int StartPen;				/* Similar to TopSpace; where to start pen 1st row */
DEF int ScreenYPixels;			/* used in converting points to logical units */
DEF int PrinterYPixels;			/* used in converting points to logical units */
DEF COLORREF OldTextColor, OldBkColor;
DEF COLORREF NetUnSubscribedColor;	/* color to use for unsubscribed groups  */
DEF COLORREF NetSubscribedColor;	/* color to use for subscribed groups  */
DEF COLORREF ArticleSeenColor;	/* color to use for articles that have been seen */
DEF COLORREF ArticleKilledColor;	/* color for unseen articles that have been marked seen */
DEF COLORREF ArticleUnSeenColor;	/* color to use for articles that have not been seen */
DEF COLORREF ArticleTextColor;	/* color to use for article/post text */
DEF COLORREF StatusTextColor;	/* Color to use for status text */
DEF COLORREF ListBackgroundColor;	/* background color for group/article listings */
DEF COLORREF ArticleBackgroundColor;	/* background color for article/post windows */
DEF COLORREF StatusBackgroundColor;		/* background color for status windows */
DEF COLORREF CustomColors[16];	/* Custom colors definable by user in ChooseColor */
DEF HBRUSH hListBackgroundBrush;
DEF HBRUSH hArticleBackgroundBrush;
DEF HBRUSH hStatusBackgroundBrush;
DEF BOOL LimitedColor;
DEF BOOL UseInverseSelections;
DEF BOOL ShowSplashScreen;

DEF int ReverseVideo;
DEF BOOL ThumbTrack;

DEF BOOL MailDemandLogon;		/* FALSE = permanent logon
								   TRUE  = logon on send mail */
DEF int MailForceType;			/*  Force Mail Type to valid value where
								   Less then zero means
								   default negotiation */
DEF int MailLog;				/* True means append to log files */
DEF int PostLog;				/* where XXXXLogFile is file name */


DEF char MailLogFile[MAXFILENAME];
DEF char PostLogFile[MAXFILENAME];

DEF int fmtDaysB4Mth;
DEF char fmtDateDelim[2];


#define QuoteLineInd  '>'

DEF DLGPROC lpfnWinVnArticleActionDlg;
DEF DLGPROC lpfnWinVnSaveArtDlg;
DEF DLGPROC lpfnWinVnSaveArtsDlg;
DEF DLGPROC lpfnWinVnFindDlg;
DEF DLGPROC lpfnWinVnGenericDlg;
DEF DLGPROC lpfnWinVnSubjectDlg;
DEF DLGPROC lpfnWinVnCommDlg;
DEF DLGPROC lpfnWinVnAuthDlg;
DEF DLGPROC lpfnWinVnDoListDlg;
DEF DLGPROC lpfnWinVnPersonalInfoDlg;
DEF DLGPROC lpfnWinVnExecuteInfoDlg;
DEF DLGPROC lpfnWinVnConfirmationDlg;
DEF DLGPROC lpfnWinVnAppearanceDlg;
DEF DLGPROC lpfnWinVnControlSubclass;
DEF DLGPROC lpfnWinVnThresholdDlg;
DEF DLGPROC lpfnWinVnLogOptDlg;
DEF DLGPROC lpfnWinVnDecodeArtsDlg;
DEF DLGPROC lpfnWinVnAttachDlg;
DEF DLGPROC lpfnWinVnComposePrefsDlg;
DEF DLGPROC lpfnWinVnAttachPrefsDlg;
DEF DLGPROC lpfnWinVnEncodeDlg;
DEF DLGPROC lpfnWinVnExitDlg;
DEF DLGPROC lpfnWinVnMailDlg;
DEF DLGPROC lpfnWinVnSmartFilerDlg;
DEF DLGPROC lpfnWinVnSelectPathDlg;
DEF DLGPROC lpfnWinVnVersionListDlg;
DEF DLGPROC lpfnWinVnArticleDlg;
DEF DLGPROC lpfnWinVnCodingPrefsDlg;
DEF DLGPROC lpfnWinVnArtListDlg;
DEF DLGPROC lpfnWinVnGroupListDlg;
DEF DLGPROC lpfnWinVnHeadersDlg;	// shimomai

DEF char *szAppName;
DEF char szAppProFile[MAXFILENAME];
DEF char szNewsSrc[MAXFILENAME];

DEF char SaveArtFileName[MAXFILENAME];
DEF char DecodePathName[MAXFILENAME];
DEF char DialogString[MAXDIALOGSTRING];
DEF char AddressString[MAXDIALOGSTRING];
DEF char NameString[MAXDIALOGSTRING];
DEF char CcAddress[MAXDIALOGSTRING];
DEF BOOL CcByMail;
DEF int SaveArtAppend;
DEF BOOL SaveNewsrcOnClose;
DEF int ThreadFullSubject;
DEF char ThreadDepthIndicator[2];
DEF BOOL GroupListMultiSelect;
DEF BOOL ArtListMultiSelect;
DEF int SpareRanges;
DEF BOOL TrackSubscribedCrossposts;
DEF BOOL TrackUnsubscribedCrossposts;

DEF TypDoc *FindDoc;
DEF char *NewsgroupsPtr;		/* Used to pass pointer to newsgroup of new posting. */

/* For each new group detected, we create an entry in the following
 * array, NewGroupTable.  Each entry contains a far pointer to a
 * dynamically-allocated global data structure containing a line
 * containing information on this group, in the exact same format
 * as used in the NetDoc.
 */
DEF void huge *huge * NewGroupTable;	/* array of pointers to new group lines */
DEF HANDLE hNewGroupTable;		/* Handle to the above array */
DEF unsigned long nNewGroups;
DEF HANDLE hNewGroupData;
DEF void huge *NewGroupData;
DEF unsigned long HashTableSize;
DEF unsigned long LinesInRC;

typedef struct structHier {
  HANDLE hName;
  long Start;
  unsigned long NumGroups;
  HANDLE hNext;
} TypHier;

#define ADD_SUBSCRIBED_END_OF_SUB	0
#define ADD_SUBSCRIBED_TOP_OF_DOC	1
#define ADD_FIRST_SELECTED       	2

#define LINE_FLAG_SET			0

#define GROUP_ACTION_SUBSCRIBE		0
#define GROUP_ACTION_UNSUBSCRIBE	1
#define GROUP_ACTION_CHECK_ACTIVE	2
#define GROUP_ACTION_GET_GROUPNAMES 3
#define GROUP_ACTION_SELECTED       4	
#define GROUP_ACTION_CATCHUP        5

#define ARTICLE_ACTION_SAVE		0
#define EXTEND				2
#define COMPARE				1
#define NO_COMPARE			0
#define SHOW				1
#define NO_SHOW				0
#define NO_ID				NULL
#define REUSE				1
#define NO_REUSE			0
#define SELECT				1
#define DESELECT			0
#define ENABLE				1
#define DISABLE				0
#define BLOCK_ACTION_SET_ACTIVE		0

DEF int il, ic;
DEF int irow;
DEF int imemo;
DEF int ih;

#if 0
#define MAXCOMMSPEEDCHARS 7
DEF int CommPortID;				/* IDD_COM1 or IDD_COM2 */
DEF int CommParityID;			/* IDD_7EVEN or IDD_8NONE  */
DEF char pszCommSpeed[MAXCOMMSPEEDCHARS];	/* character version of comm speed */
#endif

DEF int idTimer;				/* timer ID            */

#define IncPtr(ptr,byint) (char far *) ptr += byint

/* the MailCtrl global variable is scoped globally after the main window is
   created and is only modified at creation during MailInit in wvmail.c */
DEF struct MailCtrlStruct {
  int MailType;
  int enableMail;
  int enableLogout;
  int enableForward;
  int (*fnMlInit) (HWND hWnd);
  int (*fnMlLogout) (HWND hWnd);
  int (*fnMlClose) (HWND hWnd);
  int (*fnMlWinCreate) (HWND hWnd, TypDoc * Doc, int DocType);
} MailCtrl;

#define MT_NONE 0
#define MT_MAPI 1
#define MT_SMTP 2

#define INACTIVE		0		/* values for CodingState      */
#define DECODE_ACTIVE		1	/* values for Decoding must be */
#define DECODE_SKIPPING		2	/* a contiguous range          */
#define DECODE_PROCESSING	3
#define DECODE_GET_TABLE	4
#define ATTACH_PROCESSING	10	/* Encodes must be > decodes   */
#define ATTACH_SENDING		11
#define ATTACH_READFILE		12
#define ATTACH_WAITING      13

#define CODINGTABLESIZE		64

#define BASE_BLOCK_SIZE		16384	/* base size for the huge data */
typedef struct structcoded {
  char name[MAXFILENAME];		/* original file name from begin line */
  char ident[MAXINTERNALLINE];	/* based on article subject line + author */
  BOOL beginFlag;				/* =TRUE this block is begin of the complete binary */
  BOOL endFlag;					/* =TRUE this block is end of the complete binary */
  int sequence;					/* =-1 if unknown, or # in mult-part file */
  int seqConfidence;			/* confidence of sequence info */
  long estNumLines;				/* info obtained from Lines: header during decode */
  unsigned long numLines;		/* num lines read so far (for status window */
  unsigned long numBytes;		/* # of bytes used in this coded data block */
  unsigned long maxBytes;		/* max # of bytes in this coded data block */
  char huge *data;				/* the huge data array */
  HWND hParentWnd;				/* handle to group wnd that started this */
} TypCoded;

#define MAX_DECODE_BLOCKS  256	/* max # of parts for a decode file */
#define MAX_DECODE_THREADS 75	/* max # of files in one batch decode */
typedef struct decodeThreadStruct {
  char name[MAXFILENAME];		/* original file name from begin line */
  char ident[MAXINTERNALLINE];	/* thread ID based on article subject line */
  char dosFileName[MAXFILENAME];	/* workable DOS file name */
  char contentType[MAXCONTENTTYPELEN];	/* MIME content type */
  char contentDesc[80];			/* MIME content description */
  char customTable[100];		/* custom coding table (if CODE_CUSTOM) */
  int contentEncoding;			/* MIME content-transfer-encoding */
  int numBlocksWritten;			/* number of blocks written to disk, so far */
  int mode;						/* 2nd field of begin header, don't use in DOS */
  int numBlocks;				/* number of coded blocks used in list */
  int expectedNumBlocks;		/* 0 if unknown, or a # if found in headers */
  unsigned long totalBytes;		/* total # of bytes for entire file */
  TypCoded *codedBlockList[MAX_DECODE_BLOCKS];	/* list of ptrs to decode
												   objects */
  TypTextBlock *statusText;		/* buffers for thread status text window */
} TypDecodeThread;

#define CODE_BASE64   1
#define CODE_UU       2
#define CODE_XX       3
#define CODE_CUSTOM   4
#define CODE_QP       5
#define CODE_UNKNOWN  6
#define CODE_NONE     0

#define ENCODE_LINE_LEN  45

/* these correspond to the # members in the static arrays of strings */
/* defined in wvattach.c */
#define NUM_CONTENT_TYPES 10
DEF char *ContentTypes[NUM_CONTENT_TYPES]
#ifdef WINMAIN
 = {
 "Text/Plain",
 "Text/Richtext",
 "Video/MPEG",
 "Video/AVI",
 "Image/JPEG",
 "Image/GIF",
 "Audio/Basic",
 "Application/Zip",
 "Application/PostScript",
 "Other"}
#endif
;

#define NUM_ENCODING_TYPES 5
DEF char *EncodingTypes[NUM_ENCODING_TYPES]
#ifdef WINMAIN
 = {"Base-64", "UU", "XX", "Custom", "None"}
#endif
;

/* coding and attachment globals  */
/* use 256 for arrays to support 2-byte charsets from Japan and Russia */
DEF char xxMap[256], uuMap[256], base64Map[256], customMap[256];
DEF char *CodingMap[7];			/* N+1 for N coding types */
DEF int CodingState;
DEF TypCoded *currentCoded;
DEF TypTextBlock *CodingStatusText[MAX_DECODE_THREADS];
DEF int NumStatusTexts;
DEF char uuTable[CODINGTABLESIZE+1]
#ifdef WINMAIN
  = "`!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_"
#endif
;
DEF char xxTable[CODINGTABLESIZE+1]
#ifdef WINMAIN
  = "+-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
#endif
;
DEF char base64Table[CODINGTABLESIZE+1]
#ifdef WINMAIN
  = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"
#endif
;

DEF BOOL CodingStatusVerbose;
DEF BOOL BlockCodingStatusAlwaysOnTop;
DEF BOOL MinimizeStatusWindows;
DEF BOOL DumbDecode;
DEF BOOL ExecuteDecodedFiles;
DEF BOOL KeepArticleHeaderVisible;
DEF BOOL AlsoDecodeOpenArticles;
DEF BOOL UseSmartFiler;
DEF HWND hCodedBlockWnd;		/* the block coding status window (top center of screen) */
DEF char UserCodingTable[CODINGTABLESIZE + 1];
#define STATUSWIDTH (85*StatusCharWidth)
#define STATUSHEIGHT (8*StatusLineHeight)

DEF char DefaultEncodingType[MAXENCODINGTYPELEN];
DEF int DefaultAttachInNewArt;
DEF char DefaultContentType[MAXCONTENTTYPELEN];
DEF char SubjectTemplate[MAXINTERNALLINE];

DEF char FollowupSaysTemplate[MAXINTERNALLINE];
DEF char ReplySaysTemplate[MAXINTERNALLINE];

DEF long ArticleSplitLength;
DEF char MIMEUUType[MAXENCODINGTYPELEN];		/* experimental types used in MIME header gen */
DEF char MIMEXXType[MAXENCODINGTYPELEN];
DEF char MIMECustomType[MAXENCODINGTYPELEN];

DEF char MIMECharset[80];

DEF BOOL GenerateMIME;
DEF BOOL MIMEUsageSuggestions;
DEF BOOL ReviewAttach;
DEF char* MIMEBoundary;

DEF BOOL UsingMIME;					/* = TRUE if found MIME Version header in incoming art */

#define CUT_HERE_TEXT  "BEGIN --- CUT HERE --- Cut Here --- cut here ---"

#define FAIL  -1
#define SUCCESS   0
#define ABORT 2
#define CONTINUE 3

#define MIME_VERSION "1.0"
#define ADD_TO_EDIT 1			/* used for AddEndedLineToBlock  */
#define ADD_TO_POST 2
#define ADD_TO_FILE 3
#define ADD_PLAIN   0

/* Signature File globals */
DEF int EnableSig;
DEF char SigFileName[MAXFILENAME];
DEF TypTextBlock *Signature;
#define BIG_SIG_FILE 40			/* warning if sig file > this many lines */
#define SIG_DELIMITER "-- "		/* delimiter as defined in Spencer rfc1036++ */

/* Mail List globals  */
DEF TypTextBlock *MailList;
DEF int MailListOrigNum;

/* Smart Filer globals */
DEF TypTextBlock *ExtMapSourceList;
DEF TypTextBlock *ExtMapDosList;
DEF int ExtListOrigNum;
DEF BOOL EnableExtensionConversion;
DEF unsigned int MaxFileNameLen;
DEF unsigned int MaxFileExtLen;
DEF int OnDupeName;
DEF int OnNameTooLong;

#define DUPE_AVOID_NONE			0	/* dupe avoidance list.  these numbers */
#define DUPE_AVOID_NUMBER_EXT	1	/* correspond with posn in droplist */
#define DUPE_AVOID_PREPEND_NUM	2
#define DUPE_AVOID_APPEND_NUM	3

#define SHORTEN_NONE			0	/* name shotrening list.  these numbers */
#define SHORTEN_TRUNCATE		1	/* correspond with posn in droplist */
#define SHORTEN_SKIP_VOWELS		2

/* bitmaps */
DEF HBITMAP DiskBitmaps[5];
DEF HBITMAP FolderBitmaps[3];

/* Printing Globals  */
DEF PRINTDLG pd;				/* Global structure to hold printer defaults */

/* globals for status bar */
typedef struct {
  int dyBorder;					/* System Border Width/Height       */
  int dyBorderx2;				/* System Border Width/Height * 2   */
  int dyBorderx3;				/* System Border Width/Height * 3   */
  int dyBorderx4;				/* System Border Width/Height * 4   */
  int dyBorderx8;				/* System Border Width/Height * 8   */
  int dyBorderx9;				/* System Border Width/Height * 9   */
  int dyBorderx10;				/* System Border Width/Height * 10  */
  int dyStatbar;				/* Status Bar height                */
  int dxStates;					/* Width reserved for State Info    */
  HFONT hFontStatbar;			/* Font used in status bar */
} STATUSPAINT;
DEF STATUSPAINT StatbarPntData;	/* dimensions used in status bar */

/* macros added by jsc */
/* why is there no uitoa!? */
#define uitoa(x,s,b) ultoa((unsigned long)(x),(s),(b))
#define atoui(s) (unsigned int)atol((s))
#define Decoding (CodingState >= DECODE_ACTIVE && CodingState <= DECODE_GET_TABLE)
#define TextBlockLine(b, n) &(b->text[b->offset[n]])
#define IsBright(c) (GetRValue(c) > 180 && GetGValue(c) > 180 && GetBValue(c) > 180)
#define IsDark(c) (GetRValue(c) < 40 && GetGValue(c) < 40 && GetBValue(c) < 40)
#define RectWidth(r) (r.right - r.left)
#define RectHeight(r) (r.bottom - r.top)

#define ENABLE_MENU   MF_BYCOMMAND|MF_ENABLED
#define DISABLE_MENU  MF_BYCOMMAND|MF_DISABLED|MF_GRAYED

/* this is the static system color for light gray (C0,C0,C0) */
#define GRAY_COLOR RGB(192,192,192)
#define BLACK_COLOR RGB(0,0,0)

/* Spoiler by shimomai */
#define SpoilChar 0x0c

/* Group/Article list seperator */
DEF int GroupListSeparator;	//shimomai
DEF int ArtListSeparator1;	//shimomai
DEF int ArtListSeparator2;	//shimomai
DEF int ArtListSeparator3;	//shimomai

/* WWW Client & FTP Client */
DEF char HttpClient[MAXFILENAME];    //shimomai
DEF char FtpClient[MAXFILENAME];     //shimomai
DEF char GopherClient[MAXFILENAME];  //dumoulin
DEF char WaisClient[MAXFILENAME];    //dumoulin
DEF BOOL UsingDDE;			         //shimomai
DEF int DdeServID;			         //shimomai
DEF char DdeServName[MAXFILENAME];   //dumoulin

#define DDECLIENT_NO_DIRECTIVE	0
#define DDECLIENT_USR_SPECIFIED 1
#define DDECLIENT_NETSCAPE	2
#define DDECLIENT_IEXPLORE	3
#define DDECLIENT_MOSAIC    4

/* Table of mappings between value and string */
struct ValStrTable
{
  int value;
  char *text;
};

#include <string.h>
#include <stdio.h>				/* sprintf, etc... */

#ifdef __cplusplus
}
#endif

/*--- Last line of WVGLOB.H -------------------------------------------- */

#endif

/*
 * Local Variables:
 * tab-width: 2
 * end:
 */
