/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.basic.Primes;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Port;
import com.sun.electric.tool.ncc.netlist.Subcircuit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SubcircuitInfo {
    private final ReferenceInfo shared;
    private final Map<String, Integer> exportNameToPortIndex;

    private void processReferencePorts(String[] portNames, Map<String, Integer> exportNameToPortIndex, Port[] refPorts) {
        for (int i = 0; i < refPorts.length; ++i) {
            Integer portIndex = i;
            Port port = refPorts[i];
            Iterator<String> it = port.getExportNames();
            while (it.hasNext()) {
                String exportName = it.next();
                if (portNames[i] == null) {
                    portNames[i] = exportName;
                }
                exportNameToPortIndex.put(exportName, portIndex);
            }
            Job.error(portNames[i] == null, "Port with no name?");
        }
    }

    public SubcircuitInfo(String name, int ID, Port[] refPorts) {
        String[] portNames = new String[refPorts.length];
        this.exportNameToPortIndex = new HashMap<String, Integer>();
        this.processReferencePorts(portNames, this.exportNameToPortIndex, refPorts);
        this.shared = new ReferenceInfo(name, ID, portNames);
    }

    public SubcircuitInfo(SubcircuitInfo referenceInfo, Map<String, Integer> exportNameToPortIndex) {
        this.shared = referenceInfo.shared;
        this.exportNameToPortIndex = exportNameToPortIndex;
    }

    public int getID() {
        return this.shared.ID;
    }

    public String getName() {
        return this.shared.name;
    }

    public int numPorts() {
        return this.shared.portNames.length;
    }

    public String getPortName(int i) {
        return this.shared.portNames[i];
    }

    public int getPortIndex(String exportName) {
        Integer I = this.exportNameToPortIndex.get(exportName);
        return I == null ? -1 : I;
    }

    public int[] getPortCoeffs() {
        return this.shared.portCoeffs;
    }

    public PinType[] getPinTypes() {
        return this.shared.pinTypes;
    }

    private static class ReferenceInfo {
        final String name;
        final int ID;
        final String[] portNames;
        final int[] portCoeffs;
        final PinType[] pinTypes;

        private int[] initPortCoeffs() {
            int i;
            int[] coeffs = new int[this.portNames.length];
            int nameHash = 0;
            for (i = 0; i < this.name.length(); ++i) {
                nameHash = (nameHash << 1) + this.name.charAt(i);
            }
            nameHash %= 257;
            nameHash = Math.abs(nameHash);
            for (i = 0; i < coeffs.length; ++i) {
                coeffs[i] = Primes.get(nameHash + i);
            }
            return coeffs;
        }

        ReferenceInfo(String name, int ID, String[] portNames) {
            Job.error(name == null, "No name?");
            this.name = name;
            this.ID = ID;
            this.portNames = portNames;
            this.portCoeffs = this.initPortCoeffs();
            this.pinTypes = new PinType[portNames.length];
            for (int i = 0; i < this.pinTypes.length; ++i) {
                String pinDesc = name + " " + portNames[i];
                this.pinTypes[i] = new Subcircuit.SubcircuitPinType(0, i, pinDesc);
            }
        }
    }
}

